//go:build !ignore_autogenerated
// +build !ignore_autogenerated

// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by defaulter-gen. DO NOT EDIT.

package v2alpha1

import (
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&ClusterTrainingRuntime{}, func(obj interface{}) { SetObjectDefaults_ClusterTrainingRuntime(obj.(*ClusterTrainingRuntime)) })
	scheme.AddTypeDefaultingFunc(&ClusterTrainingRuntimeList{}, func(obj interface{}) { SetObjectDefaults_ClusterTrainingRuntimeList(obj.(*ClusterTrainingRuntimeList)) })
	scheme.AddTypeDefaultingFunc(&TrainingRuntime{}, func(obj interface{}) { SetObjectDefaults_TrainingRuntime(obj.(*TrainingRuntime)) })
	scheme.AddTypeDefaultingFunc(&TrainingRuntimeList{}, func(obj interface{}) { SetObjectDefaults_TrainingRuntimeList(obj.(*TrainingRuntimeList)) })
	return nil
}

func SetObjectDefaults_ClusterTrainingRuntime(in *ClusterTrainingRuntime) {
	for i := range in.Spec.Template.Spec.ReplicatedJobs {
		a := &in.Spec.Template.Spec.ReplicatedJobs[i]
		for j := range a.Template.Spec.Template.Spec.InitContainers {
			b := &a.Template.Spec.Template.Spec.InitContainers[j]
			for k := range b.Ports {
				c := &b.Ports[k]
				if c.Protocol == "" {
					c.Protocol = "TCP"
				}
			}
			if b.LivenessProbe != nil {
				if b.LivenessProbe.ProbeHandler.GRPC != nil {
					if b.LivenessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.ReadinessProbe != nil {
				if b.ReadinessProbe.ProbeHandler.GRPC != nil {
					if b.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.StartupProbe != nil {
				if b.StartupProbe.ProbeHandler.GRPC != nil {
					if b.StartupProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
		}
		for j := range a.Template.Spec.Template.Spec.Containers {
			b := &a.Template.Spec.Template.Spec.Containers[j]
			for k := range b.Ports {
				c := &b.Ports[k]
				if c.Protocol == "" {
					c.Protocol = "TCP"
				}
			}
			if b.LivenessProbe != nil {
				if b.LivenessProbe.ProbeHandler.GRPC != nil {
					if b.LivenessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.ReadinessProbe != nil {
				if b.ReadinessProbe.ProbeHandler.GRPC != nil {
					if b.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.StartupProbe != nil {
				if b.StartupProbe.ProbeHandler.GRPC != nil {
					if b.StartupProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
		}
		for j := range a.Template.Spec.Template.Spec.EphemeralContainers {
			b := &a.Template.Spec.Template.Spec.EphemeralContainers[j]
			for k := range b.EphemeralContainerCommon.Ports {
				c := &b.EphemeralContainerCommon.Ports[k]
				if c.Protocol == "" {
					c.Protocol = "TCP"
				}
			}
			if b.EphemeralContainerCommon.LivenessProbe != nil {
				if b.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC != nil {
					if b.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.EphemeralContainerCommon.ReadinessProbe != nil {
				if b.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC != nil {
					if b.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.EphemeralContainerCommon.StartupProbe != nil {
				if b.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC != nil {
					if b.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
		}
	}
}

func SetObjectDefaults_ClusterTrainingRuntimeList(in *ClusterTrainingRuntimeList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_ClusterTrainingRuntime(a)
	}
}

func SetObjectDefaults_TrainingRuntime(in *TrainingRuntime) {
	for i := range in.Spec.Template.Spec.ReplicatedJobs {
		a := &in.Spec.Template.Spec.ReplicatedJobs[i]
		for j := range a.Template.Spec.Template.Spec.InitContainers {
			b := &a.Template.Spec.Template.Spec.InitContainers[j]
			for k := range b.Ports {
				c := &b.Ports[k]
				if c.Protocol == "" {
					c.Protocol = "TCP"
				}
			}
			if b.LivenessProbe != nil {
				if b.LivenessProbe.ProbeHandler.GRPC != nil {
					if b.LivenessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.ReadinessProbe != nil {
				if b.ReadinessProbe.ProbeHandler.GRPC != nil {
					if b.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.StartupProbe != nil {
				if b.StartupProbe.ProbeHandler.GRPC != nil {
					if b.StartupProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
		}
		for j := range a.Template.Spec.Template.Spec.Containers {
			b := &a.Template.Spec.Template.Spec.Containers[j]
			for k := range b.Ports {
				c := &b.Ports[k]
				if c.Protocol == "" {
					c.Protocol = "TCP"
				}
			}
			if b.LivenessProbe != nil {
				if b.LivenessProbe.ProbeHandler.GRPC != nil {
					if b.LivenessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.ReadinessProbe != nil {
				if b.ReadinessProbe.ProbeHandler.GRPC != nil {
					if b.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.StartupProbe != nil {
				if b.StartupProbe.ProbeHandler.GRPC != nil {
					if b.StartupProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
		}
		for j := range a.Template.Spec.Template.Spec.EphemeralContainers {
			b := &a.Template.Spec.Template.Spec.EphemeralContainers[j]
			for k := range b.EphemeralContainerCommon.Ports {
				c := &b.EphemeralContainerCommon.Ports[k]
				if c.Protocol == "" {
					c.Protocol = "TCP"
				}
			}
			if b.EphemeralContainerCommon.LivenessProbe != nil {
				if b.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC != nil {
					if b.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.EphemeralContainerCommon.ReadinessProbe != nil {
				if b.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC != nil {
					if b.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if b.EphemeralContainerCommon.StartupProbe != nil {
				if b.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC != nil {
					if b.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						b.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
		}
	}
}

func SetObjectDefaults_TrainingRuntimeList(in *TrainingRuntimeList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_TrainingRuntime(a)
	}
}
