/*
 * Decompiled with CFR 0.152.
 */
package com.ktplayer;

import com.jfoenix.controls.JFXSlider;
import com.ktplayer.Main;
import com.ktplayer.Song;
import com.ktplayer.SongImageController;
import com.mpatric.mp3agic.ID3v2;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.Mp3File;
import com.mpatric.mp3agic.UnsupportedTagException;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Pane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;

public class Controller {
    @FXML
    private AnchorPane window;
    @FXML
    private AnchorPane playlistNode;
    @FXML
    private Pane showPlaylist;
    @FXML
    private Pane exit;
    @FXML
    private Pane minimize;
    @FXML
    private Pane imagePane;
    @FXML
    private TableView<Song> songTable;
    @FXML
    private TableColumn<Song, String> idColumn;
    @FXML
    private TableColumn<Song, String> artistNameColumn;
    @FXML
    private TableColumn<Song, String> songNameColumn;
    @FXML
    private TableColumn<Song, String> durationColumn;
    @FXML
    private TableColumn<Song, String> rateColumn;
    @FXML
    private TableColumn<Song, String> formatColumn;
    @FXML
    private Label artistName;
    @FXML
    private Label albumName;
    @FXML
    private Label songName;
    @FXML
    private Label totalDuration;
    @FXML
    private Label currentDuration;
    @FXML
    private Label volumeValue;
    @FXML
    private Label songsCounter;
    @FXML
    private JFXSlider songSlider;
    @FXML
    private Slider volumeSlider;
    @FXML
    private ImageView folderChooser;
    @FXML
    private ImageView playButton;
    @FXML
    private ImageView pauseButton;
    @FXML
    private ImageView nextSongButton;
    @FXML
    private ImageView previousSongButton;
    @FXML
    private ImageView muteIcon;
    @FXML
    private ImageView volumeIcon;
    @FXML
    private ToggleButton autoPlayIcon;
    @FXML
    private Stage stage;
    private Main main;
    private SongImageController songImageController;
    private List<MediaPlayer> players;
    private MediaPlayer mediaPlayer;
    private MediaView mediaView;
    private boolean isAutoplay = false;
    private double volume = 0.1;
    private String path;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private FadeTransition fadeIn = new FadeTransition();
    private FadeTransition fadeOut = new FadeTransition();

    public Controller() {
        this.players = new ArrayList<MediaPlayer>();
        this.songSlider = new JFXSlider();
        this.stage = Main.getStage();
        this.stage.getIcons().add((Object)new Image(ClassLoader.getSystemResource("images/logo.png").toExternalForm()));
        this.songImageController = new SongImageController();
    }

    @FXML
    private void initialize() throws Exception {
        this.window.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Controller.this.xOffset = Controller.this.stage.getX() - event.getScreenX();
                Controller.this.yOffset = Controller.this.stage.getY() - event.getScreenY();
            }
        });
        this.window.addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Controller.this.stage.setX(event.getScreenX() + Controller.this.xOffset);
                Controller.this.stage.setY(event.getScreenY() + Controller.this.yOffset);
            }
        });
        this.autoPlayIcon.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (Controller.this.isAutoplay) {
                    Controller.this.autoPlayIcon.setSelected(false);
                    Controller.this.isAutoplay = false;
                } else if (!Controller.this.isAutoplay) {
                    Controller.this.autoPlayIcon.setSelected(true);
                    Controller.this.isAutoplay = true;
                }
            }
        });
        this.showPlaylist.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (Controller.this.playlistNode.isVisible()) {
                    Controller.this.hideTransation(Controller.this.playlistNode);
                } else {
                    Controller.this.showTransation(Controller.this.playlistNode);
                }
            }
        });
        this.minimize.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Controller.this.stage.setIconified(true);
            }
        });
        this.exit.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Controller.this.songImageController.deleteImage();
                System.exit(0);
            }
        });
        this.idColumn.setCellValueFactory(cellData -> ((Song)cellData.getValue()).idProperty());
        this.artistNameColumn.setCellValueFactory(cellData -> ((Song)cellData.getValue()).artistNameProperty());
        this.songNameColumn.setCellValueFactory(cellData -> ((Song)cellData.getValue()).songNameProperty());
        this.durationColumn.setCellValueFactory(cellData -> ((Song)cellData.getValue()).durationProperty());
        this.rateColumn.setCellValueFactory(cellData -> ((Song)cellData.getValue()).rateProperty());
        this.formatColumn.setCellValueFactory(cellData -> ((Song)cellData.getValue()).formatProperty());
        this.showSongInfo(null);
        this.songTable.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.showSongInfo((Song)newValue));
        this.folderChooser.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DirectoryChooser chooser = new DirectoryChooser();
                File selectedDirectory = chooser.showDialog((Window)Controller.this.stage);
                if (selectedDirectory == null) {
                    System.out.println("No directory selected!");
                } else {
                    try {
                        if (!Controller.this.players.isEmpty()) {
                            Controller.this.players.clear();
                            System.out.println("new array list");
                        }
                        Controller.this.songTable.setItems(Controller.this.songsUrls(selectedDirectory));
                        Controller.this.songTable.setOnMouseClicked(e -> {
                            if (e.getClickCount() > 0 && e.getClickCount() < 2) {
                                try {
                                    Controller.this.takeCare();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void showSongInfo(Song song) {
        if (song != null) {
            this.artistName.setText(song.getArtistName());
            this.songName.setText(song.getSongName());
            this.albumName.setText(song.getFormat());
        } else {
            this.artistName.setText("-");
            this.songName.setText("-");
            this.albumName.setText("-");
        }
    }

    public ObservableList<Song> songsUrls(File dir) throws Exception {
        ObservableList songData = FXCollections.observableArrayList();
        File[] files = dir.listFiles();
        int i = 0;
        for (File file : files) {
            String name;
            if (!file.isFile() || !(name = file.getName()).endsWith("mp3") && !name.endsWith("wav")) continue;
            try {
                Mp3File mp3 = new Mp3File(file.getPath());
                ID3v2 tag = mp3.getId3v2Tag();
                Song song = new Song(String.valueOf(++i), tag.getArtist(), tag.getTitle(), this.kbToMb(file.length()), this.secToMin(mp3.getLengthInSeconds()), tag.getAlbum(), file.getAbsolutePath());
                this.players.add(this.createPlayer(file.getAbsolutePath()));
                songData.add((Object)song);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        i = 0;
        System.out.println(this.players.size());
        this.songsCounter.setText("");
        this.songsCounter.setText("Songs: " + this.players.size());
        return songData;
    }

    public void playPauseSong(final Song song) throws Exception {
        if (song != null) {
            File file = new File(song.getUrl());
            String path = file.getAbsolutePath();
            path.replace("\\", "/");
            if (this.mediaView != null && this.mediaPlayer != null) {
                this.volume = this.mediaView.getMediaPlayer().getVolume();
                this.mediaView.getMediaPlayer().stop();
                this.mediaView = null;
                this.mediaPlayer = null;
            }
            Media media = new Media(new File(path).toURI().toString());
            this.mediaPlayer = new MediaPlayer(media);
            this.mediaPlayer.stop();
            this.mediaPlayer.setAutoPlay(false);
            this.mediaView = new MediaView(this.mediaPlayer);
            this.pauseIcon();
            this.mediaView = new MediaView(this.players.get(Integer.parseInt(song.getId()) - 1));
            this.volumeValue.setText(String.valueOf((int)this.volumeSlider.getValue()));
            this.volumeSlider.setValue(this.volume * 100.0);
            this.mediaView.getMediaPlayer().setVolume(this.volume);
            this.mediaView.getMediaPlayer().seek(Duration.ZERO);
            this.updateSliderPosition(Duration.ZERO);
            this.updateValues();
            this.setImage(this.songImageController.go(song.getUrl()));
            this.mediaView.mediaPlayerProperty().addListener((ChangeListener)new ChangeListener<MediaPlayer>(){

                public void changed(ObservableValue<? extends MediaPlayer> observable, MediaPlayer oldValue, MediaPlayer newValue) {
                    try {
                        Controller.this.setCurrentlyPlayer(newValue);
                        Controller.this.updateValues();
                        Controller.this.setImage(Controller.this.songImageController.go(song.getUrl()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.playButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Controller.this.mediaView.getMediaPlayer().play();
                    Controller.this.playIcon();
                    Controller.this.updateValues();
                    for (int i = Controller.this.players.indexOf(Controller.this.mediaView.getMediaPlayer()) % Controller.this.players.size(); i < Controller.this.players.size(); ++i) {
                        MediaPlayer player = (MediaPlayer)Controller.this.players.get(i);
                        Controller.this.mediaPlayer = player;
                        final MediaPlayer nextPlayer = (MediaPlayer)Controller.this.players.get((i + 1) % Controller.this.players.size());
                        Controller.this.mediaPlayer.setOnEndOfMedia(new Runnable(){

                            @Override
                            public void run() {
                                Controller.this.mediaView.getMediaPlayer().stop();
                                Controller.this.mediaView.getMediaPlayer().seek(Duration.ZERO);
                                if (Controller.this.isAutoplay) {
                                    Controller.this.mediaView.getMediaPlayer().seek(Duration.ZERO);
                                    Controller.this.repeatSongs();
                                    return;
                                }
                                Controller.this.mediaPlayer = nextPlayer;
                                Controller.this.mediaView.setMediaPlayer(Controller.this.mediaPlayer);
                                Controller.this.mediaView.getMediaPlayer().seek(Duration.ZERO);
                                Controller.this.updateSliderPosition(Duration.ZERO);
                                Controller.this.songSlider.setValue(0.0);
                                Controller.this.updateValues();
                                Controller.this.mediaPlayer.setVolume(Controller.this.volume);
                                Controller.this.mediaPlayer.play();
                                Controller.this.playIcon();
                            }
                        });
                        Controller.this.pauseSong();
                    }
                }
            });
            this.nextSongButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Controller.this.seekAndUpdate(((MediaPlayer)Controller.this.players.get(Controller.this.players.indexOf(Controller.this.mediaView.getMediaPlayer()))).getTotalDuration());
                }
            });
            this.previousSongButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Controller.this.seekAndUpdate(Duration.ZERO);
                }
            });
            this.songSlider.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Bounds b1 = Controller.this.songSlider.getLayoutBounds();
                    double mouseX = event.getX();
                    double percent = (b1.getMinX() + mouseX) * 100.0 / (b1.getMaxX() - b1.getMinX());
                    Controller.this.songSlider.setValue(percent / 100.0);
                    Controller.this.seekAndUpdate(new Duration(Controller.this.mediaView.getMediaPlayer().getTotalDuration().toMillis() * percent / 100.0));
                    Controller.this.songSlider.setValueFactory((Callback<JFXSlider, StringBinding>)((Callback)slider -> Bindings.createStringBinding(() -> Controller.this.secToMin((long)Controller.this.mediaView.getMediaPlayer().getCurrentTime().toSeconds()), (Observable[])new Observable[]{Controller.this.songSlider.valueProperty()})));
                }
            });
        } else {
            if (this.pauseButton.isVisible()) {
                if (this.mediaPlayer != null && this.mediaView != null) {
                    this.mediaPlayer = this.mediaView.getMediaPlayer();
                    this.mediaPlayer.stop();
                    this.mediaView = null;
                    this.mediaPlayer = null;
                }
                this.pauseIcon();
            }
            System.out.println("Song does not exist!");
        }
    }

    public void setMain(Main main) {
        this.main = main;
    }

    public String kbToMb(long length) {
        Long l = length;
        double d = l.doubleValue();
        DecimalFormat df = new DecimalFormat("#.00");
        String form = df.format(d / 1024.0 / 1024.0);
        return form + "Mb";
    }

    public String secToMin(long sec) {
        Long s = sec;
        String time = null;
        time = s % 60L < 10L ? s / 60L + ":0" + s % 60L : s / 60L + ":" + s % 60L;
        return time;
    }

    public MediaPlayer createPlayer(String url) {
        url.replace("\\", "/");
        Media media = new Media(new File(url).toURI().toString());
        MediaPlayer player = new MediaPlayer(media);
        System.out.println("+++++ " + url);
        return player;
    }

    public Media createMedia(String url) {
        url.replace("\\", "/");
        Media media = new Media(new File(url).toURI().toString());
        return media;
    }

    public void playIcon() {
        this.playButton.setVisible(false);
        this.playButton.setDisable(true);
        this.pauseButton.setVisible(true);
        this.pauseButton.setDisable(false);
    }

    public void pauseIcon() {
        this.pauseButton.setVisible(false);
        this.pauseButton.setDisable(true);
        this.playButton.setVisible(true);
        this.playButton.setDisable(false);
    }

    public void setCurrentlyPlayer(MediaPlayer player) throws InvalidDataException, IOException, UnsupportedTagException {
        String source = player.getMedia().getSource();
        source = source.replace("/", "\\");
        source = source.replaceAll("%20", " ");
        source = source.replaceAll("%5B", "[");
        source = source.replaceAll("%5D", "]");
        source = source.substring(6, source.length());
        System.out.println(source + " +++");
        Mp3File mp3 = new Mp3File(source);
        ID3v2 tag = mp3.getId3v2Tag();
        this.artistName.setText(tag.getArtist());
        this.songName.setText(tag.getTitle());
        this.albumName.setText(tag.getAlbum());
    }

    public void takeCare() throws Exception {
        if (this.songTable.getSelectionModel().getSelectedItem() != null) {
            Song song = (Song)this.songTable.getSelectionModel().getSelectedItem();
            this.playPauseSong(song);
        } else {
            System.out.println("null");
        }
    }

    private void seekAndUpdate(Duration duration) {
        MediaPlayer player = this.players.get(this.players.indexOf(this.mediaView.getMediaPlayer()));
        player.seek(duration);
    }

    private void updateValues() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                do {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MediaPlayer player = Controller.this.mediaView.getMediaPlayer();
                            if (player.getStatus() != MediaPlayer.Status.PAUSED && player.getStatus() != MediaPlayer.Status.STOPPED && player.getStatus() != MediaPlayer.Status.READY) {
                                double tduration = player.getTotalDuration().toSeconds();
                                Controller.this.totalDuration.setText(Controller.this.secToMin((long)tduration));
                                Controller.this.currentDuration.setText(Controller.this.secToMin((long)player.getCurrentTime().toSeconds()));
                                Controller.this.updateSliderPosition(player.getCurrentTime());
                                Controller.this.volumeHandler();
                            }
                        }
                    });
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                } while (!Controller.this.players.isEmpty());
            }
        });
        thread.start();
    }

    private void updateSliderPosition(Duration currentTime) {
        MediaPlayer player = this.mediaView.getMediaPlayer();
        Duration totalDuration = player.getTotalDuration();
        if (totalDuration == null || currentTime == null) {
            this.songSlider.setValue(0.0);
        } else {
            this.songSlider.setValue(currentTime.toMillis() / totalDuration.toMillis() * 100.0);
        }
    }

    private void volumeHandler() {
        this.volumeSlider.valueProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                Controller.this.mediaView.getMediaPlayer().setVolume(Controller.this.volumeSlider.getValue() / 100.0);
                Controller.this.volumeValue.setText(String.valueOf((int)Controller.this.volumeSlider.getValue()));
                Controller.this.volume = Controller.this.mediaView.getMediaPlayer().getVolume();
                Controller.this.volumeIconChanger();
            }
        });
    }

    private void volumeIconChanger() {
        if (this.volumeSlider.getValue() == 0.0) {
            this.muteIcon.setVisible(true);
            this.volumeIcon.setVisible(false);
        } else {
            this.muteIcon.setVisible(false);
            this.volumeIcon.setVisible(true);
        }
    }

    private void showTransation(AnchorPane anchorPane) {
        this.fadeIn.setNode((Node)anchorPane);
        this.fadeIn.setDuration(Duration.millis((double)1000.0));
        this.fadeIn.setFromValue(0.0);
        this.fadeIn.setToValue(1.0);
        anchorPane.setVisible(true);
        this.fadeIn.play();
    }

    private void hideTransation(AnchorPane anchorPane) {
        this.fadeOut.setNode((Node)anchorPane);
        this.fadeOut.setDuration(Duration.millis((double)1000.0));
        this.fadeOut.setFromValue(1.0);
        this.fadeOut.setToValue(0.0);
        anchorPane.setVisible(false);
        this.fadeOut.play();
    }

    private void setImage(String path) {
        Image img = new Image(path);
        BackgroundSize bgsize = new BackgroundSize(105.0, 105.0, false, false, true, true);
        this.imagePane.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(img, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, bgsize)}));
    }

    private void repeatSongs() {
        this.mediaView.getMediaPlayer().setOnRepeat(new Runnable(){

            @Override
            public void run() {
                Controller.this.mediaView.getMediaPlayer().seek(Duration.ZERO);
            }
        });
        if (!this.isAutoplay) {
            return;
        }
        this.mediaView.getMediaPlayer().play();
        this.playIcon();
    }

    private void pauseSong() {
        this.mediaView.getMediaPlayer().setAutoPlay(true);
        this.pauseButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (Controller.this.mediaView.getMediaPlayer().getStatus() == MediaPlayer.Status.PLAYING) {
                    Controller.this.mediaView.getMediaPlayer().pause();
                    Controller.this.pauseButton.setVisible(false);
                    Controller.this.pauseButton.setDisable(true);
                    Controller.this.playButton.setVisible(true);
                    Controller.this.playButton.setDisable(false);
                }
            }
        });
    }
}

