/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import com.jfoenix.transitions.CacheMomento;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.animation.AnimationTimer;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.util.Duration;

public class JFXAnimationTimer
extends AnimationTimer {
    private Set<AnimationHandler> animationHandlers = new HashSet<AnimationHandler>();
    private HashMap<WritableValue<?>, Object> initialValuesMap = new HashMap();
    private long startTime = -1L;
    private boolean running = false;
    private List<CacheMomento> caches = new ArrayList<CacheMomento>();
    private double totalElapsedMilliseconds;
    Runnable onFinished = null;

    public JFXAnimationTimer(JFXKeyFrame ... keyFrames) {
        for (JFXKeyFrame keyFrame : keyFrames) {
            Duration duration = keyFrame.getTime();
            Set<JFXKeyValue> keyValuesSet = keyFrame.getValues();
            if (keyValuesSet.isEmpty()) continue;
            this.animationHandlers.add(new AnimationHandler(duration, keyFrame.getValues()));
        }
    }

    public void start() {
        super.start();
        this.running = true;
        this.startTime = -1L;
        for (AnimationHandler animationHandler : this.animationHandlers) {
            animationHandler.init();
        }
        for (CacheMomento cache : this.caches) {
            cache.cache();
        }
    }

    public void handle(long now) {
        this.startTime = this.startTime == -1L ? now : this.startTime;
        this.totalElapsedMilliseconds = (double)(now - this.startTime) / 1000000.0;
        boolean stop = true;
        for (AnimationHandler handler : this.animationHandlers) {
            handler.animate(this.totalElapsedMilliseconds);
            if (handler.finished) continue;
            stop = false;
        }
        if (stop) {
            this.stop();
        }
    }

    public void reverseAndContinue() {
        if (this.isRunning()) {
            super.stop();
            for (AnimationHandler handler : this.animationHandlers) {
                handler.reverse(this.totalElapsedMilliseconds);
            }
            this.startTime = -1L;
            super.start();
        } else {
            this.start();
        }
    }

    public void stop() {
        super.stop();
        this.running = false;
        this.initialValuesMap.clear();
        for (CacheMomento cache : this.caches) {
            cache.restore();
        }
        if (this.onFinished != null) {
            this.onFinished.run();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setOnFinished(Runnable onFinished) {
        this.onFinished = onFinished;
    }

    public void setCacheNodes(Node ... nodesToCache) {
        this.caches.clear();
        if (nodesToCache != null) {
            for (Node node : nodesToCache) {
                this.caches.add(new CacheMomento(node));
            }
        }
    }

    class AnimationHandler {
        double duration;
        double currentDuration;
        Set<JFXKeyValue> keyValues;
        boolean finished = false;

        public AnimationHandler(Duration duration, Set<JFXKeyValue> keyValues) {
            this.currentDuration = this.duration = duration.toMillis();
            this.keyValues = keyValues;
        }

        public void init() {
            this.finished = false;
            for (JFXKeyValue keyValue : this.keyValues) {
                if (keyValue.getTarget() == null) continue;
                JFXAnimationTimer.this.initialValuesMap.putIfAbsent(keyValue.getTarget(), keyValue.getTarget().getValue());
            }
        }

        public void reverse(double now) {
            this.currentDuration = this.duration - (this.currentDuration - now);
            for (JFXKeyValue keyValue : this.keyValues) {
                if (keyValue.getTarget() == null) continue;
                JFXAnimationTimer.this.initialValuesMap.put(keyValue.getTarget(), keyValue.getTarget().getValue());
            }
        }

        public void animate(double now) {
            if (now <= this.currentDuration) {
                for (JFXKeyValue keyValue : this.keyValues) {
                    WritableValue<?> target;
                    if (!keyValue.isValid() || (target = keyValue.getTarget()) == null || target.getValue().equals(keyValue.getEndValue())) continue;
                    target.setValue(keyValue.getInterpolator().interpolate(JFXAnimationTimer.this.initialValuesMap.get(target), keyValue.getEndValue(), now / this.currentDuration));
                }
            } else if (!this.finished) {
                this.finished = true;
                for (JFXKeyValue keyValue : this.keyValues) {
                    WritableValue<?> target;
                    if (!keyValue.isValid() || (target = keyValue.getTarget()) == null) continue;
                    target.setValue(keyValue.getEndValue());
                }
                this.currentDuration = this.duration;
            }
        }
    }
}

