/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXMasonryPane$$Lambda$1;
import com.jfoenix.controls.JFXMasonryPane$$Lambda$2;
import com.jfoenix.controls.JFXMasonryPane$$Lambda$3;
import com.jfoenix.controls.JFXMasonryPane$$Lambda$4;
import com.jfoenix.controls.JFXMasonryPane$1$$Lambda$1;
import com.jfoenix.controls.JFXMasonryPane$2$$Lambda$1;
import com.jfoenix.transitions.CachedTransition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.geometry.BoundingBox;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class JFXMasonryPane
extends Pane {
    private boolean performingLayout = false;
    private int[][] matrix;
    private HashMap<Region, Transition> animationMap = null;
    private ParallelTransition trans = new ParallelTransition();
    private boolean valid = false;
    private List<BoundingBox> oldBoxes;
    private ObjectProperty<LayoutMode> layoutMode = new SimpleObjectProperty((Object)LayoutMode.MASONRY);
    private DoubleProperty cellWidth = new SimpleDoubleProperty(70.0);
    private DoubleProperty cellHeight = new SimpleDoubleProperty(70.0);
    private DoubleProperty hSpacing = new SimpleDoubleProperty(5.0);
    private DoubleProperty vSpacing = new SimpleDoubleProperty(5.0);
    private IntegerProperty limitColumn = new SimpleIntegerProperty(-1);
    private IntegerProperty limitRow = new SimpleIntegerProperty(-1);

    public JFXMasonryPane() {
        this.widthProperty().addListener(JFXMasonryPane$$Lambda$1.lambdaFactory$(this));
        this.heightProperty().addListener(JFXMasonryPane$$Lambda$2.lambdaFactory$(this));
        InvalidationListener layoutListener = JFXMasonryPane$$Lambda$3.lambdaFactory$(this);
        this.cellWidthProperty().addListener(layoutListener);
        this.cellHeightProperty().addListener(layoutListener);
        this.hSpacingProperty().addListener(layoutListener);
        this.vSpacingProperty().addListener(layoutListener);
        this.limitColumnProperty().addListener(layoutListener);
        this.limitRowProperty().addListener(layoutListener);
        this.getChildren().addListener(JFXMasonryPane$$Lambda$4.lambdaFactory$(this));
    }

    protected void layoutChildren() {
        this.performingLayout = true;
        if (!this.valid) {
            int i;
            int col = (int)Math.floor(this.getWidth() / (this.getCellWidth() + 2.0 * this.getHSpacing()));
            int n = col = this.getLimitColumn() != -1 && col > this.getLimitColumn() ? this.getLimitColumn() : col;
            if (this.matrix != null && col == this.matrix[0].length) {
                this.performingLayout = false;
                return;
            }
            int row = 100;
            row = this.getLimitRow() != -1 && row > this.getLimitRow() ? this.getLimitRow() : row;
            this.matrix = new int[row][col];
            double minWidth = -1.0;
            double minHeight = -1.0;
            ArrayList<Region> childs = new ArrayList<Region>();
            for (i = 0; i < this.getChildren().size(); ++i) {
                if (!(this.getChildren().get(i) instanceof Region)) continue;
                childs.add((Region)this.getChildren().get(i));
            }
            List<BoundingBox> newBoxes = ((LayoutMode)this.layoutMode.get()).fillGrid(this.matrix, childs, this.getCellWidth(), this.getCellHeight(), row, col, this.getHSpacing(), this.getVSpacing());
            if (newBoxes == null) {
                this.performingLayout = false;
                return;
            }
            for (i = 0; i < this.getChildren().size() && i < newBoxes.size(); ++i) {
                double blockHeight;
                double blockWidth;
                double blockY;
                double blockX;
                final Region block = (Region)this.getChildren().get(i);
                if (block instanceof GridPane) continue;
                if (newBoxes.get(i) != null) {
                    blockX = newBoxes.get(i).getMinY() * this.getCellWidth() + ((newBoxes.get(i).getMinY() + 1.0) * 2.0 - 1.0) * this.getHSpacing();
                    blockY = newBoxes.get(i).getMinX() * this.getCellHeight() + ((newBoxes.get(i).getMinX() + 1.0) * 2.0 - 1.0) * this.getVSpacing();
                    blockWidth = newBoxes.get(i).getWidth() * this.getCellWidth() + (newBoxes.get(i).getWidth() - 1.0) * 2.0 * this.getHSpacing();
                    blockHeight = newBoxes.get(i).getHeight() * this.getCellHeight() + (newBoxes.get(i).getHeight() - 1.0) * 2.0 * this.getVSpacing();
                } else {
                    blockX = block.getLayoutX();
                    blockY = block.getLayoutY();
                    blockWidth = -1.0;
                    blockHeight = -1.0;
                }
                if (this.animationMap == null) {
                    block.setLayoutX(blockX);
                    block.setLayoutY(blockY);
                    block.setPrefSize(blockWidth, blockHeight);
                    block.resizeRelocate(blockX, blockY, blockWidth, blockHeight);
                } else {
                    KeyFrame keyFrame;
                    if (this.oldBoxes == null || i >= this.oldBoxes.size()) {
                        block.setOpacity(0.0);
                        block.setLayoutX(blockX);
                        block.setLayoutY(blockY);
                        block.setPrefSize(blockWidth, blockHeight);
                        block.resizeRelocate(blockX, blockY, blockWidth, blockHeight);
                    }
                    if (newBoxes.get(i) != null) {
                        keyFrame = new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{new KeyValue((WritableValue)block.opacityProperty(), (Object)1, Interpolator.LINEAR), new KeyValue((WritableValue)block.layoutXProperty(), (Object)blockX, Interpolator.LINEAR), new KeyValue((WritableValue)block.layoutYProperty(), (Object)blockY, Interpolator.LINEAR)});
                        this.animationMap.put(block, new CachedTransition((Node)block, new Timeline(new KeyFrame[]{keyFrame})){
                            {
                                super(node, timeline);
                                this.setCycleDuration(Duration.seconds((double)0.32));
                                this.setDelay(Duration.seconds((double)0.0));
                                this.setOnFinished(JFXMasonryPane$1$$Lambda$1.lambdaFactory$(block, blockX, blockY));
                            }

                            static /* synthetic */ void lambda$new$0(Region block2, double blockX2, double blockY2, ActionEvent finish) {
                                block2.setLayoutX(blockX2);
                                block2.setLayoutY(blockY2);
                                block2.setOpacity(1.0);
                            }
                        });
                    } else {
                        keyFrame = new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{new KeyValue((WritableValue)block.opacityProperty(), (Object)0, Interpolator.LINEAR), new KeyValue((WritableValue)block.layoutXProperty(), (Object)blockX, Interpolator.LINEAR), new KeyValue((WritableValue)block.layoutYProperty(), (Object)blockY, Interpolator.LINEAR)});
                        this.animationMap.put(block, new CachedTransition((Node)block, new Timeline(new KeyFrame[]{keyFrame})){
                            {
                                super(node, timeline);
                                this.setCycleDuration(Duration.seconds((double)0.32));
                                this.setDelay(Duration.seconds((double)0.0));
                                this.setOnFinished(JFXMasonryPane$2$$Lambda$1.lambdaFactory$(block, blockX, blockY));
                            }

                            static /* synthetic */ void lambda$new$0(Region block2, double blockX2, double blockY2, ActionEvent finish) {
                                block2.setLayoutX(blockX2);
                                block2.setLayoutY(blockY2);
                                block2.setOpacity(0.0);
                            }
                        });
                    }
                }
                if (newBoxes.get(i) == null) continue;
                if (blockX + blockWidth > minWidth) {
                    minWidth = blockX + blockWidth;
                }
                if (!(blockY + blockHeight > minHeight)) continue;
                minHeight = blockY + blockHeight;
            }
            this.setMinSize(minWidth, minHeight);
            if (this.animationMap == null) {
                this.animationMap = new HashMap();
            }
            this.trans.stop();
            ParallelTransition newTransition = new ParallelTransition();
            newTransition.getChildren().addAll(this.animationMap.values());
            newTransition.play();
            this.trans = newTransition;
            this.oldBoxes = newBoxes;
            this.valid = true;
        }
        this.performingLayout = false;
    }

    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        super.requestLayout();
    }

    public final ObjectProperty<LayoutMode> layoutModeProperty() {
        return this.layoutMode;
    }

    public final LayoutMode getLayoutMode() {
        return (LayoutMode)this.layoutModeProperty().get();
    }

    public final void setLayoutMode(LayoutMode layoutMode) {
        this.layoutModeProperty().set((Object)layoutMode);
    }

    public final DoubleProperty cellWidthProperty() {
        return this.cellWidth;
    }

    public final double getCellWidth() {
        return this.cellWidthProperty().get();
    }

    public final void setCellWidth(double cellWidth) {
        this.cellWidthProperty().set(cellWidth);
    }

    public final DoubleProperty cellHeightProperty() {
        return this.cellHeight;
    }

    public final double getCellHeight() {
        return this.cellHeightProperty().get();
    }

    public final void setCellHeight(double cellHeight) {
        this.cellHeightProperty().set(cellHeight);
    }

    public final DoubleProperty hSpacingProperty() {
        return this.hSpacing;
    }

    public final double getHSpacing() {
        return this.hSpacingProperty().get();
    }

    public final void setHSpacing(double spacing) {
        this.hSpacingProperty().set(spacing);
    }

    public final DoubleProperty vSpacingProperty() {
        return this.vSpacing;
    }

    public final double getVSpacing() {
        return this.vSpacingProperty().get();
    }

    public final void setVSpacing(double spacing) {
        this.vSpacingProperty().set(spacing);
    }

    public final IntegerProperty limitColumnProperty() {
        return this.limitColumn;
    }

    public final int getLimitColumn() {
        return this.limitColumnProperty().get();
    }

    public final void setLimitColumn(int limitColumn) {
        this.limitColumnProperty().set(limitColumn);
    }

    public final IntegerProperty limitRowProperty() {
        return this.limitRow;
    }

    public final int getLimitRow() {
        return this.limitRowProperty().get();
    }

    public final void setLimitRow(int limitRow) {
        this.limitRowProperty().set(limitRow);
    }

    static /* synthetic */ void lambda$new$3(JFXMasonryPane this_, Observable observable) {
        this_.valid = false;
        this_.matrix = null;
        this_.requestLayout();
    }

    static /* synthetic */ void lambda$new$2(JFXMasonryPane this_, Observable observable) {
        this_.valid = false;
        this_.requestLayout();
    }

    static /* synthetic */ void lambda$new$1(JFXMasonryPane this_, Observable observable) {
        this_.valid = false;
    }

    static /* synthetic */ void lambda$new$0(JFXMasonryPane this_, Observable observable) {
        this_.valid = false;
    }

    private static class BinPackingLayout
    extends LayoutMode {
        private BinPackingLayout() {
        }

        @Override
        public List<BoundingBox> fillGrid(int[][] matrix, List<Region> children, double cellWidth, double cellHeight, int limitRow, int limitCol, double gutterX, double gutterY) {
            int row = matrix.length;
            if (row <= 0) {
                return null;
            }
            int col = matrix[0].length;
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            block0: for (int b = 0; b < children.size(); ++b) {
                Region block = children.get(b);
                for (int i = 0; i < row; ++i) {
                    int old = boxes.size();
                    for (int j = 0; j < col; ++j) {
                        BoundingBox box;
                        if (matrix[i][j] != 0 || !this.validWidth(box = this.getFreeArea(matrix, i, j, block, cellWidth, cellHeight, limitRow, limitCol, gutterX, gutterY), block, cellWidth, gutterX, gutterY) || !this.validHeight(box, block, cellHeight, gutterX, gutterY)) continue;
                        matrix = this.fillMatrix(matrix, b + 1, box.getMinX(), box.getMinY(), box.getWidth(), box.getHeight());
                        boxes.add(box);
                        break;
                    }
                    if (boxes.size() != old) continue block0;
                    if (i != row - 1) continue;
                    boxes.add(null);
                }
            }
            return boxes;
        }
    }

    private static class MasonryLayout
    extends LayoutMode {
        private MasonryLayout() {
        }

        @Override
        public List<BoundingBox> fillGrid(int[][] matrix, List<Region> children, double cellWidth, double cellHeight, int limitRow, int limitCol, double gutterX, double gutterY) {
            int row = matrix.length;
            if (row <= 0) {
                return null;
            }
            int col = matrix[0].length;
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            block0: for (int b = 0; b < children.size(); ++b) {
                Region block = children.get(b);
                for (int i = 0; i < row; ++i) {
                    int old = boxes.size();
                    for (int j = 0; j < col; ++j) {
                        BoundingBox box;
                        if (matrix[i][j] != 0) continue;
                        boolean isValidCell = true;
                        for (int k = i + 1; k < row; ++k) {
                            if (matrix[k][j] == 0) continue;
                            isValidCell = false;
                            break;
                        }
                        if (!isValidCell || !this.validWidth(box = this.getFreeArea(matrix, i, j, block, cellWidth, cellHeight, limitRow, limitCol, gutterX, gutterY), block, cellWidth, gutterX, gutterY) || !this.validHeight(box, block, cellHeight, gutterX, gutterY)) continue;
                        matrix = this.fillMatrix(matrix, b + 1, box.getMinX(), box.getMinY(), box.getWidth(), box.getHeight());
                        boxes.add(box);
                        break;
                    }
                    if (boxes.size() != old) continue block0;
                    if (i != row - 1) continue;
                    boxes.add(null);
                }
            }
            return boxes;
        }
    }

    public static abstract class LayoutMode {
        public static final MasonryLayout MASONRY = new MasonryLayout();
        public static final BinPackingLayout BIN_PACKING = new BinPackingLayout();

        protected abstract List<BoundingBox> fillGrid(int[][] var1, List<Region> var2, double var3, double var5, int var7, int var8, double var9, double var11);

        protected BoundingBox getFreeArea(int[][] matrix, int x, int y, Region block, double cellWidth, double cellHeight, int limitRow, int limitCol, double gutterX, double gutterY) {
            int j;
            int i;
            double blockHeight = this.getBLockHeight(block);
            double blockWidth = this.getBLockWidth(block);
            int rowsNeeded = (int)Math.ceil(blockHeight / (cellHeight + gutterY));
            if (cellHeight * (double)rowsNeeded + (double)((rowsNeeded - 1) * 2) * gutterY < blockHeight) {
                ++rowsNeeded;
            }
            int maxRow = Math.min(x + rowsNeeded, limitRow);
            int colsNeeded = (int)Math.ceil(blockWidth / (cellWidth + gutterX));
            if (cellWidth * (double)colsNeeded + (double)((colsNeeded - 1) * 2) * gutterX < blockWidth) {
                ++colsNeeded;
            }
            int maxCol = Math.min(y + colsNeeded, limitCol);
            int minRow = maxRow;
            int minCol = maxCol;
            for (i = x; i < minRow; ++i) {
                for (j = y; j < maxCol; ++j) {
                    if (matrix[i][j] == 0 || y >= j || j >= minCol) continue;
                    minCol = j;
                }
            }
            for (i = x; i < maxRow; ++i) {
                for (j = y; j < minCol; ++j) {
                    if (matrix[i][j] == 0 || x >= i || i >= minRow) continue;
                    minRow = i;
                }
            }
            return new BoundingBox((double)x, (double)y, (double)(minCol - y), (double)(minRow - x));
        }

        protected double getBLockWidth(Region region) {
            if (region.getMinWidth() != -1.0) {
                return region.getMinWidth();
            }
            if (region.getPrefWidth() != -1.0) {
                return region.getPrefWidth();
            }
            return region.prefWidth(-1.0);
        }

        protected double getBLockHeight(Region region) {
            if (region.getMinHeight() != -1.0) {
                return region.getMinHeight();
            }
            if (region.getPrefHeight() != -1.0) {
                return region.getPrefHeight();
            }
            return region.prefHeight(this.getBLockWidth(region));
        }

        protected boolean validWidth(BoundingBox box, Region region, double cellW, double gutterX, double gutterY) {
            boolean valid = false;
            if (region.getMinWidth() != -1.0 && box.getWidth() * cellW + (box.getWidth() - 1.0) * 2.0 * gutterX < region.getMinWidth()) {
                return false;
            }
            if (region.getPrefWidth() == -1.0 && box.getWidth() * cellW + (box.getWidth() - 1.0) * 2.0 * gutterX >= region.prefWidth(-1.0)) {
                valid = true;
            }
            if (region.getPrefWidth() != -1.0 && box.getWidth() * cellW + (box.getWidth() - 1.0) * 2.0 * gutterX >= region.getPrefWidth()) {
                valid = true;
            }
            return valid;
        }

        protected boolean validHeight(BoundingBox box, Region region, double cellH, double gutterX, double gutterY) {
            boolean valid = false;
            if (region.getMinHeight() != -1.0 && box.getHeight() * cellH + (box.getHeight() - 1.0) * 2.0 * gutterY < region.getMinHeight()) {
                return false;
            }
            if (region.getPrefHeight() == -1.0 && box.getHeight() * cellH + (box.getHeight() - 1.0) * 2.0 * gutterY >= region.prefHeight(region.prefWidth(-1.0))) {
                valid = true;
            }
            if (region.getPrefHeight() != -1.0 && box.getHeight() * cellH + (box.getHeight() - 1.0) * 2.0 * gutterY >= region.getPrefHeight()) {
                valid = true;
            }
            return valid;
        }

        protected int[][] fillMatrix(int[][] matrix, int id, double row, double col, double width, double height) {
            int x = (int)row;
            while ((double)x < row + height) {
                int y = (int)col;
                while ((double)y < col + width) {
                    matrix[x][y] = id;
                    ++y;
                }
                ++x;
            }
            return matrix;
        }
    }
}

