# CIMA

This repository includes the data for the paper "CIMA: Construction of a Large Open Access Dialogue Dataset for Tutoring," to be presented at the Building Educational Applications (BEA) workshop at ACL 2020.

Data is made available under the Creative Commons 2.5 license (https://creativecommons.org/licenses/by/2.5/).  

The following are the keys for TutorActions and StudentActions, which are a list of booleans corresponding to the following actions:

Tutor Action Key:  [Question, Hint/Information Reveal, Correction, Confirmation, Other]

Student Action Key: [Guess, Question, Affirmation, Other]

If you make use of this data, please cite our paper:
```
@inproceedings{stasaski-etal-2020-cima,
    title = "{CIMA}: A Large Open Access Dialogue Dataset for Tutoring",
    author = "Stasaski, Katherine  and
      Kao, Kimberly  and
      Hearst, Marti A.",
    booktitle = "Proceedings of the Fifteenth Workshop on Innovative Use of NLP for Building Educational Applications",
    month = jul,
    year = "2020",
    address = "Seattle, WA, USA â†’ Online",
    publisher = "Association for Computational Linguistics",
    url = "https://www.aclweb.org/anthology/2020.bea-1.5",
    pages = "52--64",
    abstract = "One-to-one tutoring is often an effective means to help students learn, and recent experiments with neural conversation systems are promising. However, large open datasets of tutoring conversations are lacking. To remedy this, we propose a novel asynchronous method for collecting tutoring dialogue via crowdworkers that is both amenable to the needs of deep learning algorithms and reflective of pedagogical concerns. In this approach, extended conversations are obtained between crowdworkers role-playing as both students and tutors. The CIMA collection, which we make publicly available, is novel in that students are exposed to overlapping grounded concepts between exercises and multiple relevant tutoring responses are collected for the same input. CIMA contains several compelling properties from an educational perspective: student role-players complete exercises in fewer turns during the course of the conversation and tutor players adopt strategies that conform with some educational conversational norms, such as providing hints versus asking questions in appropriate contexts. The dataset enables a model to be trained to generate the next tutoring utterance in a conversation, conditioned on a provided action strategy.",
}
```
