<?php

/**
 * This file is part of the Krystal Framework
 * 
 * Copyright (c) No Global State Lab
 * 
 * For the full copyright and license information, please view
 * the license file that was distributed with this source code.
 */

namespace Krystal\Text;

abstract class ForeignChars
{
    /**
     * Foreign chars
     * 
     * @var array
     */
    private static $chars = array(
        '/ä|æ|ǽ/'   => 'ae',
        '/ö|œ/'     => 'oe',
        '/ü/'       => 'ue',
        '/Ä/'       => 'Ae',
        '/Ü/'       => 'Ue',
        '/Ö/'       => 'Oe',
        '/À|Á|Â|Ã|Ä|Å|Ǻ|Ā|Ă|Ą|Ǎ|Α|Ά|А/' => 'A',
        '/à|á|â|ã|å|ǻ|ā|ă|ą|ǎ|ª|α|ά|а/' => 'a',
        '/Б/'       => 'B',
        '/б/'       => 'b',
        '/Ç|Ć|Ĉ|Ċ|Č|Ц/' => 'C',
        '/ç|ć|ĉ|ċ|č|ц/' => 'c',
        '/Ð|Ď|Đ|Δ|Д/' => 'D',
        '/ð|ď|đ|δ|д/' => 'd',
        '/È|É|Ê|Ë|Ē|Ĕ|Ė|Ę|Ě|Ε|Έ|Е|Ё|Э/' => 'E',
        '/è|é|ê|ë|ē|ĕ|ė|ę|ě|έ|ε|е|ё|э/' => 'e',
        '/Ф/'       => 'F',
        '/ф/'       => 'f',
        '/Ĝ|Ğ|Ġ|Ģ|Γ|Г|Ғ/' => 'G',
        '/ĝ|ğ|ġ|ģ|γ|г|ғ/' => 'g',
        '/Ĥ|Ħ|Х|Ҳ/'   => 'H',
        '/ĥ|ħ|х|ҳ/'   => 'h',
        '/Ì|Í|Î|Ï|Ĩ|Ī|Ĭ|Ǐ|Į|İ|Η|Ή|Ί|Ι|Ϊ|И/' => 'I',
        '/ì|í|î|ï|ĩ|ī|ĭ|ǐ|į|ı|η|ή|ί|ι|ϊ|и/' => 'i',
        '/Ĵ|Й/'     => 'J',
        '/ĵ|й/'     => 'j',
        '/Ķ|Κ|К|Қ/'   => 'K',
        '/ķ|κ|к|қ/'   => 'k',
        '/Ĺ|Ļ|Ľ|Ŀ|Ł|Λ|Л/' => 'L',
        '/ĺ|ļ|ľ|ŀ|ł|λ|л/' => 'l',
        '/М/'       => 'M',
        '/м/'       => 'm',
        '/Ñ|Ń|Ņ|Ň|Ν|Н/' => 'N',
        '/ñ|ń|ņ|ň|ŉ|ν|н/' => 'n',
        '/Ò|Ó|Ô|Õ|Ō|Ŏ|Ǒ|Ő|Ơ|Ø|Ǿ|Ο|Ό|Ω|Ώ|О/' => 'O',
        '/ò|ó|ô|õ|ō|ŏ|ǒ|ő|ơ|ø|ǿ|º|ο|ό|ω|ώ|о/' => 'o',
        '/Π|П/' => 'P',
        '/π|п/' => 'p',
        '/Ŕ|Ŗ|Ř|Ρ|Р/' => 'R',
        '/ŕ|ŗ|ř|ρ|р/' => 'r',
        '/Ś|Ŝ|Ş|Š|Σ|С/' => 'S',
        '/ś|ŝ|ş|š|ſ|σ|ς|с/' => 's',
        '/Ţ|Ť|Ŧ|Τ|Т/' => 'T',
        '/ţ|ť|ŧ|τ|т/' => 't',
        '/Ù|Ú|Û|Ũ|Ū|Ŭ|Ů|Ű|Ų|Ư|Ǔ|Ǖ|Ǘ|Ǚ|Ǜ|У|Ў/' => 'U',
        '/ù|ú|û|ũ|ū|ŭ|ů|ű|ų|ư|ǔ|ǖ|ǘ|ǚ|ǜ|υ|ύ|ϋ|у|ў/' => 'u',
        '/В/' => 'V',
        '/в/' => 'v',
        '/Ý|Ÿ|Ŷ|Υ|Ύ|Ϋ|Ы/' => 'Y',
        '/ý|ÿ|ŷ|ы/' => 'y',
        '/Ŵ/' => 'W',
        '/ŵ/' => 'w',
        '/Ź|Ż|Ž|Ζ|З/' => 'Z',
        '/ź|ż|ž|ζ|з/' => 'z',
        '/Æ|Ǽ/' => 'AE',
        '/ß/'=> 'ss',
        '/Ĳ/' => 'IJ',
        '/ĳ/' => 'ij',
        '/Œ/' => 'OE',
        '/ƒ/' => 'f',
        '/θ/' => 'th',
        '/χ/' => 'x',
        '/φ/' => 'f',
        '/ξ/' => 'ks',
        '/π/' => 'p',
        '/β/' => 'v',
        '/μ/' => 'm',
        '/ψ/' => 'ps',
        '/Ч/' => 'Ch',
        '/ч/' => 'ch',
        '/Ю/' => 'Ju',
        '/ю/' => 'ju',
        '/Я/' => 'Ya',
        '/я/' => 'ya',
        '/Ш/' => 'Sh',
        '/ш/' => 'sh',
        '/Щ/' => 'Shch',
        '/щ/' => 'shch',
        '/Ж/' => 'Zh',
        '/ж/' => 'zh',
        '/ь|ъ/' =>  '',
    );

    /**
     * Romanizes the string that contains foreign chars
     * 
     * @param string $string The input
     * @return string Normalized string
     */
    public static function romanize($string)
    {
        foreach (self::$chars as $regex => $replacement) {
            // u enables Unicode
            $string = preg_replace($regex . 'u', $replacement, $string);
        }

        return $string;
    }
}
