<?php

/**
 * This file is part of the Krystal Framework
 * 
 * Copyright (c) No Global State Lab
 * 
 * For the full copyright and license information, please view
 * the license file that was distributed with this source code.
 */

namespace Krystal\Iso\ISO3166;

/**
 * Represents ISO3166-1 Alpha-2 codes
 */
final class Country
{
    /**
     * Country code name collection
     * 
     * @var array
     */
    private $countries = array(
        //'catalonia' => '',
        //'scotland' => '',
        //'england' => '',
        //'wales' => '',
        'zw' => 'Zimbabwe',
        'za' => 'South Africa',
        'yt' => 'Mayotte',
        'ye' => 'Yemen',
        'ws' => 'Samoa',
        'wf' => 'Wallis and Futuna',
        'vu' => 'Vanuatu',
        'vn' => 'Viet Nam',
        'vi' => 'Virgin Islands, U.S.',
        'vg' => 'Virgin Islands, British',
        've' => 'Venezuela, Bolivarian Republic of',
        'vc' => 'Saint Vincent and the Grenadines',
        'va' => 'Holy See (Vatican City State)',
        'uz' => 'Uzbekistan',
        'uy' => 'Uruguay',
        'us' => 'United States',
        'um' => 'United States Minor Outlying Islands',
        'ug' => 'Uganda',
        'ua' => 'Ukraine',
        'tz' => 'Tanzania, United Republic of',
        'tw' => 'Taiwan, Province of China',
        'tv' => 'Tuvalu',
        'tt' => 'Trinidad and Tobago',
        'tr' => 'Turkey',
        'to' => 'Tonga',
        'tn' => 'Tunisia',
        'tm' => 'Turkmenistan',
        'tl' => 'Timor-Leste',
        'tk' => 'Tokelau',
        'tj' => 'Tajikistan',
        'th' => 'Thailand',
        'tg' => 'Togo',
        'tf' => 'French Southern Territories',
        'td' => 'Chad',
        'tc' => 'Turks and Caicos Islands',
        'sz' => 'Swaziland',
        'sy' => 'Syrian Arab Republic',
        'sx' => 'Sint Maarten (Dutch part)',
        'sv' => 'El Salvador',
        'st' => 'Sao Tome and Principe',
        'ss' => 'South Sudan',
        'sr' => 'Suriname',
        'so' => 'Somalia',
        'sn' => 'Senegal',
        'sm' => 'San Marino',
        'sl' => 'Sierra Leone',
        'sk' => 'Slovakia',
        'sj' => 'Svalbard and Jan Mayen',
        'si' => 'Slovenia',
        'sh' => 'Saint Helena, Ascension and Tristan da Cunha',
        'sg' => 'Singapore',
        'se' => 'Sweden',
        'sd' => 'Sudan',
        'sc' => 'Seychelles',
        'sb' => 'Solomon Islands',
        'sa' => 'Saudi Arabia',
        'rw' => 'Rwanda',
        'ru' => 'Russian Federation',
        'rs' => 'Serbia',
        'ro' => 'Romania',
        're' => 'Reunion',
        'qa' => 'Qatar',
        'py' => 'Paraguay',
        'pw' => 'Palau',
        'pt' => 'Portugal',
        'ps' => 'Palestine, State of',
        'pr' => 'Puerto Rico',
        'pn' => 'Pitcairn',
        'pm' => 'Saint Pierre and Miquelon',
        'pl' => 'Poland',
        'pk' => 'Pakistan',
        'ph' => 'Philippines',
        'pg' => 'Papua New Guinea',
        'pf' => 'French Polynesia',
        'pe' => 'Peru',
        'pa' => 'Panama',
        'om' => 'Oman',
        'nz' => 'New Zealand',
        'nu' => 'Niue',
        'nr' => 'Nauru',
        'np' => 'Nepal',
        'no' => 'Norway',
        'bv' => 'Bouvet Island',
        'sj' => 'Svalbard and Jan Mayen',
        'nl' => 'Netherlands',
        'ni' => 'Nicaragua',
        'ng' => 'Nigeria',
        'nf' => 'Norfolk Island',
        'ne' => 'Niger',
        'nc' => 'New Caledonia',
        'na' => 'Namibia',
        'mz' => 'Mozambique',
        'my' => 'Malaysia',
        'mx' => 'Mexico',
        'mw' => 'Malawi',
        'mv' => 'Maldives',
        'mu' => 'Mauritius',
        'mt' => 'Malta',
        'ms' => 'Montserrat',
        'mr' => 'Mauritania',
        'mq' => 'Martinique',
        'mp' => 'Northern Mariana Islands',
        'mo' => 'Macao',
        'mn' => 'Mongolia',
        'mm' => 'Myanmar',
        'ml' => 'Mali',
        'mk' => 'Macedonia, the former Yugoslav Republic of',
        'mh' => 'Marshall Islands',
        'mg' => 'Madagascar',
        'me' => 'Montenegro',
        'mf' => 'Saint Martin (French part)',
        'md' => 'Moldova, Republic of',
        'mc' => 'Monaco',
        'ma' => 'Morocco',
        'ly' => 'Libya',
        'lv' => 'Latvia',
        'lu' => 'Luxembourg',
        'lt' => 'Lithuania',
        'ls' => 'Lesotho',
        'lr' => 'Liberia',
        'lk' => 'Sri Lanka',
        'li' => 'Liechtenstein',
        'lc' => 'Saint Lucia',
        'lb' => 'Lebanon',
        'la' => "Lao People's Democratic Republic",
        'kz' => 'Kazakhstan',
        'ky' => 'Cayman Islands',
        'kw' => 'Kuwait',
        'kr' => 'Korea, Republic of',
        'kp' => "Korea, Democratic People's Republic of",
        'kn' => 'Saint Kitts and Nevis',
        'km' => 'Comoros',
        'ki' => 'Kiribati',
        'kh' => 'Cambodia',
        'kg' => 'Kyrgyzstan',
        'ke' => 'Kenya',
        'jp' => 'Japan',
        'jo' => 'Jordan',
        'jm' => 'Jamaica',
        'je' => 'Jersey',
        'it' => 'Italy',
        'is' => 'Iceland',
        'ir' => 'Iran, Islamic Republic of',
        'iq' => 'Iraq',
        'io' => 'British Indian Ocean Territory',
        'in' => 'India',
        'im' => 'Isle of Man',
        'il' => 'Israel',
        'ie' => 'Ireland',
        'id' => 'Indonesia',
        'hu' => 'Hungary',
        'ht' => 'Haiti',
        'hr' => 'Croatia',
        'hn' => 'Honduras',
        'hm' => 'Heard Island and McDonald Islands',
        'hk' => 'Hong Kong',
        'gy' => 'Guyana',
        'gw' => 'Guinea-Bissau',
        'gu' => 'Guam',
        'gt' => 'Guatemala',
        'gs' => 'South Georgia and the South Sandwich Islands',
        'gr' => 'Greece',
        'gq' => 'Equatorial Guinea',
        'gp' => 'Guadeloupe',
        'gn' => 'Guinea',
        'gm' => 'Gambia',
        'gl' => 'Greenland',
        'gi' => 'Gibraltar',
        'gh' => 'Ghana',
        'gg' => 'Guernsey',
        'gf' => 'French Guiana',
        'ge' => 'Georgia',
        'gd' => 'Grenada',
        'gb' => 'United Kingdom',
        'ga' => 'Gabon',
        'fr' => 'France',
        're' => 'Heard Island and McDonald Islands',
        'mf' => 'Saint Martin (French part)',
        'fo' => 'Faroe Islands',
        'fm' => 'Micronesia, Federated States of',
        'fk' => 'Falkland Islands (Malvinas)',
        'fj' => 'Fiji',
        'fi' => 'Finland',
        'eu' => 'Europe',
        'et' => 'Ethiopia',
        'es' => 'Spain',
        'er' => 'Eritrea',
        'eh' => 'Western Sahara',
        'eg' => 'Egypt',
        'ee' => 'Estonia',
        'ec' => 'Ecuador',
        'dz' => 'Algeria',
        'do' => 'Dominican Republic',
        'dm' => 'Dominica',
        'dk' => 'Denmark',
        'dj' => 'Djibouti',
        'de' => 'Germany',
        'cz' => 'Czech Republic',
        'cy' => 'Cyprus',
        'cx' => 'Christmas Island',
        'cw' => 'Curacao',
        'cv' => 'Cabo Verde',
        'cu' => 'Cuba',
        'cs' => 'Serbia and Montenegro',
        'cr' => 'Costa Rica',
        'co' => 'Colombia',
        'cn' => 'China',
        'cm' => 'Cameroon',
        'cl' => 'Chile',
        'ck' => 'Cook Islands',
        'ci' => "Cote d'Ivoire",
        'ch' => 'Switzerland',
        'cg' => 'Congo',
        'cf' => 'Central African Republic',
        'cd' => 'Congo, the Democratic Republic of the',
        'cc' => 'Cocos (Keeling) Islands',
        'ca' => 'Canada',
        'bz' => 'Belize',
        'by' => 'Belarus',
        'bw' => 'Botswana',
        'bt' => 'Bhutan',
        'bs' => 'Bahamas',
        'br' => 'Brazil',
        'bq' => 'Bonaire, Sint Eustatius and Saba',
        'bo' => 'Bolivia, Plurinational State of',
        'bn' => 'Brunei Darussalam',
        'bm' => 'Bermuda',
        'bl' => 'Saint Barthelemy',
        'bj' => 'Benin',
        'bi' => 'Burundi',
        'bh' => 'Bahrain',
        'bg' => 'Bulgaria',
        'bf' => 'Burkina Faso',
        'be' => 'Belgium',
        'bd' => 'Bangladesh',
        'bb' => 'Barbados',
        'ba' => 'Bosnia and Herzegovina',
        'az' => 'Azerbaijan',
        'ax' => 'Aland Islands',
        'aw' => 'Aruba',
        'au' => 'Australia',
        'at' => 'Austria',
        'as' => 'American Samoa',
        'ar' => 'Argentina',
        'aq' => 'Antarctica',
        'ao' => 'Angola',
        'am' => 'Armenia',
        'al' => 'Albania',
        'ai' => 'Anguilla',
        'ag' => 'Antigua and Barbuda',
        'af' => 'Afghanistan',
        'ae' => 'United Arab Emirates',
        'ad' => 'Andorra'
    );

    /**
     * Returns all collection
     * 
     * @return array
     */
    public function getAll()
    {
        return array_reverse($this->countries);
    }

    /**
     * Returns a country by its associated code
     * 
     * @param string $code
     * @return string
     */
    public function getCountryByCode($code)
    {
        return isset($this->countries[$code]) ? $this->countries[$code] : null;
    }

    /**
     * Returns a code by its associated country code
     * 
     * @param string $country
     * @return string
     */
    public function getCodeByCountry($country)
    {
        $countries = array_flip($this->countries);
        return $countries[$country];
    }
}
