<?php

/**
 * This file is part of the Krystal Framework
 * 
 * Copyright (c) No Global State Lab
 * 
 * For the full copyright and license information, please view
 * the license file that was distributed with this source code.
 */

namespace Krystal\Ftp;

interface ConnectorInterface
{
    /**
     * Tells whether user connected or not
     * 
     * @return boolean
     */
    public function isConnected();

    /**
     * Check whether user successfully logged in
     * 
     * @return boolean
     */
    public function isLoggedIn();

    /**
     * Returns a stream
     * 
     * @return resource
     */
    public function &getStream();

    /**
     * Connects to the server
     * 
     * @return boolean Depending on success
     */
    public function connect();

    /**
     * Disconnects from FTP server
     * 
     * @return boolean Depending on success
     */
    public function disconnect();

    /**
     * Logins using username and password
     * 
     * @param string $username
     * @param string $password
     * @return boolean Depending on success
     */
    public function login($username, $password);
}
