/*

	TVP2 ( T Visual Presenter 2 )  A script authoring tool
	Copyright (C) 2000-2009 W.Dee <dee@kikyou.info> and contributors

	See details of license at "license.txt"


*/

/* core C routines for graphics operations */
/* this file is always generated by gengl.pl rev. 0.1 */

/* #include "tjsCommHead.h" */
#include <memory.h>
#include <math.h>
#include "tjsTypes.h"
#include "tvpgl.h"

#if __BORLANDC__
	#pragma warn -par /* prevent unsed parameter warning */
	#pragma warn -aus /* prevent unsed variable warning */
#endif

/*-----------------------------------------------------------------*/
unsigned char TVPDivTable[256*256];
unsigned char TVPOpacityOnOpacityTable[256*256];
unsigned char TVPNegativeMulTable[256*256];
/* following two are for 65-level anti-aliased letter drawing */
/* ( TVPApplyColorMap65_d and TVPApplyColorMap65_do ) */
unsigned char TVPOpacityOnOpacityTable65[65*256];
unsigned char TVPNegativeMulTable65[65*256];
unsigned char TVPDitherTable_5_6[8][4][2][256];
unsigned char TVPDitherTable_676[3][4][4][256];
unsigned char TVP252DitherPalette[3][256];
tjs_uint32 TVPRecipTable256[256]; /* 1/x  table  ( 65536 ) multiplied */
tjs_uint16 TVPRecipTable256_16[256]; /* 1/x  table  ( 65536 ) multiplied,
	but limitted to 32767 (signed 16bits) */
static const tjs_uint8 TVPDither4x4[4][4] = {
 {   0, 12,  2, 14   },
 {   8,  4, 10,  6   },
 {   3, 15,  1, 13   },
 {  11,  7,  9,  5   }};

#define TVP_TLG6_GOLOMB_HALF_THRESHOLD 8


#define TVP_TLG6_GOLOMB_N_COUNT  4
#define TVP_TLG6_LeadingZeroTable_BITS 12
#define TVP_TLG6_LeadingZeroTable_SIZE  (1<<TVP_TLG6_LeadingZeroTable_BITS)
tjs_uint8 TVPTLG6LeadingZeroTable[TVP_TLG6_LeadingZeroTable_SIZE];
short int TVPTLG6GolombCompressed[TVP_TLG6_GOLOMB_N_COUNT][9] = {
		{3,7,15,27,63,108,223,448,130,},
		{3,5,13,24,51,95,192,384,257,},
		{2,5,12,21,39,86,155,320,384,},
		{2,3,9,18,33,61,129,258,511,},
	/* Tuned by W.Dee, 2004/03/25 */
};
char TVPTLG6GolombBitLengthTable
	[TVP_TLG6_GOLOMB_N_COUNT*2*128][TVP_TLG6_GOLOMB_N_COUNT] =
	{ { 0 } };



static void TVPTLG6InitLeadingZeroTable(void)
{
	/* table which indicates first set bit position + 1. */
	/* this may be replaced by BSF (IA32 instrcution). */

	int i;
	for(i = 0; i < TVP_TLG6_LeadingZeroTable_SIZE; i++)
	{
		int cnt = 0;
		int j;
		for(j = 1; j != TVP_TLG6_LeadingZeroTable_SIZE && !(i & j);
			j <<= 1, cnt++);
		cnt ++;
		if(j == TVP_TLG6_LeadingZeroTable_SIZE) cnt = 0;
		TVPTLG6LeadingZeroTable[i] = cnt;
	}
}

void TVPTLG6InitGolombTable(void)
{
	int n, i, j;
	for(n = 0; n < TVP_TLG6_GOLOMB_N_COUNT; n++)
	{
		int a = 0;
		for(i = 0; i < 9; i++)
		{
			for(j = 0; j < TVPTLG6GolombCompressed[n][i]; j++)
				TVPTLG6GolombBitLengthTable[a++][n] = (char)i;
		}
		if(a != TVP_TLG6_GOLOMB_N_COUNT*2*128)
			*(char*)0 = 0;   /* THIS MUST NOT BE EXECUETED! */
				/* (this is for compressed table data check) */
	}
}


static void TVPInitDitherTable(void)
{
	/* create an ordered dither table for conversion of 8bit->6bit and 8bit->5bit and */
	/* RGB ( 256*256*256 ) -> palettized 252 colors ( 6*7*6 ) */
	tjs_int j, i, r, g, b, c;

	for(j = 0; j < 4; j ++)
	{
		for(i = 0; i < 4; i ++)
		{
			double v1 = TVPDither4x4[j][i] / 16.0;
			double v2 = TVPDither4x4[((j+1)%2)][((i+1)%2)] / 16.0;
			double v3 = TVPDither4x4[j][((i+1)%2)] / 16.0;

			int n;

			for(n = 0; n < 256; n++)
			{
				double nt = n / 255.0;
				double frac;
				int main;

				/* for 5bit */
				main = (int)(nt * 31.0);
				frac = nt * 31.0 - (int)(nt * 31.0);
				TVPDitherTable_5_6[j][i][0][n] = main + ((v1 < frac)?1:0);
				TVPDitherTable_5_6[j+4][i][0][n] = TVPDitherTable_5_6[j][i][0][n];

				/* for 6bit */
				main = (int)(nt * 63.0);
				frac = nt * 63.0 - (int)(nt * 63.0);
				TVPDitherTable_5_6[j][i][1][n] = main + ((v2 < frac)?1:0);
				TVPDitherTable_5_6[j+4][i][1][n] = TVPDitherTable_5_6[j][i][1][n];

				/* 256 level -> 6 level R, B */
				main = (int)(nt * 5);
				frac = nt * 5 - (int)(nt * 5);
				TVPDitherTable_676[2][i][j][n] = (main + ((v1 < frac)?1:0)) * (6 * 7);
				TVPDitherTable_676[0][i][j][n] = (main + ((v2 < frac)?1:0));

				/* 256 level -> 7 level G */
				main = (int)(nt * 6);
				frac = nt * 6 - (int)(nt * 6);
				TVPDitherTable_676[1][i][j][n] = (main + ((v3 < frac)?1:0)) * (6);
			}
		}
	}

	/* create 256 colors dither palette table */
	/* ( 252 colors are used ) */
	c = 0;
	for(r = 0; r < 6; r++)
	{
		for(g = 0; g < 7; g++)
		{
			for(b = 0; b < 6; b++)
			{
				TVP252DitherPalette[0][c] = r * 255 / 5;
				TVP252DitherPalette[1][c] = g * 255 / 6;
				TVP252DitherPalette[2][c] = b * 255 / 5;
				c ++;
			}
		}
	}
	for(; c < 256; c++)
	{
		TVP252DitherPalette[0][c] =
		TVP252DitherPalette[1][c] =
		TVP252DitherPalette[2][c] = 0;
	}

	/* create TVPRecipTable256 */
	TVPRecipTable256[0] = 65536;
	TVPRecipTable256_16[0] = 0x7fff;
	for(i = 1; i < 256; i++)
	{
		TVPRecipTable256[i] = 65536/i;
		TVPRecipTable256_16[i] = TVPRecipTable256[i] > 0x7fff ?
									0x7fff : TVPRecipTable256[i];
	}
}


static void TVPCreateTable(void)
{
	int a,b;

	for(a=0; a<256; a++)
	{
		for(b=0; b<256; b++)
		{
			float c;
			int ci;
			int addr = b*256+ a;

			if(a)
			{
				float at = (float)(a/255.0), bt = (float)(b/255.0);
				c = bt / at;
				c /= (float)( (1.0 - bt + c) );
				ci = (int)(c*255);
				if(ci>=256) ci = 255; /* will not overflow... */
			}
			else
			{
				ci=255;
			}

			TVPOpacityOnOpacityTable[addr]=(unsigned char)ci;
				/* higher byte of the index is source opacity */
				/* lower byte of the index is destination opacity */
		
			TVPNegativeMulTable[addr] = (unsigned char)
				( 255 - (255-a)*(255-b)/ 255 ); 
		}
	}

	for(a=0; a<256; a++)
	{
		for(b=0; b<65; b++)
		{
			float c;
			int ci;
			int addr = b*256+ a;
			int bb;

			if(a)
			{
				float at = (float)(a / 255.0), bt = (float)(b / 64.0);
				c = bt / at;
				c /= (float)( (1.0 - bt + c) );
				ci = (int)(c*255);
				if(ci>=256) ci = 255; /* will not overflow... */
			}
			else
			{
				ci=255;
			}

			TVPOpacityOnOpacityTable65[addr]=(unsigned char)ci;
				/* higher byte of the index is source opacity */
				/* lower byte of the index is destination opacity */

			bb = b * 4;
			if(bb > 255) bb = 255;
			TVPNegativeMulTable65[addr] = (unsigned char)
				( 255 - (255-a)*(255-bb)/ 255 ); 
		}
	}

	for(b=0; b<256; b++)
	{
		TVPDivTable[(0<<8)+b] = 0;
		for(a=1; a<256; a++)
		{
			tjs_int tmp = (tjs_int)(b*255/a);
			if(tmp > 255) tmp = 255;
			TVPDivTable[(a<<8)+b] = (tjs_uint8)(tmp);
		}
	}


	TVPInitDitherTable();
	TVPTLG6InitLeadingZeroTable();
	TVPTLG6InitGolombTable();
}

static void TVPDestroyTable(void)
{
	/* nothing to do ... */
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAlphaBlend_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{
	tjs_uint32 d1, s, d, sopa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/* HDA : hold destination alpha */

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAlphaBlend_HDA_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{
	tjs_uint32 d1, s, d, sopa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000); /* hda */
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000); /* hda */
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000); /* hda */
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000); /* hda */
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAlphaBlend_o_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
	tjs_uint32 d1, s, d, sopa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAlphaBlend_HDA_o_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
	tjs_uint32 d1, s, d, sopa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAlphaBlend_d_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{
	tjs_uint32 d1, s, d, sopa, addr, destalpha;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = ((s >> 16) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 3: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = ((s >> 16) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 2: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = ((s >> 16) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 1: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = ((s >> 16) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAlphaBlend_a_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_d(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_d(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_d(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_d(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAlphaBlend_do_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
	tjs_uint32 d1, s, d, sopa, addr, destalpha;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 3: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 2: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 1: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAlphaBlend_ao_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_d_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_d_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_d_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_d_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAdditiveAlphaBlend_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_n_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_n_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_n_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_n_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInterpStretchAdditiveAlphaBlend_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int blend_y, tjs_int srcstart, tjs_int srcstep))
{
	/* stretching additive alpha blend with bilinear interpolation */
	tjs_int blend_x;
	tjs_int sp;

	blend_y += blend_y >> 7; /* adjust blend ratio */

	destlen -= 1;
	while(destlen > 0)
	{
		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[0] = TVPAddAlphaBlend_n_a(dest[0], TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y));
		srcstart += srcstep;

		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[1] = TVPAddAlphaBlend_n_a(dest[1], TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y));
		srcstart += srcstep;

		dest += 2;
		destlen -= 2;
	}

	destlen += 1;

	while(destlen > 0)
	{
		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[0] = TVPAddAlphaBlend_n_a(dest[0], TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y));
		srcstart += srcstep;
		dest ++;
		destlen --;
	}
}

/* HDA : hold destination alpha */

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAdditiveAlphaBlend_HDA_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_HDA_n_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_HDA_n_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_HDA_n_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_HDA_n_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAdditiveAlphaBlend_o_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_n_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_n_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_n_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_n_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInterpStretchAdditiveAlphaBlend_o_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int blend_y, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
	/* stretching additive alpha blend with bilinear interpolation */
	tjs_int blend_x;
	tjs_int sp;

	blend_y += blend_y >> 7; /* adjust blend ratio */

	destlen -= 1;
	while(destlen > 0)
	{
		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[0] = TVPAddAlphaBlend_n_a_o(dest[0], TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y), opa);
		srcstart += srcstep;

		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[1] = TVPAddAlphaBlend_n_a_o(dest[1], TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y), opa);
		srcstart += srcstep;

		dest += 2;
		destlen -= 2;
	}

	destlen += 1;

	while(destlen > 0)
	{
		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[0] = TVPAddAlphaBlend_n_a_o(dest[0], TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y), opa);
		srcstart += srcstep;
		dest ++;
		destlen --;
	}
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAdditiveAlphaBlend_HDA_o_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_HDA_n_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_HDA_n_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_HDA_n_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_HDA_n_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*not export*/
TVP_GL_FUNC_DECL(void, TVPStretchAdditiveAlphaBlend_d_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{/*YET NOT IMPLEMENTED*//*MAY LOOSE ADDITIVE STUFF*/
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	srcstart += srcstep;
	*dest = 0;
	dest++;
}
;
	case 3: {
	srcstart += srcstep;
	*dest = 0;
	dest++;
}
;
	case 2: {
	srcstart += srcstep;
	*dest = 0;
	dest++;
}
;
	case 1: {
	srcstart += srcstep;
	*dest = 0;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAdditiveAlphaBlend_a_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_a(*dest, src[srcstart >> 16]);
	srcstart += srcstep;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*not export*/
TVP_GL_FUNC_DECL(void, TVPStretchAdditiveAlphaBlend_do_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{/*YET NOT IMPLEMENTED*//*MAY LOOSE ADDITIVE STUFF*/
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	srcstart += srcstep;
	*dest = 0;
	dest++;
}
;
	case 3: {
	srcstart += srcstep;
	*dest = 0;
	dest++;
}
;
	case 2: {
	srcstart += srcstep;
	*dest = 0;
	dest++;
}
;
	case 1: {
	srcstart += srcstep;
	*dest = 0;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchAdditiveAlphaBlend_ao_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_a_o(*dest, src[srcstart >> 16], opa);
	srcstart += srcstep;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAlphaBlend_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
	tjs_uint32 d1, s, d, sopa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/* HDA : hold destination alpha */

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAlphaBlend_HDA_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
	tjs_uint32 d1, s, d, sopa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000); /* hda */
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000); /* hda */
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000); /* hda */
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = s >> 24;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000); /* hda */
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAlphaBlend_o_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
	tjs_uint32 d1, s, d, sopa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAlphaBlend_HDA_o_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
	tjs_uint32 d1, s, d, sopa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	sopa = ((s >> 24) * opa) >> 8;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAlphaBlend_d_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
	tjs_uint32 d1, s, d, sopa, addr, destalpha;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = ((s >> 16) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 3: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = ((s >> 16) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 2: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = ((s >> 16) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 1: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = ((s >> 16) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAlphaBlend_a_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_d(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_d(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_d(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_d(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAlphaBlend_do_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
	tjs_uint32 d1, s, d, sopa, addr, destalpha;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 3: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 2: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	case 1: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	destalpha = TVPNegativeMulTable[addr]<<24;
	sopa = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * sopa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 + ((d + ((s - d) * sopa >> 8)) & 0xff00) + destalpha;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAlphaBlend_ao_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_d_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_d_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_d_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_d_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAdditiveAlphaBlend_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_n_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_n_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_n_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_n_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInterpLinTransAdditiveAlphaBlend_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
	/* bilinear interpolation version */
	/* note that srcpitch unit is in byte */
	destlen -= 1;
	while(destlen > 0)
	{
		int blend_x, blend_y;
		const tjs_uint32 *p0, *p1;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[0] = TVPAddAlphaBlend_n_a(dest[0], TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y));
		sx += stepx, sy += stepy;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[1] = TVPAddAlphaBlend_n_a(dest[1], TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y));
		sx += stepx, sy += stepy;

		dest += 2;
		destlen -= 2;
	}

	destlen += 1;

	while(destlen > 0)
	{
		int blend_x, blend_y;
		const tjs_uint32 *p0, *p1;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[0] = TVPAddAlphaBlend_n_a(dest[0], TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y));
		sx += stepx, sy += stepy;

		dest ++;
		destlen --;
	}
}

/* HDA : hold destination alpha */

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAdditiveAlphaBlend_HDA_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_HDA_n_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_HDA_n_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_HDA_n_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_HDA_n_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAdditiveAlphaBlend_o_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_n_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_n_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_n_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_n_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInterpLinTransAdditiveAlphaBlend_o_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
	/* bilinear interpolation version */
	/* note that srcpitch unit is in byte */
	opa += opa >> 7;

	destlen -= 1;
	while(destlen > 0)
	{
		int blend_x, blend_y;
		const tjs_uint32 *p0, *p1;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[0] = TVPAddAlphaBlend_n_a_o(dest[0], TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y), opa);
		sx += stepx, sy += stepy;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[1] = TVPAddAlphaBlend_n_a_o(dest[1], TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y), opa);
		sx += stepx, sy += stepy;

		dest += 2;
		destlen -= 2;
	}

	destlen += 1;

	while(destlen > 0)
	{
		int blend_x, blend_y;
		const tjs_uint32 *p0, *p1;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[0] = TVPAddAlphaBlend_n_a_o(dest[0], TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y), opa);
		sx += stepx, sy += stepy;

		dest ++;
		destlen --;
	}
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAdditiveAlphaBlend_HDA_o_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_HDA_n_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_HDA_n_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_HDA_n_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_HDA_n_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*not export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAdditiveAlphaBlend_d_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{/*YET NOT IMPLEMENTED*//*MAY LOOSE ADDITIVE STUFF*/
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = 0;
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = 0;
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = 0;
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = 0;
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAdditiveAlphaBlend_a_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_a(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*not export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAdditiveAlphaBlend_do_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{/*YET NOT IMPLEMENTED*//*MAY LOOSE ADDITIVE STUFF*/
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = 0;
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = 0;
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = 0;
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = 0;
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransAdditiveAlphaBlend_ao_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_a_o(*dest, 
		*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)), opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchCopyOpaqueImage_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{

	destlen -= 3;
	while(destlen > 0)
	{
		dest[0] = 0xff000000 | src[srcstart >> 16];
		srcstart += srcstep;
		dest[1] = 0xff000000 | src[srcstart >> 16];
		srcstart += srcstep;
		dest[2] = 0xff000000 | src[srcstart >> 16];
		srcstart += srcstep;
		dest[3] = 0xff000000 | src[srcstart >> 16];
		srcstart += srcstep;
		dest += 4;
		destlen -= 4;
	}

	destlen += 3;

	while(destlen > 0)
	{
		dest[0] = 0xff000000 | src[srcstart >> 16];
		srcstart += srcstep;
		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchConstAlphaBlend_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
	tjs_uint32 d1, s, d;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = src[srcstart>>16];
	srcstart += srcstep;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = src[srcstart>>16];
	srcstart += srcstep;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = src[srcstart>>16];
	srcstart += srcstep;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = src[srcstart>>16];
	srcstart += srcstep;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInterpStretchConstAlphaBlend_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int blend_y, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
	/* stretch copy with bilinear interpolation */
	tjs_int blend_x;
	tjs_int sp;

	blend_y += blend_y >> 7; /* adjust blend ratio */
	opa += opa > 7; /* adjust opa */

	destlen -= 1;
	while(destlen > 0)
	{
		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[0] = TVPBlendARGB(dest[0], TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y), opa);
		srcstart += srcstep;

		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[1] = TVPBlendARGB(dest[1], TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y), opa);
		srcstart += srcstep;

		dest += 2;
		destlen -= 2;
	}

	destlen += 1;

	while(destlen > 0)
	{
		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[0] = TVPBlendARGB(dest[0], TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y), opa);
		srcstart += srcstep;
		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchConstAlphaBlend_HDA_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
	tjs_uint32 d1, s, d;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchConstAlphaBlend_d_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
	tjs_uint32 d1, s, d, addr;
	tjs_int alpha;
	if(opa > 128) opa ++; /* adjust for error */
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	alpha = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * alpha >> 8)) & 0xff00ff) +
		(TVPNegativeMulTable[addr]<<24);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	alpha = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * alpha >> 8)) & 0xff00ff) +
		(TVPNegativeMulTable[addr]<<24);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	alpha = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * alpha >> 8)) & 0xff00ff) +
		(TVPNegativeMulTable[addr]<<24);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = src[srcstart >> 16];
	srcstart += srcstep;
	d = *dest;
	addr = (( (s>>24)*opa) & 0xff00) + (d>>24);
	alpha = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * alpha >> 8)) & 0xff00ff) +
		(TVPNegativeMulTable[addr]<<24);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchConstAlphaBlend_a_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa))
{
	opa <<= 24;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_a(*dest, (src[srcstart >> 16] & 0xffffff) | opa);
	srcstart += srcstep;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_a(*dest, (src[srcstart >> 16] & 0xffffff) | opa);
	srcstart += srcstep;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_a(*dest, (src[srcstart >> 16] & 0xffffff) | opa);
	srcstart += srcstep;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_a(*dest, (src[srcstart >> 16] & 0xffffff) | opa);
	srcstart += srcstep;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransCopyOpaqueImage_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{

	destlen -= 3;
	while(destlen > 0)
	{
		dest[0] = 0xff000000 | *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx;
		sy += stepy;
		dest[1] = 0xff000000 | *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx;
		sy += stepy;
		dest[2] = 0xff000000 | *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx;
		sy += stepy;
		dest[3] = 0xff000000 | *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx;
		sy += stepy;
		dest += 4;
		destlen -= 4;
	}

	destlen += 3;

	while(destlen > 0)
	{
		dest[0] = 0xff000000 | *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx;
		sy += stepy;
		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransConstAlphaBlend_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
	tjs_uint32 d1, s, d;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = (d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff;
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInterpLinTransConstAlphaBlend_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
	/* bilinear interpolation version */
	/* note that srcpitch unit is in byte */
	opa += opa >> 7; /* adjust opacity */

	destlen -= 1;
	while(destlen > 0)
	{
		int blend_x, blend_y;
		const tjs_uint32 *p0, *p1;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[0] = TVPBlendARGB(dest[0], TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y), opa);
		sx += stepx, sy += stepy;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[1] = TVPBlendARGB(dest[1], TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y), opa);
		sx += stepx, sy += stepy;

		dest += 2;
		destlen -= 2;
	}

	destlen += 1;

	while(destlen > 0)
	{
		int blend_x, blend_y;
		const tjs_uint32 *p0, *p1;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[0] = TVPBlendARGB(dest[0], TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y), opa);
		sx += stepx, sy += stepy;

		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransConstAlphaBlend_HDA_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
	tjs_uint32 d1, s, d;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * opa >> 8)) & 0xff00ff) + (d & 0xff000000);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * opa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransConstAlphaBlend_d_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
	tjs_uint32 d1, s, d, addr;
	tjs_int alpha;
	opa <<= 8;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = opa + (d>>24);
	alpha = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * alpha >> 8)) & 0xff00ff) +
		(TVPNegativeMulTable[addr]<<24);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = opa + (d>>24);
	alpha = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * alpha >> 8)) & 0xff00ff) +
		(TVPNegativeMulTable[addr]<<24);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = opa + (d>>24);
	alpha = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * alpha >> 8)) & 0xff00ff) +
		(TVPNegativeMulTable[addr]<<24);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	s = *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
	sx += stepx;
	sy += stepy;
	d = *dest;
	addr = opa + (d>>24);
	alpha = TVPOpacityOnOpacityTable[addr];
	d1 = d & 0xff00ff;
	d1 = ((d1 + (((s & 0xff00ff) - d1) * alpha >> 8)) & 0xff00ff) +
		(TVPNegativeMulTable[addr]<<24);
	d &= 0xff00;
	s &= 0xff00;
	*dest = d1 | ((d + ((s - d) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransConstAlphaBlend_a_c, (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa))
{
	opa <<= 24;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	*dest = TVPAddAlphaBlend_a_a(*dest, 
		((*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16))) & 0xffffff) | opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 3: {
	*dest = TVPAddAlphaBlend_a_a(*dest, 
		((*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16))) & 0xffffff) | opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 2: {
	*dest = TVPAddAlphaBlend_a_a(*dest, 
		((*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16))) & 0xffffff) | opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	case 1: {
	*dest = TVPAddAlphaBlend_a_a(*dest, 
		((*( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16))) & 0xffffff) | opa);
	sx += stepx;
	sy += stepy;
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInitUnivTransBlendTable_c, (tjs_uint32 *table, tjs_int phase, tjs_int vague))
{
	tjs_int i;
	tjs_int phasemax = phase;
	phase -= vague;
	for(i = 0; i<256; i++)
	{
		if(i<phase) table[i] = 255;
		else if(i>=phasemax) table[i] = 0;
		else
		{
			int tmp = (255-(( i - phase )*255 / vague));
			if(tmp<0) tmp = 0;
			if(tmp>255) tmp = 255;
			table[i] = tmp;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInitUnivTransBlendTable_d_c, (tjs_uint32 *table, tjs_int phase, tjs_int vague))
{
	/* alias to TVPInitUnivTransBlendTable_c */
	TVPInitUnivTransBlendTable_c(table, phase, vague);
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInitUnivTransBlendTable_a_c, (tjs_uint32 *table, tjs_int phase, tjs_int vague))
{
	/* alias to TVPInitUnivTransBlendTable_c */
	TVPInitUnivTransBlendTable_c(table, phase, vague);
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPUnivTransBlend_c, (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len))
{
	tjs_uint32 s1_, s1, s2;
	tjs_int opa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	opa = table[*rule];
	rule++;
	s1 = *src1;
	src1++;
	s2 = *src2;
	src2++;
	s1_ = s1 & 0xff00ff;
	s1_ = (s1_ + (((s2 & 0xff00ff) - s1_) * opa >> 8)) & 0xff00ff;
	s2 &= 0xff00;
	s1 &= 0xff00;
	*dest = s1_ | ((s1 + ((s2 - s1) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	opa = table[*rule];
	rule++;
	s1 = *src1;
	src1++;
	s2 = *src2;
	src2++;
	s1_ = s1 & 0xff00ff;
	s1_ = (s1_ + (((s2 & 0xff00ff) - s1_) * opa >> 8)) & 0xff00ff;
	s2 &= 0xff00;
	s1 &= 0xff00;
	*dest = s1_ | ((s1 + ((s2 - s1) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	opa = table[*rule];
	rule++;
	s1 = *src1;
	src1++;
	s2 = *src2;
	src2++;
	s1_ = s1 & 0xff00ff;
	s1_ = (s1_ + (((s2 & 0xff00ff) - s1_) * opa >> 8)) & 0xff00ff;
	s2 &= 0xff00;
	s1 &= 0xff00;
	*dest = s1_ | ((s1 + ((s2 - s1) * opa >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	opa = table[*rule];
	rule++;
	s1 = *src1;
	src1++;
	s2 = *src2;
	src2++;
	s1_ = s1 & 0xff00ff;
	s1_ = (s1_ + (((s2 & 0xff00ff) - s1_) * opa >> 8)) & 0xff00ff;
	s2 &= 0xff00;
	s1 &= 0xff00;
	*dest = s1_ | ((s1 + ((s2 - s1) * opa >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPUnivTransBlend_switch_c, (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len, tjs_int src1lv, tjs_int src2lv))
{
	tjs_uint32 s1_, s1, s2;
	tjs_int opa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	opa = *rule;
	if(opa >= src1lv)
	{
		*dest = *src1;
		rule++; src1++; src2++; dest++;
	}
	else if(opa < src2lv)
	{
		*dest = *src2;
		rule++; src1++; src2++; dest++;
	}
	else
	{
		opa = table[opa];
		rule++;
		s1 = *src1;
		src1++;
		s2 = *src2;
		src2++;
		s1_ = s1 & 0xff00ff;
		s1_ = (s1_ + (((s2 & 0xff00ff) - s1_) * opa >> 8)) & 0xff00ff;
		s2 &= 0xff00;
		s1 &= 0xff00;
		*dest = s1_ | ((s1 + ((s2 - s1) * opa >> 8)) & 0xff00);
		dest++;
	}
}
;
	case 3: {
	opa = *rule;
	if(opa >= src1lv)
	{
		*dest = *src1;
		rule++; src1++; src2++; dest++;
	}
	else if(opa < src2lv)
	{
		*dest = *src2;
		rule++; src1++; src2++; dest++;
	}
	else
	{
		opa = table[opa];
		rule++;
		s1 = *src1;
		src1++;
		s2 = *src2;
		src2++;
		s1_ = s1 & 0xff00ff;
		s1_ = (s1_ + (((s2 & 0xff00ff) - s1_) * opa >> 8)) & 0xff00ff;
		s2 &= 0xff00;
		s1 &= 0xff00;
		*dest = s1_ | ((s1 + ((s2 - s1) * opa >> 8)) & 0xff00);
		dest++;
	}
}
;
	case 2: {
	opa = *rule;
	if(opa >= src1lv)
	{
		*dest = *src1;
		rule++; src1++; src2++; dest++;
	}
	else if(opa < src2lv)
	{
		*dest = *src2;
		rule++; src1++; src2++; dest++;
	}
	else
	{
		opa = table[opa];
		rule++;
		s1 = *src1;
		src1++;
		s2 = *src2;
		src2++;
		s1_ = s1 & 0xff00ff;
		s1_ = (s1_ + (((s2 & 0xff00ff) - s1_) * opa >> 8)) & 0xff00ff;
		s2 &= 0xff00;
		s1 &= 0xff00;
		*dest = s1_ | ((s1 + ((s2 - s1) * opa >> 8)) & 0xff00);
		dest++;
	}
}
;
	case 1: {
	opa = *rule;
	if(opa >= src1lv)
	{
		*dest = *src1;
		rule++; src1++; src2++; dest++;
	}
	else if(opa < src2lv)
	{
		*dest = *src2;
		rule++; src1++; src2++; dest++;
	}
	else
	{
		opa = table[opa];
		rule++;
		s1 = *src1;
		src1++;
		s2 = *src2;
		src2++;
		s1_ = s1 & 0xff00ff;
		s1_ = (s1_ + (((s2 & 0xff00ff) - s1_) * opa >> 8)) & 0xff00ff;
		s2 &= 0xff00;
		s1 &= 0xff00;
		*dest = s1_ | ((s1 + ((s2 - s1) * opa >> 8)) & 0xff00);
		dest++;
	}
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPUnivTransBlend_d_c, (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len))
{
	tjs_uint32 s1_, s2, s1, addr;
	tjs_uint32 a1, a2;
	tjs_int alpha;
	tjs_int opa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	opa = table[*rule];
	rule++;
	s1 = *src1;
	s2 = *src2;
	a1 = s1 >> 24;
	a2 = s2 >> 24;
	addr = (a2*opa & 0xff00) + (a1*(256-opa) >> 8);
	alpha = TVPOpacityOnOpacityTable[addr];
	s1_ = s1 & 0xff00ff;
	s1_ = ((s1_ + (((s2 & 0xff00ff) - s1_) * alpha >> 8)) & 0xff00ff);
	src1++;
	src2++;
	s1 &= 0xff00;
	s2 &= 0xff00;
	s1_ |= (a1 + ((a2 - a1)*opa >> 8)) << 24;
	*dest = s1_ | ((s1 + ((s2 - s1) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	case 3: {
	opa = table[*rule];
	rule++;
	s1 = *src1;
	s2 = *src2;
	a1 = s1 >> 24;
	a2 = s2 >> 24;
	addr = (a2*opa & 0xff00) + (a1*(256-opa) >> 8);
	alpha = TVPOpacityOnOpacityTable[addr];
	s1_ = s1 & 0xff00ff;
	s1_ = ((s1_ + (((s2 & 0xff00ff) - s1_) * alpha >> 8)) & 0xff00ff);
	src1++;
	src2++;
	s1 &= 0xff00;
	s2 &= 0xff00;
	s1_ |= (a1 + ((a2 - a1)*opa >> 8)) << 24;
	*dest = s1_ | ((s1 + ((s2 - s1) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	case 2: {
	opa = table[*rule];
	rule++;
	s1 = *src1;
	s2 = *src2;
	a1 = s1 >> 24;
	a2 = s2 >> 24;
	addr = (a2*opa & 0xff00) + (a1*(256-opa) >> 8);
	alpha = TVPOpacityOnOpacityTable[addr];
	s1_ = s1 & 0xff00ff;
	s1_ = ((s1_ + (((s2 & 0xff00ff) - s1_) * alpha >> 8)) & 0xff00ff);
	src1++;
	src2++;
	s1 &= 0xff00;
	s2 &= 0xff00;
	s1_ |= (a1 + ((a2 - a1)*opa >> 8)) << 24;
	*dest = s1_ | ((s1 + ((s2 - s1) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	case 1: {
	opa = table[*rule];
	rule++;
	s1 = *src1;
	s2 = *src2;
	a1 = s1 >> 24;
	a2 = s2 >> 24;
	addr = (a2*opa & 0xff00) + (a1*(256-opa) >> 8);
	alpha = TVPOpacityOnOpacityTable[addr];
	s1_ = s1 & 0xff00ff;
	s1_ = ((s1_ + (((s2 & 0xff00ff) - s1_) * alpha >> 8)) & 0xff00ff);
	src1++;
	src2++;
	s1 &= 0xff00;
	s2 &= 0xff00;
	s1_ |= (a1 + ((a2 - a1)*opa >> 8)) << 24;
	*dest = s1_ | ((s1 + ((s2 - s1) * alpha >> 8)) & 0xff00);
	dest++;
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPUnivTransBlend_switch_d_c, (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len, tjs_int src1lv, tjs_int src2lv))
{
	tjs_uint32 s1_, s2, s1, addr;
	tjs_uint32 a1, a2;
	tjs_int alpha;
	tjs_int opa;
  if(len > 0)
  {
	int lu_n = (len + (4-1)) / 4;
	switch(len % 4)
	{
	case 0: do { {
	opa = *rule;
	if(opa >= src1lv)
	{
		*dest = *src1;
		rule++; src1++; src2++; dest++;
	}
	else if(opa < src2lv)
	{
		*dest = *src2;
		rule++; src1++; src2++; dest++;
	}
	else
	{
		opa = table[opa];
		rule++;
		s1 = *src1;
		s2 = *src2;
		a1 = s1 >> 24;
		a2 = s2 >> 24;
		addr = (a2*opa & 0xff00) + (a1*(256-opa) >> 8);
		alpha = TVPOpacityOnOpacityTable[addr];
		s1_ = s1 & 0xff00ff;
		s1_ = ((s1_ + (((s2 & 0xff00ff) - s1_) * alpha >> 8)) & 0xff00ff) +
			(TVPNegativeMulTable[addr]<<24);
		src1++;
		src2++;
		s1 &= 0xff00;
		s2 &= 0xff00;
		*dest = s1_ | ((s1 + ((s2 - s1) * alpha >> 8)) & 0xff00);
		dest++;
	}
}
;
	case 3: {
	opa = *rule;
	if(opa >= src1lv)
	{
		*dest = *src1;
		rule++; src1++; src2++; dest++;
	}
	else if(opa < src2lv)
	{
		*dest = *src2;
		rule++; src1++; src2++; dest++;
	}
	else
	{
		opa = table[opa];
		rule++;
		s1 = *src1;
		s2 = *src2;
		a1 = s1 >> 24;
		a2 = s2 >> 24;
		addr = (a2*opa & 0xff00) + (a1*(256-opa) >> 8);
		alpha = TVPOpacityOnOpacityTable[addr];
		s1_ = s1 & 0xff00ff;
		s1_ = ((s1_ + (((s2 & 0xff00ff) - s1_) * alpha >> 8)) & 0xff00ff) +
			(TVPNegativeMulTable[addr]<<24);
		src1++;
		src2++;
		s1 &= 0xff00;
		s2 &= 0xff00;
		*dest = s1_ | ((s1 + ((s2 - s1) * alpha >> 8)) & 0xff00);
		dest++;
	}
}
;
	case 2: {
	opa = *rule;
	if(opa >= src1lv)
	{
		*dest = *src1;
		rule++; src1++; src2++; dest++;
	}
	else if(opa < src2lv)
	{
		*dest = *src2;
		rule++; src1++; src2++; dest++;
	}
	else
	{
		opa = table[opa];
		rule++;
		s1 = *src1;
		s2 = *src2;
		a1 = s1 >> 24;
		a2 = s2 >> 24;
		addr = (a2*opa & 0xff00) + (a1*(256-opa) >> 8);
		alpha = TVPOpacityOnOpacityTable[addr];
		s1_ = s1 & 0xff00ff;
		s1_ = ((s1_ + (((s2 & 0xff00ff) - s1_) * alpha >> 8)) & 0xff00ff) +
			(TVPNegativeMulTable[addr]<<24);
		src1++;
		src2++;
		s1 &= 0xff00;
		s2 &= 0xff00;
		*dest = s1_ | ((s1 + ((s2 - s1) * alpha >> 8)) & 0xff00);
		dest++;
	}
}
;
	case 1: {
	opa = *rule;
	if(opa >= src1lv)
	{
		*dest = *src1;
		rule++; src1++; src2++; dest++;
	}
	else if(opa < src2lv)
	{
		*dest = *src2;
		rule++; src1++; src2++; dest++;
	}
	else
	{
		opa = table[opa];
		rule++;
		s1 = *src1;
		s2 = *src2;
		a1 = s1 >> 24;
		a2 = s2 >> 24;
		addr = (a2*opa & 0xff00) + (a1*(256-opa) >> 8);
		alpha = TVPOpacityOnOpacityTable[addr];
		s1_ = s1 & 0xff00ff;
		s1_ = ((s1_ + (((s2 & 0xff00ff) - s1_) * alpha >> 8)) & 0xff00ff) +
			(TVPNegativeMulTable[addr]<<24);
		src1++;
		src2++;
		s1 &= 0xff00;
		s2 &= 0xff00;
		*dest = s1_ | ((s1 + ((s2 - s1) * alpha >> 8)) & 0xff00);
		dest++;
	}
}
;
	   } while(-- lu_n);
	}
  }
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPUnivTransBlend_a_c, (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
	dest[(___index+0)] = TVPBlendARGB(src1[(___index+0)], src2[(___index+0)], table[rule[(___index+0)]]);
	dest[(___index+1)] = TVPBlendARGB(src1[(___index+1)], src2[(___index+1)], table[rule[(___index+1)]]);
	dest[(___index+2)] = TVPBlendARGB(src1[(___index+2)], src2[(___index+2)], table[rule[(___index+2)]]);
	dest[(___index+3)] = TVPBlendARGB(src1[(___index+3)], src2[(___index+3)], table[rule[(___index+3)]]);
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
	dest[___index] = TVPBlendARGB(src1[___index], src2[___index], table[rule[___index]]);
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPUnivTransBlend_switch_a_c, (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len, tjs_int src1lv, tjs_int src2lv))
{
	tjs_int opa;
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
	opa = rule[(___index+0)];
	if(opa >= src1lv)
		dest[(___index+0)] = src1[(___index+0)];
	else if(opa < src2lv)
		dest[(___index+0)] = src2[(___index+0)];
	else
		dest[(___index+0)] = TVPBlendARGB(src1[(___index+0)], src2[(___index+0)], table[opa]);
	opa = rule[(___index+1)];
	if(opa >= src1lv)
		dest[(___index+1)] = src1[(___index+1)];
	else if(opa < src2lv)
		dest[(___index+1)] = src2[(___index+1)];
	else
		dest[(___index+1)] = TVPBlendARGB(src1[(___index+1)], src2[(___index+1)], table[opa]);
	opa = rule[(___index+2)];
	if(opa >= src1lv)
		dest[(___index+2)] = src1[(___index+2)];
	else if(opa < src2lv)
		dest[(___index+2)] = src2[(___index+2)];
	else
		dest[(___index+2)] = TVPBlendARGB(src1[(___index+2)], src2[(___index+2)], table[opa]);
	opa = rule[(___index+3)];
	if(opa >= src1lv)
		dest[(___index+3)] = src1[(___index+3)];
	else if(opa < src2lv)
		dest[(___index+3)] = src2[(___index+3)];
	else
		dest[(___index+3)] = TVPBlendARGB(src1[(___index+3)], src2[(___index+3)], table[opa]);
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
	opa = rule[___index];
	if(opa >= src1lv)
		dest[___index] = src1[___index];
	else if(opa < src2lv)
		dest[___index] = src2[___index];
	else
		dest[___index] = TVPBlendARGB(src1[___index], src2[___index], table[opa]);
			___index ++;
		}
	}
}

/*not export*/
TVP_GL_FUNC_DECL(void, TVPRemoveAdditiveConstOpacity_c, (tjs_uint32 *dest, tjs_int len, tjs_int strength))
{/*YET NOT IMPLEMENTED*//*MAY LOOSE ADDITIVE STUFF*/
}

/*not export*/
TVP_GL_FUNC_DECL(void, TVPRemoveAdditiveOpacity_c, (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len))
{/*YET NOT IMPLEMENTED*//*MAY LOOSE ADDITIVE STUFF*/
}

/*not export*/
TVP_GL_FUNC_DECL(void, TVPRemoveAdditiveOpacity_o_c, (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_int strength))
{/*YET NOT IMPLEMENTED*//*MAY LOOSE ADDITIVE STUFF*/
}

/*not export*/
TVP_GL_FUNC_DECL(void, TVPRemoveAdditiveOpacity65_c, (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len))
{/*YET NOT IMPLEMENTED*//*MAY LOOSE ADDITIVE STUFF*/
}

/*not export*/
TVP_GL_FUNC_DECL(void, TVPRemoveAdditiveOpacity65_o_c, (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_int strength))
{/*YET NOT IMPLEMENTED*//*MAY LOOSE ADDITIVE STUFF*/
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchCopy_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{

	destlen -= 3;
	while(destlen > 0)
	{
		dest[0] = src[srcstart >> 16];
		srcstart += srcstep;
		dest[1] = src[srcstart >> 16];
		srcstart += srcstep;
		dest[2] = src[srcstart >> 16];
		srcstart += srcstep;
		dest[3] = src[srcstart >> 16];
		srcstart += srcstep;
		dest += 4;
		destlen -= 4;
	}

	destlen += 3;

	while(destlen > 0)
	{
		dest[0] = src[srcstart >> 16];
		srcstart += srcstep;
		dest ++;
		destlen --;
	}
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPInterpStretchCopy_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int blend_y, tjs_int srcstart, tjs_int srcstep))
{
	/* stretch copy with bilinear interpolation */
	tjs_int blend_x;
	tjs_int sp;

	blend_y += blend_y >> 7; /* adjust blend ratio */

	destlen -= 1;
	while(destlen > 0)
	{
		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[0] = TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y);
		srcstart += srcstep;

		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[1] = TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y);
		srcstart += srcstep;

		dest += 2;
		destlen -= 2;
	}

	destlen += 1;

	while(destlen > 0)
	{
		blend_x = (srcstart & 0xffff) >> 8;
		sp = srcstart >> 16;
		dest[0] = TVPBlendARGB(
			TVPBlendARGB(src1[sp], src1[sp+1], blend_x),
			TVPBlendARGB(src2[sp], src2[sp+1], blend_x),
				blend_y);
		srcstart += srcstep;
		dest ++;
		destlen --;
	}
}

#define AVG_PACKED(x, y) (((x) & (y)) + ((((x) ^ (y)) & 0xfefefefe) >> 1))

/*export*/
TVP_GL_FUNC_DECL(void, TVPFastLinearInterpH2F_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src))
{
	/* horizontal 2x fast linear interpolation; forward */
	destlen -= 2;
	while(destlen > 0)
	{
		dest[0] = src[0];
		dest[1] = AVG_PACKED(src[0], src[1]);
		dest += 2;
		src ++;
		destlen -= 2;
	}

	destlen += 2;

	while(destlen > 0)
	{
		dest[0] = src[0];
		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPFastLinearInterpH2B_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src))
{
	/* horizontal 2x fast linear interpolation; backward */
	destlen -= 2;
	while(destlen > 0)
	{
		dest[0] = src[0];
		dest[1] = AVG_PACKED(src[0], src[-1]);
		dest += 2;
		src --;
		destlen -= 2;
	}

	destlen += 2;

	while(destlen > 0)
	{
		dest[0] = src[0];
		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPFastLinearInterpV2_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src0, const tjs_uint32 *src1))
{
	/* vertical 2x fast linear interpolation */
	destlen -= 3;
	while(destlen > 0)
	{
		dest[0] = AVG_PACKED(src0[0], src1[0]);
		dest[1] = AVG_PACKED(src0[1], src1[1]);
		dest[2] = AVG_PACKED(src0[2], src1[2]);
		dest[3] = AVG_PACKED(src0[3], src1[3]);
		dest += 4;
		src0 += 4;
		src1 += 4;
		destlen -= 4;
	}

	destlen += 3;

	while(destlen > 0)
	{
		dest[0] = AVG_PACKED(src0[0], src1[0]);
		dest ++;
		src0 ++;
		src1 ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPStretchColorCopy_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep))
{
	/* this performs only color(main) copy */
	destlen -= 3;
	while(destlen > 0)
	{
		dest[0] = (dest[0] & 0xff000000) + (src[srcstart >> 16] & 0xffffff);
		srcstart += srcstep;
		dest[1] = (dest[1] & 0xff000000) + (src[srcstart >> 16] & 0xffffff);
		srcstart += srcstep;
		dest[2] = (dest[2] & 0xff000000) + (src[srcstart >> 16] & 0xffffff);
		srcstart += srcstep;
		dest[3] = (dest[3] & 0xff000000) + (src[srcstart >> 16] & 0xffffff);
		srcstart += srcstep;
		dest += 4;
		destlen -= 4;
	}

	destlen += 3;

	while(destlen > 0)
	{
		dest[0] = (dest[0] & 0xff0000) + (src[srcstart >> 16] & 0xffffff);
		srcstart += srcstep;
		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransCopy_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
	/* note that srcpitch unit is in byte */
	destlen -= 3;
	while(destlen > 0)
	{
		dest[0] = *( (const tjs_uint32*)((tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx, sy += stepy;
		dest[1] = *( (const tjs_uint32*)((tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx, sy += stepy;
		dest[2] = *( (const tjs_uint32*)((tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx, sy += stepy;
		dest[3] = *( (const tjs_uint32*)((tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx, sy += stepy;

		dest += 4;
		destlen -= 4;
	}

	destlen += 3;

	while(destlen > 0)
	{
		dest[0] = *( (const tjs_uint32*)((tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16));
		sx += stepx, sy += stepy;
		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPInterpLinTransCopy_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
	/* bilinear interpolation version */
	/* note that srcpitch unit is in byte */
	destlen -= 1;
	while(destlen > 0)
	{
		int blend_x, blend_y;
		const tjs_uint32 *p0, *p1;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[0] = TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y);
		sx += stepx, sy += stepy;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[1] = TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y);
		sx += stepx, sy += stepy;

		dest += 2;
		destlen -= 2;
	}

	destlen += 1;

	while(destlen > 0)
	{
		int blend_x, blend_y;
		const tjs_uint32 *p0, *p1;

		blend_x = (sx & 0xffff) >> 8;
		blend_x += blend_x >> 7;
		blend_y = (sy & 0xffff) >> 8;
		blend_y += blend_y >> 7;
		p0 = (const tjs_uint32*)((const tjs_uint8*)src + ((sy>>16)  )*srcpitch) + (sx>>16);
		p1 = (const tjs_uint32*)((const tjs_uint8*)p0 + srcpitch);
		dest[0] = TVPBlendARGB(
			TVPBlendARGB(p0[0], p0[1], blend_x),
			TVPBlendARGB(p1[0], p1[1], blend_x),
				blend_y);
		sx += stepx, sy += stepy;

		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPLinTransColorCopy_c, (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch))
{
	/* note that srcpitch unit is in byte */
	destlen -= 3;
	while(destlen > 0)
	{
		dest[0] = (dest[0] & 0xff000000) + (0x00ffffff & *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
		sx += stepx, sy += stepy;
		dest[1] = (dest[1] & 0xff000000) + (0x00ffffff & *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
		sx += stepx, sy += stepy;
		dest[2] = (dest[2] & 0xff000000) + (0x00ffffff & *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
		sx += stepx, sy += stepy;
		dest[3] = (dest[3] & 0xff000000) + (0x00ffffff & *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
		sx += stepx, sy += stepy;

		dest += 4;
		destlen -= 4;
	}

	destlen += 3;

	while(destlen > 0)
	{
		dest[0] = (dest[0] & 0xff000000) + (0x00ffffff & *( (const tjs_uint32*)((const tjs_uint8*)src + (sy>>16)*srcpitch) + (sx>>16)));
		sx += stepx, sy += stepy;
		dest ++;
		destlen --;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPMakeAlphaFromKey_c, (tjs_uint32 *dest, tjs_int len, tjs_uint32 key))
{
	tjs_uint32 a, b;
	{
		int ___index = 0;
		len -= (8-1);

		while(___index < len)
		{
	a = dest[(___index+(0*2))] & 0xffffff;
	b = dest[(___index+(0*2+1))] & 0xffffff;
	if(a != key) a |= 0xff000000;
	if(b != key) b |= 0xff000000;
	dest[(___index+(0*2))] = a;
	dest[(___index+(0*2+1))] = b;
	a = dest[(___index+(1*2))] & 0xffffff;
	b = dest[(___index+(1*2+1))] & 0xffffff;
	if(a != key) a |= 0xff000000;
	if(b != key) b |= 0xff000000;
	dest[(___index+(1*2))] = a;
	dest[(___index+(1*2+1))] = b;
	a = dest[(___index+(2*2))] & 0xffffff;
	b = dest[(___index+(2*2+1))] & 0xffffff;
	if(a != key) a |= 0xff000000;
	if(b != key) b |= 0xff000000;
	dest[(___index+(2*2))] = a;
	dest[(___index+(2*2+1))] = b;
	a = dest[(___index+(3*2))] & 0xffffff;
	b = dest[(___index+(3*2+1))] & 0xffffff;
	if(a != key) a |= 0xff000000;
	if(b != key) b |= 0xff000000;
	dest[(___index+(3*2))] = a;
	dest[(___index+(3*2+1))] = b;
			___index += 8;
		}

		len += (8-1);

		while(___index < len)
		{
	a = dest[___index] & 0xffffff;;
	if(a != key) a |= 0xff000000;;
	dest[___index] = a;;
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPAddSubVertSum16_c, (tjs_uint16 *dest, const tjs_uint32 *addline, const tjs_uint32 *subline, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
	tjs_uint32 add, sub;
	add = addline[(___index+0)];
	sub = subline[(___index+0)];
	dest[(___index+0)*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[(___index+0)*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[(___index+0)*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[(___index+0)*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
{
	tjs_uint32 add, sub;
	add = addline[(___index+1)];
	sub = subline[(___index+1)];
	dest[(___index+1)*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[(___index+1)*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[(___index+1)*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[(___index+1)*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
{
	tjs_uint32 add, sub;
	add = addline[(___index+2)];
	sub = subline[(___index+2)];
	dest[(___index+2)*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[(___index+2)*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[(___index+2)*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[(___index+2)*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
{
	tjs_uint32 add, sub;
	add = addline[(___index+3)];
	sub = subline[(___index+3)];
	dest[(___index+3)*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[(___index+3)*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[(___index+3)*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[(___index+3)*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
	tjs_uint32 add, sub;
	add = addline[___index];
	sub = subline[___index];
	dest[___index*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[___index*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[___index*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[___index*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPAddSubVertSum16_d_c, (tjs_uint16 *dest, const tjs_uint32 *addline, const tjs_uint32 *subline, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[(___index+0)];
	sub = subline[(___index+0)];
	dest[(___index+0)*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[(___index+0)*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[(___index+0)*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[(___index+0)*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[(___index+1)];
	sub = subline[(___index+1)];
	dest[(___index+1)*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[(___index+1)*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[(___index+1)*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[(___index+1)*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[(___index+2)];
	sub = subline[(___index+2)];
	dest[(___index+2)*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[(___index+2)*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[(___index+2)*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[(___index+2)*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[(___index+3)];
	sub = subline[(___index+3)];
	dest[(___index+3)*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[(___index+3)*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[(___index+3)*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[(___index+3)*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[___index];
	sub = subline[___index];
	dest[___index*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[___index*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[___index*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[___index*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPAddSubVertSum32_c, (tjs_uint32 *dest, const tjs_uint32 *addline, const tjs_uint32 *subline, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
	tjs_uint32 add, sub;
	add = addline[(___index+0)];
	sub = subline[(___index+0)];
	dest[(___index+0)*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[(___index+0)*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[(___index+0)*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[(___index+0)*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
{
	tjs_uint32 add, sub;
	add = addline[(___index+1)];
	sub = subline[(___index+1)];
	dest[(___index+1)*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[(___index+1)*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[(___index+1)*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[(___index+1)*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
{
	tjs_uint32 add, sub;
	add = addline[(___index+2)];
	sub = subline[(___index+2)];
	dest[(___index+2)*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[(___index+2)*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[(___index+2)*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[(___index+2)*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
{
	tjs_uint32 add, sub;
	add = addline[(___index+3)];
	sub = subline[(___index+3)];
	dest[(___index+3)*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[(___index+3)*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[(___index+3)*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[(___index+3)*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
	tjs_uint32 add, sub;
	add = addline[___index];
	sub = subline[___index];
	dest[___index*4+0] += ((add    ) & 0xff) - ((sub    ) & 0xff);
	dest[___index*4+1] += ((add>>8 ) & 0xff) - ((sub>>8 ) & 0xff);
	dest[___index*4+2] += ((add>>16) & 0xff) - ((sub>>16) & 0xff);
	dest[___index*4+3] += ((add>>24)       ) - ((sub>>24)       );
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPAddSubVertSum32_d_c, (tjs_uint32 *dest, const tjs_uint32 *addline, const tjs_uint32 *subline, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[(___index+0)];
	sub = subline[(___index+0)];
	dest[(___index+0)*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[(___index+0)*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[(___index+0)*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[(___index+0)*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[(___index+1)];
	sub = subline[(___index+1)];
	dest[(___index+1)*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[(___index+1)*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[(___index+1)*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[(___index+1)*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[(___index+2)];
	sub = subline[(___index+2)];
	dest[(___index+2)*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[(___index+2)*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[(___index+2)*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[(___index+2)*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[(___index+3)];
	sub = subline[(___index+3)];
	dest[(___index+3)*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[(___index+3)*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[(___index+3)*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[(___index+3)*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
	tjs_uint32 add, sub;
	tjs_int add_a, sub_a;
	add = addline[___index];
	sub = subline[___index];
	dest[___index*4+3] += (add_a = (add>>24)       ) - (sub_a = (sub>>24)       );
	add_a += add_a >> 7;
	sub_a += sub_a >> 7;
	dest[___index*4+0] += (((add    ) & 0xff) * add_a >> 8) - (((sub    ) & 0xff) * sub_a >> 8);
	dest[___index*4+1] += (((add>>8 ) & 0xff) * add_a >> 8) - (((sub>>8 ) & 0xff) * sub_a >> 8);
	dest[___index*4+2] += (((add>>16) & 0xff) * add_a >> 8) - (((sub>>16) & 0xff) * sub_a >> 8);
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPDoBoxBlurAvg16_c, (tjs_uint32 *dest, tjs_uint16 *sum, const tjs_uint16 * add, const tjs_uint16 * sub, tjs_int n, tjs_int len))
{
	tjs_int rcp = (1<<16) / n;
	tjs_int half_n = n >> 1;
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
	dest[(___index+0)] =
		(((sum[0] + half_n) * rcp >> 16)       )+
		(((sum[1] + half_n) * rcp >> 16) << 8  )+
		(((sum[2] + half_n) * rcp >> 16) << 16 )+
		(((sum[3] + half_n) * rcp >> 16) << 24 );

	sum[0] += add[(___index+0)*4+0] - sub[(___index+0)*4+0];
	sum[1] += add[(___index+0)*4+1] - sub[(___index+0)*4+1];
	sum[2] += add[(___index+0)*4+2] - sub[(___index+0)*4+2];
	sum[3] += add[(___index+0)*4+3] - sub[(___index+0)*4+3];
}
{
	dest[(___index+1)] =
		(((sum[0] + half_n) * rcp >> 16)       )+
		(((sum[1] + half_n) * rcp >> 16) << 8  )+
		(((sum[2] + half_n) * rcp >> 16) << 16 )+
		(((sum[3] + half_n) * rcp >> 16) << 24 );

	sum[0] += add[(___index+1)*4+0] - sub[(___index+1)*4+0];
	sum[1] += add[(___index+1)*4+1] - sub[(___index+1)*4+1];
	sum[2] += add[(___index+1)*4+2] - sub[(___index+1)*4+2];
	sum[3] += add[(___index+1)*4+3] - sub[(___index+1)*4+3];
}
{
	dest[(___index+2)] =
		(((sum[0] + half_n) * rcp >> 16)       )+
		(((sum[1] + half_n) * rcp >> 16) << 8  )+
		(((sum[2] + half_n) * rcp >> 16) << 16 )+
		(((sum[3] + half_n) * rcp >> 16) << 24 );

	sum[0] += add[(___index+2)*4+0] - sub[(___index+2)*4+0];
	sum[1] += add[(___index+2)*4+1] - sub[(___index+2)*4+1];
	sum[2] += add[(___index+2)*4+2] - sub[(___index+2)*4+2];
	sum[3] += add[(___index+2)*4+3] - sub[(___index+2)*4+3];
}
{
	dest[(___index+3)] =
		(((sum[0] + half_n) * rcp >> 16)       )+
		(((sum[1] + half_n) * rcp >> 16) << 8  )+
		(((sum[2] + half_n) * rcp >> 16) << 16 )+
		(((sum[3] + half_n) * rcp >> 16) << 24 );

	sum[0] += add[(___index+3)*4+0] - sub[(___index+3)*4+0];
	sum[1] += add[(___index+3)*4+1] - sub[(___index+3)*4+1];
	sum[2] += add[(___index+3)*4+2] - sub[(___index+3)*4+2];
	sum[3] += add[(___index+3)*4+3] - sub[(___index+3)*4+3];
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
	dest[___index] =
		(((sum[0] + half_n) * rcp >> 16)       )+
		(((sum[1] + half_n) * rcp >> 16) << 8  )+
		(((sum[2] + half_n) * rcp >> 16) << 16 )+
		(((sum[3] + half_n) * rcp >> 16) << 24 );

	sum[0] += add[___index*4+0] - sub[___index*4+0];
	sum[1] += add[___index*4+1] - sub[___index*4+1];
	sum[2] += add[___index*4+2] - sub[___index*4+2];
	sum[3] += add[___index*4+3] - sub[___index*4+3];
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPDoBoxBlurAvg16_d_c, (tjs_uint32 *dest, tjs_uint16 *sum, const tjs_uint16 * add, const tjs_uint16 * sub, tjs_int n, tjs_int len))
{
	tjs_int rcp = (1<<16) / n;
	tjs_int half_n = n >> 1;
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
	tjs_int a = ((sum[3] + half_n) * rcp >> 16);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[(___index+0)] =
		(t[(sum[0] + half_n) * rcp >> 16]       )+
		(t[(sum[1] + half_n) * rcp >> 16] << 8  )+
		(t[(sum[2] + half_n) * rcp >> 16] << 16 )+
		(a << 24 );

	sum[0] += add[(___index+0)*4+0] - sub[(___index+0)*4+0];
	sum[1] += add[(___index+0)*4+1] - sub[(___index+0)*4+1];
	sum[2] += add[(___index+0)*4+2] - sub[(___index+0)*4+2];
	sum[3] += add[(___index+0)*4+3] - sub[(___index+0)*4+3];
}
{
	tjs_int a = ((sum[3] + half_n) * rcp >> 16);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[(___index+1)] =
		(t[(sum[0] + half_n) * rcp >> 16]       )+
		(t[(sum[1] + half_n) * rcp >> 16] << 8  )+
		(t[(sum[2] + half_n) * rcp >> 16] << 16 )+
		(a << 24 );

	sum[0] += add[(___index+1)*4+0] - sub[(___index+1)*4+0];
	sum[1] += add[(___index+1)*4+1] - sub[(___index+1)*4+1];
	sum[2] += add[(___index+1)*4+2] - sub[(___index+1)*4+2];
	sum[3] += add[(___index+1)*4+3] - sub[(___index+1)*4+3];
}
{
	tjs_int a = ((sum[3] + half_n) * rcp >> 16);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[(___index+2)] =
		(t[(sum[0] + half_n) * rcp >> 16]       )+
		(t[(sum[1] + half_n) * rcp >> 16] << 8  )+
		(t[(sum[2] + half_n) * rcp >> 16] << 16 )+
		(a << 24 );

	sum[0] += add[(___index+2)*4+0] - sub[(___index+2)*4+0];
	sum[1] += add[(___index+2)*4+1] - sub[(___index+2)*4+1];
	sum[2] += add[(___index+2)*4+2] - sub[(___index+2)*4+2];
	sum[3] += add[(___index+2)*4+3] - sub[(___index+2)*4+3];
}
{
	tjs_int a = ((sum[3] + half_n) * rcp >> 16);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[(___index+3)] =
		(t[(sum[0] + half_n) * rcp >> 16]       )+
		(t[(sum[1] + half_n) * rcp >> 16] << 8  )+
		(t[(sum[2] + half_n) * rcp >> 16] << 16 )+
		(a << 24 );

	sum[0] += add[(___index+3)*4+0] - sub[(___index+3)*4+0];
	sum[1] += add[(___index+3)*4+1] - sub[(___index+3)*4+1];
	sum[2] += add[(___index+3)*4+2] - sub[(___index+3)*4+2];
	sum[3] += add[(___index+3)*4+3] - sub[(___index+3)*4+3];
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
	tjs_int a = ((sum[3] + half_n) * rcp >> 16);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[___index] =
		(t[(sum[0] + half_n) * rcp >> 16]       )+
		(t[(sum[1] + half_n) * rcp >> 16] << 8  )+
		(t[(sum[2] + half_n) * rcp >> 16] << 16 )+
		(a << 24 );

	sum[0] += add[___index*4+0] - sub[___index*4+0];
	sum[1] += add[___index*4+1] - sub[___index*4+1];
	sum[2] += add[___index*4+2] - sub[___index*4+2];
	sum[3] += add[___index*4+3] - sub[___index*4+3];
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPDoBoxBlurAvg32_c, (tjs_uint32 *dest, tjs_uint32 *sum, const tjs_uint32 * add, const tjs_uint32 * sub, tjs_int n, tjs_int len))
{
	/* This function is very slow since using divisiion in loop. Function written in assembly should be used. */
	tjs_int half_n = n >> 1;
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
	dest[(___index+0)] =
		(((sum[0] + half_n) / n)       )+
		(((sum[1] + half_n) / n) << 8  )+
		(((sum[2] + half_n) / n) << 16 )+
		(((sum[3] + half_n) / n) << 24 );

	sum[0] += add[(___index+0)*4+0] - sub[(___index+0)*4+0];
	sum[1] += add[(___index+0)*4+1] - sub[(___index+0)*4+1];
	sum[2] += add[(___index+0)*4+2] - sub[(___index+0)*4+2];
	sum[3] += add[(___index+0)*4+3] - sub[(___index+0)*4+3];
}
{
	dest[(___index+1)] =
		(((sum[0] + half_n) / n)       )+
		(((sum[1] + half_n) / n) << 8  )+
		(((sum[2] + half_n) / n) << 16 )+
		(((sum[3] + half_n) / n) << 24 );

	sum[0] += add[(___index+1)*4+0] - sub[(___index+1)*4+0];
	sum[1] += add[(___index+1)*4+1] - sub[(___index+1)*4+1];
	sum[2] += add[(___index+1)*4+2] - sub[(___index+1)*4+2];
	sum[3] += add[(___index+1)*4+3] - sub[(___index+1)*4+3];
}
{
	dest[(___index+2)] =
		(((sum[0] + half_n) / n)       )+
		(((sum[1] + half_n) / n) << 8  )+
		(((sum[2] + half_n) / n) << 16 )+
		(((sum[3] + half_n) / n) << 24 );

	sum[0] += add[(___index+2)*4+0] - sub[(___index+2)*4+0];
	sum[1] += add[(___index+2)*4+1] - sub[(___index+2)*4+1];
	sum[2] += add[(___index+2)*4+2] - sub[(___index+2)*4+2];
	sum[3] += add[(___index+2)*4+3] - sub[(___index+2)*4+3];
}
{
	dest[(___index+3)] =
		(((sum[0] + half_n) / n)       )+
		(((sum[1] + half_n) / n) << 8  )+
		(((sum[2] + half_n) / n) << 16 )+
		(((sum[3] + half_n) / n) << 24 );

	sum[0] += add[(___index+3)*4+0] - sub[(___index+3)*4+0];
	sum[1] += add[(___index+3)*4+1] - sub[(___index+3)*4+1];
	sum[2] += add[(___index+3)*4+2] - sub[(___index+3)*4+2];
	sum[3] += add[(___index+3)*4+3] - sub[(___index+3)*4+3];
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
	dest[___index] =
		(((sum[0] + half_n) / n)       )+
		(((sum[1] + half_n) / n) << 8  )+
		(((sum[2] + half_n) / n) << 16 )+
		(((sum[3] + half_n) / n) << 24 );

	sum[0] += add[___index*4+0] - sub[___index*4+0];
	sum[1] += add[___index*4+1] - sub[___index*4+1];
	sum[2] += add[___index*4+2] - sub[___index*4+2];
	sum[3] += add[___index*4+3] - sub[___index*4+3];
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPDoBoxBlurAvg32_d_c, (tjs_uint32 *dest, tjs_uint32 *sum, const tjs_uint32 * add, const tjs_uint32 * sub, tjs_int n, tjs_int len))
{
	/* This function is very slow since using divisiion in loop. Function written in assembly should be used. */
	tjs_int half_n = n >> 1;
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
	tjs_int a = ((sum[3] + half_n) / n);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[(___index+0)] =
		(t[(sum[0] + half_n) / n]       )+
		(t[(sum[1] + half_n) / n] << 8  )+
		(t[(sum[2] + half_n) / n] << 16 )+
		(a << 24 );

	sum[0] += add[(___index+0)*4+0] - sub[(___index+0)*4+0];
	sum[1] += add[(___index+0)*4+1] - sub[(___index+0)*4+1];
	sum[2] += add[(___index+0)*4+2] - sub[(___index+0)*4+2];
	sum[3] += add[(___index+0)*4+3] - sub[(___index+0)*4+3];
}
{
	tjs_int a = ((sum[3] + half_n) / n);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[(___index+1)] =
		(t[(sum[0] + half_n) / n]       )+
		(t[(sum[1] + half_n) / n] << 8  )+
		(t[(sum[2] + half_n) / n] << 16 )+
		(a << 24 );

	sum[0] += add[(___index+1)*4+0] - sub[(___index+1)*4+0];
	sum[1] += add[(___index+1)*4+1] - sub[(___index+1)*4+1];
	sum[2] += add[(___index+1)*4+2] - sub[(___index+1)*4+2];
	sum[3] += add[(___index+1)*4+3] - sub[(___index+1)*4+3];
}
{
	tjs_int a = ((sum[3] + half_n) / n);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[(___index+2)] =
		(t[(sum[0] + half_n) / n]       )+
		(t[(sum[1] + half_n) / n] << 8  )+
		(t[(sum[2] + half_n) / n] << 16 )+
		(a << 24 );

	sum[0] += add[(___index+2)*4+0] - sub[(___index+2)*4+0];
	sum[1] += add[(___index+2)*4+1] - sub[(___index+2)*4+1];
	sum[2] += add[(___index+2)*4+2] - sub[(___index+2)*4+2];
	sum[3] += add[(___index+2)*4+3] - sub[(___index+2)*4+3];
}
{
	tjs_int a = ((sum[3] + half_n) / n);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[(___index+3)] =
		(t[(sum[0] + half_n) / n]       )+
		(t[(sum[1] + half_n) / n] << 8  )+
		(t[(sum[2] + half_n) / n] << 16 )+
		(a << 24 );

	sum[0] += add[(___index+3)*4+0] - sub[(___index+3)*4+0];
	sum[1] += add[(___index+3)*4+1] - sub[(___index+3)*4+1];
	sum[2] += add[(___index+3)*4+2] - sub[(___index+3)*4+2];
	sum[3] += add[(___index+3)*4+3] - sub[(___index+3)*4+3];
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
	tjs_int a = ((sum[3] + half_n) / n);
	tjs_uint8 * t = TVPDivTable + (a << 8);
	dest[___index] =
		(t[(sum[0] + half_n) / n]       )+
		(t[(sum[1] + half_n) / n] << 8  )+
		(t[(sum[2] + half_n) / n] << 16 )+
		(a << 24 );

	sum[0] += add[___index*4+0] - sub[___index*4+0];
	sum[1] += add[___index*4+1] - sub[___index*4+1];
	sum[2] += add[___index*4+2] - sub[___index*4+2];
	sum[3] += add[___index*4+3] - sub[___index*4+3];
}
			___index ++;
		}
	}
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPInitGammaAdjustTempData_c, (tTVPGLGammaAdjustTempData *temp, const tTVPGLGammaAdjustData *data))
{
	/* make table */

	double ramp = data->RCeil - data->RFloor;
	double gamp = data->GCeil - data->GFloor;
	double bamp = data->BCeil - data->BFloor;

	double rgamma = 1.0/data->RGamma; /* we assume data.?Gamma is a non-zero value here */
	double ggamma = 1.0/data->GGamma;
	double bgamma = 1.0/data->BGamma;

	int i;
	for(i=0;i<256;i++)
	{
#if 0
		double rate = (double)i/255.0;
		int n;
		n = (int)(pow(rate, rgamma)*ramp+0.5+(double)data->RFloor);
		if(n<0) n=0; else if(n>255) n=255;
		temp->R[i]= n;
		n = (int)(pow(rate, ggamma)*gamp+0.5+(double)data->GFloor);
		if(n<0) n=0; else if(n>255) n=255;
		temp->G[i]= n;
		n = (int)(pow(rate, bgamma)*bamp+0.5+(double)data->BFloor);
		if(n<0) n=0; else if(n>255) n=255;
		temp->B[i]= n;
#else
		// pow(x, y) == exp(y * log(x))
		double rate = log((double)i/255.0);
		int n;
		n = (int)(exp(rate * rgamma)*ramp+0.5+(double)data->RFloor);
		if(n<0) n=0; else if(n>255) n=255;
		temp->R[i]= n;
		n = (int)(exp(rate * ggamma)*gamp+0.5+(double)data->GFloor);
		if(n<0) n=0; else if(n>255) n=255;
		temp->G[i]= n;
		n = (int)(exp(rate * bgamma)*bamp+0.5+(double)data->BFloor);
		if(n<0) n=0; else if(n>255) n=255;
		temp->B[i]= n;
#endif
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPUninitGammaAdjustTempData_c, (tTVPGLGammaAdjustTempData *temp))
{
	/* nothing to do */
}
/*export*/
TVP_GL_FUNC_DECL(void, TVPAdjustGamma_c, (tjs_uint32 *dest, tjs_int len, tTVPGLGammaAdjustTempData *temp))
{
	tjs_uint32 d1, t1;
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
	d1 = dest[(___index+0)];;
	if(d1 > 0x00ffffff)
	{
		/* process only non-fully-transparent pixel */
		t1 = temp->B[d1 & 0xff];;
		d1 >>= 8;;
		t1 += (temp->G[d1 & 0xff]<<8);;
		d1 >>= 8;;
		t1 += (temp->R[d1 & 0xff]<<16);;
		t1 += ((d1 & 0xff00) << 16);;
		dest[(___index+0)] = t1;;
	}
	d1 = dest[(___index+1)];;
	if(d1 > 0x00ffffff)
	{
		/* process only non-fully-transparent pixel */
		t1 = temp->B[d1 & 0xff];;
		d1 >>= 8;;
		t1 += (temp->G[d1 & 0xff]<<8);;
		d1 >>= 8;;
		t1 += (temp->R[d1 & 0xff]<<16);;
		t1 += ((d1 & 0xff00) << 16);;
		dest[(___index+1)] = t1;;
	}
	d1 = dest[(___index+2)];;
	if(d1 > 0x00ffffff)
	{
		/* process only non-fully-transparent pixel */
		t1 = temp->B[d1 & 0xff];;
		d1 >>= 8;;
		t1 += (temp->G[d1 & 0xff]<<8);;
		d1 >>= 8;;
		t1 += (temp->R[d1 & 0xff]<<16);;
		t1 += ((d1 & 0xff00) << 16);;
		dest[(___index+2)] = t1;;
	}
	d1 = dest[(___index+3)];;
	if(d1 > 0x00ffffff)
	{
		/* process only non-fully-transparent pixel */
		t1 = temp->B[d1 & 0xff];;
		d1 >>= 8;;
		t1 += (temp->G[d1 & 0xff]<<8);;
		d1 >>= 8;;
		t1 += (temp->R[d1 & 0xff]<<16);;
		t1 += ((d1 & 0xff00) << 16);;
		dest[(___index+3)] = t1;;
	}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
	d1 = dest[___index];;
	if(d1 > 0x00ffffff)
	{
		/* process only non-fully-transparent pixel */
		t1 = temp->B[d1 & 0xff];;
		d1 >>= 8;;
		t1 += (temp->G[d1 & 0xff]<<8);;
		d1 >>= 8;;
		t1 += (temp->R[d1 & 0xff]<<16);;
		t1 += ((d1 & 0xff00) << 16);;
		dest[___index] = t1;;
	}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPAdjustGamma_a_c, (tjs_uint32 *dest, tjs_int len, tTVPGLGammaAdjustTempData *temp))
{
	/* gamma adjustment for additive alpha */
	{
		int ___index = 0;
		len -= (2-1);

		while(___index < len)
		{
{
	tjs_uint32 d;
	tjs_int alpha;
	tjs_int alpha_adj;
	tjs_int recip;
	tjs_int t, d_tmp;

	d = dest[(___index+0)];

	if(d >= 0xff000000)
	{
		/* completely opaque */
		t = d & 0xff;
		d_tmp =   temp->B[t];
		t = (d>>8) & 0xff;
		d_tmp |=  temp->G[t] << 8;
		t = (d>>16) & 0xff; 
		d_tmp |=  temp->R[t] << 16;
		d_tmp |= 0xff000000;
		dest[(___index+0)] = d_tmp;
	}
	else if(d != 0)
	{
		/* not completely transparent */
		alpha = d >> 24;
		alpha_adj = alpha + (alpha >> 7);
		recip = TVPRecipTable256_16[alpha];

		/* B */
		t = d & 0xff;
		if(t > alpha)
			d_tmp = (temp->B[255] * alpha_adj >> 8) + t - alpha;
		else
			d_tmp = temp->B[recip * t >> 8] * alpha_adj >> 8;
		/* G */
		t = (d>>8) & 0xff; 
		if(t > alpha)
			d_tmp |= ((temp->G[255] * alpha_adj >> 8) + t - alpha) << 8;
		else
			d_tmp |= (temp->G[recip * t >> 8] * alpha_adj >> 8) << 8;
		/* R */
		t = (d>>16) & 0xff; 
		if(t > alpha)
			d_tmp |= ((temp->R[255] * alpha_adj >> 8) + t - alpha) << 16;
		else
			d_tmp |= (temp->R[recip * t >> 8] * alpha_adj >> 8) << 16;
		/* A */
		d_tmp |= d & 0xff000000;

		dest[(___index+0)] = d_tmp;
	}
}
{
	tjs_uint32 d;
	tjs_int alpha;
	tjs_int alpha_adj;
	tjs_int recip;
	tjs_int t, d_tmp;

	d = dest[(___index+1)];

	if(d >= 0xff000000)
	{
		/* completely opaque */
		t = d & 0xff;
		d_tmp =   temp->B[t];
		t = (d>>8) & 0xff;
		d_tmp |=  temp->G[t] << 8;
		t = (d>>16) & 0xff; 
		d_tmp |=  temp->R[t] << 16;
		d_tmp |= 0xff000000;
		dest[(___index+1)] = d_tmp;
	}
	else if(d != 0)
	{
		/* not completely transparent */
		alpha = d >> 24;
		alpha_adj = alpha + (alpha >> 7);
		recip = TVPRecipTable256_16[alpha];

		/* B */
		t = d & 0xff;
		if(t > alpha)
			d_tmp = (temp->B[255] * alpha_adj >> 8) + t - alpha;
		else
			d_tmp = temp->B[recip * t >> 8] * alpha_adj >> 8;
		/* G */
		t = (d>>8) & 0xff; 
		if(t > alpha)
			d_tmp |= ((temp->G[255] * alpha_adj >> 8) + t - alpha) << 8;
		else
			d_tmp |= (temp->G[recip * t >> 8] * alpha_adj >> 8) << 8;
		/* R */
		t = (d>>16) & 0xff; 
		if(t > alpha)
			d_tmp |= ((temp->R[255] * alpha_adj >> 8) + t - alpha) << 16;
		else
			d_tmp |= (temp->R[recip * t >> 8] * alpha_adj >> 8) << 16;
		/* A */
		d_tmp |= d & 0xff000000;

		dest[(___index+1)] = d_tmp;
	}
}
			___index += 2;
		}

		len += (2-1);

		while(___index < len)
		{
{
	tjs_uint32 d;
	tjs_int alpha;
	tjs_int alpha_adj;
	tjs_int recip;
	tjs_int t, d_tmp;

	d = dest[___index];

	if(d >= 0xff000000)
	{
		/* completely opaque */
		t = d & 0xff;
		d_tmp =   temp->B[t];
		t = (d>>8) & 0xff;
		d_tmp |=  temp->G[t] << 8;
		t = (d>>16) & 0xff; 
		d_tmp |=  temp->R[t] << 16;
		d_tmp |= 0xff000000;
		dest[___index] = d_tmp;
	}
	else if(d != 0)
	{
		/* not completely transparent */
		alpha = d >> 24;
		alpha_adj = alpha + (alpha >> 7);
		recip = TVPRecipTable256_16[alpha];

		/* B */
		t = d & 0xff;
		if(t > alpha)
			d_tmp = (temp->B[255] * alpha_adj >> 8) + t - alpha;
		else
			d_tmp = temp->B[recip * t >> 8] * alpha_adj >> 8;
		/* G */
		t = (d>>8) & 0xff; 
		if(t > alpha)
			d_tmp |= ((temp->G[255] * alpha_adj >> 8) + t - alpha) << 8;
		else
			d_tmp |= (temp->G[recip * t >> 8] * alpha_adj >> 8) << 8;
		/* R */
		t = (d>>16) & 0xff; 
		if(t > alpha)
			d_tmp |= ((temp->R[255] * alpha_adj >> 8) + t - alpha) << 16;
		else
			d_tmp |= (temp->R[recip * t >> 8] * alpha_adj >> 8) << 16;
		/* A */
		d_tmp |= d & 0xff000000;

		dest[___index] = d_tmp;
	}
}
			___index ++;
		}
	}
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPBLExpand1BitTo8BitPal_c, (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal))
{
	tjs_uint8 p[2];
	tjs_uint8 *d=dest, *dlim;
	tjs_uint8 b;

	p[0] = pal[0]&0xff, p[1] = pal[1]&0xff;
	dlim = dest + len-7;
	while(d < dlim)
	{
		b = *(buf++);
		d[0] = p[(tjs_uint)(b&(tjs_uint)0x80)>>7];
		d[1] = p[(tjs_uint)(b&(tjs_uint)0x40)>>6];
		d[2] = p[(tjs_uint)(b&(tjs_uint)0x20)>>5];
		d[3] = p[(tjs_uint)(b&(tjs_uint)0x10)>>4];
		d[4] = p[(tjs_uint)(b&(tjs_uint)0x08)>>3];
		d[5] = p[(tjs_uint)(b&(tjs_uint)0x04)>>2];
		d[6] = p[(tjs_uint)(b&(tjs_uint)0x02)>>1];
		d[7] = p[(tjs_uint)(b&(tjs_uint)0x01)   ];
		d += 8;
	}
	dlim = dest + len;
	b = *buf;
	while(d<dlim)
	{
		*(d++) = (b&0x80) ? p[1] : p[0];
		b<<=1;
	}
}
/*export*/
TVP_GL_FUNC_DECL(void, TVPBLExpand1BitTo8Bit_c, (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len))
{
	tjs_uint8 *d=dest, *dlim;
	tjs_uint8 b;

	dlim = dest + len-7;
	while(d < dlim)
	{
		b = *(buf++);
		d[0] = (tjs_uint8)((b&(tjs_uint)0x80)>>7);
		d[1] = (tjs_uint8)((b&(tjs_uint)0x40)>>6);
		d[2] = (tjs_uint8)((b&(tjs_uint)0x20)>>5);
		d[3] = (tjs_uint8)((b&(tjs_uint)0x10)>>4);
		d[4] = (tjs_uint8)((b&(tjs_uint)0x08)>>3);
		d[5] = (tjs_uint8)((b&(tjs_uint)0x04)>>2);
		d[6] = (tjs_uint8)((b&(tjs_uint)0x02)>>1);
		d[7] = (tjs_uint8)((b&(tjs_uint)0x01)   );
		d += 8;
	}
	dlim = dest + len;
	b = *buf;
	while(d<dlim)
	{
		*(d++) = (b&0x80) ? 1 : 0;
		b<<=1;
	}
}
/*export*/
TVP_GL_FUNC_DECL(void, TVPBLExpand1BitTo32BitPal_c, (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal))
{
	tjs_uint32 p[2];
	tjs_uint32 *d=dest, *dlim;
	tjs_uint8 b;

	p[0] = pal[0], p[1] = pal[1];
	dlim = dest + len-7;
	while(d < dlim)
	{
		b = *(buf++);
		d[0] = p[(tjs_uint)(b&(tjs_uint)0x80)>>7];
		d[1] = p[(tjs_uint)(b&(tjs_uint)0x40)>>6];
		d[2] = p[(tjs_uint)(b&(tjs_uint)0x20)>>5];
		d[3] = p[(tjs_uint)(b&(tjs_uint)0x10)>>4];
		d[4] = p[(tjs_uint)(b&(tjs_uint)0x08)>>3];
		d[5] = p[(tjs_uint)(b&(tjs_uint)0x04)>>2];
		d[6] = p[(tjs_uint)(b&(tjs_uint)0x02)>>1];
		d[7] = p[(tjs_uint)(b&(tjs_uint)0x01)   ];
		d += 8;
	}
	dlim = dest + len;
	b = *buf;
	while(d<dlim)
	{
		*(d++) = (b&0x80) ? p[1] : p[0];
		b<<=1;
	}
}
/*export*/
TVP_GL_FUNC_DECL(void, TVPBLExpand4BitTo8BitPal_c, (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal))
{
	tjs_uint8 *d=dest, *dlim;
	tjs_uint8 b;

	dlim = dest + (len & ~1);
	while(d < dlim)
	{
		b = *(buf++);
		d[0] = (tjs_uint8)pal[(b&0xf0)>>4];
		d[1] = (tjs_uint8)pal[b&0x0f];
		d += 2;
	}
	if(len & 1)
	{
		b = *buf;
		if(d<dlim) *d = (tjs_uint8)pal[(b&0xf0)>>4];
	}
}
/*export*/
TVP_GL_FUNC_DECL(void, TVPBLExpand4BitTo8Bit_c, (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len))
{
	tjs_uint8 *d=dest, *dlim;
	tjs_uint8 b;

	dlim = dest + (len & ~1);
	while(d < dlim)
	{
		b = *(buf++);
		d[0] = (tjs_uint8)((b&0xf0)>>4);
		d[1] = (tjs_uint8)(b&0x0f);
		d += 2;
	}
	if(len & 1)
	{
		b = *buf;
		if(d<dlim) *d = (tjs_uint8)((b&0xf0)>>4);
	}
}
/*export*/
TVP_GL_FUNC_DECL(void, TVPBLExpand4BitTo32BitPal_c, (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal))
{
	tjs_uint32 *d=dest, *dlim;
	tjs_uint8 b;

	dlim = dest + (len & ~1);
	while(d < dlim)
	{
		b = *(buf++);
		d[0] = pal[(b&0xf0)>>4];
		d[1] = pal[b&0x0f];
		d += 2;
	}
	if(len & 1)
	{
		b = *buf;
		*d = pal[(b&0xf0)>>4];
	}
}
/*export*/
TVP_GL_FUNC_DECL(void, TVPBLExpand8BitTo8BitPal_c, (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
	dest[(___index+0)] = pal[buf[(___index+0)]]&0xff;
}
{
	dest[(___index+1)] = pal[buf[(___index+1)]]&0xff;
}
{
	dest[(___index+2)] = pal[buf[(___index+2)]]&0xff;
}
{
	dest[(___index+3)] = pal[buf[(___index+3)]]&0xff;
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
	dest[___index] = pal[buf[___index]]&0xff;
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPBLExpand8BitTo32BitPal_c, (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal))
{
	{
		int ___index = 0;
		len -= (8-1);

		while(___index < len)
		{
{
	dest[(___index+0)] = pal[buf[(___index+0)]];
}
{
	dest[(___index+1)] = pal[buf[(___index+1)]];
}
{
	dest[(___index+2)] = pal[buf[(___index+2)]];
}
{
	dest[(___index+3)] = pal[buf[(___index+3)]];
}
{
	dest[(___index+4)] = pal[buf[(___index+4)]];
}
{
	dest[(___index+5)] = pal[buf[(___index+5)]];
}
{
	dest[(___index+6)] = pal[buf[(___index+6)]];
}
{
	dest[(___index+7)] = pal[buf[(___index+7)]];
}
			___index += 8;
		}

		len += (8-1);

		while(___index < len)
		{
{
	dest[___index] = pal[buf[___index]];
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPExpand8BitTo32BitGray_c, (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len))
{
	tjs_uint8 a, b;
	{
		int ___index = 0;
		len -= (8-1);

		while(___index < len)
		{
	a = buf[(___index+(0*2))];
	b = buf[(___index+(0*2+1))];
	dest[(___index+(0*2))] = 0xff000000 + (a * 0x10101);
	dest[(___index+(0*2+1))] = 0xff000000 + (b * 0x10101);
	a = buf[(___index+(1*2))];
	b = buf[(___index+(1*2+1))];
	dest[(___index+(1*2))] = 0xff000000 + (a * 0x10101);
	dest[(___index+(1*2+1))] = 0xff000000 + (b * 0x10101);
	a = buf[(___index+(2*2))];
	b = buf[(___index+(2*2+1))];
	dest[(___index+(2*2))] = 0xff000000 + (a * 0x10101);
	dest[(___index+(2*2+1))] = 0xff000000 + (b * 0x10101);
	a = buf[(___index+(3*2))];
	b = buf[(___index+(3*2+1))];
	dest[(___index+(3*2))] = 0xff000000 + (a * 0x10101);
	dest[(___index+(3*2+1))] = 0xff000000 + (b * 0x10101);
			___index += 8;
		}

		len += (8-1);

		while(___index < len)
		{
	a = buf[___index];;
	dest[___index] = 0xff000000 + (a * 0x10101);;
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPBLConvert15BitTo8Bit_c, (tjs_uint8 *dest, const tjs_uint16 *buf, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+(___index+0)) << 8 + *((tjs_uint8*)(buf+(___index+0))+1);
#else
	tjs_uint16 s = buf[(___index+0)];
#endif
	dest[(___index+0)] =
		((s&0x7c00)*56+ (s&0x03e0)*(187<<5)+ (s&0x001f)*(21<<10)) >> 15;
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+(___index+1)) << 8 + *((tjs_uint8*)(buf+(___index+1))+1);
#else
	tjs_uint16 s = buf[(___index+1)];
#endif
	dest[(___index+1)] =
		((s&0x7c00)*56+ (s&0x03e0)*(187<<5)+ (s&0x001f)*(21<<10)) >> 15;
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+(___index+2)) << 8 + *((tjs_uint8*)(buf+(___index+2))+1);
#else
	tjs_uint16 s = buf[(___index+2)];
#endif
	dest[(___index+2)] =
		((s&0x7c00)*56+ (s&0x03e0)*(187<<5)+ (s&0x001f)*(21<<10)) >> 15;
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+(___index+3)) << 8 + *((tjs_uint8*)(buf+(___index+3))+1);
#else
	tjs_uint16 s = buf[(___index+3)];
#endif
	dest[(___index+3)] =
		((s&0x7c00)*56+ (s&0x03e0)*(187<<5)+ (s&0x001f)*(21<<10)) >> 15;
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+___index) << 8 + *((tjs_uint8*)(buf+___index)+1);
#else
	tjs_uint16 s = buf[___index];
#endif
	dest[___index] =
		((s&0x7c00)*56+ (s&0x03e0)*(187<<5)+ (s&0x001f)*(21<<10)) >> 15;
}
			___index ++;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPBLConvert15BitTo32Bit_c, (tjs_uint32 *dest, const tjs_uint16 *buf, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+(___index+0)) << 8 + *((tjs_uint8*)(buf+(___index+0))+1);
#else
	tjs_uint16 s = buf[(___index+0)];
#endif
	tjs_int r = s&0x7c00;
	tjs_int g = s&0x03e0;
	tjs_int b = s&0x001f;
	dest[(___index+0)] = 0xff000000 +
		(r <<  9) + ((r&0x7000)<<4) +
		(g <<  6) + ((g&0x0380)<<1) +
		(b <<  3) + (b>>2);
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+(___index+1)) << 8 + *((tjs_uint8*)(buf+(___index+1))+1);
#else
	tjs_uint16 s = buf[(___index+1)];
#endif
	tjs_int r = s&0x7c00;
	tjs_int g = s&0x03e0;
	tjs_int b = s&0x001f;
	dest[(___index+1)] = 0xff000000 +
		(r <<  9) + ((r&0x7000)<<4) +
		(g <<  6) + ((g&0x0380)<<1) +
		(b <<  3) + (b>>2);
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+(___index+2)) << 8 + *((tjs_uint8*)(buf+(___index+2))+1);
#else
	tjs_uint16 s = buf[(___index+2)];
#endif
	tjs_int r = s&0x7c00;
	tjs_int g = s&0x03e0;
	tjs_int b = s&0x001f;
	dest[(___index+2)] = 0xff000000 +
		(r <<  9) + ((r&0x7000)<<4) +
		(g <<  6) + ((g&0x0380)<<1) +
		(b <<  3) + (b>>2);
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+(___index+3)) << 8 + *((tjs_uint8*)(buf+(___index+3))+1);
#else
	tjs_uint16 s = buf[(___index+3)];
#endif
	tjs_int r = s&0x7c00;
	tjs_int g = s&0x03e0;
	tjs_int b = s&0x001f;
	dest[(___index+3)] = 0xff000000 +
		(r <<  9) + ((r&0x7000)<<4) +
		(g <<  6) + ((g&0x0380)<<1) +
		(b <<  3) + (b>>2);
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint16 s = *(tjs_uint8*)(buf+___index) << 8 + *((tjs_uint8*)(buf+___index)+1);
#else
	tjs_uint16 s = buf[___index];
#endif
	tjs_int r = s&0x7c00;
	tjs_int g = s&0x03e0;
	tjs_int b = s&0x001f;
	dest[___index] = 0xff000000 +
		(r <<  9) + ((r&0x7000)<<4) +
		(g <<  6) + ((g&0x0380)<<1) +
		(b <<  3) + (b>>2);
}
			___index ++;
		}
	}
}

# define compose_grayscale(r,g,b) ((unsigned char)((((tjs_int)(b)*19 + (tjs_int)(g)*183 + (tjs_int)(r)*54)>>8)))
/*export*/
TVP_GL_FUNC_DECL(void, TVPBLConvert24BitTo8Bit_c, (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len))
{
	tjs_uint8 *slimglim = dest + len;
	tjs_uint8 *slimglims = slimglim - 3;
	while(dest < slimglims)
	{
		dest[0] = compose_grayscale(buf[2], buf[1], buf[0]);
		dest[1] = compose_grayscale(buf[5], buf[4], buf[3]);
		dest[2] = compose_grayscale(buf[8], buf[7], buf[6]);
		dest[3] = compose_grayscale(buf[11], buf[10], buf[9]);
		dest += 4;
		buf += 12;
	}
	while(dest < slimglim)
	{
		dest[0] = compose_grayscale(buf[2], buf[1], buf[0]);
		dest ++;
		buf += 3;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPBLConvert24BitTo32Bit_c, (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len))
{
	tjs_uint32 *slimglim = dest + len;
	tjs_uint32 *slimglims = slimglim - 7;
	while(dest < slimglims)
	{
#if TJS_HOST_IS_BIG_ENDIAN
		dest[0] = 0xff000000 + buf[0] + (buf[1]<<8) + (buf[2]<<16);
		dest[1] = 0xff000000 + buf[3] + (buf[4]<<8) + (buf[5]<<16);
		dest[2] = 0xff000000 + buf[6] + (buf[7]<<8) + (buf[8]<<16);
		dest[3] = 0xff000000 + buf[9] + (buf[10]<<8) + (buf[11]<<16);
		dest += 4;
		buf += 12;
		dest[0] = 0xff000000 + buf[0] + (buf[1]<<8) + (buf[2]<<16);
		dest[1] = 0xff000000 + buf[3] + (buf[4]<<8) + (buf[5]<<16);
		dest[2] = 0xff000000 + buf[6] + (buf[7]<<8) + (buf[8]<<16);
		dest[3] = 0xff000000 + buf[9] + (buf[10]<<8) + (buf[11]<<16);
		dest += 4;
		buf += 12;
#else
		tjs_uint32 a = *(tjs_uint32*)buf, b;
		tjs_uint32 c = *(tjs_uint32*)(buf+12), d;
		dest[0] = 0xff000000 + (a & 0x00ffffff);
		dest[4] = 0xff000000 + (c & 0x00ffffff);
		b = *(tjs_uint32*)(buf+4);
		d = *(tjs_uint32*)(buf+16);
		dest[1] = 0xff000000 + ((a >> 24) + ((b & 0xffff)<<8));
		dest[5] = 0xff000000 + ((c >> 24) + ((d & 0xffff)<<8));
		a = *(tjs_uint32*)(buf+8);
		c = *(tjs_uint32*)(buf+20);
		dest[2] = 0xff000000 + ((b >> 16) + ((a & 0xff)<<16));
		dest[6] = 0xff000000 + ((d >> 16) + ((c & 0xff)<<16));
		dest[3] = 0xff000000 + (a >> 8);
		dest[7] = 0xff000000 + (c >> 8);
		dest += 8;
		buf += 24;
#endif
	}
	while(dest < slimglim)
	{
#if TJS_HOST_IS_BIG_ENDIAN
		*(dest++) = 0xff000000 + buf[0] + (buf[1]<<8) + (buf[2]<<16);
#else
		*(dest++) = 0xff000000 + buf[0] + (buf[1]<<8) + (buf[2]<<16);
#endif
		buf += 3;
	}
}
/*export*/
TVP_GL_FUNC_DECL(void, TVPConvert24BitTo32Bit_c, (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len))
{
	/* this function does not matter the host endian */
	tjs_uint32 *slimglim = dest + len;
	tjs_uint32 *slimglims = slimglim - 7;
	while(dest < slimglims)
	{
		tjs_uint32 a = *(tjs_uint32*)buf, b;
		tjs_uint32 c = *(tjs_uint32*)(buf+12), d;
		dest[0] = 0xff000000 + (a & 0x00ffffff);
		dest[4] = 0xff000000 + (c & 0x00ffffff);
		b = *(tjs_uint32*)(buf+4);
		d = *(tjs_uint32*)(buf+16);
		dest[1] = 0xff000000 + ((a >> 24) + ((b & 0xffff)<<8));
		dest[5] = 0xff000000 + ((c >> 24) + ((d & 0xffff)<<8));
		a = *(tjs_uint32*)(buf+8);
		c = *(tjs_uint32*)(buf+20);
		dest[2] = 0xff000000 + ((b >> 16) + ((a & 0xff)<<16));
		dest[6] = 0xff000000 + ((d >> 16) + ((c & 0xff)<<16));
		dest[3] = 0xff000000 + (a >> 8);
		dest[7] = 0xff000000 + (c >> 8);
		dest += 8;
		buf += 24;
	}
	while(dest < slimglim)
	{
		*(dest++) = 0xff000000 + buf[0] + (buf[1]<<8) + (buf[2]<<16);
		buf += 3;
	}
}
/*export*/
TVP_GL_FUNC_DECL(void, TVPBLConvert32BitTo8Bit_c, (tjs_uint8 *dest, const tjs_uint32 *buf, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+0)];
	dest[(___index+0)] = compose_grayscale(d&0xff, (d&0xff00)>>8, (d&0xff0000)>>16);
#else
	tjs_uint32 d = buf[(___index+0)];
	dest[(___index+0)] = compose_grayscale((d&0xff0000)>>16, (d&0xff00)>>8, d&0xff);
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+1)];
	dest[(___index+1)] = compose_grayscale(d&0xff, (d&0xff00)>>8, (d&0xff0000)>>16);
#else
	tjs_uint32 d = buf[(___index+1)];
	dest[(___index+1)] = compose_grayscale((d&0xff0000)>>16, (d&0xff00)>>8, d&0xff);
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+2)];
	dest[(___index+2)] = compose_grayscale(d&0xff, (d&0xff00)>>8, (d&0xff0000)>>16);
#else
	tjs_uint32 d = buf[(___index+2)];
	dest[(___index+2)] = compose_grayscale((d&0xff0000)>>16, (d&0xff00)>>8, d&0xff);
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+3)];
	dest[(___index+3)] = compose_grayscale(d&0xff, (d&0xff00)>>8, (d&0xff0000)>>16);
#else
	tjs_uint32 d = buf[(___index+3)];
	dest[(___index+3)] = compose_grayscale((d&0xff0000)>>16, (d&0xff00)>>8, d&0xff);
#endif
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[___index];
	dest[___index] = compose_grayscale(d&0xff, (d&0xff00)>>8, (d&0xff0000)>>16);
#else
	tjs_uint32 d = buf[___index];
	dest[___index] = compose_grayscale((d&0xff0000)>>16, (d&0xff00)>>8, d&0xff);
#endif
}
			___index ++;
		}
	}
}


/*export*/
TVP_GL_FUNC_DECL(void, TVPBLConvert32BitTo32Bit_NoneAlpha_c, (tjs_uint32 *dest, const tjs_uint32 *buf, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+0)];
	dest[(___index+0)] = 0xff000000 + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[(___index+0)];
	dest[(___index+0)] = d | 0xff000000;
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+1)];
	dest[(___index+1)] = 0xff000000 + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[(___index+1)];
	dest[(___index+1)] = d | 0xff000000;
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+2)];
	dest[(___index+2)] = 0xff000000 + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[(___index+2)];
	dest[(___index+2)] = d | 0xff000000;
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+3)];
	dest[(___index+3)] = 0xff000000 + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[(___index+3)];
	dest[(___index+3)] = d | 0xff000000;
#endif
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[___index];
	dest[___index] = 0xff000000 + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[___index];
	dest[___index] = d | 0xff000000;
#endif
}
			___index ++;
		}
	}

}


/*export*/
TVP_GL_FUNC_DECL(void, TVPBLConvert32BitTo32Bit_MulAddAlpha_c, (tjs_uint32 *dest, const tjs_uint32 *buf, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+0)];
	dest[(___index+0)] = ((d&0xff)<<24) + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[(___index+0)];
	dest[(___index+0)] = d;
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+1)];
	dest[(___index+1)] = ((d&0xff)<<24) + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[(___index+1)];
	dest[(___index+1)] = d;
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+2)];
	dest[(___index+2)] = ((d&0xff)<<24) + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[(___index+2)];
	dest[(___index+2)] = d;
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+3)];
	dest[(___index+3)] = ((d&0xff)<<24) + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[(___index+3)];
	dest[(___index+3)] = d;
#endif
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[___index];
	dest[___index] = ((d&0xff)<<24) + ((d&0xff00)<<8) +  ((d&0xff0000)>>8) + ((d&0xff000000)>>24);
#else
	tjs_uint32 d = buf[___index];
	dest[___index] = d;
#endif
}
			___index ++;
		}
	}

}


/*export*/
TVP_GL_FUNC_DECL(void, TVPBLConvert32BitTo32Bit_AddAlpha_c, (tjs_uint32 *dest, const tjs_uint32 *buf, tjs_int len))
{
	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+0)];
	tjs_uint8 *t = TVPDivTable + ((d & 0xff)<<8);
	dest[(___index+0)] = ((d&0xff)<<24) + (t[(d&0xff00)>>8]<<16) +  (t[(d&0xff0000)>>16]<<8) + (t[(d&0xff000000)>>24]);
#else
	tjs_uint32 d = buf[(___index+0)];
	tjs_uint8 *t = TVPDivTable + ((d>>16) & 0xff00);
	dest[(___index+0)] = (d&0xff000000) + (t[(d&0xff0000)>>16]<<16) + (t[(d&0xff00)>>8]<<8) + (t[d&0xff]);
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+1)];
	tjs_uint8 *t = TVPDivTable + ((d & 0xff)<<8);
	dest[(___index+1)] = ((d&0xff)<<24) + (t[(d&0xff00)>>8]<<16) +  (t[(d&0xff0000)>>16]<<8) + (t[(d&0xff000000)>>24]);
#else
	tjs_uint32 d = buf[(___index+1)];
	tjs_uint8 *t = TVPDivTable + ((d>>16) & 0xff00);
	dest[(___index+1)] = (d&0xff000000) + (t[(d&0xff0000)>>16]<<16) + (t[(d&0xff00)>>8]<<8) + (t[d&0xff]);
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+2)];
	tjs_uint8 *t = TVPDivTable + ((d & 0xff)<<8);
	dest[(___index+2)] = ((d&0xff)<<24) + (t[(d&0xff00)>>8]<<16) +  (t[(d&0xff0000)>>16]<<8) + (t[(d&0xff000000)>>24]);
#else
	tjs_uint32 d = buf[(___index+2)];
	tjs_uint8 *t = TVPDivTable + ((d>>16) & 0xff00);
	dest[(___index+2)] = (d&0xff000000) + (t[(d&0xff0000)>>16]<<16) + (t[(d&0xff00)>>8]<<8) + (t[d&0xff]);
#endif
}
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[(___index+3)];
	tjs_uint8 *t = TVPDivTable + ((d & 0xff)<<8);
	dest[(___index+3)] = ((d&0xff)<<24) + (t[(d&0xff00)>>8]<<16) +  (t[(d&0xff0000)>>16]<<8) + (t[(d&0xff000000)>>24]);
#else
	tjs_uint32 d = buf[(___index+3)];
	tjs_uint8 *t = TVPDivTable + ((d>>16) & 0xff00);
	dest[(___index+3)] = (d&0xff000000) + (t[(d&0xff0000)>>16]<<16) + (t[(d&0xff00)>>8]<<8) + (t[d&0xff]);
#endif
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
#if TJS_HOST_IS_BIG_ENDIAN
	tjs_uint32 d = buf[___index];
	tjs_uint8 *t = TVPDivTable + ((d & 0xff)<<8);
	dest[___index] = ((d&0xff)<<24) + (t[(d&0xff00)>>8]<<16) +  (t[(d&0xff0000)>>16]<<8) + (t[(d&0xff000000)>>24]);
#else
	tjs_uint32 d = buf[___index];
	tjs_uint8 *t = TVPDivTable + ((d>>16) & 0xff00);
	dest[___index] = (d&0xff000000) + (t[(d&0xff0000)>>16]<<16) + (t[(d&0xff00)>>8]<<8) + (t[d&0xff]);
#endif
}
			___index ++;
		}
	}

}


/*export*/
TVP_GL_FUNC_DECL(void, TVPDither32BitTo16Bit565_c, (tjs_uint16 *dest, const tjs_uint32 *src, tjs_int len, tjs_int xofs, tjs_int yofs))
{

tjs_uint8 *line = TVPDitherTable_5_6[yofs & 0x03][0][0];
tjs_int x = (xofs & 0x03) << 9;


	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 11)+  (line[x + (v & 0xff)]) +
	(line[x + 256 + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 11)+  (line[x + (v & 0xff)]) +
	(line[x + 256 + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 11)+  (line[x + (v & 0xff)]) +
	(line[x + 256 + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 11)+  (line[x + (v & 0xff)]) +
	(line[x + 256 + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 11)+  (line[x + (v & 0xff)]) +
	(line[x + 256 + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
			___index ++;
		}
	}

}


/*export*/
TVP_GL_FUNC_DECL(void, TVPDither32BitTo16Bit555_c, (tjs_uint16 *dest, const tjs_uint32 *src, tjs_int len, tjs_int xofs, tjs_int yofs))
{

tjs_uint8 *line = TVPDitherTable_5_6[yofs & 0x03][0][0];
tjs_int x = (xofs & 0x03) << 9;


	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 10) + (line[x + (v & 0xff)]) +
	(line[x + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 10) + (line[x + (v & 0xff)]) +
	(line[x + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 10) + (line[x + (v & 0xff)]) +
	(line[x + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 10) + (line[x + (v & 0xff)]) +
	(line[x + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)] << 10) + (line[x + (v & 0xff)]) +
	(line[x + ((v >> 8) & 0xff)] << 5);
dest++;
src++;
x+= 0x200;
x &= 0x600;
}
			___index ++;
		}
	}

}


/*export*/
TVP_GL_FUNC_DECL(void, TVPDither32BitTo8Bit_c, (tjs_uint8 *dest, const tjs_uint32 *src, tjs_int len, tjs_int xofs, tjs_int yofs))
{

tjs_uint8 *line = &(TVPDitherTable_676[0][yofs & 0x03][0][0]);
tjs_int x = (xofs & 0x03) << 8;


	{
		int ___index = 0;
		len -= (4-1);

		while(___index < len)
		{
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)])+ (line[(256 * 16 * 2) + x + (v & 0xff)]) +
	(line[(16 * 256) + x + ((v >> 8) & 0xff)]);
dest++;
src++;
x += 0x100;
x &= 0x300;
}
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)])+ (line[(256 * 16 * 2) + x + (v & 0xff)]) +
	(line[(16 * 256) + x + ((v >> 8) & 0xff)]);
dest++;
src++;
x += 0x100;
x &= 0x300;
}
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)])+ (line[(256 * 16 * 2) + x + (v & 0xff)]) +
	(line[(16 * 256) + x + ((v >> 8) & 0xff)]);
dest++;
src++;
x += 0x100;
x &= 0x300;
}
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)])+ (line[(256 * 16 * 2) + x + (v & 0xff)]) +
	(line[(16 * 256) + x + ((v >> 8) & 0xff)]);
dest++;
src++;
x += 0x100;
x &= 0x300;
}
			___index += 4;
		}

		len += (4-1);

		while(___index < len)
		{
{
tjs_uint32 v = *src;
*dest = (line[x + ((v >> 16) & 0xff)])+ (line[(256 * 16 * 2) + x + (v & 0xff)]) +
	(line[(16 * 256) + x + ((v >> 8) & 0xff)]);
dest++;
src++;
x += 0x100;
x &= 0x300;
}
			___index ++;
		}
	}

}



/*export*/
TVP_GL_FUNC_DECL(void, TVPTLG5ComposeColors3To4_c, (tjs_uint8 *outp, const tjs_uint8 *upper, tjs_uint8 * const * buf, tjs_int width))
{
	tjs_int x;
	tjs_uint8 pc[3];
	tjs_uint8 c[3];
	pc[0] = pc[1] = pc[2] = 0;
	for(x = 0; x < width; x++)
	{
		c[0] = buf[0][x];
		c[1] = buf[1][x];
		c[2] = buf[2][x];
		c[0] += c[1]; c[2] += c[1];
		*(tjs_uint32 *)outp =
								((((pc[0] += c[0]) + upper[0]) & 0xff)      ) +
								((((pc[1] += c[1]) + upper[1]) & 0xff) <<  8) +
								((((pc[2] += c[2]) + upper[2]) & 0xff) << 16) +
								0xff000000;
		outp += 4;
		upper += 4;
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPTLG5ComposeColors4To4_c, (tjs_uint8 *outp, const tjs_uint8 *upper, tjs_uint8 * const* buf, tjs_int width))
{
	tjs_int x;
	tjs_uint8 pc[4];
	tjs_uint8 c[4];
	pc[0] = pc[1] = pc[2] = pc[3] = 0;
	for(x = 0; x < width; x++)
	{
		c[0] = buf[0][x];
		c[1] = buf[1][x];
		c[2] = buf[2][x];
		c[3] = buf[3][x];
		c[0] += c[1]; c[2] += c[1];
		*(tjs_uint32 *)outp =
								((((pc[0] += c[0]) + upper[0]) & 0xff)      ) +
								((((pc[1] += c[1]) + upper[1]) & 0xff) <<  8) +
								((((pc[2] += c[2]) + upper[2]) & 0xff) << 16) +
								((((pc[3] += c[3]) + upper[3]) & 0xff) << 24);
		outp += 4;
		upper += 4;
	}
}

/*export*/
TVP_GL_FUNC_DECL(tjs_int, TVPTLG5DecompressSlide_c, (tjs_uint8 *out, const tjs_uint8 *in, tjs_int insize, tjs_uint8 *text, tjs_int initialr))
{
	tjs_int r = initialr;
	tjs_uint flags = 0;
	const tjs_uint8 *inlim = in + insize;
	while(in < inlim)
	{
		if(((flags >>= 1) & 256) == 0)
		{
			flags = 0[in++] | 0xff00;
		}
		if(flags & 1)
		{
			tjs_int mpos = in[0] | ((in[1] & 0xf) << 8);
			tjs_int mlen = (in[1] & 0xf0) >> 4;
			in += 2;
			mlen += 3;
			if(mlen == 18) mlen += 0[in++];

			while(mlen--)
			{
				0[out++] = text[r++] = text[mpos++];
				mpos &= (4096 - 1);
				r &= (4096 - 1);
			}
		}
		else
		{
			unsigned char c = 0[in++];
			0[out++] = c;
			text[r++] = c;
/*			0[out++] = text[r++] = 0[in++];*/
			r &= (4096 - 1);
		}
	}
	return r;
}


#if TJS_HOST_IS_BIG_ENDIAN
	#define TVP_TLG6_BYTEOF(a, x) (((tjs_uint8*)(a))[(x)])

	#define TVP_TLG6_FETCH_32BITS(addr) ((tjs_uint32)TVP_TLG6_BYTEOF((addr), 0) +  \
									((tjs_uint32)TVP_TLG6_BYTEOF((addr), 1) << 8) + \
									((tjs_uint32)TVP_TLG6_BYTEOF((addr), 2) << 16) + \
									((tjs_uint32)TVP_TLG6_BYTEOF((addr), 3) << 24) )
#else
	#define TVP_TLG6_FETCH_32BITS(addr) (*(tjs_uint32*)addr)
#endif



/*export*/
TVP_GL_FUNC_DECL(void, TVPTLG6DecodeGolombValuesForFirst_c, (tjs_int8 *pixelbuf, tjs_int pixel_count, tjs_uint8 *bit_pool))
{
	/*
		decode values packed in "bit_pool".
		values are coded using golomb code.

		"ForFirst" function do dword access to pixelbuf,
		clearing with zero except for blue (least siginificant byte).
	*/

	int n = TVP_TLG6_GOLOMB_N_COUNT - 1; /* output counter */
	int a = 0; /* summary of absolute values of errors */

	tjs_int bit_pos = 1;
	tjs_uint8 zero = (*bit_pool & 1)?0:1;

	tjs_int8 * limit = pixelbuf + pixel_count*4;

	while(pixelbuf < limit)
	{
		/* get running count */
		int count;

		{
			tjs_uint32 t = TVP_TLG6_FETCH_32BITS(bit_pool) >> bit_pos;
			tjs_int b = TVPTLG6LeadingZeroTable[t&(TVP_TLG6_LeadingZeroTable_SIZE-1)];
			int bit_count = b;
			while(!b)
			{
				bit_count += TVP_TLG6_LeadingZeroTable_BITS;
				bit_pos += TVP_TLG6_LeadingZeroTable_BITS;
				bit_pool += bit_pos >> 3;
				bit_pos &= 7;
				t = TVP_TLG6_FETCH_32BITS(bit_pool) >> bit_pos;
				b = TVPTLG6LeadingZeroTable[t&(TVP_TLG6_LeadingZeroTable_SIZE-1)];
				bit_count += b;
			}


			bit_pos += b;
			bit_pool += bit_pos >> 3;
			bit_pos &= 7;

			bit_count --;
			count = 1 << bit_count;
			count += ((TVP_TLG6_FETCH_32BITS(bit_pool) >> (bit_pos)) & (count-1));

			bit_pos += bit_count;
			bit_pool += bit_pos >> 3;
			bit_pos &= 7;

		}

		if(zero)
		{
			/* zero values */

			/* fill distination with zero */
			do { *(tjs_uint32*)pixelbuf = 0; pixelbuf+=4; } while(--count);

			zero ^= 1;
		}
		else
		{
			/* non-zero values */

			/* fill distination with glomb code */

			do
			{
				int k = TVPTLG6GolombBitLengthTable[a][n], v, sign;

				tjs_uint32 t = TVP_TLG6_FETCH_32BITS(bit_pool) >> bit_pos;
				tjs_int bit_count;
				tjs_int b;
				if(t)
				{
					b = TVPTLG6LeadingZeroTable[t&(TVP_TLG6_LeadingZeroTable_SIZE-1)];
					bit_count = b;
					while(!b)
					{
						bit_count += TVP_TLG6_LeadingZeroTable_BITS;
						bit_pos += TVP_TLG6_LeadingZeroTable_BITS;
						bit_pool += bit_pos >> 3;
						bit_pos &= 7;
						t = TVP_TLG6_FETCH_32BITS(bit_pool) >> bit_pos;
						b = TVPTLG6LeadingZeroTable[t&(TVP_TLG6_LeadingZeroTable_SIZE-1)];
						bit_count += b;
					}
					bit_count --;
				}
				else
				{
					bit_pool += 5;
					bit_count = bit_pool[-1];
					bit_pos = 0;
					t = TVP_TLG6_FETCH_32BITS(bit_pool);
					b = 0;
				}


				v = (bit_count << k) + ((t >> b) & ((1<<k)-1));
				sign = (v & 1) - 1;
				v >>= 1;
				a += v;
				*(tjs_uint32*)pixelbuf = (unsigned char) ((v ^ sign) + sign + 1);
				pixelbuf += 4;

				bit_pos += b;
				bit_pos += k;
				bit_pool += bit_pos >> 3;
				bit_pos &= 7;

				if (--n < 0) {
					a >>= 1;  n = TVP_TLG6_GOLOMB_N_COUNT - 1;
				}
			} while(--count);
			zero ^= 1;
		}
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPTLG6DecodeGolombValues_c, (tjs_int8 *pixelbuf, tjs_int pixel_count, tjs_uint8 *bit_pool))
{
	/*
		decode values packed in "bit_pool".
		values are coded using golomb code.
	*/

	int n = TVP_TLG6_GOLOMB_N_COUNT - 1; /* output counter */
	int a = 0; /* summary of absolute values of errors */

	tjs_int bit_pos = 1;
	tjs_uint8 zero = (*bit_pool & 1)?0:1;

	tjs_int8 * limit = pixelbuf + pixel_count*4;

	while(pixelbuf < limit)
	{
		/* get running count */
		int count;

		{
			tjs_uint32 t = TVP_TLG6_FETCH_32BITS(bit_pool) >> bit_pos;
			tjs_int b = TVPTLG6LeadingZeroTable[t&(TVP_TLG6_LeadingZeroTable_SIZE-1)];
			int bit_count = b;
			while(!b)
			{
				bit_count += TVP_TLG6_LeadingZeroTable_BITS;
				bit_pos += TVP_TLG6_LeadingZeroTable_BITS;
				bit_pool += bit_pos >> 3;
				bit_pos &= 7;
				t = TVP_TLG6_FETCH_32BITS(bit_pool) >> bit_pos;
				b = TVPTLG6LeadingZeroTable[t&(TVP_TLG6_LeadingZeroTable_SIZE-1)];
				bit_count += b;
			}


			bit_pos += b;
			bit_pool += bit_pos >> 3;
			bit_pos &= 7;

			bit_count --;
			count = 1 << bit_count;
			count += ((TVP_TLG6_FETCH_32BITS(bit_pool) >> (bit_pos)) & (count-1));

			bit_pos += bit_count;
			bit_pool += bit_pos >> 3;
			bit_pos &= 7;

		}

		if(zero)
		{
			/* zero values */

			/* fill distination with zero */
			do { *pixelbuf = 0; pixelbuf+=4; } while(--count);

			zero ^= 1;
		}
		else
		{
			/* non-zero values */

			/* fill distination with glomb code */

			do
			{
				int k = TVPTLG6GolombBitLengthTable[a][n], v, sign;

				tjs_uint32 t = TVP_TLG6_FETCH_32BITS(bit_pool) >> bit_pos;
				tjs_int bit_count;
				tjs_int b;
				if(t)
				{
					b = TVPTLG6LeadingZeroTable[t&(TVP_TLG6_LeadingZeroTable_SIZE-1)];
					bit_count = b;
					while(!b)
					{
						bit_count += TVP_TLG6_LeadingZeroTable_BITS;
						bit_pos += TVP_TLG6_LeadingZeroTable_BITS;
						bit_pool += bit_pos >> 3;
						bit_pos &= 7;
						t = TVP_TLG6_FETCH_32BITS(bit_pool) >> bit_pos;
						b = TVPTLG6LeadingZeroTable[t&(TVP_TLG6_LeadingZeroTable_SIZE-1)];
						bit_count += b;
					}
					bit_count --;
				}
				else
				{
					bit_pool += 5;
					bit_count = bit_pool[-1];
					bit_pos = 0;
					t = TVP_TLG6_FETCH_32BITS(bit_pool);
					b = 0;
				}


				v = (bit_count << k) + ((t >> b) & ((1<<k)-1));
				sign = (v & 1) - 1;
				v >>= 1;
				a += v;
				*pixelbuf = (char) ((v ^ sign) + sign + 1);
				pixelbuf += 4;

				bit_pos += b;
				bit_pos += k;
				bit_pool += bit_pos >> 3;
				bit_pos &= 7;

				if (--n < 0) {
					a >>= 1;  n = TVP_TLG6_GOLOMB_N_COUNT - 1;
				}
			} while(--count);
			zero ^= 1;
		}
	}
}


static TVP_INLINE_FUNC tjs_uint32 make_gt_mask(tjs_uint32 a, tjs_uint32 b){
	tjs_uint32 tmp2 = ~b;
	tjs_uint32 tmp = ((a & tmp2) + (((a ^ tmp2) >> 1) & 0x7f7f7f7f) ) & 0x80808080;
	tmp = ((tmp >> 7) + 0x7f7f7f7f) ^ 0x7f7f7f7f;
	return tmp;
}
static TVP_INLINE_FUNC tjs_uint32 packed_bytes_add(tjs_uint32 a, tjs_uint32 b)
{
	tjs_uint32 tmp = (((a & b)<<1) + ((a ^ b) & 0xfefefefe) ) & 0x01010100;
	return a+b-tmp;
}
static TVP_INLINE_FUNC tjs_uint32 med2(tjs_uint32 a, tjs_uint32 b, tjs_uint32 c){
	/* do Median Edge Detector   thx, Mr. sugi  at    kirikiri.info */
	tjs_uint32 aa_gt_bb = make_gt_mask(a, b);
	tjs_uint32 a_xor_b_and_aa_gt_bb = ((a ^ b) & aa_gt_bb);
	tjs_uint32 aa = a_xor_b_and_aa_gt_bb ^ a;
	tjs_uint32 bb = a_xor_b_and_aa_gt_bb ^ b;
	tjs_uint32 n = make_gt_mask(c, bb);
	tjs_uint32 nn = make_gt_mask(aa, c);
	tjs_uint32 m = ~(n | nn);
	return (n & aa) | (nn & bb) | ((bb & m) - (c & m) + (aa & m));
}
static TVP_INLINE_FUNC tjs_uint32 med(tjs_uint32 a, tjs_uint32 b, tjs_uint32 c, tjs_uint32 v){
	return packed_bytes_add(med2(a, b, c), v);
}

#define TLG6_AVG_PACKED(x, y) ((((x) & (y)) + ((((x) ^ (y)) & 0xfefefefe) >> 1)) +\
			(((x)^(y))&0x01010101))

static TVP_INLINE_FUNC tjs_uint32 avg(tjs_uint32 a, tjs_uint32 b, tjs_uint32 c, tjs_uint32 v){
	return packed_bytes_add(TLG6_AVG_PACKED(a, b), v);
}

#define TVP_TLG6_DO_CHROMA_DECODE_PROTO(B, G, R, A, POST_INCREMENT) do \
			{ \
				tjs_uint32 u = *prevline; \
				p = med(p, u, up, \
					(0xff0000 & ((R)<<16)) + (0xff00 & ((G)<<8)) + (0xff & (B)) + ((A) << 24) ); \
				up = u; \
				*curline = p; \
				curline ++; \
				prevline ++; \
				POST_INCREMENT \
			} while(--w);
#define TVP_TLG6_DO_CHROMA_DECODE_PROTO2(B, G, R, A, POST_INCREMENT) do \
			{ \
				tjs_uint32 u = *prevline; \
				p = avg(p, u, up, \
					(0xff0000 & ((R)<<16)) + (0xff00 & ((G)<<8)) + (0xff & (B)) + ((A) << 24) ); \
				up = u; \
				*curline = p; \
				curline ++; \
				prevline ++; \
				POST_INCREMENT \
			} while(--w);
#define TVP_TLG6_DO_CHROMA_DECODE(N, R, G, B) case (N<<1): \
	TVP_TLG6_DO_CHROMA_DECODE_PROTO(R, G, B, IA, {in+=step;}) break; \
	case (N<<1)+1: \
	TVP_TLG6_DO_CHROMA_DECODE_PROTO2(R, G, B, IA, {in+=step;}) break;

/*export*/
TVP_GL_FUNC_DECL(void, TVPTLG6DecodeLineGeneric_c, (tjs_uint32 *prevline, tjs_uint32 *curline, tjs_int width, tjs_int start_block, tjs_int block_limit, tjs_uint8 *filtertypes, tjs_int skipblockbytes, tjs_uint32 *in, tjs_uint32 initialp, tjs_int oddskip, tjs_int dir))
{
	/*
		chroma/luminosity decoding
		(this does reordering, color correlation filter, MED/AVG  at a time)
	*/
	tjs_uint32 p, up;
	int step, i;

	if(start_block)
	{
		prevline += start_block * TVP_TLG6_W_BLOCK_SIZE;
		curline  += start_block * TVP_TLG6_W_BLOCK_SIZE;
		p  = curline[-1];
		up = prevline[-1];
	}
	else
	{
		p = up = initialp;
	}

	in += skipblockbytes * start_block;
	step = (dir&1)?1:-1;

	for(i = start_block; i < block_limit; i ++)
	{
		int w = width - i*TVP_TLG6_W_BLOCK_SIZE, ww;
		if(w > TVP_TLG6_W_BLOCK_SIZE) w = TVP_TLG6_W_BLOCK_SIZE;
		ww = w;
		if(step==-1) in += ww-1;
		if(i&1) in += oddskip * ww;
		switch(filtertypes[i])
		{
#define IA	(char)((*in>>24)&0xff)
#define IR	(char)((*in>>16)&0xff)
#define IG  (char)((*in>>8 )&0xff)
#define IB  (char)((*in    )&0xff)
		TVP_TLG6_DO_CHROMA_DECODE( 0, IB, IG, IR); 
		TVP_TLG6_DO_CHROMA_DECODE( 1, IB+IG, IG, IR+IG); 
		TVP_TLG6_DO_CHROMA_DECODE( 2, IB, IG+IB, IR+IB+IG); 
		TVP_TLG6_DO_CHROMA_DECODE( 3, IB+IR+IG, IG+IR, IR); 
		TVP_TLG6_DO_CHROMA_DECODE( 4, IB+IR, IG+IB+IR, IR+IB+IR+IG); 
		TVP_TLG6_DO_CHROMA_DECODE( 5, IB+IR, IG+IB+IR, IR); 
		TVP_TLG6_DO_CHROMA_DECODE( 6, IB+IG, IG, IR); 
		TVP_TLG6_DO_CHROMA_DECODE( 7, IB, IG+IB, IR); 
		TVP_TLG6_DO_CHROMA_DECODE( 8, IB, IG, IR+IG); 
		TVP_TLG6_DO_CHROMA_DECODE( 9, IB+IG+IR+IB, IG+IR+IB, IR+IB); 
		TVP_TLG6_DO_CHROMA_DECODE(10, IB+IR, IG+IR, IR); 
		TVP_TLG6_DO_CHROMA_DECODE(11, IB, IG+IB, IR+IB); 
		TVP_TLG6_DO_CHROMA_DECODE(12, IB, IG+IR+IB, IR+IB); 
		TVP_TLG6_DO_CHROMA_DECODE(13, IB+IG, IG+IR+IB+IG, IR+IB+IG); 
		TVP_TLG6_DO_CHROMA_DECODE(14, IB+IG+IR, IG+IR, IR+IB+IG+IR); 
		TVP_TLG6_DO_CHROMA_DECODE(15, IB, IG+(IB<<1), IR+(IB<<1));

		default: return;
		}
		if(step == 1)
			in += skipblockbytes - ww;
		else
			in += skipblockbytes + 1;
		if(i&1) in -= oddskip * ww;
#undef IR
#undef IG
#undef IB
	}
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPTLG6DecodeLine_c, (tjs_uint32 *prevline, tjs_uint32 *curline, tjs_int width, tjs_int block_count, tjs_uint8 *filtertypes, tjs_int skipblockbytes, tjs_uint32 *in, tjs_uint32 initialp, tjs_int oddskip, tjs_int dir))
{
	TVPTLG6DecodeLineGeneric(prevline, curline, width, 0, block_count,
		filtertypes, skipblockbytes, in, initialp, oddskip, dir);
}



TVP_GL_FUNC_PTR_DECL(void, TVPAlphaBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAlphaBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAlphaBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPAlphaBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPAlphaBlend_d,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAlphaBlend_a,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAlphaBlend_do,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPAlphaBlend_ao,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPAlphaColorMat,  (tjs_uint32 *dest, const tjs_uint32 color, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAdditiveAlphaBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAdditiveAlphaBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAdditiveAlphaBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPAdditiveAlphaBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPAdditiveAlphaBlend_a,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAdditiveAlphaBlend_ao,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConvertAdditiveAlphaToAlpha,  (tjs_uint32 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPConvertAlphaToAdditiveAlpha,  (tjs_uint32 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAlphaBlend,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAlphaBlend_HDA,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAlphaBlend_o,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAlphaBlend_HDA_o,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAlphaBlend_d,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAlphaBlend_a,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAlphaBlend_do,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAlphaBlend_ao,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAdditiveAlphaBlend,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPInterpStretchAdditiveAlphaBlend,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int blend_y, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAdditiveAlphaBlend_HDA,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAdditiveAlphaBlend_o,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPInterpStretchAdditiveAlphaBlend_o,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int blend_y, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAdditiveAlphaBlend_HDA_o,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAdditiveAlphaBlend_a,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchAdditiveAlphaBlend_ao,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAlphaBlend,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAlphaBlend_HDA,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAlphaBlend_o,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAlphaBlend_HDA_o,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAlphaBlend_d,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAlphaBlend_a,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAlphaBlend_do,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAlphaBlend_ao,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAdditiveAlphaBlend,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPInterpLinTransAdditiveAlphaBlend,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAdditiveAlphaBlend_HDA,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAdditiveAlphaBlend_o,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPInterpLinTransAdditiveAlphaBlend_o,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAdditiveAlphaBlend_HDA_o,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAdditiveAlphaBlend_a,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransAdditiveAlphaBlend_ao,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPCopyOpaqueImage,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPConstAlphaBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConstAlphaBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConstAlphaBlend_d,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConstAlphaBlend_a,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchCopyOpaqueImage,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchConstAlphaBlend,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPInterpStretchConstAlphaBlend,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int blend_y, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchConstAlphaBlend_HDA,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchConstAlphaBlend_d,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchConstAlphaBlend_a,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransCopyOpaqueImage,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransConstAlphaBlend,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPInterpLinTransConstAlphaBlend,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransConstAlphaBlend_HDA,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransConstAlphaBlend_d,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransConstAlphaBlend_a,  (tjs_uint32 *dest, tjs_int len, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConstAlphaBlend_SD,  (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConstAlphaBlend_SD_a,  (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConstAlphaBlend_SD_d,  (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPInitUnivTransBlendTable,  (tjs_uint32 *table, tjs_int phase, tjs_int vague));
TVP_GL_FUNC_PTR_DECL(void, TVPInitUnivTransBlendTable_d,  (tjs_uint32 *table, tjs_int phase, tjs_int vague));
TVP_GL_FUNC_PTR_DECL(void, TVPInitUnivTransBlendTable_a,  (tjs_uint32 *table, tjs_int phase, tjs_int vague));
TVP_GL_FUNC_PTR_DECL(void, TVPUnivTransBlend,  (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPUnivTransBlend_switch,  (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len, tjs_int src1lv, tjs_int src2lv));
TVP_GL_FUNC_PTR_DECL(void, TVPUnivTransBlend_d,  (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPUnivTransBlend_switch_d,  (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len, tjs_int src1lv, tjs_int src2lv));
TVP_GL_FUNC_PTR_DECL(void, TVPUnivTransBlend_a,  (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPUnivTransBlend_switch_a,  (tjs_uint32 *dest, const tjs_uint32 *src1, const tjs_uint32 *src2, const tjs_uint8 *rule, const tjs_uint32 *table, tjs_int len, tjs_int src1lv, tjs_int src2lv));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap_o,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap65,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap65_o,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap_HDA,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap_HDA_o,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap65_HDA,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap65_HDA_o,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap_d,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap65_d,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap_a,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap65_a,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap_do,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap65_do,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap_ao,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPApplyColorMap65_ao,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConstColorAlphaBlend,  (tjs_uint32 *dest, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConstColorAlphaBlend_d,  (tjs_uint32 *dest, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPConstColorAlphaBlend_a,  (tjs_uint32 *dest, tjs_int len, tjs_uint32 color, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPRemoveConstOpacity,  (tjs_uint32 *dest, tjs_int len, tjs_int strength));
TVP_GL_FUNC_PTR_DECL(void, TVPRemoveOpacity,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPRemoveOpacity_o,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_int strength));
TVP_GL_FUNC_PTR_DECL(void, TVPRemoveOpacity65,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPRemoveOpacity65_o,  (tjs_uint32 *dest, const tjs_uint8 *src, tjs_int len, tjs_int strength));
TVP_GL_FUNC_PTR_DECL(void, TVPAddBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAddBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAddBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPAddBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPSubBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPSubBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPSubBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPSubBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPMulBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPMulBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPMulBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPMulBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPColorDodgeBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPColorDodgeBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPColorDodgeBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPColorDodgeBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPDarkenBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPDarkenBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPDarkenBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPDarkenBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLightenBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPLightenBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPLightenBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPLightenBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPScreenBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPScreenBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPScreenBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPScreenBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchCopy,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPInterpStretchCopy,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src1, const tjs_uint32 *src2, tjs_int blend_y, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPFastLinearInterpH2F,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src));
TVP_GL_FUNC_PTR_DECL(void, TVPFastLinearInterpH2B,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src));
TVP_GL_FUNC_PTR_DECL(void, TVPFastLinearInterpV2,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src0, const tjs_uint32 *src1));
TVP_GL_FUNC_PTR_DECL(void, TVPStretchColorCopy,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int srcstart, tjs_int srcstep));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransCopy,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPInterpLinTransCopy,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPLinTransColorCopy,  (tjs_uint32 *dest, tjs_int destlen, const tjs_uint32 *src, tjs_int sx, tjs_int sy, tjs_int stepx, tjs_int stepy, tjs_int srcpitch));
TVP_GL_FUNC_PTR_DECL(void, TVPMakeAlphaFromKey,  (tjs_uint32 *dest, tjs_int len, tjs_uint32 key));
TVP_GL_FUNC_PTR_DECL(void, TVPCopyMask,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPCopyColor,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBindMaskToMain,  (tjs_uint32 *main, const tjs_uint8 *mask, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPFillARGB,  (tjs_uint32 *dest, tjs_int len, tjs_uint32 value));
TVP_GL_FUNC_PTR_DECL(void, TVPFillARGB_NC,  (tjs_uint32 *dest, tjs_int len, tjs_uint32 value));
TVP_GL_FUNC_PTR_DECL(void, TVPFillColor,  (tjs_uint32 *dest, tjs_int len, tjs_uint32 color));
TVP_GL_FUNC_PTR_DECL(void, TVPFillMask,  (tjs_uint32 *dest, tjs_int len, tjs_uint32 mask));
TVP_GL_FUNC_PTR_DECL(void, TVPAddSubVertSum16,  (tjs_uint16 *dest, const tjs_uint32 *addline, const tjs_uint32 *subline, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAddSubVertSum16_d,  (tjs_uint16 *dest, const tjs_uint32 *addline, const tjs_uint32 *subline, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAddSubVertSum32,  (tjs_uint32 *dest, const tjs_uint32 *addline, const tjs_uint32 *subline, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPAddSubVertSum32_d,  (tjs_uint32 *dest, const tjs_uint32 *addline, const tjs_uint32 *subline, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPDoBoxBlurAvg16,  (tjs_uint32 *dest, tjs_uint16 *sum, const tjs_uint16 * add, const tjs_uint16 * sub, tjs_int n, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPDoBoxBlurAvg16_d,  (tjs_uint32 *dest, tjs_uint16 *sum, const tjs_uint16 * add, const tjs_uint16 * sub, tjs_int n, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPDoBoxBlurAvg32,  (tjs_uint32 *dest, tjs_uint32 *sum, const tjs_uint32 * add, const tjs_uint32 * sub, tjs_int n, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPDoBoxBlurAvg32_d,  (tjs_uint32 *dest, tjs_uint32 *sum, const tjs_uint32 * add, const tjs_uint32 * sub, tjs_int n, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPSwapLine8,  (tjs_uint8 *line1, tjs_uint8 *line2, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPSwapLine32,  (tjs_uint32 *line1, tjs_uint32 *line2, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPReverse8,  (tjs_uint8 *pixels, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPReverse32,  (tjs_uint32 *pixels, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPDoGrayScale,  (tjs_uint32 *dest, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPInitGammaAdjustTempData,  (tTVPGLGammaAdjustTempData *temp, const tTVPGLGammaAdjustData *data));
TVP_GL_FUNC_PTR_DECL(void, TVPUninitGammaAdjustTempData,  (tTVPGLGammaAdjustTempData *temp));
TVP_GL_FUNC_PTR_DECL(void, TVPAdjustGamma,  (tjs_uint32 *dest, tjs_int len, tTVPGLGammaAdjustTempData *temp));
TVP_GL_FUNC_PTR_DECL(void, TVPAdjustGamma_a,  (tjs_uint32 *dest, tjs_int len, tTVPGLGammaAdjustTempData *temp));
TVP_GL_FUNC_PTR_DECL(void, TVPChBlurMulCopy65,  (tjs_uint8 *dest, const tjs_uint8 *src, tjs_int len, tjs_int level));
TVP_GL_FUNC_PTR_DECL(void, TVPChBlurAddMulCopy65,  (tjs_uint8 *dest, const tjs_uint8 *src, tjs_int len, tjs_int level));
TVP_GL_FUNC_PTR_DECL(void, TVPChBlurCopy65,  (tjs_uint8 *dest, tjs_int destpitch, tjs_int destwidth, tjs_int destheight, const tjs_uint8 * src, tjs_int srcpitch, tjs_int srcwidth, tjs_int srcheight, tjs_int blurwidth, tjs_int blurlevel));
TVP_GL_FUNC_PTR_DECL(void, TVPChBlurMulCopy,  (tjs_uint8 *dest, const tjs_uint8 *src, tjs_int len, tjs_int level) );
TVP_GL_FUNC_PTR_DECL(void, TVPChBlurAddMulCopy,  (tjs_uint8 *dest, const tjs_uint8 *src, tjs_int len, tjs_int level) );
TVP_GL_FUNC_PTR_DECL(void, TVPChBlurCopy,  (tjs_uint8 *dest, tjs_int destpitch, tjs_int destwidth, tjs_int destheight, const tjs_uint8 * src, tjs_int srcpitch, tjs_int srcwidth, tjs_int srcheight, tjs_int blurwidth, tjs_int blurlevel) );
TVP_GL_FUNC_PTR_DECL(void, TVPBLExpand1BitTo8BitPal,  (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal));
TVP_GL_FUNC_PTR_DECL(void, TVPBLExpand1BitTo8Bit,  (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLExpand1BitTo32BitPal,  (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal));
TVP_GL_FUNC_PTR_DECL(void, TVPBLExpand4BitTo8BitPal,  (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal));
TVP_GL_FUNC_PTR_DECL(void, TVPBLExpand4BitTo8Bit,  (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLExpand4BitTo32BitPal,  (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal));
TVP_GL_FUNC_PTR_DECL(void, TVPBLExpand8BitTo8BitPal,  (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal));
TVP_GL_FUNC_PTR_DECL(void, TVPBLExpand8BitTo32BitPal,  (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len, const tjs_uint32 *pal));
TVP_GL_FUNC_PTR_DECL(void, TVPExpand8BitTo32BitGray,  (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLConvert15BitTo8Bit,  (tjs_uint8 *dest, const tjs_uint16 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLConvert15BitTo32Bit,  (tjs_uint32 *dest, const tjs_uint16 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLConvert24BitTo8Bit,  (tjs_uint8 *dest, const tjs_uint8 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLConvert24BitTo32Bit,  (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPConvert24BitTo32Bit,  (tjs_uint32 *dest, const tjs_uint8 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLConvert32BitTo8Bit,  (tjs_uint8 *dest, const tjs_uint32 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLConvert32BitTo32Bit_NoneAlpha,  (tjs_uint32 *dest, const tjs_uint32 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLConvert32BitTo32Bit_MulAddAlpha,  (tjs_uint32 *dest, const tjs_uint32 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPBLConvert32BitTo32Bit_AddAlpha,  (tjs_uint32 *dest, const tjs_uint32 *buf, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPDither32BitTo16Bit565,  (tjs_uint16 *dest, const tjs_uint32 *src, tjs_int len, tjs_int xofs, tjs_int yofs));
TVP_GL_FUNC_PTR_DECL(void, TVPDither32BitTo16Bit555,  (tjs_uint16 *dest, const tjs_uint32 *src, tjs_int len, tjs_int xofs, tjs_int yofs));
TVP_GL_FUNC_PTR_DECL(void, TVPDither32BitTo8Bit,  (tjs_uint8 *dest, const tjs_uint32 *src, tjs_int len, tjs_int xofs, tjs_int yofs));
TVP_GL_FUNC_PTR_DECL(void, TVPTLG5ComposeColors3To4,  (tjs_uint8 *outp, const tjs_uint8 *upper, tjs_uint8 * const * buf, tjs_int width));
TVP_GL_FUNC_PTR_DECL(void, TVPTLG5ComposeColors4To4,  (tjs_uint8 *outp, const tjs_uint8 *upper, tjs_uint8 * const* buf, tjs_int width));
TVP_GL_FUNC_PTR_DECL(tjs_int, TVPTLG5DecompressSlide,  (tjs_uint8 *out, const tjs_uint8 *in, tjs_int insize, tjs_uint8 *text, tjs_int initialr));
TVP_GL_FUNC_PTR_DECL(void, TVPTLG6DecodeGolombValuesForFirst,  (tjs_int8 *pixelbuf, tjs_int pixel_count, tjs_uint8 *bit_pool));
TVP_GL_FUNC_PTR_DECL(void, TVPTLG6DecodeGolombValues,  (tjs_int8 *pixelbuf, tjs_int pixel_count, tjs_uint8 *bit_pool));
TVP_GL_FUNC_PTR_DECL(void, TVPTLG6DecodeLineGeneric,  (tjs_uint32 *prevline, tjs_uint32 *curline, tjs_int width, tjs_int start_block, tjs_int block_limit, tjs_uint8 *filtertypes, tjs_int skipblockbytes, tjs_uint32 *in, tjs_uint32 initialp, tjs_int oddskip, tjs_int dir));
TVP_GL_FUNC_PTR_DECL(void, TVPTLG6DecodeLine,  (tjs_uint32 *prevline, tjs_uint32 *curline, tjs_int width, tjs_int block_count, tjs_uint8 *filtertypes, tjs_int skipblockbytes, tjs_uint32 *in, tjs_uint32 initialp, tjs_int oddskip, tjs_int dir));
TVP_GL_FUNC_PTR_DECL(void, TVPPsAlphaBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsAlphaBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsAlphaBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsAlphaBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsAddBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsAddBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsAddBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsAddBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsSubBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsSubBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsSubBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsSubBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsMulBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsMulBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsMulBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsMulBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsScreenBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsScreenBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsScreenBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsScreenBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsOverlayBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsOverlayBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsOverlayBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsOverlayBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsHardLightBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsHardLightBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsHardLightBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsHardLightBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsSoftLightBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsSoftLightBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsSoftLightBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsSoftLightBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorDodgeBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorDodgeBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorDodgeBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorDodgeBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorDodge5Blend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorDodge5Blend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorDodge5Blend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorDodge5Blend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorBurnBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorBurnBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorBurnBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsColorBurnBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsLightenBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsLightenBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsLightenBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsLightenBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDarkenBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDarkenBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDarkenBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDarkenBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDiffBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDiffBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDiffBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDiffBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDiff5Blend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDiff5Blend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDiff5Blend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsDiff5Blend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsExclusionBlend,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsExclusionBlend_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));
TVP_GL_FUNC_PTR_DECL(void, TVPPsExclusionBlend_HDA,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len));
TVP_GL_FUNC_PTR_DECL(void, TVPPsExclusionBlend_HDA_o,  (tjs_uint32 *dest, const tjs_uint32 *src, tjs_int len, tjs_int opa));

/* suffix "_c" : function is written in C */

/*export*/
TVP_GL_FUNC_DECL(void, TVPInitTVPGL, ())
{
	TVPStretchAlphaBlend = TVPStretchAlphaBlend_c;
	TVPStretchAlphaBlend_HDA = TVPStretchAlphaBlend_HDA_c;
	TVPStretchAlphaBlend_o = TVPStretchAlphaBlend_o_c;
	TVPStretchAlphaBlend_HDA_o = TVPStretchAlphaBlend_HDA_o_c;
	TVPStretchAlphaBlend_d = TVPStretchAlphaBlend_d_c;
	TVPStretchAlphaBlend_a = TVPStretchAlphaBlend_a_c;
	TVPStretchAlphaBlend_do = TVPStretchAlphaBlend_do_c;
	TVPStretchAlphaBlend_ao = TVPStretchAlphaBlend_ao_c;
	TVPStretchAdditiveAlphaBlend = TVPStretchAdditiveAlphaBlend_c;
	TVPInterpStretchAdditiveAlphaBlend = TVPInterpStretchAdditiveAlphaBlend_c;
	TVPStretchAdditiveAlphaBlend_HDA = TVPStretchAdditiveAlphaBlend_HDA_c;
	TVPStretchAdditiveAlphaBlend_o = TVPStretchAdditiveAlphaBlend_o_c;
	TVPInterpStretchAdditiveAlphaBlend_o = TVPInterpStretchAdditiveAlphaBlend_o_c;
	TVPStretchAdditiveAlphaBlend_HDA_o = TVPStretchAdditiveAlphaBlend_HDA_o_c;
	TVPStretchAdditiveAlphaBlend_a = TVPStretchAdditiveAlphaBlend_a_c;
	TVPStretchAdditiveAlphaBlend_ao = TVPStretchAdditiveAlphaBlend_ao_c;
	TVPLinTransAlphaBlend = TVPLinTransAlphaBlend_c;
	TVPLinTransAlphaBlend_HDA = TVPLinTransAlphaBlend_HDA_c;
	TVPLinTransAlphaBlend_o = TVPLinTransAlphaBlend_o_c;
	TVPLinTransAlphaBlend_HDA_o = TVPLinTransAlphaBlend_HDA_o_c;
	TVPLinTransAlphaBlend_d = TVPLinTransAlphaBlend_d_c;
	TVPLinTransAlphaBlend_a = TVPLinTransAlphaBlend_a_c;
	TVPLinTransAlphaBlend_do = TVPLinTransAlphaBlend_do_c;
	TVPLinTransAlphaBlend_ao = TVPLinTransAlphaBlend_ao_c;
	TVPLinTransAdditiveAlphaBlend = TVPLinTransAdditiveAlphaBlend_c;
	TVPInterpLinTransAdditiveAlphaBlend = TVPInterpLinTransAdditiveAlphaBlend_c;
	TVPLinTransAdditiveAlphaBlend_HDA = TVPLinTransAdditiveAlphaBlend_HDA_c;
	TVPLinTransAdditiveAlphaBlend_o = TVPLinTransAdditiveAlphaBlend_o_c;
	TVPInterpLinTransAdditiveAlphaBlend_o = TVPInterpLinTransAdditiveAlphaBlend_o_c;
	TVPLinTransAdditiveAlphaBlend_HDA_o = TVPLinTransAdditiveAlphaBlend_HDA_o_c;
	TVPLinTransAdditiveAlphaBlend_a = TVPLinTransAdditiveAlphaBlend_a_c;
	TVPLinTransAdditiveAlphaBlend_ao = TVPLinTransAdditiveAlphaBlend_ao_c;
	TVPStretchCopyOpaqueImage = TVPStretchCopyOpaqueImage_c;
	TVPStretchConstAlphaBlend = TVPStretchConstAlphaBlend_c;
	TVPInterpStretchConstAlphaBlend = TVPInterpStretchConstAlphaBlend_c;
	TVPStretchConstAlphaBlend_HDA = TVPStretchConstAlphaBlend_HDA_c;
	TVPStretchConstAlphaBlend_d = TVPStretchConstAlphaBlend_d_c;
	TVPStretchConstAlphaBlend_a = TVPStretchConstAlphaBlend_a_c;
	TVPLinTransCopyOpaqueImage = TVPLinTransCopyOpaqueImage_c;
	TVPLinTransConstAlphaBlend = TVPLinTransConstAlphaBlend_c;
	TVPInterpLinTransConstAlphaBlend = TVPInterpLinTransConstAlphaBlend_c;
	TVPLinTransConstAlphaBlend_HDA = TVPLinTransConstAlphaBlend_HDA_c;
	TVPLinTransConstAlphaBlend_d = TVPLinTransConstAlphaBlend_d_c;
	TVPLinTransConstAlphaBlend_a = TVPLinTransConstAlphaBlend_a_c;
	TVPInitUnivTransBlendTable = TVPInitUnivTransBlendTable_c;
	TVPInitUnivTransBlendTable_d = TVPInitUnivTransBlendTable_d_c;
	TVPInitUnivTransBlendTable_a = TVPInitUnivTransBlendTable_a_c;
	TVPUnivTransBlend = TVPUnivTransBlend_c;
	TVPUnivTransBlend_switch = TVPUnivTransBlend_switch_c;
	TVPUnivTransBlend_d = TVPUnivTransBlend_d_c;
	TVPUnivTransBlend_switch_d = TVPUnivTransBlend_switch_d_c;
	TVPUnivTransBlend_a = TVPUnivTransBlend_a_c;
	TVPUnivTransBlend_switch_a = TVPUnivTransBlend_switch_a_c;
	TVPStretchCopy = TVPStretchCopy_c;
	TVPInterpStretchCopy = TVPInterpStretchCopy_c;
	TVPFastLinearInterpH2F = TVPFastLinearInterpH2F_c;
	TVPFastLinearInterpH2B = TVPFastLinearInterpH2B_c;
	TVPFastLinearInterpV2 = TVPFastLinearInterpV2_c;
	TVPStretchColorCopy = TVPStretchColorCopy_c;
	TVPLinTransCopy = TVPLinTransCopy_c;
	TVPInterpLinTransCopy = TVPInterpLinTransCopy_c;
	TVPLinTransColorCopy = TVPLinTransColorCopy_c;
	TVPAddSubVertSum16 = TVPAddSubVertSum16_c;
	TVPAddSubVertSum16_d = TVPAddSubVertSum16_d_c;
	TVPAddSubVertSum32 = TVPAddSubVertSum32_c;
	TVPAddSubVertSum32_d = TVPAddSubVertSum32_d_c;
	TVPDoBoxBlurAvg16 = TVPDoBoxBlurAvg16_c;
	TVPDoBoxBlurAvg16_d = TVPDoBoxBlurAvg16_d_c;
	TVPDoBoxBlurAvg32 = TVPDoBoxBlurAvg32_c;
	TVPDoBoxBlurAvg32_d = TVPDoBoxBlurAvg32_d_c;
	TVPInitGammaAdjustTempData = TVPInitGammaAdjustTempData_c;
	TVPUninitGammaAdjustTempData = TVPUninitGammaAdjustTempData_c;
	TVPAdjustGamma = TVPAdjustGamma_c;
	TVPAdjustGamma_a = TVPAdjustGamma_a_c;
	TVPBLExpand1BitTo8BitPal = TVPBLExpand1BitTo8BitPal_c;
	TVPBLExpand1BitTo8Bit = TVPBLExpand1BitTo8Bit_c;
	TVPBLExpand1BitTo32BitPal = TVPBLExpand1BitTo32BitPal_c;
	TVPBLExpand4BitTo8BitPal = TVPBLExpand4BitTo8BitPal_c;
	TVPBLExpand4BitTo8Bit = TVPBLExpand4BitTo8Bit_c;
	TVPBLExpand4BitTo32BitPal = TVPBLExpand4BitTo32BitPal_c;
	TVPBLExpand8BitTo8BitPal = TVPBLExpand8BitTo8BitPal_c;
	TVPBLExpand8BitTo32BitPal = TVPBLExpand8BitTo32BitPal_c;
	TVPExpand8BitTo32BitGray = TVPExpand8BitTo32BitGray_c;
	TVPBLConvert15BitTo8Bit = TVPBLConvert15BitTo8Bit_c;
	TVPBLConvert15BitTo32Bit = TVPBLConvert15BitTo32Bit_c;
	TVPBLConvert24BitTo8Bit = TVPBLConvert24BitTo8Bit_c;
	TVPBLConvert24BitTo32Bit = TVPBLConvert24BitTo32Bit_c;
	TVPConvert24BitTo32Bit = TVPConvert24BitTo32Bit_c;
	TVPBLConvert32BitTo8Bit = TVPBLConvert32BitTo8Bit_c;
	TVPBLConvert32BitTo32Bit_NoneAlpha = TVPBLConvert32BitTo32Bit_NoneAlpha_c;
	TVPBLConvert32BitTo32Bit_MulAddAlpha = TVPBLConvert32BitTo32Bit_MulAddAlpha_c;
	TVPBLConvert32BitTo32Bit_AddAlpha = TVPBLConvert32BitTo32Bit_AddAlpha_c;
	TVPDither32BitTo16Bit565 = TVPDither32BitTo16Bit565_c;
	TVPDither32BitTo16Bit555 = TVPDither32BitTo16Bit555_c;
	TVPDither32BitTo8Bit = TVPDither32BitTo8Bit_c;
	TVPTLG5ComposeColors3To4 = TVPTLG5ComposeColors3To4_c;
	TVPTLG5ComposeColors4To4 = TVPTLG5ComposeColors4To4_c;
	TVPTLG5DecompressSlide = TVPTLG5DecompressSlide_c;
	TVPTLG6DecodeGolombValuesForFirst = TVPTLG6DecodeGolombValuesForFirst_c;
	TVPTLG6DecodeGolombValues = TVPTLG6DecodeGolombValues_c;
	TVPTLG6DecodeLineGeneric = TVPTLG6DecodeLineGeneric_c;
	TVPTLG6DecodeLine = TVPTLG6DecodeLine_c;

	TVPCreateTable();
}

/*export*/
TVP_GL_FUNC_DECL(void, TVPUninitTVPGL, ())
{
	TVPDestroyTable();
}
/*end of the file*/

