---
layout: documentation
title: Userguide
---
# Was ist Kohana?

Kohana ist ein Open-Source-basiertes, [objektorientiertes](http://de.wikipedia.org/wiki/Objektorientierte_Programmierung) [MVC](http://de.wikipedia.org/wiki/Model_View_Controller "Model View Controller")-[Webframework](http://de.wikipedia.org/wiki/Web_Application_Framework) unter Verwendung von [PHP5](http://php.net/manual/de/intro-whatis "PHP Hypertext Preprocessor"). Es wird von Freiwilligen entwickelt, das darauf abzielt schnell, sicher und schlank zu sein.

[!!] Kohana ist unter der [BSD-Lizenz](http://kohanaframework.org/license) veröffentlicht, so dass man es rechtlich für alle Arten von Open-Source-, kommerzieller oder privater Projekte nutzen kann.

## Was macht Kohana besonders?

Durch den einzigartigen [Dateisystem](/documentation/userguide/about.filesystem)-Aufbau ist alles erweiterbar und man braucht wenige oder keine [Einstellungen](/documentation/userguide/about.configuration) vornehmen. Die [Fehlerbehandlung](/documentation/userguide/debugging.errors) hilft, die Fehlerquelle schnell zu finden, und die [Fehlersuche](/documentation/userguide/debugging) und [Programmanalyse](/documentation/userguide/debugging.profiling) ermöglichen einen Einblick in die Anwendung.

Um die Sicherheit deiner Anwendung zu unterstützen, enthält Kohana Werkzeuge für [XSS-Entfernung](/documentation/userguide/security.xss), [Eingabe-berprüfung](/documentation/userguide/security.validation), [signierte Cookies](/documentation/userguide/security.cookies), [Formular](/documentation/userguide/security.forms)- und [HTML](/documentation/userguide/security.html)-Erstellung. Die [Datenbank](/documentation/userguide/security.database)-Schicht bietet Schutz vor [SQL-Injection](http://de.wikipedia.org/wiki/SQL-Injection). Natürlich wurde der gesamte offizielle Quelltext sorgfältig geschrieben und auf Sicherheit geprüft.

## Diese Dokumentation ist scheiße!

Wir bemühen uns um eine vollständige Dokumentation. Wenn eine Frage trotzdem offen bleibt, versuche es beim [inoffiziellen Wiki](http://kerkness.ca/wiki/doku.php). Wenn du etwas zum Handbuch beitragen oder ändern willst, erstelle bitte [eine Kopie](http://github.com/kohana/userguide), bearbeite sie und stelle eine Anfrage zur Zusammenführung. Falls du nicht mit git vertraut bist, kannst du auch ein [Feature-Vorschlag](http://dev.kohanaframework.org/projects/kohana3/issues) (Anmeldung erforderlich) machen.