# SmatcheD

This project is a web application that allows you to transfer make-up from one photo to another using the Stable
Diffusion. It is built using Streamlit, a Python library for creating web applications with minimal effort.


<div align="center"><img src="https://s11.gifyu.com/images/S4SS6.gif" width="500" /></div>

## Getting Started

To run this application on your local machine, follow these steps:

1. **Clone the Repository**: Start by cloning this repository to your local machine using Git.

```bash
 git clone https://github.com/konstantgr/smatched.git
```

2. **Install Dependencies**: Navigate to the project directory and use Poetry to install the project dependencies.

```bash
cd smatched
poetry shell
poetry install
```

3. **Run the Streamlit App**: Once the dependencies are installed, you can run the Streamlit web application.

```bash
poetry run streamlit run web/app.py
```

## Access the Web App:

Open your web browser and go to the URL provided by Streamlit, typically http://localhost:8501.
You can now use the web application to transfer makeup from one photo to another.

## Usage

1. Upload the source image containing the makeup you want to transfer.
2. Upload the target image where you want to apply the makeup.
3. Adjust any relevant parameters or settings (if available).
4. Click the "Generate makeup" button.
5. The result, with makeup transferred to the target image, will be displayed on the screen.
6. You can download the resulting image for your use.
