/*******************************************************************************
 * KOMORAN 3.0 - Korean Morphology Analyzer
 *
 * Copyright 2015 Shineware http://www.shineware.co.kr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 	
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package kr.co.shineware.nlp.komoran.constant;

/**
 * komoran에서 사용되는 SYMBOL에 대한 정의<br>
 * @author Junsoo Shin
 * @version 2.1
 * @since 2.1
 *
 */
public class SYMBOL {
	
	public static final String START = "<start>";
	public static final String END = "<end>";
	public static final String SPACE = "<sp>";
	public static final String NA = "NA";
	
	public static final String NUMBER = "<number>";
	public static final String SW = "SW";
	public static final String SF = "SF";
	public static final String EC = "EC";
	public static final String EF = "EF";
	public static final String JKO = "JKO";
	public static final String JX = "JX";
	public static final String ETM = "ETM";
	public static final String JKS = "JKS";
	public static final String JKC = "JKC";
	public static final String IRREGULAR = "IRR";
	public static final int IRREGULAR_ID = -1;
	public static final String SS = "SS";
	public static final String NNG = "NNG";
	public static final String NNP = "NNP";
	public static final String NNB = "NNB";
	
}
