/*
 * Decompiled with CFR 0.152.
 */
package org.openkoreantext.processor.phrase_extractor;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.openkoreantext.processor.phrase_extractor.KoreanPhraseExtractor;
import org.openkoreantext.processor.phrase_extractor.KoreanPhraseExtractor$KoreanPhrase$;
import org.openkoreantext.processor.tokenizer.KoreanTokenizer;
import org.openkoreantext.processor.util.Hangul$;
import org.openkoreantext.processor.util.KoreanDictionaryProvider$;
import org.openkoreantext.processor.util.KoreanPos;
import org.openkoreantext.processor.util.KoreanPos$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class KoreanPhraseExtractor$ {
    public static KoreanPhraseExtractor$ MODULE$;
    private final int MinCharsPerPhraseChunkWithoutSpaces;
    private final int MinPhrasesPerPhraseChunk;
    private final int MaxCharsPerPhraseChunkWithoutSpaces;
    private final int MaxPhrasesPerPhraseChunk;
    private final Set<Object> ModifyingPredicateEndings;
    private final Set<Object> ModifyingPredicateExceptions;
    private final Set<Enumeration.Value> PhraseTokens;
    private final Set<String> ConjunctionJosa;
    private final Set<Enumeration.Value> PhraseHeadPoses;
    private final Set<Enumeration.Value> PhrasTailPoses;
    private final Map<String, Enumeration.Value> COLLAPSING_RULES;
    private final List<KoreanPos.KoreanPosTrie> CollapseTrie;

    static {
        new KoreanPhraseExtractor$();
    }

    private int MinCharsPerPhraseChunkWithoutSpaces() {
        return this.MinCharsPerPhraseChunkWithoutSpaces;
    }

    private int MinPhrasesPerPhraseChunk() {
        return this.MinPhrasesPerPhraseChunk;
    }

    private int MaxCharsPerPhraseChunkWithoutSpaces() {
        return this.MaxCharsPerPhraseChunkWithoutSpaces;
    }

    private int MaxPhrasesPerPhraseChunk() {
        return this.MaxPhrasesPerPhraseChunk;
    }

    private Set<Object> ModifyingPredicateEndings() {
        return this.ModifyingPredicateEndings;
    }

    private Set<Object> ModifyingPredicateExceptions() {
        return this.ModifyingPredicateExceptions;
    }

    private Set<Enumeration.Value> PhraseTokens() {
        return this.PhraseTokens;
    }

    private Set<String> ConjunctionJosa() {
        return this.ConjunctionJosa;
    }

    private Set<Enumeration.Value> PhraseHeadPoses() {
        return this.PhraseHeadPoses;
    }

    private Set<Enumeration.Value> PhrasTailPoses() {
        return this.PhrasTailPoses;
    }

    private Map<String, Enumeration.Value> COLLAPSING_RULES() {
        return this.COLLAPSING_RULES;
    }

    private List<KoreanPos.KoreanPosTrie> CollapseTrie() {
        return this.CollapseTrie;
    }

    private Seq<KoreanPhraseExtractor.KoreanPhrase> trimPhraseChunk(Seq<KoreanPhraseExtractor.KoreanPhrase> phrases) {
        return KoreanPhraseExtractor$.trimSpacesFromPhrase$1(this.trimNonNouns$1(phrases));
    }

    private KoreanPhraseExtractor.KoreanPhrase trimPhrase(KoreanPhraseExtractor.KoreanPhrase phrase) {
        return new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)((SeqLike)((TraversableLike)((SeqLike)phrase.tokens().dropWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$trimPhrase$1(x$5)))).reverse()).dropWhile((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$trimPhrase$2(x$6)))).reverse()), phrase.pos());
    }

    private boolean isProperPhraseChunk(Seq<KoreanPhraseExtractor.KoreanPhrase> phraseChunk) {
        return this.isRightLength$1(phraseChunk) && KoreanPhraseExtractor$.notEndingInNonPhraseSuffix$1(phraseChunk);
    }

    public Seq<KoreanPhraseExtractor.KoreanPhrase> collapsePos(Seq<KoreanTokenizer.KoreanToken> tokens) {
        return ((KoreanPhraseExtractor.PhraseBuffer)tokens.foldLeft((Object)new KoreanPhraseExtractor.PhraseBuffer((List<KoreanPhraseExtractor.KoreanPhrase>)Nil$.MODULE$, this.CollapseTrie(), (Option<Enumeration.Value>)None$.MODULE$), (arg_0, arg_1) -> KoreanPhraseExtractor$.$anonfun$collapsePos$3(this, arg_0, arg_1))).phrases();
    }

    private Seq<Seq<KoreanPhraseExtractor.KoreanPhrase>> distinctPhrases(Seq<Seq<KoreanPhraseExtractor.KoreanPhrase>> chunks) {
        Tuple2 tuple2 = (Tuple2)chunks.foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), (Function2 & Serializable & scala.Serializable)(x0$4, x1$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$4, x1$2);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            Seq chunk = (Seq)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            List l = (List)tuple23._1();
            Set buffer = (Set)tuple23._2();
            if (l == null) throw new MatchError((Object)tuple22);
            List list = l;
            if (buffer == null) throw new MatchError((Object)tuple22);
            Set set = buffer;
            if (chunk == null) throw new MatchError((Object)tuple22);
            Seq seq = chunk;
            String phraseText = ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$18 -> ((TraversableOnce)x$18.tokens().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.text(), Seq$.MODULE$.canBuildFrom())).mkString(""), Seq$.MODULE$.canBuildFrom())).mkString("");
            if (set.contains((Object)phraseText)) {
                tuple2 = new Tuple2((Object)list, (Object)set);
                return tuple2;
            } else {
                Seq seq2 = seq;
                Tuple2 tuple24 = new Tuple2((Object)list.$colon$colon((Object)seq2), (Object)set.$plus((Object)phraseText));
                tuple2 = tuple24;
            }
            return tuple2;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List l = (List)tuple2._1();
        Set buffer = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)l, (Object)buffer);
        Tuple2 tuple23 = tuple22;
        List l2 = (List)tuple23._1();
        Set buffer2 = (Set)tuple23._2();
        return l2.reverse();
    }

    public Seq<Seq<KoreanPhraseExtractor.KoreanPhrase>> getCandidatePhraseChunks(Seq<KoreanPhraseExtractor.KoreanPhrase> phrases2, boolean filterSpam) {
        Seq nounPhrases = KoreanPhraseExtractor$.collapseNounPhrases$1(phrases2);
        Seq phraseCollapsed = this.collapsePhrases$1(nounPhrases, filterSpam);
        return this.distinctPhrases((Seq<Seq<KoreanPhraseExtractor.KoreanPhrase>>)((Seq)((TraversableLike)phraseCollapsed.map((Function1 & Serializable & scala.Serializable)phrases -> this.trimPhraseChunk((Seq<KoreanPhraseExtractor.KoreanPhrase>)phrases), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.getSingleTokenNouns$1(phrases2, filterSpam), Seq$.MODULE$.canBuildFrom())));
    }

    public boolean getCandidatePhraseChunks$default$2() {
        return false;
    }

    public Seq<KoreanPhraseExtractor.KoreanPhrase> extractPhrases(Seq<KoreanTokenizer.KoreanToken> tokens, boolean filterSpam, boolean addHashtags) {
        Seq hashtags = (Seq)tokens.flatMap((Function1 & Serializable & scala.Serializable)x0$7 -> {
            KoreanTokenizer.KoreanToken koreanToken = x0$7;
            if (koreanToken != null) {
                KoreanTokenizer.KoreanToken koreanToken2 = koreanToken;
                Enumeration.Value value = koreanToken2.pos();
                Enumeration.Value value2 = KoreanPos$.MODULE$.Hashtag();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KoreanTokenizer.KoreanToken[]{koreanToken2}))), KoreanPos$.MODULE$.Hashtag())));
                }
            }
            if (koreanToken == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            KoreanTokenizer.KoreanToken koreanToken3 = koreanToken;
            Enumeration.Value value = koreanToken3.pos();
            Enumeration.Value value3 = KoreanPos$.MODULE$.CashTag();
            if (value == null) {
                if (value3 == null) return Option$.MODULE$.option2Iterable((Option)new Some((Object)new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KoreanTokenizer.KoreanToken[]{koreanToken3}))), KoreanPos$.MODULE$.CashTag())));
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                if (!value.equals(value3)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KoreanTokenizer.KoreanToken[]{koreanToken3}))), KoreanPos$.MODULE$.CashTag())));
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<KoreanPhraseExtractor.KoreanPhrase> collapsed = this.collapsePos(tokens);
        Seq<Seq<KoreanPhraseExtractor.KoreanPhrase>> candidates = this.getCandidatePhraseChunks(collapsed, filterSpam);
        Seq<Seq<KoreanPhraseExtractor.KoreanPhrase>> permutatedCandidates = this.permutateCadidates(candidates);
        Seq phrases = (Seq)permutatedCandidates.map((Function1 & Serializable & scala.Serializable)phraseChunk -> new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)this.trimPhraseChunk((Seq<KoreanPhraseExtractor.KoreanPhrase>)phraseChunk).flatMap((Function1 & Serializable & scala.Serializable)x$26 -> x$26.tokens(), Seq$.MODULE$.canBuildFrom())), KoreanPhraseExtractor$KoreanPhrase$.MODULE$.apply$default$2()), Seq$.MODULE$.canBuildFrom());
        return addHashtags ? (Seq)phrases.$plus$plus((GenTraversableOnce)hashtags, Seq$.MODULE$.canBuildFrom()) : phrases;
    }

    public boolean extractPhrases$default$2() {
        return false;
    }

    public boolean extractPhrases$default$3() {
        return true;
    }

    private Seq<Seq<KoreanPhraseExtractor.KoreanPhrase>> permutateCadidates(Seq<Seq<KoreanPhraseExtractor.KoreanPhrase>> candidates) {
        return this.distinctPhrases((Seq<Seq<KoreanPhraseExtractor.KoreanPhrase>>)((Seq)candidates.filter((Function1 & Serializable & scala.Serializable)phraseChunk -> BoxesRunTime.boxToBoolean((boolean)this.isProperPhraseChunk((Seq<KoreanPhraseExtractor.KoreanPhrase>)phraseChunk)))));
    }

    public static final /* synthetic */ boolean $anonfun$trimPhraseChunk$1(KoreanPhraseExtractor$ $this, KoreanPhraseExtractor.KoreanPhrase t) {
        return !$this.PhraseHeadPoses().contains((Object)t.pos());
    }

    public static final /* synthetic */ boolean $anonfun$trimPhraseChunk$2(KoreanPhraseExtractor$ $this, KoreanPhraseExtractor.KoreanPhrase t) {
        return !$this.PhrasTailPoses().contains((Object)t.pos());
    }

    private final Seq trimNonNouns$1(Seq phrases$1) {
        return (Seq)((SeqLike)((TraversableLike)((SeqLike)phrases$1.dropWhile((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$trimPhraseChunk$1(this, t)))).reverse()).dropWhile((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$trimPhraseChunk$2(this, t)))).reverse();
    }

    public static final /* synthetic */ boolean $anonfun$trimPhraseChunk$4(KoreanTokenizer.KoreanToken x$1) {
        Enumeration.Value value = x$1.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Space();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$trimPhraseChunk$5(KoreanTokenizer.KoreanToken x$2) {
        Enumeration.Value value = x$2.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Space();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$trimPhraseChunk$6(KoreanTokenizer.KoreanToken x$3) {
        Enumeration.Value value = x$3.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Space();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$trimPhraseChunk$7(KoreanTokenizer.KoreanToken x$4) {
        Enumeration.Value value = x$4.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Space();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private static final Seq trimSpacesFromPhrase$1(Seq phrases) {
        return (Seq)((TraversableLike)phrases.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                KoreanPhraseExtractor.KoreanPhrase phrase = (KoreanPhraseExtractor.KoreanPhrase)tuple2._1();
                if (phrases.length() == 1) {
                    return new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)((SeqLike)((TraversableLike)((SeqLike)phrase.tokens().dropWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$trimPhraseChunk$4(x$1)))).reverse()).dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$trimPhraseChunk$5(x$2)))).reverse()), phrase.pos());
                }
            }
            if (tuple2 != null) {
                KoreanPhraseExtractor.KoreanPhrase phrase = (KoreanPhraseExtractor.KoreanPhrase)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (i == 0) {
                    return new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)phrase.tokens().dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$trimPhraseChunk$6(x$3)))), phrase.pos());
                }
            }
            if (tuple2 != null) {
                KoreanPhraseExtractor.KoreanPhrase phrase = (KoreanPhraseExtractor.KoreanPhrase)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (i == phrases.length() - 1) {
                    return new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)((SeqLike)((TraversableLike)phrase.tokens().reverse()).dropWhile((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$trimPhraseChunk$7(x$4)))).reverse()), phrase.pos());
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            KoreanPhraseExtractor.KoreanPhrase phrase = (KoreanPhraseExtractor.KoreanPhrase)tuple2._1();
            return phrase;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$trimPhrase$1(KoreanTokenizer.KoreanToken x$5) {
        Enumeration.Value value = x$5.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Space();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$trimPhrase$2(KoreanTokenizer.KoreanToken x$6) {
        Enumeration.Value value = x$6.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Space();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean notEndingInNonPhraseSuffix$1(Seq phraseChunk$1) {
        KoreanTokenizer.KoreanToken lastToken = (KoreanTokenizer.KoreanToken)((KoreanPhraseExtractor.KoreanPhrase)phraseChunk$1.last()).tokens().last();
        Enumeration.Value value = lastToken.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Suffix();
        if (value == null) {
            if (value2 != null) {
                return true;
            }
        } else if (!value.equals(value2)) return true;
        String string = lastToken.text();
        String string2 = "\uc801";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$isProperPhraseChunk$1(KoreanPhraseExtractor.KoreanPhrase x$7) {
        Enumeration.Value value = x$7.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Space();
        return value == null ? value2 != null : !value.equals(value2);
    }

    private final boolean checkMaxLength$1(Seq phraseChunkWithoutSpaces$1) {
        return phraseChunkWithoutSpaces$1.length() <= this.MaxPhrasesPerPhraseChunk() && BoxesRunTime.unboxToInt((Object)((TraversableOnce)phraseChunkWithoutSpaces$1.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.length()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) <= this.MaxCharsPerPhraseChunkWithoutSpaces();
    }

    private final boolean checkMinLength$1(Seq phraseChunkWithoutSpaces$1) {
        return phraseChunkWithoutSpaces$1.length() >= this.MinPhrasesPerPhraseChunk() || phraseChunkWithoutSpaces$1.length() < this.MinPhrasesPerPhraseChunk() && BoxesRunTime.unboxToInt((Object)((TraversableOnce)phraseChunkWithoutSpaces$1.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.length()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) >= this.MinCharsPerPhraseChunkWithoutSpaces();
    }

    public static final /* synthetic */ boolean $anonfun$isProperPhraseChunk$4(KoreanPhraseExtractor.KoreanPhrase x$10) {
        return x$10.length() > 1;
    }

    private static final boolean checkMinLengthPerToken$1(Seq phraseChunkWithoutSpaces$1) {
        return phraseChunkWithoutSpaces$1.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$isProperPhraseChunk$4(x$10)));
    }

    private final boolean isRightLength$1(Seq phraseChunk$1) {
        Seq phraseChunkWithoutSpaces = (Seq)phraseChunk$1.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$isProperPhraseChunk$1(x$7)));
        return this.checkMaxLength$1(phraseChunkWithoutSpaces) && this.checkMinLength$1(phraseChunkWithoutSpaces) && KoreanPhraseExtractor$.checkMinLengthPerToken$1(phraseChunkWithoutSpaces);
    }

    public static final /* synthetic */ boolean $anonfun$collapsePos$1(KoreanTokenizer.KoreanToken token$1, KoreanPos.KoreanPosTrie x$13) {
        Enumeration.Value value = x$13.curPos();
        Enumeration.Value value2 = token$1.pos();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private static final Tuple2 getTries$1(KoreanTokenizer.KoreanToken token, List trie) {
        KoreanPos.KoreanPosTrie curTrie = (KoreanPos.KoreanPosTrie)((IterableLike)trie.filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$collapsePos$1(token, x$13)))).head();
        List nextTrie = (List)curTrie.nextTrie().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            KoreanPos.KoreanPosTrie koreanPosTrie = x0$2;
            if (koreanPosTrie != null) {
                KoreanPos.KoreanPosTrie koreanPosTrie2;
                KoreanPos.KoreanPosTrie koreanPosTrie3 = koreanPosTrie2 = koreanPosTrie;
                KoreanPos.KoreanPosTrie koreanPosTrie4 = KoreanPos$.MODULE$.selfNode();
                if (koreanPosTrie3 == null) {
                    if (koreanPosTrie4 == null) return curTrie;
                } else if (((Object)koreanPosTrie3).equals(koreanPosTrie4)) {
                    return curTrie;
                }
            }
            if (koreanPosTrie == null) throw new MatchError((Object)koreanPosTrie);
            KoreanPos.KoreanPosTrie koreanPosTrie5 = koreanPosTrie;
            return koreanPosTrie5;
        }, List$.MODULE$.canBuildFrom());
        return new Tuple2((Object)curTrie, (Object)nextTrie);
    }

    private static final List getInit$1(KoreanPhraseExtractor.PhraseBuffer phraseBuffer) {
        return phraseBuffer.phrases().isEmpty() ? Nil$.MODULE$ : (List)phraseBuffer.phrases().init();
    }

    public static final /* synthetic */ boolean $anonfun$collapsePos$4(KoreanTokenizer.KoreanToken token$2, KoreanPos.KoreanPosTrie x$14) {
        Enumeration.Value value = x$14.curPos();
        Enumeration.Value value2 = token$2.pos();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$collapsePos$5() {
        return KoreanPos$.MODULE$.Noun();
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$collapsePos$6() {
        return KoreanPos$.MODULE$.Noun();
    }

    public static final /* synthetic */ boolean $anonfun$collapsePos$7(KoreanTokenizer.KoreanToken token$3, KoreanPos.KoreanPosTrie x$16) {
        Enumeration.Value value = x$16.curPos();
        Enumeration.Value value2 = token$3.pos();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$collapsePos$8() {
        return KoreanPos$.MODULE$.Noun();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ KoreanPhraseExtractor.PhraseBuffer $anonfun$collapsePos$3(KoreanPhraseExtractor$ $this, KoreanPhraseExtractor.PhraseBuffer x0$3, KoreanTokenizer.KoreanToken x1$1) {
        block9: {
            block8: {
                var6_3 = new Tuple2((Object)x0$3, (Object)x1$1);
                if (var6_3 == null) break block8;
                output = (KoreanPhraseExtractor.PhraseBuffer)var6_3._1();
                token = (KoreanTokenizer.KoreanToken)var6_3._2();
                if (!output.curTrie().exists((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$collapsePos$4$adapted(org.openkoreantext.processor.tokenizer.KoreanTokenizer$KoreanToken org.openkoreantext.processor.util.KoreanPos$KoreanPosTrie ), (Lorg/openkoreantext/processor/util/KoreanPos$KoreanPosTrie;)Ljava/lang/Object;)((KoreanTokenizer.KoreanToken)token))) break block8;
                var10_6 = KoreanPhraseExtractor$.getTries$1(token, output.curTrie());
                if (var10_6 == null) {
                    throw new MatchError((Object)var10_6);
                }
                ct = (KoreanPos.KoreanPosTrie)var10_6._1();
                nt = (List)var10_6._2();
                var5_9 = new Tuple2((Object)ct, (Object)nt);
                var9_10 = var5_9;
                ct = (KoreanPos.KoreanPosTrie)var9_10._1();
                nt = (List)var9_10._2();
                if (output.phrases().isEmpty()) ** GOTO lbl-1000
                v0 = output.curTrie();
                var15_13 = $this.CollapseTrie();
                if (!(v0 != null ? v0.equals(var15_13) == false : var15_13 != null)) lbl-1000:
                // 2 sources

                {
                    v1 = new KoreanPhraseExtractor.PhraseBuffer((List<KoreanPhraseExtractor.KoreanPhrase>)((List)output.phrases().$colon$plus((Object)new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KoreanTokenizer.KoreanToken[]{token})), (Enumeration.Value)ct.ending().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$collapsePos$5(), ()Lscala/Enumeration$Value;)())), List$.MODULE$.canBuildFrom())), (List<KoreanPos.KoreanPosTrie>)nt, ct.ending());
                } else {
                    v1 = new KoreanPhraseExtractor.PhraseBuffer((List<KoreanPhraseExtractor.KoreanPhrase>)((List)KoreanPhraseExtractor$.getInit$1(output).$colon$plus((Object)new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)((KoreanPhraseExtractor.KoreanPhrase)output.phrases().last()).tokens().$colon$plus((Object)token, Seq$.MODULE$.canBuildFrom())), (Enumeration.Value)ct.ending().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$collapsePos$6(), ()Lscala/Enumeration$Value;)())), List$.MODULE$.canBuildFrom())), (List<KoreanPos.KoreanPosTrie>)nt, ct.ending());
                }
                var3_14 = v1;
                break block9;
            }
            if (var6_3 == null) ** GOTO lbl-1000
            output = (KoreanPhraseExtractor.PhraseBuffer)var6_3._1();
            token = (KoreanTokenizer.KoreanToken)var6_3._2();
            if ($this.CollapseTrie().exists((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$collapsePos$7$adapted(org.openkoreantext.processor.tokenizer.KoreanTokenizer$KoreanToken org.openkoreantext.processor.util.KoreanPos$KoreanPosTrie ), (Lorg/openkoreantext/processor/util/KoreanPos$KoreanPosTrie;)Ljava/lang/Object;)((KoreanTokenizer.KoreanToken)token))) {
                var19_17 = KoreanPhraseExtractor$.getTries$1(token, $this.CollapseTrie());
                if (var19_17 == null) {
                    throw new MatchError((Object)var19_17);
                }
                ct = (KoreanPos.KoreanPosTrie)var19_17._1();
                nt = (List)var19_17._2();
                var4_20 = new Tuple2((Object)ct, (Object)nt);
                var18_21 = var4_20;
                ct = (KoreanPos.KoreanPosTrie)var18_21._1();
                nt = (List)var18_21._2();
                var3_14 = new KoreanPhraseExtractor.PhraseBuffer((List<KoreanPhraseExtractor.KoreanPhrase>)((List)output.phrases().$colon$plus((Object)new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KoreanTokenizer.KoreanToken[]{token})), (Enumeration.Value)ct.ending().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$collapsePos$8(), ()Lscala/Enumeration$Value;)())), List$.MODULE$.canBuildFrom())), (List<KoreanPos.KoreanPosTrie>)nt, ct.ending());
            } else if (var6_3 != null) {
                output = (KoreanPhraseExtractor.PhraseBuffer)var6_3._1();
                token = (KoreanTokenizer.KoreanToken)var6_3._2();
                var3_14 = new KoreanPhraseExtractor.PhraseBuffer((List<KoreanPhraseExtractor.KoreanPhrase>)((List)output.phrases().$colon$plus((Object)new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KoreanTokenizer.KoreanToken[]{token})), token.pos()), List$.MODULE$.canBuildFrom())), $this.CollapseTrie(), output.ending());
            } else {
                throw new MatchError((Object)var6_3);
            }
        }
        return var3_14;
    }

    public static final /* synthetic */ boolean $anonfun$getCandidatePhraseChunks$1(KoreanTokenizer.KoreanToken t) {
        return KoreanDictionaryProvider$.MODULE$.spamNouns().contains(t.text());
    }

    private static final boolean isNotSpam$1(KoreanPhraseExtractor.KoreanPhrase phrase, boolean filterSpam$1) {
        return !filterSpam$1 || !phrase.tokens().exists((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$getCandidatePhraseChunks$1(t)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isModifyingPredicate$1(KoreanPhraseExtractor.KoreanPhrase trimmed$1) {
        char lastChar = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(((KoreanTokenizer.KoreanToken)trimmed$1.tokens().last()).text())).last());
        Enumeration.Value value = trimmed$1.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Verb();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = trimmed$1.pos();
            Enumeration.Value value4 = KoreanPos$.MODULE$.Adjective();
            if (value3 == null) {
                if (value4 != null) {
                    return false;
                }
            } else if (!value3.equals(value4)) return false;
        }
        if (!this.ModifyingPredicateEndings().contains((Object)BoxesRunTime.boxToCharacter((char)Hangul$.MODULE$.decomposeHangul(lastChar).coda()))) return false;
        if (this.ModifyingPredicateExceptions().contains((Object)BoxesRunTime.boxToCharacter((char)lastChar))) return false;
        return true;
    }

    private final boolean isConjuction$1(KoreanPhraseExtractor.KoreanPhrase trimmed$1) {
        Enumeration.Value value = trimmed$1.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Josa();
        return !(value != null ? !value.equals(value2) : value2 != null) && this.ConjunctionJosa().contains((Object)((KoreanTokenizer.KoreanToken)trimmed$1.tokens().last()).text());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAlphaNumeric$1(KoreanPhraseExtractor.KoreanPhrase trimmed$1) {
        Enumeration.Value value = trimmed$1.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Alpha();
        if (value == null) {
            if (value2 == null) return true;
        } else if (value.equals(value2)) return true;
        Enumeration.Value value3 = trimmed$1.pos();
        Enumeration.Value value4 = KoreanPos$.MODULE$.Number();
        if (value3 != null) {
            if (!value3.equals(value4)) return false;
            return true;
        }
        if (value4 == null) return true;
        return false;
    }

    private final boolean isNonNounPhraseCandidate$1(KoreanPhraseExtractor.KoreanPhrase phrase) {
        KoreanPhraseExtractor.KoreanPhrase trimmed = this.trimPhrase(phrase);
        return KoreanPhraseExtractor$.isAlphaNumeric$1(trimmed) || this.isModifyingPredicate$1(trimmed) || this.isConjuction$1(trimmed);
    }

    private static final Seq collapseNounPhrases$1(Seq phrases) {
        Tuple2 tuple2 = (Tuple2)phrases.foldLeft((Object)new Tuple2((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2 & Serializable & scala.Serializable)(x0$5, x1$3) -> {
            Tuple2 tuple2 = new Tuple2(x0$5, x1$3);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                KoreanPhraseExtractor.KoreanPhrase phrase = (KoreanPhraseExtractor.KoreanPhrase)tuple2._2();
                if (tuple22 != null) {
                    Seq output = (Seq)tuple22._1();
                    Seq buffer = (Seq)tuple22._2();
                    Enumeration.Value value = phrase.pos();
                    Enumeration.Value value2 = KoreanPos$.MODULE$.Noun();
                    if (value == null) {
                        if (value2 == null) return new Tuple2((Object)output, buffer.$colon$plus((Object)phrase, Seq$.MODULE$.canBuildFrom()));
                    } else if (value.equals(value2)) return new Tuple2((Object)output, buffer.$colon$plus((Object)phrase, Seq$.MODULE$.canBuildFrom()));
                    Enumeration.Value value3 = phrase.pos();
                    Enumeration.Value value4 = KoreanPos$.MODULE$.ProperNoun();
                    if (value3 == null) {
                        if (value4 == null) return new Tuple2((Object)output, buffer.$colon$plus((Object)phrase, Seq$.MODULE$.canBuildFrom()));
                    } else if (value3.equals(value4)) {
                        return new Tuple2((Object)output, buffer.$colon$plus((Object)phrase, Seq$.MODULE$.canBuildFrom()));
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple23 = (Tuple2)tuple2._1();
            KoreanPhraseExtractor.KoreanPhrase phrase = (KoreanPhraseExtractor.KoreanPhrase)tuple2._2();
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            Seq output = (Seq)tuple23._1();
            Seq buffer = (Seq)tuple23._2();
            Seq tempPhrases = buffer.length() > 0 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KoreanPhraseExtractor.KoreanPhrase[]{new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)buffer.flatMap((Function1 & Serializable & scala.Serializable)x$22 -> x$22.tokens(), Seq$.MODULE$.canBuildFrom())), KoreanPhraseExtractor$KoreanPhrase$.MODULE$.apply$default$2()), phrase})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KoreanPhraseExtractor.KoreanPhrase[]{phrase}));
            return new Tuple2(output.$plus$plus((GenTraversableOnce)tempPhrases, Seq$.MODULE$.canBuildFrom()), (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq output = (Seq)tuple2._1();
        Seq buffer = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)output, (Object)buffer);
        Tuple2 tuple23 = tuple22;
        Seq output2 = (Seq)tuple23._1();
        Seq buffer2 = (Seq)tuple23._2();
        return buffer2.length() > 0 ? (Seq)output2.$colon$plus((Object)new KoreanPhraseExtractor.KoreanPhrase((Seq<KoreanTokenizer.KoreanToken>)((Seq)buffer2.flatMap((Function1 & Serializable & scala.Serializable)x$24 -> x$24.tokens(), Seq$.MODULE$.canBuildFrom())), KoreanPhraseExtractor$KoreanPhrase$.MODULE$.apply$default$2()), Seq$.MODULE$.canBuildFrom()) : output2;
    }

    private static final Seq addPhraseToBuffer$1(KoreanPhraseExtractor.KoreanPhrase phrase, Seq buffer) {
        return (Seq)buffer.map((Function1 & Serializable & scala.Serializable)b -> (Seq)b.$colon$plus((Object)phrase, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq newBuffer$1() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)}));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$getCandidatePhraseChunks$6(KoreanPhraseExtractor$ $this, boolean filterSpam$1, Tuple2 x0$6, KoreanPhraseExtractor.KoreanPhrase x1$4) {
        block7: {
            block6: {
                var5_4 = new Tuple2((Object)x0$6, (Object)x1$4);
                if (var5_4 == null) break block6;
                var6_5 = (Tuple2)var5_4._1();
                phrase = (KoreanPhraseExtractor.KoreanPhrase)var5_4._2();
                if (var6_5 == null) break block6;
                output = (Seq)var6_5._1();
                buffer = (Seq)var6_5._2();
                if (!$this.PhraseTokens().contains((Object)phrase.pos()) || !KoreanPhraseExtractor$.isNotSpam$1(phrase, filterSpam$1)) break block6;
                bufferWithThisPhrase = KoreanPhraseExtractor$.addPhraseToBuffer$1(phrase, buffer);
                v0 = phrase.pos();
                var11_10 = KoreanPos$.MODULE$.Noun();
                if (!(v0 == null ? var11_10 != null : v0.equals(var11_10) == false)) ** GOTO lbl-1000
                v1 = phrase.pos();
                var12_11 = KoreanPos$.MODULE$.ProperNoun();
                if (!(v1 != null ? v1.equals(var12_11) == false : var12_11 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = new Tuple2(output.$plus$plus((GenTraversableOnce)bufferWithThisPhrase, Seq$.MODULE$.canBuildFrom()), (Object)bufferWithThisPhrase);
                } else {
                    v2 = new Tuple2((Object)output, (Object)bufferWithThisPhrase);
                }
                var4_12 = v2;
                break block7;
            }
            if (var5_4 == null) ** GOTO lbl-1000
            var13_13 = (Tuple2)var5_4._1();
            phrase = (KoreanPhraseExtractor.KoreanPhrase)var5_4._2();
            if (var13_13 == null) ** GOTO lbl-1000
            output = (Seq)var13_13._1();
            buffer = (Seq)var13_13._2();
            if ($this.isNonNounPhraseCandidate$1(phrase)) {
                var4_12 = new Tuple2((Object)output, (Object)KoreanPhraseExtractor$.addPhraseToBuffer$1(phrase, buffer));
            } else if (var5_4 != null && (var17_17 = (Tuple2)var5_4._1()) != null) {
                output = (Seq)var17_17._1();
                buffer = (Seq)var17_17._2();
                var4_12 = new Tuple2(output.$plus$plus((GenTraversableOnce)buffer, Seq$.MODULE$.canBuildFrom()), (Object)KoreanPhraseExtractor$.newBuffer$1());
            } else {
                throw new MatchError((Object)var5_4);
            }
        }
        return var4_12;
    }

    private final Seq collapsePhrases$1(Seq phrases, boolean filterSpam$1) {
        Tuple2 tuple2 = (Tuple2)phrases.foldLeft((Object)new Tuple2((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)KoreanPhraseExtractor$.newBuffer$1()), (arg_0, arg_1) -> KoreanPhraseExtractor$.$anonfun$getCandidatePhraseChunks$6(this, filterSpam$1, arg_0, arg_1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq output = (Seq)tuple2._1();
        Seq buffer = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)output, (Object)buffer);
        Tuple2 tuple23 = tuple22;
        Seq output2 = (Seq)tuple23._1();
        Seq buffer2 = (Seq)tuple23._2();
        return buffer2.length() > 0 ? (Seq)output2.$plus$plus((GenTraversableOnce)buffer2, Seq$.MODULE$.canBuildFrom()) : output2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getCandidatePhraseChunks$7(KoreanPhraseExtractor$ $this, boolean filterSpam$1, KoreanPhraseExtractor.KoreanPhrase phrase) {
        KoreanPhraseExtractor.KoreanPhrase trimmed = $this.trimPhrase(phrase);
        Enumeration.Value value = phrase.pos();
        Enumeration.Value value2 = KoreanPos$.MODULE$.Noun();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = phrase.pos();
            Enumeration.Value value4 = KoreanPos$.MODULE$.ProperNoun();
            if (value3 == null) {
                if (value4 != null) {
                    return false;
                }
            } else if (!value3.equals(value4)) return false;
        }
        if (!KoreanPhraseExtractor$.isNotSpam$1(phrase, filterSpam$1)) return false;
        if (trimmed.length() >= $this.MinCharsPerPhraseChunkWithoutSpaces()) return true;
        if (trimmed.tokens().length() < $this.MinPhrasesPerPhraseChunk()) return false;
        return true;
    }

    private final Seq getSingleTokenNouns$1(Seq phrases$3, boolean filterSpam$1) {
        return (Seq)((TraversableLike)phrases$3.filter((Function1 & Serializable & scala.Serializable)phrase -> BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$getCandidatePhraseChunks$7(this, filterSpam$1, phrase)))).map((Function1 & Serializable & scala.Serializable)phrase -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KoreanPhraseExtractor.KoreanPhrase[]{this.trimPhrase((KoreanPhraseExtractor.KoreanPhrase)phrase)})), Seq$.MODULE$.canBuildFrom());
    }

    private KoreanPhraseExtractor$() {
        MODULE$ = this;
        this.MinCharsPerPhraseChunkWithoutSpaces = 2;
        this.MinPhrasesPerPhraseChunk = 3;
        this.MaxCharsPerPhraseChunkWithoutSpaces = 30;
        this.MaxPhrasesPerPhraseChunk = 8;
        this.ModifyingPredicateEndings = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'\u3139', '\u3134'}));
        this.ModifyingPredicateExceptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'\ub9cc'}));
        this.PhraseTokens = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{KoreanPos$.MODULE$.Noun(), KoreanPos$.MODULE$.ProperNoun(), KoreanPos$.MODULE$.Space()}));
        this.ConjunctionJosa = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\uc640", "\uacfc", "\uc758"}));
        this.PhraseHeadPoses = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{KoreanPos$.MODULE$.Adjective(), KoreanPos$.MODULE$.Noun(), KoreanPos$.MODULE$.ProperNoun(), KoreanPos$.MODULE$.Alpha(), KoreanPos$.MODULE$.Number()}));
        this.PhrasTailPoses = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{KoreanPos$.MODULE$.Noun(), KoreanPos$.MODULE$.ProperNoun(), KoreanPos$.MODULE$.Alpha(), KoreanPos$.MODULE$.Number()}));
        this.COLLAPSING_RULES = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"D0m*N1s0"), (Object)KoreanPos$.MODULE$.Noun()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n*a+n*"), (Object)KoreanPos$.MODULE$.Noun()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n+"), (Object)KoreanPos$.MODULE$.Noun()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v*V1r*e0"), (Object)KoreanPos$.MODULE$.Verb()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v*J1r*e0"), (Object)KoreanPos$.MODULE$.Adjective())}));
        this.CollapseTrie = KoreanPos$.MODULE$.getTrie(this.COLLAPSING_RULES());
    }

    public static final /* synthetic */ Object $anonfun$collapsePos$4$adapted(KoreanTokenizer.KoreanToken token$2, KoreanPos.KoreanPosTrie x$14) {
        return BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$collapsePos$4(token$2, x$14));
    }

    public static final /* synthetic */ Object $anonfun$collapsePos$7$adapted(KoreanTokenizer.KoreanToken token$3, KoreanPos.KoreanPosTrie x$16) {
        return BoxesRunTime.boxToBoolean((boolean)KoreanPhraseExtractor$.$anonfun$collapsePos$7(token$3, x$16));
    }
}

