import type { Registry } from "./schema";

export const component: Registry = [
    {
        name: "ai-input-01",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-01.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-02",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-02.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-file-input.ts",
                type: "registry:hook",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-03",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-03.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-04",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-04.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-05",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-05.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-06",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-06.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-07",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-07.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-08",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: [],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-08.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "ai-input-09",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-09.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
            {
                path: "hooks/use-click-outside.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-10",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-10.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
            {
                path: "hooks/use-file-input.ts",
                type: "registry:hook",
            },
            {
                path: "hooks/use-click-outside.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-11",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-11.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
            {
                path: "hooks/use-click-outside.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-12",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea", "tooltip"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-12.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-13",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-13.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-14",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-14.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-15",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["textarea"],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-15.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-auto-resize-textarea.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "ai-input-16",
        type: "registry:component",
        dependencies: ["lucide-react", "framer-motion"],
        registryDependencies: [],
        files: [
            {
                path: "components/kokonutui/ai-input/ai-input-16.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-click-outside.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "btn-01",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-01.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "btn-02",
        type: "registry:component",
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-02.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "btn-03",
        type: "registry:component",
        dependencies: ["lucide-react", "framer-motion"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-03.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "btn-04",
        type: "registry:component",
        dependencies: ["lucide-react", "framer-motion"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-04.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "btn-05",
        type: "registry:component",
        dependencies: ["lucide-react", "framer-motion"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-05.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "btn-06",
        type: "registry:component",
        dependencies: ["lucide-react", "framer-motion"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-06.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-copy-to-clipboard.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "btn-07",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-07.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "btn-08",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-08.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "btn-09",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-09.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "btn-10",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-10.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "btn-11",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/button/btn-11.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "text-01",
        type: "registry:component",
        dependencies: [],
        files: [
            {
                path: "components/kokonutui/text/text-01.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "text-02",
        type: "registry:component",
        dependencies: ["framer-motion"],
        files: [
            {
                path: "components/kokonutui/text/text-02.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "text-03",
        type: "registry:component",
        dependencies: ["framer-motion"],
        files: [
            {
                path: "components/kokonutui/text/text-03.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "text-04",
        type: "registry:component",
        dependencies: ["framer-motion"],
        files: [
            {
                path: "components/kokonutui/text/text-04.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "text-05",
        type: "registry:component",
        dependencies: ["framer-motion"],
        files: [
            {
                path: "components/kokonutui/text/text-05.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "text-06",
        type: "registry:component",
        dependencies: [],
        files: [
            {
                path: "components/kokonutui/text/text-06.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "card-01",
        type: "registry:component",
        dependencies: [],
        registryDependencies: [],
        files: [
            {
                path: "components/kokonutui/card/card-01.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "card-02",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/card/card-02.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "card-03",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: [],
        files: [
            {
                path: "components/kokonutui/card/card-03.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "card-04",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/card/card-04.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "card-05",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: [],
        files: [
            {
                path: "components/kokonutui/card/card-05.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "card-06",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/card/card-06.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "card-07",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button", "select"],
        files: [
            {
                path: "components/kokonutui/card/card-07.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "pricing-01",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button", "badge"],
        files: [
            {
                path: "components/kokonutui/pricing/pricing-01.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "pricing-02",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/pricing/pricing-02.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "pricing-03",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/pricing/pricing-03.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "pricing-04",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/pricing/pricing-04.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "pricing-05",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/pricing/pricing-05.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "alert-01",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: [],
        files: [
            {
                path: "components/kokonutui/alert/alert-01.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "alert-02",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["alert"],
        files: [
            {
                path: "components/kokonutui/alert/alert-02.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "alert-03",
        type: "registry:component",
        dependencies: ["lucide-react", "framer-motion"],
        registryDependencies: [],
        files: [
            {
                path: "components/kokonutui/alert/alert-03.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "alert-04",
        type: "registry:component",
        dependencies: ["lucide-react", "framer-motion"],
        registryDependencies: [],
        files: [
            {
                path: "components/kokonutui/alert/alert-04.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "alert-05",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: [],
        files: [
            {
                path: "components/kokonutui/alert/alert-05.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "alert-06",
        type: "registry:component",
        dependencies: ["lucide-react", "framer-motion"],
        registryDependencies: ["alert"],
        files: [
            {
                path: "components/kokonutui/alert/alert-06.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "alert-07",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/alert/alert-07.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "input-01",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/input/input-01.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "input-02",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/input/input-02.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-tags.ts",
                type: "registry:hook",
            },
            {
                path: "hooks/use-click-outside.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "input-03",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/input/input-03.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-file-input.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "input-04",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/input/input-04.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "input-05",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/input/input-05.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "input-06",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/input/input-06.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "input-07",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/input/input-07.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-click-outside.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "input-08",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/input/input-08.tsx",
                type: "registry:component",
            },
            {
                path: "hooks/use-copy-to-clipboard.ts",
                type: "registry:hook",
            },
        ],
    },
    {
        name: "input-09",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["popover"],
        files: [
            {
                path: "components/kokonutui/input/input-09.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "input-10",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/input/input-10.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "faq-01",
        type: "registry:component",
        registryDependencies: ["accordion"],
        dependencies: [],
        files: [
            {
                path: "components/kokonutui/faq/faq-01.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "faq-02",
        type: "registry:component",
        registryDependencies: [],
        dependencies: ["framer-motion", "lucide-react"],
        files: [
            {
                path: "components/kokonutui/faq/faq-02.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "faq-03",
        type: "registry:component",
        registryDependencies: ["accordion", "badge"],
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/faq/faq-03.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "faq-04",
        type: "registry:component",
        registryDependencies: ["accordion"],
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/faq/faq-04.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "list-01",
        type: "registry:component",
        registryDependencies: [],
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/list/list-01.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "list-02",
        type: "registry:component",
        registryDependencies: [],
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/list/list-02.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "list-03",
        type: "registry:component",
        registryDependencies: [],
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/list/list-03.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "list-04",
        type: "registry:component",
        registryDependencies: [],
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/list/list-04.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "list-05",
        type: "registry:component",
        registryDependencies: [],
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/list/list-05.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "list-06",
        type: "registry:component",
        registryDependencies: [],
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/list/list-06.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "profile-01",
        type: "registry:component",
        dependencies: ["lucide-react"],
        files: [
            {
                path: "components/kokonutui/profile/profile-01.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "profile-02",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button"],
        files: [
            {
                path: "components/kokonutui/profile/profile-02.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "profile-03",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: [
            "button",
            "input",
            "label",
            "textarea",
            "avatar",
        ],
        files: [
            {
                path: "components/kokonutui/profile/profile-03.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "profile-04",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button", "badge", "progress"],
        files: [
            {
                path: "components/kokonutui/profile/profile-04.tsx",
                type: "registry:component",
            },
        ],
    },
    {
        name: "profile-05",
        type: "registry:component",
        dependencies: ["lucide-react"],
        registryDependencies: ["button", "badge"],
        files: [
            {
                path: "components/kokonutui/profile/profile-05.tsx",
                type: "registry:component",
            },
        ],
    },
];
