import React from "react";
export type Arrow25Element = SVGSVGElement;
export type Arrow25Props = React.SVGAttributes<SVGSVGElement>;

const Arrow25 = React.forwardRef<Arrow25Element, Arrow25Props>(
    (props, forwardedRef) => (
        <svg
            width="38"
            height="227"
            viewBox="0 0 38 227"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            ref={forwardedRef}
            {...props}
        >
            <title>Arrow</title>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M0.0822469 0.227534C0.0822469 0.361804 0.793904 1.27486 1.65324 2.28189C7.8163 9.45194 17.9806 26.1418 22.8681 37.0983C25.8355 43.7447 28.8029 53.9492 30.5216 63.2676C33.4487 79.2055 34.9526 102.837 34.0127 118.184C32.5491 141.816 27.5945 166.361 20.2901 185.978C19.4039 188.287 17.2959 193.51 15.5906 197.552C13.2812 203.057 12.4621 204.655 12.3278 204.077C12.2607 203.621 11.9384 201.633 11.643 199.673C10.7971 194.061 9.22613 186.609 8.51449 184.608C7.69544 182.46 6.71526 181.842 5.45311 182.688C4.79965 183.127 4.67882 185.526 5.09059 189.885C6.23189 201.58 6.55416 218.887 5.77538 224.339C5.57398 225.775 5.61424 225.936 6.29902 226.192C7.76258 226.715 8.6085 225.802 9.03817 223.197C9.1993 222.083 9.29329 221.989 10.3406 221.989C11.1597 221.989 11.643 221.734 12.2607 220.982C12.7172 220.431 13.1066 219.773 13.1066 219.545C13.1066 218.928 17.2824 213.382 20.9883 209.112C22.7204 207.125 27.0574 202.56 30.6693 198.948C37.45 192.141 37.7723 191.684 36.8995 190.046C36.4698 189.227 34.9794 188.77 33.9724 189.133C32.9654 189.522 19.8873 202.654 16.6916 206.508C15.3892 208.105 14.0868 209.663 13.8182 209.931C13.2946 210.482 13.4288 210.187 18.4775 197.74C23.9154 184.245 26.5337 176.323 29.2057 165.112C33.5696 146.663 35.7582 130.242 36.1207 112.639C36.4832 96.1505 34.6169 74.9626 31.4884 60.3539C28.9775 48.6187 26.3323 41.0592 21.606 31.7946C15.7383 20.4218 6.3796 5.97433 1.69352 1.06003C0.753621 0.120131 0.0688477 -0.282687 0.0688477 0.214114L0.0822469 0.227534Z"
                fill="currentColor"
            />
        </svg>
    )
);
Arrow25.displayName = "Arrow25";

export default Arrow25;
