import Alert01 from "@/components/kokonutui/alert-01";
import Alert02 from "@/components/kokonutui/alert-02";
import Alert03 from "@/components/kokonutui/alert-03";
import Alert04 from "@/components/kokonutui/alert-04";
import Alert05 from "@/components/kokonutui/alert-05";
import Alert06 from "@/components/kokonutui/alert-06";
import Alert07 from "@/components/kokonutui/alert-07";
import { createComponentPage } from "@/components/page-builder";
import type { PageConfig } from "@/types/component-page";

const ALERT_CONFIG: PageConfig = {
    title: "Alerts",
    description:
        "A collection of alert components to use and customize. Built with Tailwind CSS.",
    folder: "kokonutui/alert",
    viewType: "grid",
    gridClassName: "grid-cols-1 lg:grid-cols-2 gap-8",
    componentClassName: "h-full my-0",
    components: [
        {
            id: 1,
            title: "Basic",
            component: <Alert01 />,
            fileName: "alert-01.tsx",
        },
        {
            id: 2,
            title: "Basic 2",
            component: <Alert02 />,
            fileName: "alert-02.tsx",
        },
        {
            id: 3,
            title: "Info",
            component: <Alert03 />,
            fileName: "alert-03.tsx",
        },
        {
            id: 4,
            title: "Fancy",
            component: <Alert04 />,
            dependencies: ["framer-motion"],
            fileName: "alert-04.tsx",
        },
        {
            id: 5,
            title: "Payment",
            component: <Alert05 />,
            fileName: "alert-05.tsx",
        },
        {
            id: 6,
            title: "Glass",
            component: <Alert06 />,
            dependencies: ["framer-motion"],
            fileName: "alert-06.tsx",
        },
        {
            id: 7,
            title: "Classy",
            component: <Alert07 />,
            fileName: "alert-07.tsx",
        },
    ],
};

const { default: AlertsPage, metadata } = createComponentPage(ALERT_CONFIG);

export { metadata };
export default AlertsPage;
