# 連続する約物を詰めるためのグリフ配置の分析

## グリフ分析ファイルの生成

east-asian-spacingでは、グリフのアウトラインから、各グリフが左右、あるいは両側に、詰めに必要な十分な空白を持っているかどうかを分析することができます。この分析の結果を確認するには、以下のコマンドを使います。
```sh
east-asian-spacing -g . --debug shaper --test 0 input.otf
```
上記コマンドを実行すると「input.otf-glyphs」ファイルがカレントディレクトリに作成されます。

## グリフ分析ファイルの構成

「#」で始まる行が、グループを表します。例えば
```
# left
```
これは、横書きで、左側半分にグリフがあり、右側半分が空白のグループです。このグループの中を見ると
```
1397 # {t:"、",g:1397,a:1000,o:0,b:(52, -56, 341, 224),i:LEFT}
```
例えばこれは
* Glyph IDが「1397」。
* 文字「、」に割り当てられている。
* 文字方向のadvanceが「1000」。
* 文字方向のglyph offsetが「0」。
* グリフアウトラインの外接矩形が (52, -56, 341, 224)。
* 外接矩形から、左半分にしかアウトラインがない（右半分が空白）と判定された。

ことを表します。「right」「middle」グループも同様です。

「filtered」グループには、分析の結果、他のいずれのグループにも入らなかったため、詰めの対象から外されたグリフが列挙されます。対象から外される主な理由は、以下のとおりです。

### 日本語と中国語で配置が異なる文字

```
# filtered
# {t:"！",g:59047,a:1000,o:0,b:(436, -5, 564, 748),i:MIDDLE}
# {t:"？",g:59077,a:1000,o:0,b:(255, -5, 739, 761),i:MIDDLE}
```

全角の「！」と「？」は、日本語では詰めの対象になりませんが、簡体字中国語では左側に寄ったグリフとなり、詰めの対象になります。east-asian-spacingは中国語にも対応するため、これらの文字のアウトラインの外接矩形を確認していますが、「i:MIDDLE」と判定されたため、「左側ではない」ことから、グループに入らなかったことを示しています。日本語フォントでは、これは正常です。他にも、全角コロン、セミコロン「：」「；」や、繁体字中国語における句読点「、」「。」も同様に、言語の慣例によって位置が異なるため、「filtered」グループに現れることがあります。「i:」の表示が、意図したデザインと合致していれば、正常です。

日本語の慣例は[JLREQ 3.1.2]、中国語の慣例は[CLREQ 3.1.6.1]に記載がありますが、以下の用法が多いようです。

| 文字 | 日本語横 | 日本語縦 | 簡体字横 | 簡体字縦 | 繁体字横 | 繁体字縦 |
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| 、。 | 左 | 上 | 左 | 上 | 中央 | 中央 |
| ！？ | 詰めない | 詰めない | 左 | 詰めない | 詰めない | 詰めない |
| ： | 中央 | 中央（回転） | 左 | 詰めない | 中央 | 詰めない |
| ； | 中央 | 詰めない | 左 | 詰めない | 中央 | 詰めない |

### グリフの割り当てがない文字

```
# {t:"｠",g:0}
```
Glyph IDが「0」の場合、この文字にはグリフの割り当てがなかったことを示します。JISにない文字や、日本語では使われない文字についても分析が行われるため、グリフを割り当てていないのであればこれも正常ですが、割り当てているはずなのにこの表示が出たら、調査する必要があります。

### 引用符と二重引用符

```
# {t:"“",g:704,a:466,o:0,b:(36.0, 470.0, 426.0, 770.0),i:OTHER}
```
引用符と二重引用符には、少し特殊な事情があります。Unicodeにおいて、欧文の引用符類と同じコードポイントになっているため、文字コードからは、これらが全角であるべきかどうかの判断が付きません。慣例としては、中国語フォントでは中国語に合わせた全角グリフを入れますが、日本語フォントでは幅や高さを欧文に合わせた欧文グリフを入れることが多いようです。

Adobeの日本語フォントの慣例では、デフォルトでは欧文グリフですが、OpenType
[`fwid`] featureを適用した時には、高さを和文ベースラインに合わせた全角グリフとなるようです。このためeast-asian-spacingでは [`fwid`] を適用して計算しますが、この例の場合には「a:466」になっているので、[`fwid`] を適用しても和文全角グリフがなかったことを示しています。

また、縦書きにおける引用符類は、用法が確立していないこともあり、横書きと異なる側に配置してある例が見られます。
```
# vertical.filtered
# {t:"“",g:704,a:1000,o:880,b:(36.0, 470.0, 426.0, 770.0),i:LEFT}
```
この例では、「a:1000」なので、縦書きにおいては全角グリフが割り当てられていることが分かりますが、開き括弧類の二重引用符に対して「i:LEFT」、つまり縦書きで上半分にアウトラインがあるため、詰めの対象から外されたことを示しています。

### 半角に詰められないグリフ

```
# {t:"』",g:692,a:1000,o:880,b:(33.0, 367.0, 840.0, 800.0),i:OTHER}
```
この例では、全角「』」は閉じ括弧類ですが、アウトラインの外接矩形が左半分（縦書きでは上半分）に収まらなかったために「i:LEFT」ではなく「i:OTHER」と判定され、詰めの対象から外されたことを示しています。

現在のeast-asian-spacingでは、半角に詰めるか、詰めないかの二択になっているため、半角に収まらないグリフは詰めることができません。意図的なデザインで詰めの対象から外してよいとするか、あるいはグリフを調整して左半分に収めるかを選択することになります。半角以外の詰めに対応することも検討していますが、現時点では用法として確定できていません。

---

ご質問、ご意見、ご要望などございましたら、[github issues] などにお寄せください。

[CLREQ 3.1.6.1]: https://w3c.github.io/clreq/#h-punctuation_adjustment_space
[JLREQ 3.1.2]: https://w3c.github.io/jlreq/#positioning_of_punctuation_marks
[`fwid`]: https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#tag-fwid
[github issues]: https://github.com/kojiishi/east_asian_spacing/issues
