# Roadmap

Roadmap to developer. Inspired by the [Web developer roadmap](https://github.com/kamranahmedse/developer-roadmap)([번역](https://github.com/devJang/developer-roadmap)) and [The Front-End Checklist](https://frontendchecklist.io/).

## Curiosity

### Programming Language

- [x] JavaScript
  - [x] [생활코딩](https://opentutorials.org/)
    - [x] [JavaScript](https://opentutorials.org/course/743)
    - [x] [웹브라우저 자바스크립트](https://opentutorials.org/course/1375)
  - [x] [JavaScript - MDN web docs](https://developer.mozilla.org/ko/docs/Web/JavaScript)
  - [x] [자바스크립트는 어떻게 작동하는가](https://engineering.huiseoul.com/%EC%9E%90%EB%B0%94%EC%8A%A4%ED%81%AC%EB%A6%BD%ED%8A%B8%EB%8A%94-%EC%96%B4%EB%96%BB%EA%B2%8C-%EC%9E%91%EB%8F%99%ED%95%98%EB%8A%94%EA%B0%80-%EC%97%94%EC%A7%84-%EB%9F%B0%ED%83%80%EC%9E%84-%EC%BD%9C%EC%8A%A4%ED%83%9D-%EA%B0%9C%EA%B4%80-ea47917c8442)([원문: How JavaScript works](https://blog.sessionstack.com/how-does-javascript-actually-work-part-1-b0bacc073cf))
    - [x] [엔진, 런타임, 콜스택 개관](https://engineering.huiseoul.com/%EC%9E%90%EB%B0%94%EC%8A%A4%ED%81%AC%EB%A6%BD%ED%8A%B8%EB%8A%94-%EC%96%B4%EB%96%BB%EA%B2%8C-%EC%9E%91%EB%8F%99%ED%95%98%EB%8A%94%EA%B0%80-%EC%97%94%EC%A7%84-%EB%9F%B0%ED%83%80%EC%9E%84-%EC%BD%9C%EC%8A%A4%ED%83%9D-%EA%B0%9C%EA%B4%80-ea47917c8442)
    - [x] [V8 엔진의 내부 + 최적화된 코드를 작성을 위한 다섯 가지 팁](https://engineering.huiseoul.com/%EC%9E%90%EB%B0%94%EC%8A%A4%ED%81%AC%EB%A6%BD%ED%8A%B8%EB%8A%94-%EC%96%B4%EB%96%BB%EA%B2%8C-%EC%9E%91%EB%8F%99%ED%95%98%EB%8A%94%EA%B0%80-v8-%EC%97%94%EC%A7%84%EC%9D%98-%EB%82%B4%EB%B6%80-%EC%B5%9C%EC%A0%81%ED%99%94%EB%90%9C-%EC%BD%94%EB%93%9C%EB%A5%BC-%EC%9E%91%EC%84%B1%EC%9D%84-%EC%9C%84%ED%95%9C-%EB%8B%A4%EC%84%AF-%EA%B0%80%EC%A7%80-%ED%8C%81-6c6f9832c1d9)
    - [x] [메모리 관리 + 4가지 흔한 메모리 누수 대처법](https://engineering.huiseoul.com/%EC%9E%90%EB%B0%94%EC%8A%A4%ED%81%AC%EB%A6%BD%ED%8A%B8%EB%8A%94-%EC%96%B4%EB%96%BB%EA%B2%8C-%EC%9E%91%EB%8F%99%ED%95%98%EB%8A%94%EA%B0%80-%EB%A9%94%EB%AA%A8%EB%A6%AC-%EA%B4%80%EB%A6%AC-4%EA%B0%80%EC%A7%80-%ED%9D%94%ED%95%9C-%EB%A9%94%EB%AA%A8%EB%A6%AC-%EB%88%84%EC%88%98-%EB%8C%80%EC%B2%98%EB%B2%95-5b0d217d788d)
    - [x] [이벤트 루프와 비동기 프로그래밍의 부상, async/await을 이용한 코딩 팁 다섯 가지](https://engineering.huiseoul.com/%EC%9E%90%EB%B0%94%EC%8A%A4%ED%81%AC%EB%A6%BD%ED%8A%B8%EB%8A%94-%EC%96%B4%EB%96%BB%EA%B2%8C-%EC%9E%91%EB%8F%99%ED%95%98%EB%8A%94%EA%B0%80-%EC%9D%B4%EB%B2%A4%ED%8A%B8-%EB%A3%A8%ED%94%84%EC%99%80-%EB%B9%84%EB%8F%99%EA%B8%B0-%ED%94%84%EB%A1%9C%EA%B7%B8%EB%9E%98%EB%B0%8D%EC%9D%98-%EB%B6%80%EC%83%81-async-await%EC%9D%84-%EC%9D%B4%EC%9A%A9%ED%95%9C-%EC%BD%94%EB%94%A9-%ED%8C%81-%EB%8B%A4%EC%84%AF-%EA%B0%80%EC%A7%80-df65ffb4e7e)
    - [x] [웹소켓 및 HTTP/2 SSE](https://engineering.huiseoul.com/%EC%9E%90%EB%B0%94%EC%8A%A4%ED%81%AC%EB%A6%BD%ED%8A%B8%EB%8A%94-%EC%96%B4%EB%96%BB%EA%B2%8C-%EC%9E%91%EB%8F%99%ED%95%98%EB%8A%94%EA%B0%80-%EC%9B%B9%EC%86%8C%EC%BC%93-%EB%B0%8F-http-2-sse-1ccde9f9dc51)
    - [x] [웹어셈블리와의 비교 + 언제 웹어셈블리를 사용하는 게 좋은가](https://engineering.huiseoul.com/%EC%9E%90%EB%B0%94%EC%8A%A4%ED%81%AC%EB%A6%BD%ED%8A%B8%EB%8A%94-%EC%96%B4%EB%96%BB%EA%B2%8C-%EC%9E%91%EB%8F%99%ED%95%98%EB%8A%94%EA%B0%80-%EC%9B%B9%EC%96%B4%EC%85%88%EB%B8%94%EB%A6%AC%EC%99%80%EC%9D%98-%EB%B9%84%EA%B5%90-%EC%96%B8%EC%A0%9C-%EC%9B%B9%EC%96%B4%EC%85%88%EB%B8%94%EB%A6%AC%EB%A5%BC-%EC%82%AC%EC%9A%A9%ED%95%98%EB%8A%94-%EA%B2%8C-%EC%A2%8B%EC%9D%80%EA%B0%80-cf48a576ca3)
  - [x] [Understanding JavaScript Function Invocation and "this"](https://yehudakatz.com/2011/08/11/understanding-javascript-function-invocation-and-this/)
- [x] [TypeScript](https://www.typescriptlang.org/)
  - [x] [타입스크립트 코리아 : 기초 세미나 - 인프런](https://www.inflearn.com/course/%ed%83%80%ec%9e%85%ec%8a%a4%ed%81%ac%eb%a6%bd%ed%8a%b8-%ec%bd%94%eb%a6%ac%ec%95%84-1705-%ea%b8%b0%ec%b4%88-%ec%84%b8%eb%af%b8%eb%82%98/)
  - [x] [Handbook](https://www.typescriptlang.org/docs/handbook/basic-types.html)([번역](https://typescript-kr.github.io))
  - [x] [How do the different enum variants work in TypeScript? - Stack Overflow](https://stackoverflow.com/a/28818850/10358228)
- [x] [Node.js](https://nodejs.org/)
  - [x] [JavaScript (nodejs) - 생활코딩](https://opentutorials.org/course/2136)
  - [x] [Node.js server without a framework - MDN](https://developer.mozilla.org/en-US/docs/Learn/Server-side/Node_server_without_framework)
  - [x] [Introduction to the server side - MDN](https://developer.mozilla.org/en-US/docs/Learn/Server-side/First_steps/Introduction)
  - [x] [Client-Server overview - MDN](https://developer.mozilla.org/en-US/docs/Learn/Server-side/First_steps/Client-Server_overview)
  - [x] [Server-side web frameworks - MDN](https://developer.mozilla.org/en-US/docs/Learn/Server-side/First_steps/Web_frameworks)
- [ ] [Rust](https://www.rust-lang.org/)
  - [x] [Book](https://doc.rust-lang.org/book/): [2판 한글 번역](https://rinthel.github.io/rust-lang-book-ko/)([GitHub](https://github.com/rinthel/rust-lang-book-ko))
  - [x] [Rust by Example](https://doc.rust-lang.org/rust-by-example/index.html)([GitHub](https://github.com/rust-lang/rust-by-example))
  - [ ] [Rust Cookbook](https://rust-lang-nursery.github.io/rust-cookbook/)
  - [x] [Rust - Rethinking Systems Programming](https://thoughtram.io/rust-and-nickel/#/)
  - [x] [Frequently Asked Questions](https://www.rust-lang.org/en-US/faq.html)([한글](https://www.rust-lang.org/ko-KR/faq.html))
  - [x] [What is the difference between iter and into_iter? - Stack Overflow](https://stackoverflow.com/a/34745885/10358228)
  - [x] [Understanding and relationship between Box, ref, & and * - Stack Overflow](https://stackoverflow.com/q/31949579/10358228)
- [ ] [Lua](https://www.lua.org/)
- [ ] [Go](https://golang.org/)
- [ ] [Kotlin](https://kotlinlang.org/)
- [ ] [Python](https://www.python.org/)
  - [ ] [Google's Python Class](https://developers.google.com/edu/python/)
  - [ ] [Official Python Tutorial](https://docs.python.org/3/tutorial/index.html)
- [ ] [Swift](https://swift.org/)
- [ ] [Ruby](https://www.ruby-lang.org/)
- [ ] [Clojure](https://clojure.org/)
- [ ] [R Programming](https://www.r-project.org/)

### Library

- [ ] HTTP
  - [ ] [Retrofit](https://square.github.io/retrofit/)
  - [ ] [hyper](https://hyper.rs/) - [GitHub](https://github.com/hyperium/hyper)
- [ ] Event driven
  - [ ] [libevent](https://libevent.org)
    - [ ] [Programming with Libevent](http://www.wangafu.net/~nickm/libevent-book/)
  - [ ] [Tokio](https://tokio.rs/) - [GitHub](https://github.com/tokio-rs/tokio)
    - [x] [Official Documentation](https://tokio.rs/docs/overview/)
    - [ ] [API documentation](https://docs.rs/tokio)
- [x] [Reactive Extensions](https://en.wikipedia.org/wiki/Reactive_extensions) - [ReactiveX](http://reactivex.io/)
  - [x] [Rx와 Functional Reactive Programming으로 고성능 서버 만들기 - Slideshare](https://www.slideshare.net/jongwookkim/ndc14-rx-functional-reactive-programming)
  - [x] [ReactiveX - Intro](http://reactivex.io/intro.html)
  - [x] [The introduction to Reactive Programming you've been missing - GitHub Gist](https://gist.github.com/staltz/868e7e9bc2a7b8c1f754)([번역](https://gist.github.com/casamia918/93b8db69beb9ee06b92a96b2a234d48e))
  - [x] [Cold observable과 Hot observable | PoiemaWeb](https://poiemaweb.com/angular-rxjs-observable)
  - [x] [ReactiveX Docs](http://reactivex.io/documentation/observable.html)
  - [ ] [RxJS](https://rxjs.dev/) - [GitHub](https://github.com/ReactiveX/rxjs)
    - [x] [RxJS Official Docs](https://rxjs.dev/guide/overview): [Practiced here](https://github.com/khbrst/es-practice)
    - [x] [Netflix JavaScript Talks - Async JavaScript with Reactive Extensions - YouTube](https://www.youtube.com/watch?v=XRYN2xt11Ek)
    - [x] [Learn RxJS](https://www.learnrxjs.io/) - [GitHub](https://github.com/btroncone/learn-rxjs)
    - [x] [Difference Between throttling and debouncing a function - Stack Overflow](https://stackoverflow.com/a/25991510/10358228)
  - [ ] [RxJava](https://github.com/ReactiveX/RxJava)
  - [ ] [RxKotlin](https://github.com/ReactiveX/RxKotlin)
  - [ ] [RxCpp](http://reactivex.io/RxCpp/) - [GitHub](https://github.com/ReactiveX/RxCpp)
  - [ ] [RxRust](https://github.com/ReactiveX/RxRust)
- [ ] [Reactive Streams](http://www.reactive-streams.org/) - [GitHub Organization](https://github.com/reactive-streams)
  - [ ] [Reactive Streams - Wikipedia](https://en.wikipedia.org/wiki/Reactive_Streams)
  - [ ] [Reactor](https://projectreactor.io/)

### Framework

- [ ] [LLVM](https://llvm.org/)
  - [ ] [LLVM - Wikipedia](https://en.wikipedia.org/wiki/LLVM)([한글](https://ko.wikipedia.org/wiki/LLVM))
  - [x] [LLVM - 나무위키](https://namu.wiki/w/LLVM)
- [ ] Cross-platform Desktop Application
  - [ ] [Electron](https://electronjs.org/)
- [ ] Cross-platform Mobile Application
  - [ ] [React Native](https://facebook.github.io/react-native/) - [GitHub](https://github.com/facebook/react-native)
  - [ ] [NativeScript](https://www.nativescript.org/) - [GitHub](https://github.com/NativeScript/NativeScript)
- [ ] [Dependency injection](https://en.wikipedia.org/wiki/Dependency_injection)
  - [ ] [Dagger](https://google.github.io/dagger/)
- [ ] Unit Testing
  - [x] [Google Test](https://github.com/google/googletest)
    - [x] [Googletest Primer document](https://github.com/google/googletest/blob/master/googletest/docs/primer.md)
    - [x] [Google Mock document](https://github.com/google/googletest/blob/master/googlemock/README.md)

### Software development process

- [ ] [Extreme programming](https://en.wikipedia.org/wiki/Extreme_programming)
  - [ ] [Extreme Programming Roadmap](http://wiki.c2.com/?ExtremeProgrammingRoadmap)

### Programming Paradigm

- [x] [Declarative Programming](https://en.wikipedia.org/wiki/Declarative_programming)
  - [ ] [Functional Programming](https://en.wikipedia.org/wiki/Functional_programming)
    - [x] [(번역) 함수형 프로그래밍이란 무엇인가? - Jooyung Han (한주영) - Medium](https://medium.com/@jooyunghan/%ED%95%A8%EC%88%98%ED%98%95-%ED%94%84%EB%A1%9C%EA%B7%B8%EB%9E%98%EB%B0%8D%EC%9D%B4%EB%9E%80-%EB%AC%B4%EC%97%87%EC%9D%B8%EA%B0%80-fab4e960d263)
  - [x] [Dataflow Programming](https://en.wikipedia.org/wiki/Dataflow_programming)
    - [x] [Reactive Programming](https://en.wikipedia.org/wiki/Reactive_programming)
  - [x] [Functional Reactive Programming](https://en.wikipedia.org/wiki/Functional_reactive_programming)

### Embedded

- [ ] [Embedded Recipes](http://recipes.egloos.com/)

## Frontend

- [ ] HTML
  - [ ] Basics
    - [x] [HTML 수업 - 생활코딩](https://opentutorials.org/course/2039)
    - [x] [Introduction to HTML - MDN](https://developer.mozilla.org/en-US/docs/Learn/HTML/Introduction_to_HTML)
    - [ ] [Multimedia and embedding - MDN](https://developer.mozilla.org/en-US/docs/Learn/HTML/Multimedia_and_embedding)
    - [ ] [HTML forms - MDN](https://developer.mozilla.org/en-US/docs/Learn/HTML/Forms)
    - [ ] [Learn HTML to solve problems - MDN](https://developer.mozilla.org/en-US/docs/Learn/HTML/Howto)
    - [ ] [Dive Into HTML5](http://www.diveintohtml5.net)
  - [ ] [HTML reference - MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Reference)
  - [ ] [HTML5 Specification TR - W3C](https://www.w3.org/TR/html5/)
- [ ] CSS
  - [ ] Basics
    - [x] [Introduction to CSS - MDN](https://developer.mozilla.org/en-US/docs/Learn/CSS/Introduction_to_CSS)
    - [x] [Styling text - MDN](https://developer.mozilla.org/en-US/docs/Learn/CSS/Styling_text)
    - [x] [Styling boxes - MDN](https://developer.mozilla.org/en-US/docs/Learn/CSS/Styling_boxes)
    - [x] [CSS layout - MDN](https://developer.mozilla.org/en-US/docs/Learn/CSS/CSS_layout)
    - [ ] [CSS3 - MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS3)
  - [x] Media queries
    - [x] [Media queries - MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries)
    - [x] [Using media queries - MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries/Using_media_queries)
    - [x] [Testing media queries programmatically - MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries/Testing_media_queries)
    - [x] [Using Media Queries for Accessibility - MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries/Using_Media_Queries_for_Accessibility)
  - [ ] CSS Preprocessors
    - [ ] [Sass](https://sass-lang.com/)
    - [ ] [Postcss](https://postcss.org/)
  - [ ] CSS framework
    - [ ] [Bootstrap](https://getbootstrap.com/)
  - [ ] CSS architecture
    - [ ] BEM
  - [ ] [CSS reference - MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/Reference)
  - [ ] [CSS Specs - W3C](https://www.w3.org/Style/CSS/#specs)
- [x] JavaScript: [Practiced here](https://github.com/khbrst/es-practice)
- [x] TypeScript: [Practiced here](https://github.com/khbrst/es-practice)
- [x] Package Manager: [Practiced here](https://github.com/khbrst/es-practice)
- [ ] Build tool
  - [ ] Package Manager
    - [x] [NPM scripts](https://docs.npmjs.com/misc/scripts): [Practiced here](https://github.com/khbrst/es-practice)
  - [ ] Package Bundler
    - [ ] [webpack](https://webpack.js.org/)
    - [ ] [Browserify](http://browserify.org/)
  - [ ] Task Runner
    - [ ] [gulp.js](https://gulpjs.com/)
- [ ] Frontend framework
  - [ ] [React](https://reactjs.org/)
    - [ ] [Redux](https://redux.js.org/)
    - [ ] [MobX](https://mobx.js.org/)
  - [ ] [Vue.js](https://vuejs.org/)
    - [ ] [Official Docs](https://vuejs.org/guide/)
      - [x] [Essentials](https://vuejs.org/guide/installation.html)
      - [ ] [Components In-Depth](https://vuejs.org/v2/guide/components-registration.html)
      - [ ] [Transitions & Animation](https://vuejs.org/v2/guide/transitions.html)
      - [ ] [Reusability & Composition](https://vuejs.org/v2/guide/mixins.html)
      - [ ] [Tooling](https://vuejs.org/v2/guide/single-file-components.html)
      - [ ] [Scaling Up](https://vuejs.org/v2/guide/routing.html)
      - [ ] [Internals](https://vuejs.org/v2/guide/reactivity.html)
      - [ ] [Meta](https://vuejs.org/v2/guide/comparison.html)
        - [x] [Comparison with Other Frameworks](https://vuejs.org/v2/guide/comparison.html)
    - [ ] [Vuex](https://vuex.vuejs.org/)
  - [ ] [Angular](https://angular.io/)
    - [ ] [Official Docs](https://angular.io/docs)
      - [x] [Getting started](https://angular.io/guide/quickstart)
      - [x] [Tutorial: Tour of Heroes](https://angular.io/tutorial): [Practiced here](https://github.com/khbrst/angular-tour-of-heroes)
      - [ ] Fundamentals
        - [x] [Architecture](https://angular.io/guide/architecture)
        - [ ] [Components & Templates](https://angular.io/guide/displaying-data)
        - [ ] [Forms](https://angular.io/guide/forms-overview)
        - [ ] [Observables & RxJS](https://angular.io/guide/observables)
        - [ ] [Bootstrapping](https://angular.io/guide/bootstrapping)
        - [ ] [NgModules](https://angular.io/guide/ngmodules)
        - [ ] [Dependency Injection](https://angular.io/guide/dependency-injection)
        - [ ] [HttpClient](https://angular.io/guide/http)
        - [ ] [Routing & Navigation](https://angular.io/guide/router)
        - [ ] [Animations](https://angular.io/guide/animations)
    - [ ] [RxJS](https://rxjs.dev/)
    - [ ] [ngrx](https://ngrx.github.io/)
- [x] Testing framework: [Practiced here](https://github.com/khbrst/es-practice)
- [ ] Progressive WebApps
  - [x] Service Workers: [Practiced here](https://github.com/khbrst/es-practice)
  - [ ] [Progressive web apps - MDN](https://developer.mozilla.org/en-US/docs/Web/Apps/Progressive)
  - [ ] [Web Fundamentals | Google Developers](https://developers.google.com/web/fundamentals/)
  - [ ] [Progressive Web Apps Training | Google Developers](https://developers.google.com/web/ilt/pwa/)
- [ ] Server Side Rendering
  - [ ] [React](https://reactjs.org/)
    - [ ] [Next.js](https://nextjs.org/)
    - [ ] [After.js](https://github.com/jaredpalmer/after.js)
  - [ ] [Vue.js](https://vuejs.org/)
    - [ ] [Nuxt.js](https://nuxtjs.org/)
  - [ ] [Angular](https://angular.io/)
    - [ ] [Universal](https://github.com/angular/universal)
- [ ] Canvas
- [ ] HTML5 APIs
- [ ] SVG
- [ ] Source Maps
  - [ ] [Introduction to JavaScript Source Maps](https://www.html5rocks.com/en/tutorials/developertools/sourcemaps/)
- [ ] TC39 - [GitHub](https://github.com/tc39)
  - [x] [ECMAScript와 TC39](https://ahnheejong.name/articles/ecmascript-tc39/)
- [ ] Semantic Web
  - [ ] [Semantic Web - Wikipedia](https://en.wikipedia.org/wiki/Semantic_Web)([번역](https://ko.wikipedia.org/wiki/%EC%8B%9C%EB%A7%A8%ED%8B%B1_%EC%9B%B9))
  - [ ] [시맨틱 웹 - 나무위키](https://namu.wiki/w/%EC%8B%9C%EB%A7%A8%ED%8B%B1%20%EC%9B%B9)
  - [ ] [Semantic Web - W3C](https://www.w3.org/standards/semanticweb/)

## Backend

- [ ] Package Manager
  - [ ] Node.js: [Practiced here](https://github.com/khbrst/es-practice)
    - [x] [npm](https://www.npmjs.com/)
      - [x] [npm Documentation](https://docs.npmjs.com/)
      - [x] [NVM: Node Version Manager](https://github.com/creationix/nvm)
    - [ ] [Yarn](https://yarnpkg.com)
  - [x] Java
    - [x] [Maven](https://maven.apache.org/)
    - [x] [Gradle](https://gradle.org/)
  - [ ] Python
    - [ ] [pip](https://docs.python.org/3/tutorial/venv.html#managing-packages-with-pip)
    - [ ] Version Manager
      - [ ] [Anaconda](https://anaconda.org/)
      - [x] [Virtualenv](https://virtualenv.pypa.io/en/stable/)
- [ ] Standards and Best Practices
  - [ ] Node.js: [Practiced here](https://github.com/khbrst/es-practice)
    - [x] [Website security - MDN](https://developer.mozilla.org/en-US/docs/Learn/Server-side/First_steps/Website_security)
    - [x] [OWASP Top 10-2017 - Korean(pdf)](https://www.owasp.org/images/b/bd/OWASP_Top_10-2017-ko.pdf)([pptx](https://www.owasp.org/images/1/1d/OWASP_Top_10-2017-ko.pptx))
    - [x] [JavaScript Standard Style](https://standardjs.com/)([번역](https://standardjs.com/readme-kokr.html)): [GitHub](https://github.com/standard/standard)([번역](https://github.com/standard/standard/blob/master/docs/README-kokr.md))
    - [x] [Do's and Don'ts - TypeScript](https://www.typescriptlang.org/docs/handbook/declaration-files/do-s-and-don-ts.html)
    - [ ] [Node.js Best Practices](https://github.com/i0natan/nodebestpractices)
      - [x] [1. Project Structure Practices](https://github.com/i0natan/nodebestpractices#1-project-structure-practices)
      - [x] [2. Error Handling Practices](https://github.com/i0natan/nodebestpractices#2-error-handling-practices)
      - [x] [3. Code Style Practices](https://github.com/i0natan/nodebestpractices#3-code-style-practices)
      - [x] [4. Test And Overall Quality Practices](https://github.com/i0natan/nodebestpractices#4-testing-and-overall-quality-practices)
      - [x] [5. Going To Production Practices](https://github.com/i0natan/nodebestpractices#5-going-to-production-practices)
      - [x] [6. Security Best Practices](https://github.com/i0natan/nodebestpractices#6-security-best-practices)
        - [ ] [Common Node.js security best practices](https://github.com/i0natan/nodebestpractices/blob/master/sections/security/commonsecuritybestpractices.md)
        - [ ] [Using security-related headers to secure your application against common attacks](https://github.com/i0natan/nodebestpractices/blob/master/sections/security/secureheaders.md)
        - [ ] [Constantly and automatically inspect for vulnerable dependencies](https://github.com/i0natan/nodebestpractices/blob/master/sections/security/dependencysecurity.md)
    - [x] [The Twelve-Factor App](https://12factor.net/)
    - [ ] [Node.js Guides](https://nodejs.org/en/docs/guides/)
      - [x] [Overview of Blocking vs Non-Blocking](https://nodejs.org/en/docs/guides/blocking-vs-non-blocking/)
      - [x] [The Node.js Event Loop, Timers, and `process.nextTick()`](https://nodejs.org/en/docs/guides/event-loop-timers-and-nexttick/)
      - [x] [Don't Block the Event Loop (or the Worker Pool)](https://nodejs.org/en/docs/guides/dont-block-the-event-loop/)
      - [x] [Timers in Node.js and beyond](https://nodejs.org/en/docs/guides/timers-in-node/)
      - [x] [Anatomy of an HTTP Transaction](https://nodejs.org/en/docs/guides/anatomy-of-an-http-transaction/)
      - [x] [Working with Different Filesystems](https://nodejs.org/en/docs/guides/working-with-different-filesystems/)
      - [x] [Backpressuring in Streams](https://nodejs.org/en/docs/guides/backpressuring-in-streams/)
      - [ ] [How to publish N-API package](https://nodejs.org/en/docs/guides/publishing-napi-modules/)
      - [ ] [ABI Stability](https://nodejs.org/en/docs/guides/abi-stability/)
    - [ ] [Node.js API Documentation](https://nodejs.org/api/documentation.html)
    - [ ] [Express Production Best Practices: performance and reliability](https://expressjs.com/en/advanced/best-practice-performance.html)
    - [ ] [Express Production Best Practices: Security](https://expressjs.com/en/advanced/best-practice-security.html)
- [ ] Testing framework
  - [ ] Node.js: [Practiced here](https://github.com/khbrst/es-practice)
    - [x] [Mocha](https://mochajs.org/)
    - [ ] [Jasmine](https://jasmine.github.io/)
    - [ ] [SinonJS](https://sinonjs.org/)
    - [ ] Assertion
      - [x] [Node.js Assert](https://nodejs.org/api/assert.html)
      - [x] [chai](http://www.chaijs.com/)
      - [ ] [should.js](https://github.com/shouldjs/should.js)
      - [ ] [expect.js](https://github.com/Automattic/expect.js)
      - [ ] [better-assert](https://github.com/tj/better-assert)
      - [ ] [unexpected](http://unexpected.js.org/)
- [ ] RDBMS
  - [x] [Database Structure and Design Tutorial by Lucidchart](https://www.lucidchart.com/pages/database-diagram/database-design)([번역](https://medium.com/@khwsc1/%EB%B2%88%EC%97%AD-%EB%8D%B0%EC%9D%B4%ED%84%B0-%EA%B5%AC%EC%A1%B0%EC%99%80-%EC%84%A4%EA%B3%84-%ED%8A%9C%ED%86%A0%EB%A6%AC%EC%96%BC-b25792a0aa86))
  - [x] [Database design - Wikipedia](https://en.wikipedia.org/wiki/Database_design)
  - [x] [Database normalization - Wikipedia](https://en.wikipedia.org/wiki/Database_normalization)
  - [ ] [Database model - Wikipedia](https://en.wikipedia.org/wiki/Database_model)
  - [x] [Entity-relationship model - Wikipedia](https://en.wikipedia.org/wiki/Entity%E2%80%93relationship_model)
  - [x] [Conceptual data model - Wikipedia](https://en.wikipedia.org/wiki/Conceptual_schema)
  - [x] [Logical data model - Wikipedia](https://en.wikipedia.org/wiki/Logical_data_model)
  - [x] [Physical data model - Wikipedia](https://en.wikipedia.org/wiki/Physical_data_model)
  - [x] [Join (SQL) - Wikipedia](https://en.wikipedia.org/wiki/Join_(SQL))
  - [ ] [MySQL](https://www.mysql.com/)
    - [x] [MySQL - 생활코딩](https://opentutorials.org/course/195)
    - [ ] [MySQL 8.0 Reference Manual](https://dev.mysql.com/doc/refman/8.0/en/)
      - [x] [MySQL 8.0 Tutorial](https://dev.mysql.com/doc/refman/8.0/en/tutorial.html)
  - [ ] [MariaDB](https://mariadb.com/)
    - [ ] [MariaDB Knowledge Base](https://mariadb.com/kb/en/library/)
      - [x] [Beginner MariaDB Articles](https://mariadb.com/kb/en/library/beginner-mariadb-articles/)
  - [ ] [PostgreSQL](https://www.postgresql.org/)
    - [ ] [PostgreSQL Documentation](https://www.postgresql.org/docs/current/index.html)
      - [x] [PostgreSQL Tutorial](https://www.postgresql.org/docs/current/tutorial.html)
- [ ] Backend framework
  - [ ] Node.js
    - [ ] [Express](https://expressjs.com/)
      - [x] [Express web framework - MDN](https://developer.mozilla.org/en-US/docs/Learn/Server-side/Express_Nodejs): [`LocalLibrary` practiced here](https://github.com/khbrst/express-locallibrary-tutorial)
      - [x] [Express Guide](https://expressjs.com/en/guide/routing.html)
      - [x] [Express 4.x - API Reference](https://expressjs.com/en/4x/api.html)
    - [ ] [Sails.js](https://sailsjs.com/)
    - [ ] [Meteor](https://www.meteor.com/)
  - [ ] Java
    - [ ] [Spring](http://spring.io/)
      - [x] [신입 프로그래머를 위한 자바 스프링 (Spring) 프레임워크 강좌 - 인프런](https://www.inflearn.com/course/%ec%9e%90%eb%b0%94-%ec%8a%a4%ed%94%84%eb%a7%81-%ea%b0%95%ec%a2%8c/)
      - [ ] [Spring Framework](https://spring.io/projects/spring-framework)
        - [x] [Core Technologies](https://docs.spring.io/spring-framework/docs/current/spring-framework-reference/core.html)
      - [ ] [Spring Boot](https://spring.io/projects/spring-boot)
  - [ ] Python
    - [ ] [Django](https://www.djangoproject.com/)
      - [ ] [Django Web Framework (Python) - MDN](https://developer.mozilla.org/en-US/docs/Learn/Server-side/Django)
      - [ ] [Getting started | Django documentation](https://docs.djangoproject.com/en/stable/intro)
    - [ ] [Flask](http://flask.pocoo.org/)
- [ ] NoSQL
  - [ ] Key-value
    - [ ] [memcached](https://memcached.org/)
    - [ ] [Redis](https://redis.io/)
      - [x] [Try Redis](http://try.redis.io/)
  - [ ] Document
    - [ ] [MongoDB](https://www.mongodb.com/)
      - [x] [📚 MongoDB in Action - 몽고디비 인 액션](https://books.google.co.kr/books?isbn=9788994506395)
      - [ ] [MongoDB Manual](https://docs.mongodb.com/manual)
        - [ ] [Introduction - MongoDB Manual](https://docs.mongodb.com/manual/introduction)
        - [ ] [The `mongo` Shell - MongoDB Manual](https://docs.mongodb.com/manual/mongo)
        - [ ] [MongoDB CRUD Operations - MongoDB Manual](https://docs.mongodb.com/manual/crud)
    - [ ] [CouchDB](http://couchdb.apache.org/)
  - [ ] Column-Family
    - [ ] [Apache Cassandra](http://cassandra.apache.org/)
  - [ ] Graph databases
    - [ ] [Neo4j](https://neo4j.com/)
  - [ ] [GraphQL](https://graphql.org/)
- [x] Caching
- [x] Creating RESTful APIs
- [ ] Authentication / Authorization
  - [ ] [OAuth](https://oauth.net/) - [RFC 6749](https://tools.ietf.org/html/rfc6749) and [RFC 6750](https://tools.ietf.org/html/rfc6750)
    - [x] [OAuth 2.0 - 생활코딩](https://opentutorials.org/course/3405)
  - [x] [Basic Authentication](https://en.wikipedia.org/wiki/Basic_access_authentication) - [RFC 7617](https://tools.ietf.org/html/rfc7617)
    - [x] [HTTP authentication - MDN](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication)
  - [x] Token Authentication
    - [x] [What is token based authentication? - Stack Overflow](https://stackoverflow.com/questions/1592534/what-is-token-based-authentication)
  - [x] [JWT](https://jwt.io/) - [RFC 7519](https://tools.ietf.org/html/rfc7519)
  - [x] [OpenID](https://en.wikipedia.org/wiki/OpenID)
  - [ ] [OpenID Connect](https://en.wikipedia.org/wiki/OpenID_Connect)
- [ ] Cryptography
  - [x] [Digital signature](https://en.wikipedia.org/wiki/Digital_signature)
  - [ ] [Elliptic-curve cryptography (ECC)](https://en.wikipedia.org/wiki/Elliptic-curve_cryptography)
    - [ ] [Elliptic-curve Diffie–Hellman (ECDH)](https://en.wikipedia.org/wiki/Elliptic-curve_Diffie%E2%80%93Hellman)
    - [ ] [Elliptic Curve Digital Signature Algorithm (ECDSA)](https://en.wikipedia.org/wiki/Elliptic_Curve_Digital_Signature_Algorithm)
- [x] [Message Broker](https://en.wikipedia.org/wiki/Message_broker)
  - [ ] [RabbitMQ](https://www.rabbitmq.com/)
  - [ ] [Apache Kafka](https://kafka.apache.org/)
    - [ ] [Official Documentation](https://kafka.apache.org/documentation/)
- [ ] Search Engine
  - [ ] [Elastic](https://www.elastic.co/)
  - [ ] [Solr](http://lucene.apache.org/solr/)
  - [ ] [Sphinx](http://sphinxsearch.com/)
- [ ] Web Servers
  - [ ] [Apache HTTPd](https://httpd.apache.org/)
  - [ ] [Apache Tomcat](http://tomcat.apache.org/)
  - [ ] [Nginx](https://nginx.org/)
- [ ] [WebSocket](https://en.wikipedia.org/wiki/WebSocket)
- [ ] Profiling
- [ ] Static Analysis
- [ ] [DDD: Domain-driven design](https://en.wikipedia.org/wiki/Domain-driven_design)
- [ ] [SOAP](https://en.wikipedia.org/wiki/SOAP)
- [ ] [Serverless](https://serverless.com/)
- [ ] [Micro Services](https://en.wikipedia.org/wiki/Microservices)
  - [ ] [Microservices.io](https://microservices.io)
    - [ ] [A pattern language for microservices](https://microservices.io/patterns/index.html)
    - [ ] [Architecture patterns](https://microservices.io/patterns/microservices.html)
  - [ ] [Circuit Breaker](https://en.wikipedia.org/wiki/Circuit_breaker_design_pattern)
    - [ ] [Microservices.io article](https://microservices.io/patterns/reliability/circuit-breaker.html)
    - [ ] [Martin Fowler article](https://martinfowler.com/bliki/CircuitBreaker.html)
  - [ ] [API Gateway](https://microservices.io/patterns/apigateway.html)
    - [ ] [Zuul](https://github.com/Netflix/zuul/wiki) - [GitHub](https://github.com/Netflix/zuul)
      - [x] [배민 API GATEWAY - spring cloud zuul 적용기 - 우아한형제들 기술 블로그](http://woowabros.github.io/r&d/2017/06/13/apigateway.html)
    - [x] [API Gateway vs Reverse Proxy - Stack Overflow](https://stackoverflow.com/questions/35756663/api-gateway-vs-reverse-proxy)

## DevOps

- [ ] CI and CD
  - [ ] [Jenkins](https://jenkins.io/)
  - [ ] [Circle CI](https://circleci.com/)
  - [ ] [Travis CI](https://travis-ci.org/)

## References

- [Web developer roadmap](https://github.com/kamranahmedse/developer-roadmap)([번역](https://github.com/devJang/developer-roadmap))
- Basics
  - [Semantic Versioning](https://semver.org/)
  - [Git](https://git-scm.com/)
    - [How to Write a Git Commit Message](https://chris.beams.io/posts/git-commit/)([번역](https://item4.github.io/2016-11-01/How-to-Write-a-Git-Commit-Message/))
  - Documentation
    - [What nobody tells you about documentation - Blog - Divio](https://www.divio.com/blog/documentation/)([번역](http://blog.weirdx.io/post/60414))
- Trends
  - [Google Trends](https://trends.google.com/trends)
  - [Stack Overflow Annual Developer Survey](https://insights.stackoverflow.com/survey)
  - Database
    - [DB-Engines Ranking](https://db-engines.com/en/ranking) and [history](https://db-engines.com/en/ranking_trend)([Method of calculating the scores](https://db-engines.com/en/ranking_definition))
    - [MariaDB vs. MySQL vs. PostgreSQL Comparison](https://db-engines.com/en/system/MariaDB%3BMySQL%3BPostgreSQL)
  - Web
    - [HotFrameworks](http://hotframeworks.com/)
- Standards
  - ECMAScript
    - [Standard ECMA-262](http://www.ecma-international.org/publications/standards/Ecma-262.htm)
    - [ECMAScript 6 compatibility table](http://kangax.github.io/compat-table/es6/)
- Blog & Community
  - [The Clean Code Blog by Robert C. Martin (Uncle Bob)](https://blog.cleancoder.com/)
  - Rust
    - [한국 러스트 사용자 그룹 - Facebook](https://www.facebook.com/groups/rustlang/)
- Tutorial & Training
  - [Find the Best Programming Courses & Tutorials - Hackr.io](https://hackr.io/)
  - [Exercism](https://exercism.io)
  - [Google Developers Training](https://developers.google.com/training/)
  - Open Source
    - [First Contributions](https://firstcontributions.github.io/)
  - C Programming Language
    - [c-faq](http://c-faq.com/)
  - [Rust Programming Language - Official site](https://www.rust-lang.org)
    - [Rust Documentation](https://www.rust-lang.org/en-US/documentation.html)([한글](https://www.rust-lang.org/ko-KR/documentation.html)) and [another documentation index](https://doc.rust-lang.org/)
      - Learn Rust
        - [Book](https://doc.rust-lang.org/book/)
          - [1판 한글 번역](https://www.penflip.com/sarojaba/rust-doc-korean)
          - [2판 한글 번역](https://rinthel.github.io/rust-lang-book-ko/)([GitHub](https://github.com/rinthel/rust-lang-book-ko))
        - [Rust by Example](https://doc.rust-lang.org/rust-by-example/index.html)([GitHub](https://github.com/rust-lang/rust-by-example))
        - [Frequently Asked Questions](https://www.rust-lang.org/en-US/faq.html)([한글](https://www.rust-lang.org/ko-KR/faq.html))
        - [rust-learning](https://github.com/ctjhoa/rust-learning)
      - Use Rust
        - [Rust Cookbook](https://rust-lang-nursery.github.io/rust-cookbook/)
        - [The Standard Library](https://doc.rust-lang.org/std/index.html)
        - [The Rustc Book](https://doc.rust-lang.org/rustc/index.html)
        - [The Cargo Book](https://doc.rust-lang.org/cargo/index.html)
        - [The Rustdoc Book](https://doc.rust-lang.org/rustdoc/index.html)
        - [Rust Compiler Error Index](https://doc.rust-lang.org/error-index.html)
      - Master Rust
        - [The Reference](https://doc.rust-lang.org/reference/index.html)
        - [The Rustonomicon](https://doc.rust-lang.org/nomicon/index.html)
        - [The Unstable Book](https://doc.rust-lang.org/unstable-book/index.html)
    - Development environment
      - [Rust development using VS Code on OS X, debugging included.](https://medium.com/@royalstream/rust-development-using-vs-code-on-os-x-debugging-included-bc10c9863777): (VS Code + Rusty Code + Native Debug) + (Rust + Racer + GDB)
      - [Visual Studio Code를 이용한 Rust 개발환경 꾸며보기 - Rinthel's note](https://rinthel.github.io/2017/08/20/rust-vscode-macos/): (VS Code + Rusty Code(rls) + Native Debug) + (Rust + GDB)
      - [Debugging Rust programs with lldb on MacOS](https://bryce.fisher-fleig.org/blog/debugging-rust-programs-with-lldb/index.html): Rust + LLDB
  - Web
    - [Web | Google Developers](https://developers.google.com/web/)
    - [The Front-End Checklist](https://frontendchecklist.io/) - [GitHub](https://github.com/thedaviddias/Front-End-Checklist)([번역](https://github.com/kesuskim/Front-End-Checklist))
    - [How Browsers Work: Behind the scenes of modern web browsers](https://www.html5rocks.com/en/tutorials/internals/howbrowserswork/)([번역](https://d2.naver.com/helloworld/59361))
    - [HTTP Documentation](http://httpwg.org/specs/)
    - [NAVER D2](https://d2.naver.com/home)
      - [2018년과 이후 JavaScript의 동향 - JavaScript(ECMAScript)](https://d2.naver.com/helloworld/7495331)
      - [2018년과 이후 JavaScript의 동향 - 라이브러리와 프레임워크](https://d2.naver.com/helloworld/3259111)
      - [2018년과 이후 JavaScript의 동향 - 브라우저 밖의 JavaScript](https://d2.naver.com/helloworld/5644368)
    - [Crash-only software - Wikipedia](https://en.wikipedia.org/wiki/Crash-only_software)
    - [The Node.js Way - Understanding Error-First Callbacks](http://fredkschott.com/post/2014/03/understanding-error-first-callbacks-in-node-js/)
    - Web security
      - [Web security exploits - Wikipedia](https://en.wikipedia.org/wiki/Category:Web_security_exploits)
      - [Category:Attack - OWASP](https://www.owasp.org/index.php/Category:Attack)
      - [Security Cheat Sheet - OWASP](https://www.owasp.org/index.php/OWASP_Cheat_Sheet_Series)
      - [Fork bomb - Wikipedia](https://en.wikipedia.org/wiki/Fork_bomb)
      - [Path Traversal - OWASP](https://www.owasp.org/index.php/Path_Traversal)
      - SQL Injection
        - [Testing for NoSQL Injection - OWASP](https://www.owasp.org/index.php/Testing_for_NoSQL_injection)
      - Regular Expression
        - [Regular expression Denial of Service - ReDoS](https://www.owasp.org/index.php/Regular_expression_Denial_of_Service_-_ReDoS)
        - [Regular Expression Library](http://www.regexlib.com/)
- Projects & Packages
  - Serialization
    - [Protocol Buffers](https://developers.google.com/protocol-buffers/)([GitHub](https://github.com/protocolbuffers/protobuf))
  - Node.js
    - [Awesome Node.js](https://github.com/sindresorhus/awesome-nodejs)
    - Rust
      - [The Neon Project](https://www.neon-bindings.com/)([GitHub](https://github.com/neon-bindings/neon))
    - TypeScript
      - [ts-node](https://github.com/TypeStrong/ts-node)
    - Editor
      - [Monaco Editor](https://microsoft.github.io/monaco-editor/) - [GitHub](https://github.com/Microsoft/monaco-editor)
    - Project configuration
      - [rc](https://www.npmjs.com/package/rc)
      - [nconf](https://www.npmjs.com/package/nconf)
      - [config](https://www.npmjs.com/package/config)
      - [Browserslist](https://github.com/browserslist/browserslist)
    - Web frameworks
      - [Node.js frameworks](http://nodeframework.com/)
    - Web security
      - [Retire.js](http://retirejs.github.io/retire.js/)
      - [express-rate-limit](https://www.npmjs.com/package/express-rate-limit)
      - [express-brute](https://www.npmjs.com/package/express-brute)
      - [bcrypt](https://www.npmjs.com/package/bcrypt)
      - [helmet](https://www.npmjs.com/package/helmet)
      - [escape-html](https://github.com/component/escape-html)
      - [node-esapi](https://github.com/ESAPI/node-esapi)
      - Regular Expression
        - [safe-regex](https://github.com/substack/safe-regex)
        - [node-re2](https://github.com/uhop/node-re2)
        - [RE2](https://github.com/google/re2)
        - [ip-regex](https://www.npmjs.com/package/ip-regex)
      - JSON
        - [JSONStream](https://www.npmjs.com/package/JSONStream)
        - [Big-Friendly JSON](https://gitlab.com/philbooth/bfj)
    - Authentication / Authorization
      - [passport](http://www.passportjs.org/)
      - [express-jwt](https://github.com/auth0/express-jwt)
    - Database
      - SQL query builder
        - [Knex](https://github.com/tgriesser/knex)
      - ORM
        - [TypeORM](https://github.com/typeorm/typeorm)
        - [sequelize](https://github.com/sequelize/sequelize)
        - [Objection.js](https://github.com/Vincit/objection.js)
        - [waterline](https://github.com/balderdashy/waterline)
      - ODM
        - [mongoose](https://github.com/Automattic/mongoose)
    - Promise
      - [async](https://www.npmjs.com/package/async)
      - [bluebird](https://www.npmjs.com/package/bluebird)
    - Restarter
      - [forever](https://www.npmjs.com/package/forever)
      - [pm2](https://www.npmjs.com/package/pm2)
    - Logger
      - [winston](https://www.npmjs.com/package/winston)
      - [log4j](https://www.npmjs.com/package/log4js)
      - [pino](https://www.npmjs.com/package/pino)
    - [Validators](https://www.npmjs.com/search?q=validator)
    - Code Style
      - [ESLint](https://eslint.org/)
      - [prettier](https://www.npmjs.com/package/prettier)
      - [js-beautify](https://www.npmjs.com/package/js-beautify)
    - Code Coverage
      - [Istanbul](https://github.com/gotwarlost/istanbul)
  - Rust
    - [Awesome Rust](https://github.com/rust-unofficial/awesome-rust)
    - [Rust OS Projects](https://wiki.osdev.org/Rust)
    - Mobile
      - [Rust on Android](https://github.com/tomaka/android-rs-glue)
      - [Rust on iOS](https://www.bignerdranch.com/blog/building-an-ios-app-in-rust-part-1/)
    - Web
      - [Are we web yet? - Rust](https://www.arewewebyet.org/)
      - [The Neon Project](https://www.neon-bindings.com/)([GitHub](https://github.com/neon-bindings/neon)): Rust + Node.js
      - [The Rusty Web](https://davidmcneil.gitbooks.io/the-rusty-web/)(Experimental: [WebAssembly](https://webassembly.org/) and [asm.js](http://asmjs.org/))
  - Lua
    - [LuaRocks](https://luarocks.org/)
- Tools & Services
  - Terminal
    - [Tmux](https://github.com/tmux/tmux)
      - [.tmux (Oh My Tmux)](https://github.com/gpakosz/.tmux)
  - Unix Shell
    - [Zsh](http://www.zsh.org/)  
      - [Oh My Zsh](https://ohmyz.sh/) - [GitHub](https://github.com/robbyrussell/oh-my-zsh)
  - Declarative provisioning
    - [Chef](https://www.chef.io/chef/)
    - [Puppet](https://puppet.com/)
  - Light-weight virtual environment
    - [Docker](https://www.docker.com/)
    - [Vagrant](https://www.vagrantup.com/)
    - [Kubernetes](https://kubernetes.io/)
  - Database
    - [Online SQL interpreter](https://kripken.github.io/sql.js/GUI/)
    - [SQL Fiddle](http://sqlfiddle.com/)
    - MongoDB
      - [Top 10 MongoDB Hosting You Can Try for Free (or Cheap)](https://studio3t.com/whats-new/cheap-free-mongodb-hosting/)
      - [Atlas](https://cloud.mongodb.com)
      - [mLab](https://mlab.com/)
      - [Mongo Clusters](https://www.mongoclusters.com)
  - Cloud computing
    - [AWS: Amazone Web Services](https://aws.amazon.com/)
    - [GCP: Google Cloud Platform Console](https://console.cloud.google.com/)
    - [Microsoft Azure](https://azure.microsoft.com/)
    - [Heroku](https://www.heroku.com/)
    - [Cloud Foundary](https://www.cloudfoundry.org/)
    - [PWS: Pivotal Web Services](https://run.pivotal.io/)
    - [Digital Ocean](https://www.digitalocean.com/)
    - [Envoy Proxy](https://www.envoyproxy.io/)
  - Distributed computing
    - [Apache ZooKeeper](https://zookeeper.apache.org/)
  - CDN
    - [UNPKG](https://unpkg.com/)
  - Load Balancer & Reverse Proxy
    - [Nginx](https://nginx.org/)
    - [HAProxy](http://www.haproxy.org/)
  - Documentation
    - Online Editor
      - [StackEdit](https://stackedit.io)
      - [CodeSandbox](https://codesandbox.io/)
      - [StackBlitz](https://stackblitz.com/)
    - Inforgraphics
      - [Inforgram](https://infogram.com)
    - API
      - [Swagger](https://swagger.io/)
  - Testing
    - [Postman](https://www.getpostman.com/)
    - [Selenium](https://www.seleniumhq.org/)
    - [ngrok](https://ngrok.com/)
  - Validation & Lint
    - [Markup Validation Service - W3C](https://validator.w3.org)
    - [ESLint](https://eslint.org/)
    - [CSS Lint](http://csslint.net/)
  - Benchmark
    - [PageSpeed Insights](https://developers.google.com/speed/pagespeed/insights/)
  - Code Coverage
    - [Codecov](https://codecov.io/)
  - CI
    - [Jenkins](https://jenkins.io/)
    - [Circle CI](https://circleci.com/)
    - [Travis CI](https://travis-ci.org/)
  - Web security
    - [git-secrets](https://github.com/awslabs/git-secrets)
    - [npm audit](https://docs.npmjs.com/cli/audit)
    - [snyk](https://snyk.io/)
    - [OWASP Dependency Check](https://www.owasp.org/index.php/OWASP_Dependency_Check)
    - [Greenkeeper](https://greenkeeper.io/)
  - Static analysis
    - [Awesome Static Analysis](https://matthias-endler.de/awesome-static-analysis/)
    - [SonarQube](https://www.sonarqube.org/)
    - [Code Climate](https://codeclimate.com/)
  - Monitoring
    - [AWS CloudWatch](https://aws.amazon.com/ko/cloudwatch/)
    - [Google Stackdriver](https://cloud.google.com/stackdriver/)
    - [Elastic stack](https://www.elastic.co/kr/products)
    - Error
      - [Sentry](https://sentry.io/)
      - [Rollbar](https://rollbar.com/)
      - [Raygun](https://raygun.com/)
  - Application Performance Management(APM)
    - Website or API monitoring
      - [Pingdom](https://www.pingdom.com/)
      - [Uptime Robot](https://uptimerobot.com/)
      - [New Relic](https://newrelic.com/application-monitoring)
    - Code instrumentation
      - [New Relic](https://newrelic.com/application-monitoring)
      - [App Danymics](https://www.appdynamics.com/)
    - Operational intelligence dashboard
      - [Datadog](https://www.datadoghq.com/)
      - [Splunk](https://www.splunk.com/)
      - [Zabbix](https://www.zabbix.com/)
