# Keybindings

This page contains all keybindings added by Stardew Access.
All keybindings may be modified in the config except for escape (esc).

## Table Of Contents

- [Global Keys](#global-keys)
- [Tile Viewer Keys](#tile-viewer-keys)
- [Chat Menu keys](#chat-menu-keys)
- [New Game or Character Customization Menu Keys](#new-game-or-character-customization-menu-keys)
- [Menus With Inventory Keys](#menus-with-inventory-keys)
- [Junimo Note or Community Center Menu Keys](#junimo-note-or-community-center-menu-keys)
- [Primary Info Key](#primary-info-key)
- [Other Pages](#other-pages)

## Global Keys

| Key                  | Description                                                                                                                                          |
|----------------------|------------------------------------------------------------------------------------------------------------------------------------------------------|
| left ctrl + enter | primary left mouse click                                                                                                             |
| left shift + enter   | primary right mouse click                                                                                                            |
| [                     | secondary left mouse click                                                                                                           |
| ]                    | secondary right mouse click                                                                                                          |
| h                    | narrate health and stamina                                                                                                                          |
| left alt + k         | narrate current map                                                                                                                       |
| k                    | narrate current coordinates.                                                                                                                             |
| q                    | narrate time, date, and season                                                                                                    |
| r                    | Narrate current money -- additional currency info when used in the inventory menu  |
| left alt + j         | narrate the tile the player is standing on                                                                                     |
| j                    | narrate the tile the player is facing                                                                                      |
| c                    | primary info key -- see [Primary Info Key](#primary-info-key) for details                                                              |
| esc| closing menus -- stop interacting with text boxes                                                                                                    |

## Tile Viewer Keys

| Key                      | Description                                                                             |
|--------------------------|-----------------------------------------------------------------------------------------|
| l                        | toggle relative cursor lock |
| left ctrl + enter     | move the player to the focused tile                                                                   |
| left shift + enter       | open the Tile Info Menu for the focused tile                                            |       
| arrow up                 | move the tile cursor one tile up                                                             |
| arrow right              | move the tile cursor one tile right                                                          |
| arrow down               | move the tile cursor one tile down                                                           |
| arrow left               | move the tile cursor one tile left                                                           |
| left shift + arrow up    | move the tile cursor up pixel by pixel                                    |
| left shift + arrow right | move the tile cursor right pixel by pixel                                 |
| left shift + arrow down  | move the tile cursor down pixel by pixel                                  |
| left shift + arrow left  | move the tile cursor left pixel by pixel                                  |

## Grid Movement Keys

| Key          | Description                      |
|--------------|----------------------------------|
| i            | Toggle grid movement             |
| left ctrl | disable grid movement while held |

## Object Tracker Keys

| Key                    | Description                                                   |
|------------------------|---------------------------------------------------------------|
| left ctrl + pageUp | previous category                                             |
| left ctrl + pageDown | next Category                                           |
| pageUp                 | previous object                                               |
| pageDown               | next Object                                             |
| left ctrl + home     | move to the selected object.                        |
| home                   | narrate info about the selected object                |
| end                    | narrate info about the selected objects tile location |
| esc| stop walking to a selected tile or object                                   |
| ~                  | toggle between alphabetical and proximity object sorting                      |
| alt + 1 | object tracker favorite slot 1 info |
| alt + 2 | object tracker favorite slot 2 info |
| alt + 3 | object tracker favorite slot 3 info |
| alt + 4 | object tracker favorite slot 4 info |
| alt + 5 | object tracker favorite slot 5 info |
| alt + 6 | object tracker favorite slot 6 info |
| alt + 7 | object tracker favorite slot 7 info |
| alt + 8 | object tracker favorite slot 8 info |
| alt + 9 | object tracker favorite slot 9 info |
| alt + 0 | object tracker favorite slot 10 info |
| alt + double-tap 1 | Set object tracker favorite slot 1 -- travel to slot 1 if already set |
| alt + double-tap 2 | Set object tracker favorite slot 2 -- travel to slot 2 if already set |
| alt + double-tap 3 | Set object tracker favorite slot 3 -- travel to slot 3 if already set |
| alt + double-tap 4 | Set object tracker favorite slot 4 -- travel to slot 4 if already set |
| alt + double-tap 5 | Set object tracker favorite slot 5 -- travel to slot 5 if already set |
| alt + double-tap 6 | Set object tracker favorite slot 6 -- travel to slot 6 if already set |
| alt + double-tap 7 | Set object tracker favorite slot 7 -- travel to slot 7 if already set |
| alt + double-tap 8 | Set object tracker favorite slot 8 -- travel to slot 8 if already set |
| alt + double-tap 9 | Set object tracker favorite slot 9 -- travel to slot 9 if already set |
| alt + double-tap 0 | Set object tracker favorite slot 10 -- travel to slot 10 if already set |
| alt + triple-tap 1 | clear object tracker favorite slot 1 |
| alt + triple-tap 2 | clear object tracker favorite slot 2 |
| alt + triple-tap 3 | clear object tracker favorite slot 3 |
| alt + triple-tap 4 | clear object tracker favorite slot 4 |
| alt + triple-tap 5 | clear object tracker favorite slot 5 |
| alt + triple-tap 6 | clear object tracker favorite slot 6 |
| alt + triple-tap 7 | clear object tracker favorite slot 7 |
| alt + triple-tap 8 | clear object tracker favorite slot 8 |
| alt + triple-tap 9 | clear object tracker favorite slot 9 |
| alt + triple-tap 0 | clear object tracker favorite slot 10 |
| alt + - | previous stack of object tracker favorites |
| alt + = | next stack of object tracker favorites |

## Chat Menu keys

Active when the chat window is opened with `t`

| Key                       | Description                                                                                                            |
|---------------------------|------------------------------------------------------------------------------------------------------------------------|
| pageUp                   | Read previous chat message                                                                                             |
| pageDown                 | Read next chat message                                                                                                 |
| left alt + (1-9)  | read previous chat message in order of age      |
| right alt + (1-9) | read previous notifications in order of age |

## New Game or Character Customization Menu Keys

These keys are used in the context of the character creation/new game menu.

| Key                  | Description                                |
|----------------------|--------------------------------------------|
| right arrow          | move to next element                        |
| left arrow           | move to previous element                    |
| left ctrl + space | Toggle displaying character design options |
| up arrow             | increase control value by 1             |
| pageUp              | increase control value by 10            |
| down arrow           | decrease control value by 1             |
| pageDown            | decrease control value by 10            |
| esc | stop interacting with a text box |

## Menus With Inventory Keys

This includes menus such as shop menus and chest menus.

| Key            | Description                                                          |
|----------------|----------------------------------------------------------------------|
| i              | select first item in the crafting/chest/shop menu |
| left shift + i | select first item in the player's inventory                      |

## Junimo Note or Community Center Menu Keys

| Key                 | Description                                                  |
|---------------------|--------------------------------------------------------------|
| i  | next item in a bundle |
| left shift + i | previous item in a bundle |
| c  | next item in player inventory            |
| left shift + c | previous item in player inventory |
| v | next ingredient slot in bundle                     |
| left shift + v | previous item slot in bundle |
| p                   | Move the mouse cursor to the purchase button                     |
| backspace           | Move the mouse cursor to the back button                         |

## Primary Info Key

`c` by default is used in several menus. They are as follows:

| Menu             | Usage                                      |
|------------------|--------------------------------------------|
| Crafting Menu | move to the next available recipe |
| Construction Menu   | Speak the info about the current blueprint |
| Animal Info Menu | Speak the animal's detail                  |
| Museum Menu      | Donate focused item              |
| Fish Pond Menu   | Speak info about the selected pond                   |
| Quest Menu       | Speak current quest info                   |

## Other Pages

- [Readme](README.md)
- [Setup](setup.md)
- [Features](features.md)
- [Commands](commands.md)
- [Configs](config.md)
- [Guides](guides/guides-home.md)
