# Mining

Mining is the main method of collecting many of the resources required to craft items, upgrade your tools, and power machinery. Mining is primarily done in the mines in the mountains, however there are other locations which will unlock later in the game such as the Skull Caverns. You may encounter monsters and obstacles while mining, and you must defend yourself in order to grab those precious ores.

The guides on this page build on each other. Information in the section about the mines is still relevant to later sections, such as exploration and use of the object tracker.

## Table of Contents
- [Mining Basics](#mining-basics)
- [Suggested Mods](#suggested-mods)
- [Object Tracker Configuration Options](#object-tracker-configuration-options)
- [The Mines](#the-mines)
    - [Accessing the Mines](#accessing-the-mines)
    - [Navigating The Mines](#navigating-the-mines)
- [Adventurer's Guild](#adventurers-guild)
    - [Lost Your Stuff?](#lost-your-stuff)
- [Quarry Mine](#quarry-mine)
- [The Skull Cavern](#the-skull-cavern)
    - [Accessing the Skull Cavern](#accessing-the-skull--cavern)
- [Other Guides](#other-guides)

## Mining Basics

To break rocks and mine metals, you'll need your pickaxe that you started with. The act of mining itself is exactly the same as clearing rocks on your farm, that is you face the rock or ore you want to mine, select your pickaxe, and press your tool key. Some items will require multiple pickaxe swings. To make mining easier, you can visit clint at the blacksmith in town to upgrade your pickaxe as you collect the necessary resources to do so.

Keep in mind that mining, like most other activities, consumes your energy. It is difficult to keep track of your energy without sight. Stardew Access will announce your energy as a percentage at preset consumption intervals. Pay attention to the warnings, especially in the early game when you have very low total energy.

## Suggested Mods

The mods in this section are not required to mine, but they can help make the experience less daunting.

- [autoMeleeAttack](https://www.nexusmods.com/stardewvalley/mods/20704): a mod to automatically attack the nearest enemy to you
- [Heartbeat](https://www.nexusmods.com/stardewvalley/mods/5941): a more noticeable indicator that your health is low
- [Personal Combat Drone Redux](https://www.nexusmods.com/stardewvalley/mods/18224): a drone that you can toggle on and off to farm and mine in peace
- [Time Master](https://www.nexusmods.com/stardewvalley/mods/20847): a highly customizable mod that lets you pause time and adjust time speed in single-player or multi-player (must be run by host to work in multi-player)

## Object Tracker Configuration Options

By default, the object tracker will provide descriptions for the various stones that you will come across. It will also give specific colors of slimes. Some users may find these descriptions overwhelming. They can be turned off in the [config](../config.md) if desired.

## The Mines

With exception to farm maps such as the Hilltop Farm and Four Corners Farm, the first place you will gain access to mineable resources is in the mines in the mountains. This guide will focus on navigating the mines as a Stardew Access player. You can read general info on [the mines wiki page](https://stardewvalleywiki.com/The_Mines).

- [Accessing the Mines](#accessing-the-mines)
- [Navigating The Mines](#navigating-the-mines)
- [back to top](#mining)

### Accessing The Mines

The mines will open on day 5 of spring year 1 once Joja clears the rockslide blocking the entrance. The first time you enter, you will meet Marlin in a cutscene where he gives you your first weapon: a rusty sword. Once you have entered, you will find several doors, items, and the dwarf. You cannot yet speak to the dwarf as she is behind a boulder. There is an elevator, but it is not yet functional. Head to the down ladder and use it to enter the first level of the mines.

### Navigating The Mines

Mine levels are randomly-generated each day that you enter. The layouts are irregular and can be disorienting. The best way to get around is a combination of exploration and the [object tracker](stardew-access-guides.md#object-tracker) to traverse each level successfully.

Walk around and explore. Pay attention to your footsteps to find walls. Use the object tracker to navigate to specific items. You may frequently find that the object tracker cannot find a path to the item you want to reach. This is usually due to another item, such as a stone or weeds, blocking the only path. In these cases, exploration will yield the best results.

A ladder has a chance of appearing after breaking a rock. Some levels may already have a down ladder available to continue on to the next level. You may also encounter an infested level which will not reveal a down ladder until all monsters are killed. Stardew Access will announce an infested level when you enter.

Certain levels will have a Minecart or bag that will provide coal once per day. Items like these will be under the "other" category. Every 5 levels will unlock a new elevator floor, giving you a checkpoint you can return to next time. Every 10 levels (except 30 for some reason) will also have a reward inside of a chest.


## Adventurer's Guild

While the [Adventurer's Guild](https://stardewvalleywiki.com/Adventurer%27s_Guild) located in the mountains is not strictly part of the mining experience, it is worth knowing about. Once you gain access to it, you can purchase weapons and defense items as well as recover items that you may lose if you pass out while mining.

### Lost Your Stuff?

You will probably pass out in the mines at some point. If this happens, another citizen of Pelican Town will drag you back up and revive you. Unfortunately, you will likely lose some money and items in the process. Head to the Guild where you can pay Marlin to find your items and send them to you in the mail.
Be careful. If you pass out in the mines before gaining access to the guild, you may find yourself in the hilariously enraging situation where you lose your sword and cannot recover it because you do not yet have access to the guild which makes it much harder to kill monsters which you need to do in order to access the guild to recover your sword which you cannot do because you... In this situation, you can either use your scythe as a makeshift weapon to kill monsters, or you can quit the game before going to sleep to discard that day's progress.

## Quarry Mine

[The Quarry Mine](https://stardewvalleywiki.com/Quarry_Mine) will become available after completing the Craftsroom bundle in the community center. Unlike the mines or skull cavern, the quarry mine only has one level and resets once per day instead of once per visit. Reaching the grim reaper statue and getting the [golden scythe](https://stardewvalleywiki.com/Golden_Scythe) is the primary goal.

Navigating the quarry mine will rely almost entirely on exploration as the path to the statue is blocked by several obstacles. The object tracker can help you make it through. There is a long passage to the west which can be explored and mined.

## The Skull Cavern

[The Skull Cavern](https://stardewvalleywiki.com/Skull_Cavern) will become accessible once you reach the bottom of the mines and gain access to the desert. It presents many of the same navigation challenges as the mines, but there is no elevator, infinite levels, and it is much more difficult. Besides the difficulty and lack of elevator, there is one key difference: you now have a chance of finding either a down ladder which takes you down 1 level as usual or a shaft which will take you down several levels at a time. The deeper you go, the more valuable loot you will find. Be wary of the monsters here. They are much more dangerous than in the mines.

- [Accessing the Skull Cavern](#accessing-the-skull--cavern)
- [back to top](#mining)

### Accessing the Skull  cavern

The Skull Cavern can only be accessed when you have both reached the bottom of The Mines and gained access to the desert by repairing the bus. The latter can be accomplished either by completing the vault bundle in the community center or purchasing the Joja community improvement form.

Once in the desert, proceed to "skull cave entrance" and then to "skull cavern door". The first time you access the skull cavern, your farmer will insert the skull key into the lock on the door. Close the dialogue and interact with the door once again. You will enter the skull cavern. Good luck.

<!--todo: volcano dungeon-->

## Other guides

- [Stardew Access Guides](stardew-access-guides.md)
- [General Guides](general-guides.md)
- [Farming Guides](farming-guides.md)

**[Back to guides home](guides-home.md)

**[Back to readme...](../README.md)**
