# Farming

Farming, including planting and harvesting crops, is the primary way to make money in Stardew Valley, especially in the early-game. The following guides will cover how to farm.

## Table of Contents

- [Crops](#crops)
    - [Planting Crops](#planting-crops)
    - [Growing Crops](#growing-crops)
    - [Harvesting Crops](#harvesting-crops)
- [Farm Buildings](#farm-buildings)
    - [Constructing Farm Buildings](#constructing-farm-buildings)
    - [Upgrading Farm Buildings](#upgrading-farm-buildings)
    - [Moving Farm Buildings](#moving-farm-buildings)
    - [Demolishing Farm Buildings](#demolishing-farm-buildings)
- [Farm Animals](#farm-animals)
    - [Purchasing Farm Animals](#purchasing-farm-animals)
    - [Moving Farm Animals](#moving-farm-animals)
    - [Other Guides](#other-guides)

## Crops

The following guides all cover planting and growing crops.

- [Planting Crops](#planting-crops)
- [Growing Crops](#growing-crops)
- [Harvesting Crops](#harvesting-crops)
- [back to top]( #farming)

### Planting Crops

Once you have purchased seeds from Pierre's general store in the town (a.k.a) SeedShop) or otherwise obtained seeds, go to your farm and use your tools to clear a plot of land to plant them. Make sure to clear grass as well.
Your scythe does not consume any of your energy. Once you have cleared sufficient land to plant your crops, use your hoe to till the soil.
Next, use your watering can to water the soil and add any [fertilizer](https://stardewvalleywiki.com/Fertilizer) if desired to the soil.
finally, place your crops in the soil. You may plant your crops before watering, but fertilizers **must** be placed before the crop is placed.
Tilling individual tiles can be very tedious, so be sure to check Clint's shop in the town (a.k.a Blacksmith) for tool upgrades. Once you upgrade your hoe, you can hold down `tool button` and hoe several tiles at a time.

### Growing crops

Different crops will take different amounts of time to grow. Most crops will only grow during one season, however they will grow during any season in the greenhouse. Growing season and growing time are listed in Pierre's shop as well as on the item's tooltip in your inventory.
Each season is 28 days long, and it's important to ensure your crop has enough time to grow. If your crop has not been harvested before the start of the next season, it will die unless it also grows in the new season. Most crops only grow in one season. It's important to water your crop daily. Unwatered crops will not die, but they will not grow that day.
Each day has a chance of rain. If it rains, there is no need to water your crops as the rain will take care of it. Crops grown indoors or in the greenhouse must be watered regardless of rain. Check the TV in your farmhouse for next day's forecast.
You can walk over most crops safely with the exception of crops that grow on a trellis. You cannot pass through trellis crops at all, so make sure you leave enough room to reach them.
Some crops, such as green beans, hot peppers, and blueberries, will produce multiple harvests per crop. Once they mature, you can pick the first harvest and continue watering the crops daily as normal and producing more harvests until the end of the season.
Lastly, you may craft [sprinklers](https://stardewvalleywiki.com/Sprinkler) in order to keep crops watered. There are several tiers of sprinklers which keep progressively more tiles watered.

### Harvesting Crops

To harvest a mature crop, walk up to the crop and press `action button` to harvest it. The tile will be emptied and another crop may be placed. If the crop produces multiple harvests, the crop will remain on the tile and you can continue to water it as normal.
Be careful that you do not use your pickaxe on crops as doing so will destroy them, undoing all your hard work.

## Farm Buildings

The following guides are all related to constructing and managing buildings on your farm such as coops, silos, barns, and more. All of them are accomplished through the construction menu in Robin's shop in the mountains. This shop is labeled as "ScienceHouse" in-game. Enter Robin's shop during business hours and select "construct farm buildings" from the shop counter menu to find a list of building blueprints and construction options.

- [Constructing Farm Buildings](#constructing-farm-buildings)
- [Upgrading Farm Buildings](#upgrading-farm-buildings)
- [Moving Farm Buildings](#moving-farm-buildings)
- [Demolishing Farm Buildings](#demolishing-farm-buildings)
- [back to top](#farming)

### Constructing Farm Buildings

To construct a building on your farm, first decide where you want to build it and ensure that there is no debris in the area. The [tile cursor](#using-the-tile-viewer) is very helpful for accomplishing this. Different buildings will occupy different amounts of space on your farm. Check Robin's shop for more info.
Once you have decided where you want your building to be and cleared debris from the area, collect the necessary materials for construction and ensure you have enough money. Go to Robin's shop, select "construct farm buildings" from the shop counter dialogue, and use the controls in the new menu to select the desired farm building to construct. To repeat information about the currently-selected building in this menu, press `C`.
Once you have selected the building you want to construct, click "construct". A map of your farm will appear on screen.
Use the arrow keys to focus on the coordinate where you want to place the building. As you move the tile cursor around, the map will scroll when the cursor reaches the edge of the portion of the map that is visible on screen. This will result in the tile cursor appearing to move too far as the map scrolls beneath it.
The map will continue scrolling until you move the tile cursor away from the edge of the screen or until the map scrolls all the way to a map edge. To scroll the map a small amount, you must move the tile cursor back and forth to "nudge" the map forward. If you think this is terrible, sighted players agree with you.
Once you are focused on the tile you want to select, use left mouse click to place the building for construction. If the building cannot be constructed, nothing will happen. If the building can be constructed, Robin will speak to you and inform you that she will begin work the next day (unless the next day has a festival, in which case she will begin work the day after tomorrow).
During construction, you will find Robin on your farm hard at work and you will be unable to construct additional buildings or upgrade your house. It will take several days for Robin to construct the farm building.
Note: the tile you select will be the top-left corner of the building. For example, if you are building a silo which is 3 tiles by 3 tiles, select the tile at the very top-left of the 3x3 area you have prepared. If you select X:64, Y:21, the silo will occupy a footprint from X:64, Y:21 to X:67, Y:24.

**If you cannot place your building where you want**, ensure the following are all true:

1. you have enough money to construct the desired building
2. you have enough resources in your inventory to construct the building
3. The area you have selected is *completely clear* of **all** debris
4. There are no other buildings or items overlapping the building you are attempting to construct
5. You are selecting the correct tile (Remember, you are placing the building from the top-left corner) and map scrolling can move you to an undesired tile

### Upgrading Farm Buildings

The barn, shed, and coop farm buildings can be upgraded. Doing this involves many of the same steps as constructing a new farm building, however instead of placing a new building on your farm, you must select an existing building that can be upgraded.
The coop and barn must both be upgraded in their own specific orders, but they have similar names: coop and barn, big coop and big barn, deluxe coop and deluxe barn. The shed only has one upgrade option, "big shed".
As an example: to upgrade a regular coop, select "big coop" from the construction menu. To upgrade a big barn, select "deluxe barn" from the construction menu. You cannot skip upgrade stages.
Once you enter the map interface, place the tile cursor over any portion of the building you want to upgrade and use left mouse click. If successful, Robin will tell you that she will begin work on the upgrade the next day. It will take several days to upgrade the building. Unlike constructing a new building, Robin will be inside the building while she upgrades it. Like constructing a new building, you will not be able to construct any other buildings or upgrade your house while Robin works.

### Moving Farm Buildings

To move a farm building, select "move building" from the construction menu. The currently-selected blueprint does not matter. Once in the map interface, move the tile cursor onto any portion of the building you want to move and use left mouse click.
You will hear a sound once you have successfully selected a building. From this point, the directions are identical to [constructing a new farm building](#constructing-farm-buildings).
Move the tile cursor to the new desired location. The area must be free of debris, items, and other buildings in order to move the selected building. Left mouse click to place the building down. When successful, you will hear another sound and you will be returned to the shop. You do not have to wait any time for your buildings to be moved.

**Important:** Regardless of which portion of the building you select, you will place the building down from its top left corner. For example: if you select the center tile of a silo and then place it down at X:64, Y:21, the silo will occupy a footprint from X:64, Y:21 to X:67, Y:24 regardless of which part of the silo you initially selected.

<!--painting farm buildings. Not yet accessible-->

### Demolishing Farm Buildings

To demolish a farm building, select "demolish building" from the construction menu. The currently-selected blueprint does not matter. Once in the map interface, use the tile cursor to select any portion of the building you want to demolish. There will be no confirmation dialogue, so make sure you actually want to demolish a building before selecting it. If successful, you will hear an explosion sound and be returned to the shop. The building has now been demolished.

## Farm Animals

The following guides provide instructions on how to purchase and move farm animals. This feature currently relies on console commands.

<!--todo: update docs once accessible feature is implemented in-game-->

- [Purchasing Farm Animals](#purchasing-farm-animals)
- [Moving Farm Animals](#moving-farm-animals)
- [back to top](

### Purchasing Farm Animals

To purchase animals for your farm, you must first have an appropriate farm building to house them. See [the farm buildings section](#farm-buildings) for details. Not all animals can be housed in all buildings. Chickens and ducks may only be housed in coops, cows and goats may only be housed in barns, and certain other animals require upgraded coops or barns.

Go to Marnie's ranch in the forest (a.k.a AnimalShop) during business hours and select "purchase animals" from the shop counter dialogue.
A new menu will open with a grid of options. Depending on which farm buildings you have constructed, you may see the names of various animals or a message informing you that a specific farm building is required.
If the animal can be purchased, its name will be read along with its price, description, and the type of building it lives in. Select the animal you wish to purchase with left mouse click.
Once the map interface opens, enter the command `buildlist` into the SMAPI console to get a list of all farm buildings. Then enter `buildsel <i>`, replacing `<i>` with the number of the building you want to place the animal in. If successful, you will be presented with a text box to name the animal. Interact with it, enter the desired name, press escape, and then select "ok" below the textbox. Marnie will deliver your animal to their new home.

If you cannot purchase an animal, ensure the following are true:

1. You have the correct farm building for that animal
2. You have enough money to purchase that animal
3. You are selecting the correct farm building
4. The farm building you are selecting has space for that animal

### Moving Farm Animals

To move an animal that you own to another building, use action button on that animal to open their menu. If you have not pet your animal that day yet, you may need to press twice to do this. This menu allows you to sell your animal, rename it, and change its home building. Select "change home building". Once the map interface opens, enter the command `buildlist` to get a list of all farm buildings. Then enter `buildsel <i>`, replacing `<i>` with the number of the building you want to place the animal in. If successful, the animal will be moved to the new building and you will return to the game.

If you cannot move an animal to a new building, ensure that the following are true:

1. The animal can live in the building you are moving it to
2. The building you are moving the animal to has room for the animal
3. You are selecting the correct building

<!--todo: more animal guides probably-->

## Other guides

- [Stardew Access Guides](stardew-access-guides.md)
- [General Guides](general-guides.md)
- [Mining Guides](mining-guides.md)

**[Back to guides home](guides-home.md)

**[Back to readme...](../README.md)**
