## Changelog v1.6.0-beta.5

### New Features

- Configure automatic reading of dialogs; new manual read dialog key (by @ParadoxiKat)
    - New config option `AutoReadCharacterBubbles` (default: true) can be disabled to prevent character speech bubbles from reading.
    - New config option `AutoReadCharacterDialog` (default: true) can be disabled to prevent character dialogs from reading when first opened.
    - New config option `AutoReadQuestionDialog` (default: true) can be disabled to prevent question dialogs (such as go to bed? TV etc) from reading when first opened.
    - New config option `AutoReadBasicDialog` (default: true) can be disabled to prevent basic dialogs (such as unable to use basic axe on large stump) from reading when first opened.
    - New config option `ManualReadDialogKey` (default: "R") can be pressed in any dialog to reread it as if just opened, regardless of related verbosity setting.
- Patched home renovations menu
    - Use the `PrimaryInfoKey` in the menu to snap the mouse to the renovation area and speak the details about the affected area.
      Then use `LeftClick` to renovate.

### Feature Updates

- Farm animal's age is spoken in days if it is less than a month old.
- Animal's info include the baby and hungry statuses.
- Animal purchase menu:
    - The menu will now speak the "Select Building" prompt along with the animal's colour.
    - It will also speak the animal names as they are shown. Previously, it spoke white cow as opposed to what's shown, dairy cow.
- Added custom names support for items. This can be used to have separate names for items with same names (like for jungle decals purchasable in Luau). At the moment the scope is only at the inventory level or wherever InventoryUtils is used to get the plural form of a name.
- Inventory slots that haven't been unlocked yet now appropriately read as "Locked Slot" instead of "Empty Slot"; #361

### Bug Fixes

- Removed duplicate entries of entrances in bath house women's locker room
- Updated location of soup pot in Luau festival
- Fixed glitchiness in Pierre's shop in the Luau festival; #318
- Fixed other player's mail boxes showing up in buildings category
- Fix duplicate animal category and out of bounds animals being tracked in farms.
- Fixed support for medowlands and custom farm types in the custom tile entry menu.
- Fixed descriptive flooring names not being read. Introduced a new config, `DisableDescriptiveFlooring`; #362
- Fixed green rain weeds being categorized as other instead of debris; #365

### Tile Tracker Changes

- Bookseller's tile is now dynamically tracked.
- Detect Pierre's Booth tile in Luau festival.
- Detect lumber pile dynamically.

### Misc

- Added progress information for infinity conversion (galaxy soul enchantment); #239
- "Start Forging" button in the forge menu now also speaks the forge cost.
- The special orders board menu now correctly indicates when a quest is completed; #228

### Translation Changes

- New(en.ftl): `event_tile-luau-pierre_booth` = `Pierre's Booth`
- Modified(en.ftl): `npc-farm_animal_info` = [Updated English value](https://github.com/khanshoaib3/stardew-access/blob/a33d90157baa532e09f45d72bed91ff53a601649/stardew-access/i18n/en.ftl#L333-L348)
- New(en.ftl): `tile-town-bookseller` = `Bookseller`
- Removed(static_tiles.en.ftl): `static_tile-town-bookseller`
- Modified(menu.en.ftl): `menu-animal_query-animal_info` = [Updated English value](https://github.com/khanshoaib3/stardew-access/blob/a33d90157baa532e09f45d72bed91ff53a601649/stardew-access/i18n/menu.en.ftl#L345-L367)
- New(en.ftl): `dynamic_tile-farm-lumber_pile` = `Lumber Pile`.
- Removed(static_tiles.en.ftl): `static_tile-farm-lumber_pile`.
- New(en.ftl): `inventory_util-special_items-name` with placeholder values at the moment.
- New(en.ftl): `inventory_util-locked_slot` = `Locked Slot`
- New(en.ftl): `inventory_util-enchantments-galaxy_soul` = `Galaxy Soul ({$progress_in_percentage}% transformed)`
- Modified(menu.en.ftl): `menu-forge-start_forging_button` = [English value](https://github.com/khanshoaib3/stardew-access/blob/499637832b0801a75c4435517e0420c08a06bbeb/stardew-access/i18n/menu.en.ftl#L260-L263)

### Development Chores

- Added pull request template
- ci: As opposed to `/fast-forward`, we can also now use `/fast-forward-force` to merge the PR without checking for `mergeable_state`.
- ci: Fix if condition failure in fast-forward.yml
- Updated the `release` workflow to automatically generate release notes. Added a helper python script for it, `gen_final_changelog_n_release_notes.py`.
- New sub-heading for changelogs, `Development Chores`.
- Updated the order of `Translation Changes` sub-heading to be at last with `Development Chores`.

