## Changelog

### New Features

- New Repeat Text Feature:
    - This feature allows us to repeat the last texts spoken by the mod.
    - We can use the `Left/Right Alt + Space` to speak the very last text.
        - And when pressed again within 500 ms, it will repeat the second last text, then the third text and so on.
        - This is configurable and named "RepeatLastTextKey" in the config.
    - We can also the `rlt` (short for repeat last text) command to do the same.
        - The commands syntax is `rlt <index>`
        - Replace <index> with the number, 1 representing the last text, 2 the second last and so on.
- Mod commands can be entered through chat (this does not require the chat commands mod like before).
- The bobber machine is patched although the style names are arbitrary for now (Waiting for @ParadoxiKat and JJ to make them more descriptive 🙂)

### Feature Updates

- (By @christopherpross) Added a config, `Use24HourFormat`, to toggle between speaking time in 24 hour or 12 hour format.

### Bug Fixes

- Fixed recipe names not being spoken in letters.
- Fixed `Left Click To Accept Quest` text from being unwantedly spoken in letters.
- Fixed crashes in raccoon bundle menu and home cook's community center bundle.
- Updated cellar location fixing the bug causing the player to be warped outside of map when auto traveling to cellar entrance.
- Fixed grid movement passing though un-passable tiles, like turtles blocking entrances in the island.
- Prevented grid movement to pass through the magical bug land barrier.

### Tile Tracker Changes

- Fishing rods now speak equipped bait and tackles.
- Patched Statue of Blessings and Statue of Dwarf King
- Removed duplicate entrances for bath house men/women locker room and mutant bug land.

### Guides And Docs

- Update hyperlinks, fixed typos, etc. - @PepperTheVixen.
- Added instructions for installing Kokoro - @PepperTheVixen.
- Reworked the guides page and added additional guides in order to bring it up to speed with SVA 1.5+ and to improve the guides - @PepperTheVixen.
- The guides page is now also available in the compiled docs and relevant links have been updated in the other docs pages to point to the updated guides page - @PepperTheVixen.
- Revamped commands.md and features.md to be much more readable, include more resources, and include the updated feature sets - @PepperTheVixen.
- Added a note in features.md on how to solve the issue of your screen reader having the narration cut off after you press a key - @PepperTheVixen.
- More info is added to the setup page to make the instructions easier to follow. The readme page has been improved to better convey what the mod is about at a glance - @PepperTheVixen.
- Provided instructions for how to use the new [Accessible Stardew Setup](https://github.com/ParadoxiKat/AccessibleStardewSetup/) - @PepperTheVixen.

### Misc

- Updated skills page patch to reflect new additions.

### Translation Changes

- Modified(menu.en.ftl): `menu-skills_page-player_info` = [Updated English value](https://github.com/khanshoaib3/stardew-access/blob/204d3b41aef01c5a57146b8b6a7b04acf090cc75/stardew-access/i18n/menu.en.ftl#L214-L238)
- New(menu.en.ftl): `menu-choose_from_icons-bobber_styles` = [English value](https://github.com/khanshoaib3/stardew-access/blob/204d3b41aef01c5a57146b8b6a7b04acf090cc75/stardew-access/i18n/menu.en.ftl#L423-L468)
- Removed(static_tiles.en.ftl): `static_tile-bathhouse_locker-pool_entrance`
- Removed(static_tiles.en.ftl): `static_tile-bathhouse_locker-entry_room_door`
- Removed(static_tiles.en.ftl): `static_tile-sewer-mutant_bug_lair`
- New(static_tiles.en.ftl): `static_tile-fishshop-bobber_machine` = `Bobber Machine`
- New(static_tiles.en.ftl): `static_tile-fishshop-miniature_frigate` = `Miniature Frigate`
- New(static_tiles.en.ftl): `static_tile-fishshop-tackle_box` = `Tackle Box`

