# Stardew Access

Stardew Access is a [Stardew Valley](https://stardewvalley.net/) mod that focuses on making the game accessible to blind screen reader users on Windows, Linux and Mac OS. It adds narration through the active screen reader to the game, the menus, the character dialogue, and more to give the player information about their farmer and the world around them.
Nearby objects, monsters, and favorite locations are only a few keystrokes away with the object tracker.
Planting, harvesting, construction, and mining are all made easy via narration of tiles and the tile reader.
To interact with the active screen reader, Stardew Access uses the [Tolk](https://github.com/ndarilek/tolk) library on windows, [libspeechdwrapper](https://github.com/khanshoaib3/libspeechdwrapper) on Linux, and [libspeak](https://github.com/Flameborn/libspeak) on Mac OS.

<!--todo: add this link to the wiki once there's info for developers. https://github.com/khanshoaib3/stardew-access/wiki-->

## Features

Below is an overview of what Stardew Access can do. Check out [the features page](features.md) for a full list.

### Game Narration

Tap into your screen reader to narrate menus, tiles, character dialogue, chests, health, money, time of day, and much more to play Stardew Valley without sight!

### Tile Viewer

Know what's in front of and around you. Stardew Access will automatically read the tile you face. Want to see the rest of the map? Move the tile viewer anywhere you like and explore! Stardew Access will read doors, crops, buildings, animals, farmers, and more with configurable options. Stardew Access also supports reading user-defined objects, great for mods.

### Object Tracker

Browse through all objects on a map, organized by category and proximity, and get location information or automatically travel to the object of your choosing. Store favorite locations on each map for easy access with less searching!

### Grid Movement

Automatically snap your farmer to the tile grid when walking around. Great for planting crops and cleaning up your farm!

## Installation

In order to use Stardew Access, you must first own a copy of Stardew Valley on Windows, Mac or Linux. Stardew Access does not support other platforms at this time. Check [the setup page](setup.md) for required dependencies and installation instructions. Check out [Accessible Stardew Setup](https://github.com/ParadoxiKat/AccessibleStardewSetup/releases/latest) for a streamlined, automated installation process.

## Official Guide

Check out the [official guide](guides/guides-home.md) for tutorials on creating a game, farming, constructing farm buildings, raising animals, buying and selling, mining, and more with Stardew Access!

## Useful Links

- [Stardew Valley Wiki](https://stardewvalleywiki.com/Stardew_Valley_Wiki)
    - The official Stardew Valley wiki. It has guides and info for everything in Stardew valley though some things may not be screen-reader accessible.
- [Issues](https://github.com/khanshoaib3/stardew-access/issues)
    - post any bug or feature request here.
- [Source Code](https://github.com/khanshoaib3/stardew-access)
    - contributions are always welcome!
- [Stardew Access on Nexus Mods](https://www.nexusmods.com/stardewvalley/mods/16205)
- [Latest Release](https://github.com/khanshoaib3/stardew-access/releases/latest)
- [Our Discord Server](https://discord.gg/yQjjsDqWQX)
- [Shoaib's Twitter](https://twitter.com/shoaib_mk0) - follow me on twitter to get updates regarding Stardew Access and [minecraft access](https://github.com/khanshoaib3/minecraft-access)

## Support Us

If you find this project helpful and would like to support its development, you can do so by becoming a patron.

- [My Patreon page](https://www.patreon.com/shoaibkhan)
- [Kat's Patreon page](https://www.patreon.com/BlindSighted)

Your support will help us dedicate more time to this project as well as other future gaming accessibility projects. 

## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

## Translations

As of v1.5.0, the mod has been fully internationalised.
Follow [the language translations issue page](https://github.com/khanshoaib3/stardew-access/issues/182) to track the progress of
translations currently in the works and/or if you want to provide translation for your language.

## Contact Us

You can contact us by pinging us on the [Playability](https://discord.gg/yQjjsDqWQX) discord server
or if you want to, you can also send me dm (my username: `theonewhoknocks3`).

Additionally, my email is `shoaib.khan20@outlook.com`.

## Other Pages

- [Setup](setup.md)
- [Features](features.md)
- [Keybindings](keybindings.md)
- [Commands](commands.md)
- [Configs](config.md)
- [Guides](guides/guides-home.md)
