﻿// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License (Ms-PL).
// Please see http://go.microsoft.com/fwlink/?LinkID=131993 for details.
// All other rights reserved.

namespace Microsoft.Test.Input
{
    /// <summary>
    /// Defines values that specify the buttons on a mouse device.
    /// </summary>
    public enum MouseButton 
    {
        /// <summary>
        /// The left mouse button.
        /// </summary>
        Left = 0,

        /// <summary>
        /// The middle mouse button.
        /// </summary>
        Middle = 1,

        /// <summary>
        /// The right mouse button.
        /// </summary>
        Right = 2,

        /// <summary>
        /// The first extended mouse button.
        /// </summary>
        XButton1 = 3,

        /// <summary>
        /// The second extended mouse button
        /// </summary>
        XButton2 = 4,
    }
}
