import urllib.request
from html.parser import HTMLParser
import json


# Simply retrieves the content info from the website and add them to the md files.
class Parser(HTMLParser):

  def __init__(self, content, index):
    super().__init__()
    self.title_on = False
    self.index = index
    self.profile = None
    self.content = content

  def handle_starttag(self, tag, attrs):

    def check_attr(attrs, attr_name):
      for attr in attrs:
        if attr[0] == attr_name:
          if attr_name == 'class':
            return attr[1].split(' ')
          return attr[1]
      return ""

    if tag == 'h2' and 'title' in check_attr(attrs, "class"):
      self.title_on = True

  def handle_data(self, data):
    if self.title_on:
      self.profile = data
      self.title_on = False

  def parse(self):
    self.feed(self.content)


class Crawler:

  def __init__(self):
    self.start_url = "http://itguru.tistory.com/"
    self.result_dict = {}

  def parse(self):
    for i in range(5, 229):
      url = self.start_url + str(i)
      print("url : ", url)
      try:
        content = str(urllib.request.urlopen(url).read())
      except:
        continue
      html_parser = Parser(content, i)
      html_parser.parse()
      self.result_dict[i] = html_parser.profile


if __name__ == '__main__':
  '''
    crawler = Crawler()
    crawler.parse()
    print(crawler.result_dict)
    '''
  #t = b"{5: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <1. C \xec\x96\xb8\xec\x96\xb4\xea\xb0\x80 \xeb\xad\x90\xec\x95\xbc?>', 6: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <2 - 1. C \xec\x96\xb8\xec\x96\xb4 \xeb\xb3\xb8\xea\xb2\xa9 \xeb\xa7\x9b\xeb\xb3\xb4\xea\xb8\xb0>', 7: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <3. \xeb\xb3\x80\xec\x88\x98\xea\xb0\x80 \xeb\xad\x90\xec\xa7\x80? >', 8: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <4. \xea\xb3\x84\xec\x82\xb0\xed\x95\x98\xeb\xa6\xac >', 9: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <5. \xeb\xac\xb8\xec\x9e\x90 \xec\x9e\x85\xeb\xa0\xa5 \xeb\xb0\x9b\xea\xb8\xb0>', 10: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <6. \xeb\xa7\x8c\xec\x95\xbd\xec\x97\x90...(if \xeb\xac\xb8)>', 12: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <7. \xeb\xb1\x85\xea\xb8\x80 \xeb\xb1\x85\xea\xb8\x80 (for, while) >', 14: '\xec\x94\xb9\xec\x96\xb4 \xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <8. \xec\x9a\xb0\xeb\xb6\x84\xed\x88\xac \xeb\xa6\xac\xeb\x88\x85\xec\x8a\xa4\xec\x97\x90\xec\x84\x9c C \xed\x94\x84\xeb\xa1\x9c\xea\xb7\xb8\xeb\x9e\x98\xeb\xb0\x8d \xed\x95\x98\xea\xb8\xb0>', 16: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <9. \xeb\xa7\x8c\xec\x95\xbd\xec\x97\x90... 2\xed\x83\x84 (switch \xeb\xac\xb8)>', 17: '\xec\x94\xb9\xec\x96\xb4 \xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <10. \xec\x97\xb0\xec\x98\x88\xec\x9d\xb8 \xec\xba\x90\xec\x8a\xa4\xed\x8c\x85(?) (C \xec\x96\xb8\xec\x96\xb4\xec\x97\x90\xec\x84\x9c\xec\x9d\x98 \xed\x98\x95 \xeb\xb3\x80\xed\x99\x98)>', 18: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <11 - 1. C \xec\x96\xb8\xec\x96\xb4\xec\x9d\x98 \xec\x95\x84\xed\x8c\x8c\xed\x8a\xb8 (\xeb\xb0\xb0\xec\x97\xb4), \xec\x83\x81\xec\x88\x98>', 19: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <2 - 2. \xec\xa3\xbc\xec\x84\x9d(Comment)\xec\x97\x90 \xeb\x8c\x80\xed\x95\x9c \xec\x9d\xb4\xed\x95\xb4>', 20: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <11 - 2. C \xec\x96\xb8\xec\x96\xb4\xec\x9d\x98 \xec\x95\x84\xed\x8c\x8c\xed\x8a\xb82 (\xea\xb3\xa0\xec\xb0\xa8\xec\x9b\x90\xec\x9d\x98 \xeb\xb0\xb0\xec\x97\xb4)>', 21: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <2 - 3. \xec\x88\x98\xeb\xa5\xbc \xed\x91\x9c\xed\x98\x84\xed\x95\x98\xeb\x8a\x94 \xeb\xb0\xa9\xeb\xb2\x95(\xea\xb8\xb0\xec\x88\x98\xeb\xb2\x95)>', 23: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <12 - 1. \xed\x8f\xac\xec\x9d\xb8\xed\x84\xb0\xeb\x8a\x94 \xec\x98\x81\xed\x9d\xac\xec\x9d\xb4\xeb\x8b\xa4! (\xed\x8f\xac\xec\x9d\xb8\xed\x84\xb0)>', 24: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <12 - 2. \xed\x8f\xac\xec\x9d\xb8\xed\x84\xb0\xeb\x8a\x94 \xec\x98\x81\xed\x9d\xac\xec\x9d\xb4\xeb\x8b\xa4! (\xed\x8f\xac\xec\x9d\xb8\xed\x84\xb0)>', 25: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <12 - 3. \xed\x8f\xac\xec\x9d\xb8\xed\x84\xb0\xeb\x8a\x94 \xec\x98\x81\xed\x9d\xac\xec\x9d\xb4\xeb\x8b\xa4! (\xed\x8f\xac\xec\x9d\xb8\xed\x84\xb0)>', 26: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <13 - 1. \xeb\xa7\x88\xec\x88\xa0 \xec\x83\x81\xec\x9e\x90 \xed\x95\xa8\xec\x88\x98(function)>', 27: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <13 - 2. \xeb\xa7\x88\xec\x88\xa0 \xec\x83\x81\xec\x9e\x90 \xed\x95\xa8\xec\x88\x98 2 (function)>', 28: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <13 - 3. \xeb\xa7\x88\xec\x88\xa0 \xec\x83\x81\xec\x9e\x90 \xed\x95\xa8\xec\x88\x98 3 (function)>', 29: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <15 - 1. \xec\x9d\xbc\xeb\xa1\x9c\xec\x99\x80\xeb\xb4\x90, \xeb\xac\xb8\xec\x9e\x90\xec\x97\xb4(string)>', 30: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <13 - 4. \xeb\xa7\x88\xec\x88\xa0 \xec\x83\x81\xec\x9e\x90 \xed\x95\xa8\xec\x88\x98 (\xec\x83\x9d\xea\xb0\x81\xed\x95\xb4\xeb\xb3\xbc \xeb\xac\xb8\xec\xa0\x9c\xec\x97\x90 \xeb\x8c\x80\xed\x95\x9c \xec\x95\x84\xec\x9d\xb4\xeb\x94\x94\xec\x96\xb4)>', 31: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <14. \xec\xbb\xb4\xed\x93\xa8\xed\x84\xb0\xec\x9d\x98 \xeb\xa8\xb8\xeb\xa6\xac\xeb\xa1\x9c \xeb\x94\xb0\xeb\x9d\xbc\xea\xb0\x80\xeb\xb3\xb4\xec\x9e\x90 - \xeb\x94\x94\xeb\xb2\x84\xea\xb9\x85(debugging)>', 32: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <15 - 2. \xec\x9d\xbc\xeb\xa1\x9c\xec\x99\x80\xeb\xb4\x90, \xeb\xac\xb8\xec\x9e\x90\xec\x97\xb4(string) - \xeb\xb2\x84\xed\x8d\xbc\xec\x97\x90 \xea\xb4\x80\xed\x95\x9c \xec\x9d\xb4\xed\x95\xb4>', 33: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <15 - 3. \xec\x9d\xbc\xeb\xa1\x9c\xec\x99\x80\xeb\xb4\x90, \xeb\xac\xb8\xec\x9e\x90\xec\x97\xb4(string) - \xeb\xac\xb8\xec\x9e\x90\xec\x97\xb4 \xec\xa7\x80\xec\xa7\x80\xea\xb3\xa0 \xeb\xb3\xb6\xea\xb8\xb0 & \xeb\xa6\xac\xed\x84\xb0\xeb\x9f\xb4>', 34: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - stdio.h (cstdio) \xed\x97\xa4\xeb\x8d\x94\xed\x8c\x8c\xec\x9d\xbc', 35: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - printf \xed\x95\xa8\xec\x88\x98', 36: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - scanf \xed\x95\xa8\xec\x88\x98', 37: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fgetc \xed\x95\xa8\xec\x88\x98', 38: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fgets \xed\x95\xa8\xec\x88\x98', 39: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 -  fputc \xed\x95\xa8\xec\x88\x98', 40: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fputs \xed\x95\xa8\xec\x88\x98', 41: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - getc \xed\x95\xa8\xec\x88\x98', 43: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <15 - 4. \xec\x9d\xbc\xeb\xa1\x9c\xec\x99\x80\xeb\xb4\x90, \xeb\xac\xb8\xec\x9e\x90\xec\x97\xb4(string) - \xeb\x8f\x84\xec\x84\x9c \xea\xb4\x80\xeb\xa6\xac \xed\x94\x84\xeb\xa1\x9c\xec\xa0\x9d\xed\x8a\xb8>', 44: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - getchar \xed\x95\xa8\xec\x88\x98', 45: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - gets \xed\x95\xa8\xec\x88\x98', 46: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - putc \xed\x95\xa8\xec\x88\x98', 47: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - putchar \xed\x95\xa8\xec\x88\x98', 48: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - puts \xed\x95\xa8\xec\x88\x98', 49: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ungetc \xed\x95\xa8\xec\x88\x98', 50: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - clearerr \xed\x95\xa8\xec\x88\x98', 51: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - feof \xed\x95\xa8\xec\x88\x98', 52: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ferror \xed\x95\xa8\xec\x88\x98', 53: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - perror \xed\x95\xa8\xec\x88\x98', 54: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fclose \xed\x95\xa8\xec\x88\x98', 55: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <16 - 1. \xeb\xaa\xa8\xec\x95\x84 \xeb\xaa\xa8\xec\x95\x84 \xea\xb5\xac\xec\xa1\xb0\xec\xb2\xb4(struct)>', 57: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fflush \xed\x95\xa8\xec\x88\x98', 58: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fopen \xed\x95\xa8\xec\x88\x98', 59: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - freopen \xed\x95\xa8\xec\x88\x98', 60: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <16 - 2. \xeb\xaa\xa8\xec\x95\x84 \xeb\xaa\xa8\xec\x95\x84 \xea\xb5\xac\xec\xa1\xb0\xec\xb2\xb4(struct) - \xea\xb5\xac\xec\xa1\xb0\xec\xb2\xb4 \xec\x9d\xb8\xec\x9e\x90\xeb\xa1\x9c \xea\xb0\x80\xec\xa7\x84 \xed\x95\xa8\xec\x88\x98>', 61: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - setbuf \xed\x95\xa8\xec\x88\x98', 62: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - setvbuf \xed\x95\xa8\xec\x88\x98', 64: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fprintf \xed\x95\xa8\xec\x88\x98', 65: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fscanf \xed\x95\xa8\xec\x88\x98', 66: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - sprintf \xed\x95\xa8\xec\x88\x98', 67: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - sscanf \xed\x95\xa8\xec\x88\x98', 68: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fread \xed\x95\xa8\xec\x88\x98', 69: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fwrite \xed\x95\xa8\xec\x88\x98', 70: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fgetpos \xed\x95\xa8\xec\x88\x98', 71: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <16 - 3. \xea\xb5\xac\xec\xa1\xb0\xec\xb2\xb4\xec\x99\x80 \xec\xb9\x9c\xea\xb5\xac\xeb\x93\xa4(\xea\xb3\xb5\xec\x9a\xa9\xec\xb2\xb4(union), \xec\x97\xb4\xea\xb1\xb0\xed\x98\x95(enum))>', 72: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fseek \xed\x95\xa8\xec\x88\x98', 73: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - fsetpos \xed\x95\xa8\xec\x88\x98', 74: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ftell \xed\x95\xa8\xec\x88\x98', 75: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - rewind \xed\x95\xa8\xec\x88\x98', 76: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - string.h (cstring) \xed\x97\xa4\xeb\x8d\x94\xed\x8c\x8c\xec\x9d\xbc', 77: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - memcpy \xed\x95\xa8\xec\x88\x98', 78: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - memmove \xed\x95\xa8\xec\x88\x98', 79: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strcpy \xed\x95\xa8\xec\x88\x98', 80: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strncpy \xed\x95\xa8\xec\x88\x98', 81: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strcat \xed\x95\xa8\xec\x88\x98', 82: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strncat \xed\x95\xa8\xec\x88\x98', 83: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <17. \xeb\xb3\x80\xec\x88\x98\xec\x9d\x98 \xec\x83\x9d\xec\xa1\xb4 \xec\xa1\xb0\xea\xb1\xb4 \xeb\xb0\x8f \xeb\x8d\xb0\xec\x9d\xb4\xed\x84\xb0 \xec\x84\xb8\xea\xb7\xb8\xeb\xa8\xbc\xed\x8a\xb8\xec\x9d\x98 \xea\xb5\xac\xec\xa1\xb0>', 84: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - memcmp \xed\x95\xa8\xec\x88\x98', 85: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strcmp \xed\x95\xa8\xec\x88\x98', 86: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4- strcoll \xed\x95\xa8\xec\x88\x98', 87: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <18 - 1. \xed\x8c\x8c\xec\x9d\xbc \xeb\xbd\x80\xea\xb0\x9c\xea\xb8\xb0 (\xed\x97\xa4\xeb\x8d\x94\xed\x8c\x8c\xec\x9d\xbc\xea\xb3\xbc #include) >', 88: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <18 - 2. \xed\x8c\x8c\xec\x9d\xbc \xeb\xbd\x80\xea\xb0\x9c\xea\xb8\xb0 (# \xec\xb9\x9c\xea\xb5\xac\xeb\x93\xa4, \xeb\x9d\xbc\xec\x9d\xb4\xeb\xb8\x8c\xeb\x9f\xac\xeb\xa6\xac)>', 89: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <19. main \xed\x95\xa8\xec\x88\x98\xec\x9d\x98 \xec\x9d\xb8\xec\x9e\x90, \xed\x85\x85 \xeb\xb9\x88 void \xed\x98\x95>', 90: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strncmp \xed\x95\xa8\xec\x88\x98', 91: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strxfrm \xed\x95\xa8\xec\x88\x98', 92: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - memchr \xed\x95\xa8\xec\x88\x98', 93: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strchr \xed\x95\xa8\xec\x88\x98', 94: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strcspn \xed\x95\xa8\xec\x88\x98', 95: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strpbrk \xed\x95\xa8\xec\x88\x98', 96: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strrchr \xed\x95\xa8\xec\x88\x98', 97: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strspn \xed\x95\xa8\xec\x88\x98', 98: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <20 - 1. \xeb\x8f\x99\xeb\x8f\x99\xeb\x8f\x99 \xeb\xa9\x94\xeb\xaa\xa8\xeb\xa6\xac \xeb\x8f\x99\xec\xa0\x81\xed\x95\xa0\xeb\x8b\xb9(Dynamic Memory Allocation)>', 99: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <21. \xeb\xa7\xa4\xed\x81\xac\xeb\xa1\x9c \xed\x95\xa8\xec\x88\x98, \xec\x9d\xb8\xeb\x9d\xbc\xec\x9d\xb8 \xed\x95\xa8\xec\x88\x98>', 100: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <20 - 2. \xeb\xa9\x94\xeb\xaa\xa8\xeb\xa6\xac \xeb\x8f\x99\xec\xa0\x81\xed\x95\xa0\xeb\x8b\xb9 + \xeb\xa9\x94\xeb\xaa\xa8\xeb\xa6\xac \xea\xb0\x96\xea\xb3\xa0 \xeb\x86\x80\xea\xb8\xb0>', 101: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strstr \xed\x95\xa8\xec\x88\x98', 102: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strtok \xed\x95\xa8\xec\x88\x98', 103: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <22. C \xec\x96\xb8\xec\x96\xb4\xec\x9d\x98 \xec\x9e\xa1\xeb\x8b\xa4\xed\x95\x9c \xed\x82\xa4\xec\x9b\x8c\xeb\x93\x9c\xeb\x93\xa4 (typedef, volatile, #pragma)>', 104: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - memset \xed\x95\xa8\xec\x88\x98', 105: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strerror \xed\x95\xa8\xec\x88\x98', 106: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strlen \xed\x95\xa8\xec\x88\x98', 108: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - time.h \xed\x97\xa4\xeb\x8d\x94\xed\x8c\x8c\xec\x9d\xbc', 109: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - struct tm ( tm \xea\xb5\xac\xec\xa1\xb0\xec\xb2\xb4 )', 110: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - clock \xed\x95\xa8\xec\x88\x98', 111: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - difftime \xed\x95\xa8\xec\x88\x98', 112: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - mktime \xed\x95\xa8\xec\x88\x98', 113: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - time_t \xed\x98\x95', 114: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - time \xed\x95\xa8\xec\x88\x98', 115: '100 \xeb\xb2\x88\xec\xa7\xb8 \xea\xb8\x80\xec\x9d\x84 \xeb\x8f\x8c\xed\x8c\x8c\xed\x95\x98\xeb\xa9\xb0', 116: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - asctime \xed\x95\xa8\xec\x88\x98', 117: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <23 - 1. \xed\x8c\x8c\xec\x9d\xbc \xed\x95\x98\xea\xb3\xa0 \xec\x9d\xb4\xec\x95\xbc\xea\xb8\xb0 \xed\x95\x98\xea\xb8\xb0 (\xed\x8c\x8c\xec\x9d\xbc \xec\x9e\x85\xec\xb6\x9c\xeb\xa0\xa5\xec\x97\x90 \xeb\x8c\x80\xed\x95\x9c \xea\xb8\xb0\xeb\xb3\xb8\xec\xa0\x81 \xec\x9d\xb4\xed\x95\xb4)>', 118: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ctime \xed\x95\xa8\xec\x88\x98', 119: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - gmtime \xed\x95\xa8\xec\x88\x98', 120: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - localtime \xed\x95\xa8\xec\x88\x98', 121: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - stdlib.h (cstlib)', 122: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - strftime \xed\x95\xa8\xec\x88\x98', 123: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <23 - 2. \xed\x8c\x8c\xec\x9d\xbc \xed\x95\x98\xea\xb3\xa0 \xec\x9d\xb4\xec\x95\xbc\xea\xb8\xb0 \xed\x95\x98\xea\xb8\xb0 (\xed\x8c\x8c\xec\x9d\xbc \xec\x9e\x85\xec\xb6\x9c\xeb\xa0\xa5)>', 124: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - atof \xed\x95\xa8\xec\x88\x98', 125: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <23 - 3. \xed\x8c\x8c\xec\x9d\xbc \xed\x95\x98\xea\xb3\xa0 \xec\x9d\xb4\xec\x95\xbc\xea\xb8\xb0 \xed\x95\x98\xea\xb8\xb0 (\xed\x8c\x8c\xec\x9d\xbc \xec\x9e\x85\xec\xb6\x9c\xeb\xa0\xa5 - \xeb\xa7\x88\xeb\xac\xb4\xeb\xa6\xac)>', 129: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - <24. \xeb\x8d\x94 \xeb\xb9\xa0\xeb\xa5\xb4\xea\xb2\x8c \xec\x8b\xa4\xed\x96\x89\xeb\x90\x98\xeb\x8a\x94 \xec\xbd\x94\xeb\x93\x9c\xeb\xa5\xbc \xec\x9c\x84\xed\x95\x98\xec\x97\xac (C \xec\xbd\x94\xeb\x93\x9c \xec\xb5\x9c\xec\xa0\x81\xed\x99\x94)>', 130: '\xec\xb4\x88\xeb\xb3\xb4\xec\x9e\x90\xeb\xa5\xbc \xec\x9c\x84\xed\x95\x9c C \xec\x96\xb8\xec\x96\xb4 \xea\xb0\x95\xec\xa2\x8c - \xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 (\xec\x99\x84\xea\xb2\xb0)', 131: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - atoi \xed\x95\xa8\xec\x88\x98', 132: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - atol \xed\x95\xa8\xec\x88\x98', 133: '\xed\x8b\xb0\xec\x8a\xa4\xed\x86\xa0\xeb\xa6\xac\xec\x9a\xa9 \xed\x86\xb5\xea\xb3\x84 \xed\x94\x84\xeb\xa1\x9c\xea\xb7\xb8\xeb\x9e\xa8 (\xeb\x8c\x93\xea\xb8\x80, \xed\x8f\xac\xec\x8a\xa4\xed\x8a\xb8, \xeb\xb0\xa9\xeb\xac\xb8\xec\x9e\x90 \xeb\x93\xb1\xeb\x93\xb1) - tistory_stat (v.0.1)', 134: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <1. \xec\x9e\x90~ C++ \xec\x9d\x98 \xec\x84\xb8\xea\xb3\x84\xeb\xa1\x9c>', 135: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ \xea\xb0\x95\xec\xa2\x8c \xea\xb3\x84\xed\x9a\x8d', 136: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <1 - 2. \xec\xb2\xab C++ \xed\x94\x84\xeb\xa1\x9c\xea\xb7\xb8\xeb\x9e\xa8 \xeb\xb6\x84\xec\x84\x9d\xed\x95\x98\xea\xb8\xb0>', 138: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <2 - 1. C++ \xec\x9d\x80 C \xec\xb9\x9c\xea\xb5\xac - C \xec\x99\x80 \xea\xb3\xb5\xed\x86\xb5\xec\xa0\x90>', 139: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - rand \xed\x95\xa8\xec\x88\x98', 140: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - srand \xed\x95\xa8\xec\x88\x98', 141: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <2 - 2. C++ \xec\x9d\x80 C \xec\xb9\x9c\xea\xb5\xac\xec\x9d\xbc\xea\xb9\x8c?>', 142: '\xeb\xb9\x84\xec\xa3\xbc\xec\x96\xbc \xec\x8a\xa4\xed\x8a\x9c\xeb\x94\x94\xec\x98\xa4\xec\x97\x90\xec\x84\x9c \xec\x86\x8c\xec\x8a\xa4 \xed\x95\x9c\xea\xba\xbc\xeb\xb2\x88\xec\x97\x90 \xec\xa0\x95\xeb\xa0\xac\xed\x95\x98\xea\xb8\xb0', 143: 'C++ IOstream (\xec\x9e\x85\xec\xb6\x9c\xeb\xa0\xa5) \xeb\x9d\xbc\xec\x9d\xb4\xeb\xb8\x8c\xeb\x9f\xac\xeb\xa6\xac', 144: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base \xed\x81\xb4\xeb\x9e\x98\xec\x8a\xa4', 145: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios \xed\x81\xb4\xeb\x9e\x98\xec\x8a\xa4', 146: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - istream \xed\x81\xb4\xeb\x9e\x98\xec\x8a\xa4', 147: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - istream::operator>> (\xec\xb6\x94\xec\xb6\x9c \xec\x97\xb0\xec\x82\xb0\xec\x9e\x90)', 149: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - istream::getline \xed\x95\xa8\xec\x88\x98', 150: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::exceptions', 151: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ifstream \xed\x81\xb4\xeb\x9e\x98\xec\x8a\xa4', 152: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::width', 153: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::flags \xed\x95\xa8\xec\x88\x98', 154: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::fmtflags \xed\x83\x80\xec\x9e\x85', 155: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::setf \xed\x95\xa8\xec\x88\x98', 156: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::usetf \xed\x95\xa8\xec\x88\x98', 157: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::precision \xed\x95\xa8\xec\x88\x98', 158: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::imbue', 159: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::register_callback \xed\x95\xa8\xec\x88\x98', 160: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::getloc \xed\x95\xa8\xec\x88\x98', 161: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::iword', 162: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::xalloc \xed\x95\xa8\xec\x88\x98', 163: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios_base::pword \xed\x95\xa8\xec\x88\x98', 164: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::good \xed\x95\xa8\xec\x88\x98', 165: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::fail \xed\x95\xa8\xec\x88\x98', 166: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::bad \xed\x95\xa8\xec\x88\x98', 167: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::eof \xed\x95\xa8\xec\x88\x98', 168: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::operator!', 169: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <3. C++ \xec\x9d\x98 \xec\x84\xb8\xea\xb3\x84\xeb\xa1\x9c \xec\x98\xa4\xec\x8b\xa0 \xea\xb2\x83\xec\x9d\x84 \xed\x99\x98\xec\x98\x81\xed\x95\xa9\xeb\x8b\x88\xeb\x8b\xa4. (new, delete)>', 170: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::operator void*', 171: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::rdstate \xed\x95\xa8\xec\x88\x98', 172: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <4 - 1. \xec\x9d\xb4 \xec\x84\xb8\xec\x83\x81\xec\x9d\x80 \xea\xb0\x9d\xec\xb2\xb4\xeb\xa1\x9c \xec\x9d\xb4\xeb\xa3\xa8\xec\x96\xb4\xec\xa0\xb8 \xec\x9e\x88\xeb\x8b\xa4>', 173: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <4 - 2. \xed\x81\xb4\xeb\x9e\x98\xec\x8a\xa4\xec\x9d\x98 \xec\x84\xb8\xea\xb3\x84\xeb\xa1\x9c \xec\x98\xa4\xec\x8b\xa0 \xea\xb2\x83\xec\x9d\x84 \xed\x99\x98\xec\x98\x81\xed\x95\xa9\xeb\x8b\x88\xeb\x8b\xa4. (\xed\x95\xa8\xec\x88\x98\xec\x9d\x98 \xec\x98\xa4\xeb\xb2\x84\xeb\xa1\x9c\xeb\x94\xa9, \xec\x83\x9d\xec\x84\xb1\xec\x9e\x90) >', 174: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - STL \xec\xbb\xa8\xed\x85\x8c\xec\x9d\xb4\xeb\x84\x88 (STL Container)', 175: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - STL \xec\xbb\xa8\xed\x85\x8c\xec\x9d\xb4\xeb\x84\x88 - vector', 176: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - STL \xec\xbb\xa8\xed\x85\x8c\xec\x9d\xb4\xeb\x84\x88 - deque', 177: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - STL \xec\xbb\xa8\xed\x85\x8c\xec\x9d\xb4\xeb\x84\x88 - list', 178: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - STL \xec\xbb\xa8\xed\x85\x8c\xec\x9d\xb4\xeb\x84\x88 - vector \xec\x83\x9d\xec\x84\xb1\xec\x9e\x90', 179: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::setstate \xed\x95\xa8\xec\x88\x98', 180: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::clear', 181: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::fill \xed\x95\xa8\xec\x88\x98', 182: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::rdbuf \xed\x95\xa8\xec\x88\x98', 183: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - STL \xec\xbb\xa8\xed\x85\x8c\xec\x9d\xb4\xeb\x84\x88 - vector::assign \xed\x95\xa8\xec\x88\x98', 184: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 - \xec\xb0\xbe\xec\x95\x84\xeb\xb3\xb4\xea\xb8\xb0', 185: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - vector::push_back', 186: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - vector::insert', 187: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C \xec\x96\xb8\xec\x96\xb4 \xea\xb0\x95\xec\xa2\x8c - PDF \xed\x8c\x8c\xec\x9d\xbc', 188: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <4 - 3. \xec\x8a\xa4\xed\x83\x80\xed\x81\xac\xeb\x9e\x98\xed\x94\x84\xed\x8a\xb8\xeb\xa5\xbc \xeb\xa7\x8c\xeb\x93\xa4\xec\x9e\x90 \xe2\x91\xa0 (\xeb\xb3\xb5\xec\x82\xac \xec\x83\x9d\xec\x84\xb1\xec\x9e\x90, \xec\x86\x8c\xeb\xa9\xb8\xec\x9e\x90)>', 189: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ \xed\x86\xa0\xeb\xa7\x89\xea\xb8\x80 \xe2\x91\xa0 - Rvalue(\xec\x9a\xb0\xec\xb8\xa1\xea\xb0\x92) \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4\xec\x97\x90 \xea\xb4\x80\xed\x95\xb4', 190: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - ios::tie \xed\x95\xa8\xec\x88\x98', 191: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - istream::get \xed\x95\xa8\xec\x88\x98', 192: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - istream::gcount \xed\x95\xa8\xec\x88\x98', 193: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - istream::ignore \xed\x95\xa8\xec\x88\x98', 194: 'C++ \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4 - istream::peak \xed\x95\xa8\xec\x88\x98', 195: '\xeb\xb9\x84\xec\xa3\xbc\xec\x96\xbc \xec\x8a\xa4\xed\x8a\x9c\xeb\x94\x94\xec\x98\xa4 2010 \xec\x97\x90\xec\x84\x9c C \xeb\xb0\x8f C++ \xed\x94\x84\xeb\xa1\x9c\xea\xb7\xb8\xeb\x9e\x98\xeb\xb0\x8d \xed\x95\x98\xea\xb8\xb0', 196: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ \xed\x86\xa0\xeb\xa7\x89\xea\xb8\x80 \xe2\x91\xa1 - \xeb\x9e\x8c\xeb\x8b\xa4(lambda) \xed\x95\xa8\xec\x88\x98', 197: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <4 - 4. \xec\x8a\xa4\xed\x83\x80\xed\x81\xac\xeb\x9e\x98\xed\x94\x84\xed\x8a\xb8\xeb\xa5\xbc \xeb\xa7\x8c\xeb\x93\xa4\xec\x9e\x90 \xe2\x91\xa1 (const, static)>', 198: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <4 - 5. \xeb\x82\xb4\xea\xb0\x80 \xeb\xa7\x8c\xeb\x93\x9c\xeb\x8a\x94 String \xed\x81\xb4\xeb\x9e\x98\xec\x8a\xa4>', 199: '\xeb\xaa\xa8\xeb\x93\xa0 \xec\xbb\xb4\xed\x93\xa8\xed\x84\xb0 \xea\xb3\xbc\xed\x95\x99\xec\x9e\x90\xea\xb0\x80 \xec\x95\x8c\xec\x95\x84\xec\x95\xbc \xed\x95\xa0 \xeb\xb6\x80\xeb\x8f\x99 \xec\x86\x8c\xec\x88\x98\xec\xa0\x90\xec\x9d\x98 \xeb\xaa\xa8\xeb\x93\xa0 \xea\xb2\x83(What Every Computer Scientists Should Know About Floating Point Arithmetic)', 201: '\xec\x98\xa4\xed\x94\x88\xeb\xb6\x81 \xed\x94\x84\xeb\xa1\x9c\xec\xa0\x9d\xed\x8a\xb8 - \xec\x96\x91\xec\xa7\x88\xec\x9d\x98 \xec\xbb\xb4\xed\x93\xa8\xed\x84\xb0 \xeb\xac\xb8\xec\x84\x9c \xea\xb3\xb5\xea\xb8\x89 \xed\x94\x84\xeb\xa1\x9c\xec\xa0\x9d\xed\x8a\xb8', 202: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <5 - 1. \xeb\x82\xb4\xea\xb0\x80 \xeb\xa7\x8c\xeb\x93\xa0 \xec\x97\xb0\xec\x82\xb0\xec\x9e\x90 - \xec\x97\xb0\xec\x82\xb0\xec\x9e\x90 \xec\x98\xa4\xeb\xb2\x84\xeb\xa1\x9c\xeb\x94\xa9>', 203: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <5 - 2. \xec\x9e\x85\xec\xb6\x9c\xeb\xa0\xa5, \xec\xb2\xa8\xec\x9e\x90, \xed\x83\x80\xec\x9e\x85\xeb\xb3\x80\xed\x99\x98, \xec\xa6\x9d\xea\xb0\x90 \xec\x97\xb0\xec\x82\xb0\xec\x9e\x90 \xec\x98\xa4\xeb\xb2\x84\xeb\xa1\x9c\xeb\x94\xa9>', 204: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <5 - 3. \xec\x97\xb0\xec\x82\xb0\xec\x9e\x90 \xec\x98\xa4\xeb\xb2\x84\xeb\xa1\x9c\xeb\x94\xa9 \xed\x94\x84\xeb\xa1\x9c\xec\xa0\x9d\xed\x8a\xb8 - N \xec\xb0\xa8\xec\x9b\x90 \xeb\xb0\xb0\xec\x97\xb4>', 208: 'C++ 11 \xec\x9e\x90\xec\xa3\xbc \xec\xa7\x88\xeb\xac\xb8\xeb\x90\x98\xeb\x8a\x94 \xea\xb2\x83\xeb\x93\xa4 \xeb\xaa\xa8\xec\x9d\x8c (C++ 11 FAQs - Bjarne Stroustup)', 209: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <6 - 1. C++ \xed\x91\x9c\xec\xa4\x80 \xeb\xac\xb8\xec\x9e\x90\xec\x97\xb4 & \xeb\xb6\x80\xeb\xaa\xa8\xec\x9d\x98 \xea\xb2\x83\xec\x9d\x84 \xeb\xac\xbc\xeb\xa0\xa4\xec\x93\xb0\xec\x9e\x90 - \xec\x83\x81\xec\x86\x8d>', 210: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <6 - 2.  \xea\xb0\x80\xec\x83\x81(virtual) \xed\x95\xa8\xec\x88\x98\xec\x99\x80 \xeb\x8b\xa4\xed\x98\x95\xec\x84\xb1>', 211: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <6 - 3. \xea\xb0\x80\xec\x83\x81\xed\x95\xa8\xec\x88\x98\xec\x99\x80 \xec\x83\x81\xec\x86\x8d\xec\x97\x90 \xea\xb4\x80\xeb\xa0\xa8\xed\x95\x9c \xec\x9e\xa1\xeb\x8b\xa4\xed\x95\x9c \xeb\x82\xb4\xec\x9a\xa9\xeb\x93\xa4>', 213: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <7 - 1. C++ \xec\x97\x90\xec\x84\x9c\xec\x9d\x98 \xec\x9e\x85\xec\xb6\x9c\xeb\xa0\xa5 (istream, ostream)>', 214: 'C \xec\x96\xb8\xec\x96\xb4 \xeb\xb0\x8f \xea\xb0\x95\xec\xa2\x8c \xea\xb4\x80\xeb\xa0\xa8 \xec\x9e\x90\xec\xa3\xbc \xec\xa7\x88\xeb\xac\xb8\xeb\x90\x98\xeb\x8a\x94 \xea\xb2\x83\xeb\x93\xa4\xec\x97\x90 \xeb\x8c\x80\xed\x95\x9c \xeb\x8b\xb5\xeb\xb3\x80', 215: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <7 - 2. C++ \xec\x97\x90\xec\x84\x9c \xed\x8c\x8c\xec\x9d\xbc \xec\x9e\x85\xec\xb6\x9c\xeb\xa0\xa5 - ifstream. ofstream, stringstream>', 217: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <8 - 1. Excel \xeb\xa7\x8c\xeb\x93\xa4\xea\xb8\xb0 \xed\x94\x84\xeb\xa1\x9c\xec\xa0\x9d\xed\x8a\xb8 1\xeb\xb6\x80>', 218: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <8 - 2. Excel \xeb\xa7\x8c\xeb\x93\xa4\xea\xb8\xb0 \xed\x94\x84\xeb\xa1\x9c\xec\xa0\x9d\xed\x8a\xb8 2\xeb\xb6\x80>', 219: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <9 - 1. \xec\xbd\x94\xeb\x93\x9c\xeb\xa5\xbc \xec\xb0\x8d\xec\x96\xb4\xeb\x82\xb4\xeb\x8a\x94 \xed\x8b\x80 - C++ \xed\x85\x9c\xed\x94\x8c\xeb\xa6\xbf(template)>', 220: '\xeb\xb9\x84\xec\xa3\xbc\xec\x96\xbc \xec\x8a\xa4\xed\x8a\x9c\xeb\x94\x94\xec\x98\xa4 2017 \xec\xbb\xa4\xeb\xae\xa4\xeb\x8b\x88\xed\x8b\xb0\xec\x97\x90\xec\x84\x9c C/C++ \xed\x94\x84\xeb\xa1\x9c\xea\xb7\xb8\xeb\x9e\x98\xeb\xb0\x8d \xed\x95\x98\xea\xb8\xb0', 221: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <9 - 2. \xed\x85\x9c\xed\x94\x8c\xeb\xa6\xbf \xeb\xa9\x94\xed\x83\x80 \xed\x94\x84\xeb\xa1\x9c\xea\xb7\xb8\xeb\x9e\x98\xeb\xb0\x8d (Template Meta programming)>', 222: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <9 - 3. \xed\x85\x9c\xed\x94\x8c\xeb\xa6\xbf \xeb\xa9\x94\xed\x83\x80 \xed\x94\x84\xeb\xa1\x9c\xea\xb7\xb8\xeb\x9e\x98\xeb\xb0\x8d 2>', 223: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <10 - 1. C++ STL - \xeb\xb2\xa1\xed\x84\xb0(vector), \xeb\xa6\xac\xec\x8a\xa4\xed\x8a\xb8(list), \xeb\x8d\xb0\xed\x81\xac(deque)>', 224: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <10 - 2. C++ STL - \xec\x85\x8b(set), \xeb\xa7\xb5(map), unordered_set, unordered_map>', 225: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <10 - 3. C++ STL - \xec\x95\x8c\xea\xb3\xa0\xeb\xa6\xac\xec\xa6\x98(algorithm)>', 227: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <11 - 1. \xec\x9a\xb0\xec\xb8\xa1\xea\xb0\x92 \xeb\xa0\x88\xed\x8d\xbc\xeb\x9f\xb0\xec\x8a\xa4\xec\x99\x80 \xec\x9d\xb4\xeb\x8f\x99 \xec\x83\x9d\xec\x84\xb1\xec\x9e\x90>', 228: '\xec\x94\xb9\xec\x96\xb4\xeb\xa8\xb9\xeb\x8a\x94 C++ - <11 - 2. Move \xeb\xac\xb8\xeb\xb2\x95 (move semantics) \xea\xb3\xbc \xec\x99\x84\xeb\xb2\xbd\xed\x95\x9c \xec\xa0\x84\xeb\x8b\xac (perfect forwarding)>'}"
  #print(t.decode('utf8'))
  d = {
      5:
      '씹어먹는 C 언어 - <1. C 언어가 뭐야?>',
      6:
      '씹어먹는 C 언어 - <2 - 1. C 언어 본격 맛보기>',
      7:
      '씹어먹는 C 언어 - <3. 변수가 뭐지? >',
      8:
      '씹어먹는 C 언어 - <4. 계산하리 >',
      9:
      '씹어먹는 C 언어 - <5. 문자 입력 받기>',
      10:
      '씹어먹는 C 언어 - <6. 만약에...(if 문)>',
      12:
      '씹어먹는 C 언어 - <7. 뱅글 뱅글 (for, while) >',
      14:
      '씹어 먹는 C 언어 - <8. 우분투 리눅스에서 C 프로그래밍 하기>',
      16:
      '씹어먹는 C 언어 - <9. 만약에... 2탄 (switch 문)>',
      17:
      '씹어 먹는 C 언어 - <10. 연예인 캐스팅(?) (C 언어에서의 형 변환)>',
      18:
      '씹어먹는 C 언어 - <11 - 1. C 언어의 아파트 (배열), 상수>',
      19:
      '씹어먹는 C 언어 - <2 - 2. 주석(Comment)에 대한 이해>',
      20:
      '씹어먹는 C 언어 - <11 - 2. C 언어의 아파트2 (고차원의 배열)>',
      21:
      '씹어먹는 C 언어 - <2 - 3. 수를 표현하는 방법(기수법)>',
      23:
      '씹어먹는 C 언어 - <12 - 1. 포인터는 영희이다! (포인터)>',
      24:
      '씹어먹는 C 언어 - <12 - 2. 포인터는 영희이다! (포인터)>',
      25:
      '씹어먹는 C 언어 - <12 - 3. 포인터는 영희이다! (포인터)>',
      26:
      '씹어먹는 C 언어 - <13 - 1. 마술 상자 함수(function)>',
      27:
      '씹어먹는 C 언어 - <13 - 2. 마술 상자 함수 2 (function)>',
      28:
      '씹어먹는 C 언어 - <13 - 3. 마술 상자 함수 3 (function)>',
      29:
      '씹어먹는 C 언어 - <15 - 1. 일로와봐, 문자열(string)>',
      30:
      '씹어먹는 C 언어 - <13 - 4. 마술 상자 함수 (생각해볼 문제에 대한 아이디어)>',
      31:
      '씹어먹는 C 언어 - <14. 컴퓨터의 머리로 따라가보자 - 디버깅(debugging)>',
      32:
      '씹어먹는 C 언어 - <15 - 2. 일로와봐, 문자열(string) - 버퍼에 관한 이해>',
      33:
      '씹어먹는 C 언어 - <15 - 3. 일로와봐, 문자열(string) - 문자열 지지고 볶기 & 리터럴>',
      34:
      'C 언어 레퍼런스 - stdio.h (cstdio) 헤더파일',
      35:
      'C 언어 레퍼런스 - printf 함수',
      36:
      'C 언어 레퍼런스 - scanf 함수',
      37:
      'C 언어 레퍼런스 - fgetc 함수',
      38:
      'C 언어 레퍼런스 - fgets 함수',
      39:
      'C 언어 레퍼런스 -  fputc 함수',
      40:
      'C 언어 레퍼런스 - fputs 함수',
      41:
      'C 언어 레퍼런스 - getc 함수',
      43:
      '씹어먹는 C 언어 - <15 - 4. 일로와봐, 문자열(string) - 도서 관리 프로젝트>',
      44:
      'C 언어 레퍼런스 - getchar 함수',
      45:
      'C 언어 레퍼런스 - gets 함수',
      46:
      'C 언어 레퍼런스 - putc 함수',
      47:
      'C 언어 레퍼런스 - putchar 함수',
      48:
      'C 언어 레퍼런스 - puts 함수',
      49:
      'C 언어 레퍼런스 - ungetc 함수',
      50:
      'C 언어 레퍼런스 - clearerr 함수',
      51:
      'C 언어 레퍼런스 - feof 함수',
      52:
      'C 언어 레퍼런스 - ferror 함수',
      53:
      'C 언어 레퍼런스 - perror 함수',
      54:
      'C 언어 레퍼런스 - fclose 함수',
      55:
      '씹어먹는 C 언어 - <16 - 1. 모아 모아 구조체(struct)>',
      57:
      'C 언어 레퍼런스 - fflush 함수',
      58:
      'C 언어 레퍼런스 - fopen 함수',
      59:
      'C 언어 레퍼런스 - freopen 함수',
      60:
      '씹어먹는 C 언어 - <16 - 2. 모아 모아 구조체(struct) - 구조체 인자로 가진 함수>',
      61:
      'C 언어 레퍼런스 - setbuf 함수',
      62:
      'C 언어 레퍼런스 - setvbuf 함수',
      64:
      'C 언어 레퍼런스 - fprintf 함수',
      65:
      'C 언어 레퍼런스 - fscanf 함수',
      66:
      'C 언어 레퍼런스 - sprintf 함수',
      67:
      'C 언어 레퍼런스 - sscanf 함수',
      68:
      'C 언어 레퍼런스 - fread 함수',
      69:
      'C 언어 레퍼런스 - fwrite 함수',
      70:
      'C 언어 레퍼런스 - fgetpos 함수',
      71:
      '씹어먹는 C 언어 - <16 - 3. 구조체와 친구들(공용체(union), 열거형(enum))>',
      72:
      'C 언어 레퍼런스 - fseek 함수',
      73:
      'C 언어 레퍼런스 - fsetpos 함수',
      74:
      'C 언어 레퍼런스 - ftell 함수',
      75:
      'C 언어 레퍼런스 - rewind 함수',
      76:
      'C 언어 레퍼런스 - string.h (cstring) 헤더파일',
      77:
      'C 언어 레퍼런스 - memcpy 함수',
      78:
      'C 언어 레퍼런스 - memmove 함수',
      79:
      'C 언어 레퍼런스 - strcpy 함수',
      80:
      'C 언어 레퍼런스 - strncpy 함수',
      81:
      'C 언어 레퍼런스 - strcat 함수',
      82:
      'C 언어 레퍼런스 - strncat 함수',
      83:
      '씹어먹는 C 언어 - <17. 변수의 생존 조건 및 데이터 세그먼트의 구조>',
      84:
      'C 언어 레퍼런스 - memcmp 함수',
      85:
      'C 언어 레퍼런스 - strcmp 함수',
      86:
      'C 언어 레퍼런스- strcoll 함수',
      87:
      '씹어먹는 C 언어 - <18 - 1. 파일 뽀개기 (헤더파일과 #include) >',
      88:
      '씹어먹는 C 언어 - <18 - 2. 파일 뽀개기 (# 친구들, 라이브러리)>',
      89:
      '씹어먹는 C 언어 - <19. main 함수의 인자, 텅 빈 void 형>',
      90:
      'C 언어 레퍼런스 - strncmp 함수',
      91:
      'C 언어 레퍼런스 - strxfrm 함수',
      92:
      'C 언어 레퍼런스 - memchr 함수',
      93:
      'C 언어 레퍼런스 - strchr 함수',
      94:
      'C 언어 레퍼런스 - strcspn 함수',
      95:
      'C 언어 레퍼런스 - strpbrk 함수',
      96:
      'C 언어 레퍼런스 - strrchr 함수',
      97:
      'C 언어 레퍼런스 - strspn 함수',
      98:
      '씹어먹는 C 언어 - <20 - 1. 동동동 메모리 동적할당(Dynamic Memory Allocation)>',
      99:
      '씹어먹는 C 언어 - <21. 매크로 함수, 인라인 함수>',
      100:
      '씹어먹는 C 언어 - <20 - 2. 메모리 동적할당 + 메모리 갖고 놀기>',
      101:
      'C 언어 레퍼런스 - strstr 함수',
      102:
      'C 언어 레퍼런스 - strtok 함수',
      103:
      '씹어먹는 C 언어 - <22. C 언어의 잡다한 키워드들 (typedef, volatile, #pragma)>',
      104:
      'C 언어 레퍼런스 - memset 함수',
      105:
      'C 언어 레퍼런스 - strerror 함수',
      106:
      'C 언어 레퍼런스 - strlen 함수',
      108:
      'C 언어 레퍼런스 - time.h 헤더파일',
      109:
      'C 언어 레퍼런스 - struct tm ( tm 구조체 )',
      110:
      'C 언어 레퍼런스 - clock 함수',
      111:
      'C 언어 레퍼런스 - difftime 함수',
      112:
      'C 언어 레퍼런스 - mktime 함수',
      113:
      'C 언어 레퍼런스 - time_t 형',
      114:
      'C 언어 레퍼런스 - time 함수',
      115:
      '100 번째 글을 돌파하며',
      116:
      'C 언어 레퍼런스 - asctime 함수',
      117:
      '씹어먹는 C 언어 - <23 - 1. 파일 하고 이야기 하기 (파일 입출력에 대한 기본적 이해)>',
      118:
      'C 언어 레퍼런스 - ctime 함수',
      119:
      'C 언어 레퍼런스 - gmtime 함수',
      120:
      'C 언어 레퍼런스 - localtime 함수',
      121:
      'C 언어 레퍼런스 - stdlib.h (cstlib)',
      122:
      'C 언어 레퍼런스 - strftime 함수',
      123:
      '씹어먹는 C 언어 - <23 - 2. 파일 하고 이야기 하기 (파일 입출력)>',
      124:
      'C 언어 레퍼런스 - atof 함수',
      125:
      '씹어먹는 C 언어 - <23 - 3. 파일 하고 이야기 하기 (파일 입출력 - 마무리)>',
      129:
      '씹어먹는 C 언어 - <24. 더 빠르게 실행되는 코드를 위하여 (C 코드 최적화)>',
      130:
      '초보자를 위한 C 언어 강좌 - 씹어먹는 C 언어 (완결)',
      131:
      'C 언어 레퍼런스 - atoi 함수',
      132:
      'C 언어 레퍼런스 - atol 함수',
      133:
      '티스토리용 통계 프로그램 (댓글, 포스트, 방문자 등등) - tistory_stat (v.0.1)',
      134:
      '씹어먹는 C++ - <1. 자~ C++ 의 세계로>',
      135:
      '씹어먹는 C++ 강좌 계획',
      136:
      '씹어먹는 C++ - <1 - 2. 첫 C++ 프로그램 분석하기>',
      138:
      '씹어먹는 C++ - <2 - 1. C++ 은 C 친구 - C 와 공통점>',
      139:
      'C 언어 레퍼런스 - rand 함수',
      140:
      'C 언어 레퍼런스 - srand 함수',
      141:
      '씹어먹는 C++ - <2 - 2. C++ 은 C 친구일까?>',
      142:
      '비주얼 스튜디오에서 소스 한꺼번에 정렬하기',
      143:
      'C++ IOstream (입출력) 라이브러리',
      144:
      'C++ 레퍼런스 - ios_base 클래스',
      145:
      'C++ 레퍼런스 - ios 클래스',
      146:
      'C++ 레퍼런스 - istream 클래스',
      147:
      'C++ 레퍼런스 - istream::operator>> (추출 연산자)',
      149:
      'C++ 레퍼런스 - istream::getline 함수',
      150:
      'C++ 레퍼런스 - ios::exceptions',
      151:
      'C++ 레퍼런스 - ifstream 클래스',
      152:
      'C++ 레퍼런스 - ios_base::width',
      153:
      'C++ 레퍼런스 - ios_base::flags 함수',
      154:
      'C++ 레퍼런스 - ios_base::fmtflags 타입',
      155:
      'C++ 레퍼런스 - ios_base::setf 함수',
      156:
      'C++ 레퍼런스 - ios_base::usetf 함수',
      157:
      'C++ 레퍼런스 - ios_base::precision 함수',
      158:
      'C++ 레퍼런스 - ios_base::imbue',
      159:
      'C++ 레퍼런스 - ios_base::register_callback 함수',
      160:
      'C++ 레퍼런스 - ios_base::getloc 함수',
      161:
      'C++ 레퍼런스 - ios_base::iword',
      162:
      'C++ 레퍼런스 - ios_base::xalloc 함수',
      163:
      'C++ 레퍼런스 - ios_base::pword 함수',
      164:
      'C++ 레퍼런스 - ios::good 함수',
      165:
      'C++ 레퍼런스 - ios::fail 함수',
      166:
      'C++ 레퍼런스 - ios::bad 함수',
      167:
      'C++ 레퍼런스 - ios::eof 함수',
      168:
      'C++ 레퍼런스 - ios::operator!',
      169:
      '씹어먹는 C++ - <3. C++ 의 세계로 오신 것을 환영합니다. (new, delete)>',
      170:
      'C++ 레퍼런스 - ios::operator void*',
      171:
      'C++ 레퍼런스 - ios::rdstate 함수',
      172:
      '씹어먹는 C++ - <4 - 1. 이 세상은 객체로 이루어져 있다>',
      173:
      '씹어먹는 C++ - <4 - 2. 클래스의 세계로 오신 것을 환영합니다. (함수의 오버로딩, 생성자) >',
      174:
      'C++ 레퍼런스 - STL 컨테이너 (STL Container)',
      175:
      'C++ 레퍼런스 - STL 컨테이너 - vector',
      176:
      'C++ 레퍼런스 - STL 컨테이너 - deque',
      177:
      'C++ 레퍼런스 - STL 컨테이너 - list',
      178:
      'C++ 레퍼런스 - STL 컨테이너 - vector 생성자',
      179:
      'C++ 레퍼런스 - ios::setstate 함수',
      180:
      'C++ 레퍼런스 - ios::clear',
      181:
      'C++ 레퍼런스 - ios::fill 함수',
      182:
      'C++ 레퍼런스 - ios::rdbuf 함수',
      183:
      'C++ 레퍼런스 - STL 컨테이너 - vector::assign 함수',
      184:
      '씹어먹는 C 언어 - 찾아보기',
      185:
      'C++ 레퍼런스 - vector::push_back',
      186:
      'C++ 레퍼런스 - vector::insert',
      187:
      '씹어먹는 C 언어 강좌 - PDF 파일',
      188:
      '씹어먹는 C++ - <4 - 3. 스타크래프트를 만들자 ① (복사 생성자, 소멸자)>',
      189:
      '씹어먹는 C++ 토막글 ① - Rvalue(우측값) 레퍼런스에 관해',
      190:
      'C++ 레퍼런스 - ios::tie 함수',
      191:
      'C++ 레퍼런스 - istream::get 함수',
      192:
      'C++ 레퍼런스 - istream::gcount 함수',
      193:
      'C++ 레퍼런스 - istream::ignore 함수',
      194:
      'C++ 레퍼런스 - istream::peak 함수',
      195:
      '비주얼 스튜디오 2010 에서 C 및 C++ 프로그래밍 하기',
      196:
      '씹어먹는 C++ 토막글 ② - 람다(lambda) 함수',
      197:
      '씹어먹는 C++ - <4 - 4. 스타크래프트를 만들자 ② (const, static)>',
      198:
      '씹어먹는 C++ - <4 - 5. 내가 만드는 String 클래스>',
      199:
      '모든 컴퓨터 과학자가 알아야 할 부동 소수점의 모든 것(What Every Computer Scientists Should Know About Floating Point Arithmetic)',
      201:
      '오픈북 프로젝트 - 양질의 컴퓨터 문서 공급 프로젝트',
      202:
      '씹어먹는 C++ - <5 - 1. 내가 만든 연산자 - 연산자 오버로딩>',
      203:
      '씹어먹는 C++ - <5 - 2. 입출력, 첨자, 타입변환, 증감 연산자 오버로딩>',
      204:
      '씹어먹는 C++ - <5 - 3. 연산자 오버로딩 프로젝트 - N 차원 배열>',
      208:
      'C++ 11 자주 질문되는 것들 모음 (C++ 11 FAQs - Bjarne Stroustup)',
      209:
      '씹어먹는 C++ - <6 - 1. C++ 표준 문자열 & 부모의 것을 물려쓰자 - 상속>',
      210:
      '씹어먹는 C++ - <6 - 2.  가상(virtual) 함수와 다형성>',
      211:
      '씹어먹는 C++ - <6 - 3. 가상함수와 상속에 관련한 잡다한 내용들>',
      213:
      '씹어먹는 C++ - <7 - 1. C++ 에서의 입출력 (istream, ostream)>',
      214:
      'C 언어 및 강좌 관련 자주 질문되는 것들에 대한 답변',
      215:
      '씹어먹는 C++ - <7 - 2. C++ 에서 파일 입출력 - ifstream. ofstream, stringstream>',
      217:
      '씹어먹는 C++ - <8 - 1. Excel 만들기 프로젝트 1부>',
      218:
      '씹어먹는 C++ - <8 - 2. Excel 만들기 프로젝트 2부>',
      219:
      '씹어먹는 C++ - <9 - 1. 코드를 찍어내는 틀 - C++ 템플릿(template)>',
      220:
      '비주얼 스튜디오 2017 커뮤니티에서 C/C++ 프로그래밍 하기',
      221:
      '씹어먹는 C++ - <9 - 2. 템플릿 메타 프로그래밍 (Template Meta programming)>',
      222:
      '씹어먹는 C++ - <9 - 3. 템플릿 메타 프로그래밍 2>',
      223:
      '씹어먹는 C++ - <10 - 1. C++ STL - 벡터(vector), 리스트(list), 데크(deque)>',
      224:
      '씹어먹는 C++ - <10 - 2. C++ STL - 셋(set), 맵(map), unordered_set, unordered_map>',
      225:
      '씹어먹는 C++ - <10 - 3. C++ STL - 알고리즘(algorithm)>',
      227:
      '씹어먹는 C++ - <11 - 1. 우측값 레퍼런스와 이동 생성자>',
      228:
      '씹어먹는 C++ - <11 - 2. Move 문법 (move semantics) 과 완벽한 전달 (perfect forwarding)>'
  }
  print(json.dumps(d, ensure_ascii=False))
