----------------
title : 2020년 마무리 및 2021년 계획
path : /잡담
publish_date : 2021-01-18
----------------

다사다난했던 2020년이 끝나고 2021년이 되었습니다. 작년 한 해 동안 모두의 코드 웹사이트 업데이트 현황을 정리하면서 2021년에는 어떠한 내용으로 찾아갈지 이야기 해보고자 합니다.

### 2020 년 정리
#### 씹어먹는 C++ 완결

마침내 2020년이 되어서야 씹어먹는 C++ 강의를 완결 시킬 수 있었습니다. 첫 글을 작성한 것이 2011년 이였으니까 꼬박 10년 가까히 걸렸네요. 물론 앞으로 C++ 에 관련된 글을 안쓴다는 것은 아니고, 이전에 기획하였던 C++ 강의 내용을 (C++ 17 까지) 마무리 지었다는 의미 입니다.

그 외에 계획하고 있는 글들은 모두 씹어먹는 C++ 의 부록 형태로 제공할 것이고 C++ 20 이 본격적으로 도입이 된다면 아예 씹어먹는 C++ 20 이라는 이름으로 따로 강의를 제작하고 싶네요.

#### X86/64 명령어 셋 레퍼런스 업로드

왠지는 모르겠지만 X86-64 명령어 셋은 인텔과 AMD 웹사이트에서 PDF 파일로만 제공되고 따로 검색이 쉽게 가능한 웹사이트로는 제공되지 않습니다. ARM 어셈블리의 경우 웹사이트에 잘 정리되어 있는 것과는 많이 대조적이죠.

그래서 아예 인텔 명령어 어셈블리 레퍼런스 PDF 전체를 직접 파싱해서 사이트에 업로드 하였습니다. PDF 를 파싱하는 일은 꽤나 골치가 아팠는데 PDF 라는 문서 형식 자체가 **문서를 동일하게 보여주기 위한 포맷** 이지 정보를 간단히 추출하게 해주는 포맷이 아니기 때문이죠. 기존에 C++ 로 제공되는 PDF 라이브러리를 활용하려고 했으나 마땅히 없어서 그냥 제가 직접 PDF 파싱 라이브러리를 만들어서 사용하였습니다.

전체 인텔 명령어들은 *X86-64 명령어 레퍼런스* 에서 읽을 수 있습니다.

![caption=덕분에 어셈블리 명령어들에 모두 링크를 걸 수 있었습니다. 위에 명령어들 `lea`, `mov` 등등을 누르면 해당 명령어 레퍼런스 페이지로 이동합니다.](/img/random/asm.png)

이 덕분에 제 웹사이트에서 임베딩 하는 모든 어셈블리 코드들의 명령어들에 적절한 라이브러리 링크를 걸 수 있게 되었습니다.

#### 마크다운 파서 업그레이드

기존에 사용하던 마크 다운 파서는 여러 한계점들이 있어서 아예 처음부터 다시 재작성 하였습니다. ([코드](https://github.com/kev0960/md2)) 덕분에 이전 버전보다 속도를 10 배 이상 향상 시킬 수 있었습니다. 

특히 가장 큰 성능 향상은 기존에 사용하던 clang-format 을 바탕으로 [clang-format-server](https://github.com/kev0960/llvm-project) 를 제작한 것이였습니다.

clang-format 은 제가 모두의 코드에 보여지는 모든 코드들을 정렬하는데 사용하는 프로그램인데, 코드 정렬을 해야 할 때 마다 해당 프로그램을 프로세스로 만들어서 실행해야 했기 때문입니다. fork 후 execve 는 상당히 느리기 때문에 마크 다운에서 HTML 로의 변환이 느린 주요 문제였습니다. 하지만 이제는 clang-format 을 바탕으로 clang-format-server 를 만들어서 아예 매 번 fork 를 할 필요 없이 clang-format 을 서버의 형태로 계속 띄어놓고 정렬이 필요한 코드가 있으면 요청을 주고 받는 형식으로 만들었습니다. 

### 2021년 계획

#### C++ 20 에 관한 글 쓰기

21년이 되면 C++ 20 에서 추가된 내용들도 컴파일러들에 많이 구현이 될 터이니 이에 관해서 한 번 글을 써보고 싶습니다. 특히 C++ 20 에는 기대되는 내용들이 엄청 많습니다. concept 이러던지, module 이라던지, coroutine 이라던지 ...

#### 알고리즘 및 자료 구조에 관한 글 쓰기

기존에 알고리즘에 관한 글을 연재하고 있었는데 시간을 별로 할애할 수 가 없어서 중단 상태로 방치시켰습니다. 21년에는 여유를 조금 내서 해당 내용에 관련한 글들을 써보고자 합니다. 또한 알고리즘 **만** 쓰기에는 아쉬운 점이 많은데, 아예 그냥 여러가지 중요한 자료 구조들에 대해서도 복합적으로 써보고자 합니다. 

#### 운영체제 개발에 관한 글 쓰기

사실 2019년 부터 취미로 [간단한 운영체제를 개발](https://github.com/kev0960/modooOS)하고 있었는데, 2020년 중반에 가서야 마무리 할 수 있었습니다. 

```embed
<iframe width="560" height="315" src="https://www.youtube.com/embed/eJ8qK4nb4ck" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
```

위는 제가 만든 운영체제에서 DOOM 이라는 게임을 돌리는 모습입니다. 제 운영체제는 64 비트 운영체제로 멀티 코어를 지원하고 있습니다. 이 운영체제를 만들면서 우여곡절도 많고 배운 점도 많았기에 이에 관해서 (아니면 그냥 시스템 프로그래밍에 관한 전반적인 내용에 대해) 글로 써보고 싶습니다. 
