----------------------------
title : VDBPSADBW (Intel x86/64 assembly instruction)
cat_title : VDBPSADBW
ref_title : VDBPSADBW
published : 2020-09-01
path : /X86-64 명령어 레퍼런스/V
publish_date: 2020-09-01
----------------------------


#@ VDBPSADBW

**Double Block Packed Sum-Absolute-Differences (SAD) on Unsigned Bytes**

```lec-info
아래 표를 해석하는 방법은 [x86-64 명령어 레퍼런스 읽는 법](/316) 글을 참조하시기 바랍니다.
```

|**Opcode/**\newline{}**Instruction**|**Op / **\newline{}**En**|**64/32 **\newline{}**bit Mode **\newline{}**Support**|**CPUID **\newline{}**Feature **\newline{}**Flag**|**Description**|
|------------------------------------|-------------------------|------------------------------------------------------|--------------------------------------------------|---------------|
|`EVEX.NDS.128.66.0F3A.W0 42 /r ib`\newline{}`VDBPSADBW` \tooltip{xmm1}{128 비트 XMM 레지스터로 XMM0 부터 XMM7 까지 있다. 64 비트 모드에서는 XMM8 부터 XMM15 까지 추가적으로 사용할 수 있다.} \tooltip{\{k1\}\{z\}}{쓰기 마스크 (write mask) 레지스터로 64 비트 k 레지스터로 k1 부터 k7 까지 사용 가능하다. 쓰기 마스크는 오직 EVEX 접두사가 있을 경우에만 사용 가능하다. 마스크 방식으로 마스크 되지 않는 부분의 값을 유지하는 병합 마스크 (merge mask) 가 있고, 해당 부분을 아예 0 으로 지워버리는 zeroing mask 방식이 있다. 어떤 식으로 마스크를 할 지는 EVEX.z 필드의 비트값에 따라 달라진다.} \tooltip{xmm2}{128 비트 XMM 레지스터로 XMM0 부터 XMM7 까지 있다. 64 비트 모드에서는 XMM8 부터 XMM15 까지 추가적으로 사용할 수 있다.} \tooltip{xmm3/m128}{128 비트 XMM 레지스터 혹은 128 비트 메모리 데이터.} \tooltip{imm8}{1 바이트 짜리 명시적 데이터 (immediate value). imm8 의 경우 부호 있는 정수를 의미하며, -128 부터 127 까지의 값을 표현할 수 있다. 참고로 만일 imm8 이 1 바이트 보다 큰 피연산자를 가지는 명령어와 사용될 경우, 명시적 데이터는 부호를 유지한채 해당 크기로 확장이 된다. (쉽게 말해 0b11000000 은 0b11111111 11000000 로 확장되며 0b00110000 은 0b00000000 00110000 으로 확장된다.)} |FVM|V/V|AVX512VL\newline{}AVX512BW|Compute packed SAD word results of unsigned bytes in dword block from xmm2 with unsigned bytes of dword blocks transformed from xmm3/m128 using the shuffle controls in imm8. Results are written to xmm1 under the writemask k1.|
|`EVEX.NDS.256.66.0F3A.W0 42 /r ib`\newline{}`VDBPSADBW` \tooltip{ymm1}{256 비트 YMM 레지스터로 YMM0 부터 YMM7 까지 있다. 64 비트 모드에서는 YMM8 부터 YMM15 까지 추가적으로 사용할 수 있다.} \tooltip{\{k1\}\{z\}}{쓰기 마스크 (write mask) 레지스터로 64 비트 k 레지스터로 k1 부터 k7 까지 사용 가능하다. 쓰기 마스크는 오직 EVEX 접두사가 있을 경우에만 사용 가능하다. 마스크 방식으로 마스크 되지 않는 부분의 값을 유지하는 병합 마스크 (merge mask) 가 있고, 해당 부분을 아예 0 으로 지워버리는 zeroing mask 방식이 있다. 어떤 식으로 마스크를 할 지는 EVEX.z 필드의 비트값에 따라 달라진다.} \tooltip{ymm2}{256 비트 YMM 레지스터로 YMM0 부터 YMM7 까지 있다. 64 비트 모드에서는 YMM8 부터 YMM15 까지 추가적으로 사용할 수 있다.} \tooltip{ymm3/m256}{YMM 레지스터나 256 비트 메모리 데이터.} \tooltip{imm8}{1 바이트 짜리 명시적 데이터 (immediate value). imm8 의 경우 부호 있는 정수를 의미하며, -128 부터 127 까지의 값을 표현할 수 있다. 참고로 만일 imm8 이 1 바이트 보다 큰 피연산자를 가지는 명령어와 사용될 경우, 명시적 데이터는 부호를 유지한채 해당 크기로 확장이 된다. (쉽게 말해 0b11000000 은 0b11111111 11000000 로 확장되며 0b00110000 은 0b00000000 00110000 으로 확장된다.)} |FVM|V/V|AVX512VL\newline{}AVX512BW|Compute packed SAD word results of unsigned bytes in dword block from ymm2 with unsigned bytes of dword blocks transformed from ymm3/m256 using the shuffle controls in imm8. Results are written to ymm1 under the writemask k1.|
|`EVEX.NDS.512.66.0F3A.W0 42 /r ib`\newline{}`VDBPSADBW` zmm1 \tooltip{\{k1\}\{z\}}{쓰기 마스크 (write mask) 레지스터로 64 비트 k 레지스터로 k1 부터 k7 까지 사용 가능하다. 쓰기 마스크는 오직 EVEX 접두사가 있을 경우에만 사용 가능하다. 마스크 방식으로 마스크 되지 않는 부분의 값을 유지하는 병합 마스크 (merge mask) 가 있고, 해당 부분을 아예 0 으로 지워버리는 zeroing mask 방식이 있다. 어떤 식으로 마스크를 할 지는 EVEX.z 필드의 비트값에 따라 달라진다.} zmm2 \tooltip{zmm3/m512}{ZMM 레지스터나 512 비트 메모리 데이터.} \tooltip{imm8}{1 바이트 짜리 명시적 데이터 (immediate value). imm8 의 경우 부호 있는 정수를 의미하며, -128 부터 127 까지의 값을 표현할 수 있다. 참고로 만일 imm8 이 1 바이트 보다 큰 피연산자를 가지는 명령어와 사용될 경우, 명시적 데이터는 부호를 유지한채 해당 크기로 확장이 된다. (쉽게 말해 0b11000000 은 0b11111111 11000000 로 확장되며 0b00110000 은 0b00000000 00110000 으로 확장된다.)} |FVM|V/V|AVX512BW|Compute packed SAD word results of unsigned bytes in dword block from zmm2 with unsigned bytes of dword blocks transformed from zmm3/m512 using the shuffle controls in imm8. Results are written to zmm1 under the writemask k1.|
###                                                      Instruction Operand Encoding


Op/En Operand 1 Operand 2 Operand 3 Operand 4

FVM ModRM:reg (w) EVEX.vvvv ModRM:r/m (r) Imm8

### Description


Compute packed SAD (sum of absolute differences) word results of unsigned bytes from two 32-bit dword elements. Packed SAD word results are calculated in multiples of qword superblocks, producing 4 SAD word results in each 64-bit superblock of the destination register. 

Within each super block of packed word results, the SAD results from two 32-bit dword elements are calculated as follows:

*  The lower two word results are calculated each from the SAD operation between a sliding dword element within a qword superblock from an intermediate vector with a stationary dword element in the corresponding qword superblock of the first source operand. The intermediate vector, see "Tmp1" in Figure 5-8, is constructed from the second source operand the imm8 byte as shuffle control to select dword elements within a 128-bit lane of the second source operand. The two sliding dword elements in a qword superblock of Tmp1 are located at byte offset 0 and 1 within the superblock, respectively. The stationary dword element in the qword superblock from the first source operand is located at byte offset 0.

*  The next two word results are calculated each from the SAD operation between a sliding dword element within a qword superblock from the intermediate vector Tmp1 with a second stationary dword element in the corre-sponding qword superblock of the first source operand. The two sliding dword elements in a qword superblock of Tmp1 are located at byte offset 2and 3 within the superblock, respectively. The stationary dword element in the qword superblock from the first source operand is located at byte offset 4.

*  The intermediate vector is constructed in 128-bits lanes. Within each 128-bit lane, each dword element of the intermediate vector is selected by a two-bit field within the imm8 byte on the corresponding 128-bits of the second source operand. The imm8 byte serves as dword shuffle control within each 128-bit lanes of the inter-mediate vector and the second source operand, similarly to `PSHUFD`.

The first source operand is a ZMM/YMM/XMM register. The second source operand is a ZMM/YMM/XMM register, or a 512/256/128-bit memory location. The destination operand is conditionally updated based on writemask k1 at 16-bit word granularity.

```embed
<figure>
<svg viewBox="0 0 493.560028 491.640015">
<rect x="0.000000" y="10.000000" width="0.480000" height="394.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="493.079987" y="10.000000" width="0.480040" height="394.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="0.000000" y="9.520020" width="493.559998" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="0.000000" y="404.500031" width="493.559998" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="111.599991" y="376.720001" width="288.239990" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="399.359985" y="376.960022" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="111.360001" y="389.980011" width="288.239990" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="111.360001" y="376.720001" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="327.359985" y="377.020020" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="327.359985" y="377.260010" width="0.480010" height="13.200000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="255.359985" y="377.020020" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="255.359985" y="377.260010" width="0.480010" height="13.200000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="183.360001" y="377.020020" width="0.480000" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="183.360001" y="377.260010" width="0.480000" height="13.200000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="289.320007" y="201.220032" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="358.199982" y="201.460022" width="0.479980" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="289.079987" y="213.220001" width="69.360001" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="289.079987" y="201.220032" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="306.359985" y="201.220032" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="306.359985" y="201.460022" width="0.480010" height="12.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="323.639984" y="201.220032" width="0.479980" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="323.639984" y="201.460022" width="0.479980" height="12.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="340.919983" y="201.220032" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="340.919983" y="201.460022" width="0.480010" height="12.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="289.320007" y="233.920044" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="358.199982" y="234.160034" width="0.479980" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="289.079987" y="245.920044" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="289.079987" y="233.920013" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="306.359985" y="233.920013" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="306.359985" y="234.160004" width="0.480010" height="11.940000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="323.639984" y="233.920013" width="0.479980" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="323.639984" y="234.160004" width="0.479980" height="11.940000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="340.919983" y="233.920013" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="340.919983" y="234.160004" width="0.480010" height="11.940000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="289.799988" y="177.880005" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="358.679993" y="178.119995" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="289.559998" y="189.880005" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="289.559998" y="177.880005" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="306.839996" y="177.880005" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="306.839996" y="178.119995" width="0.480010" height="12.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="324.119995" y="177.880005" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="324.119995" y="178.119995" width="0.480010" height="12.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="341.399994" y="177.880005" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="341.399994" y="178.119995" width="0.480010" height="12.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M191.339996,354.940002 L190.379990,355.059998 L189.479996,355.299988 L189.539993,355.299988 L188.699997,355.779999 L188.759995,355.720001 L188.099991,356.260010 L187.500000,356.980011 L187.559998,356.920013 L187.080002,357.760010 L187.080002,357.700012 L186.839996,358.600006 L186.720001,359.559998 L186.720001,359.500000 L186.839996,360.459991 L186.839996,360.399994 L187.080002,361.299988 L187.080002,361.239990 L187.559998,362.019989 L187.500000,362.019989 L188.099991,362.739990 L188.099991,362.679993 L188.759995,363.279999 L188.699997,363.279999 L189.539993,363.700012 L189.539993,363.640015 L190.440002,363.940002 L190.379990,363.940002 L191.339996,364.059998 L191.279999,364.059998 L191.699997,364.059998 L192.660004,363.940002 L192.599991,363.940002 L193.500000,363.640015 L193.440002,363.700012 L194.279999,363.279999 L194.940002,362.679993 L194.879990,362.739990 L195.479996,362.019989 L195.959991,361.239990 L195.899994,361.299988 L196.139999,360.399994 L196.139999,360.459991 L196.259995,359.500000 L196.259995,359.559998 L196.139999,358.600006 L195.899994,357.700012 L195.959991,357.760010 L195.479996,356.920013 L195.479996,356.980011 L194.879990,356.260010 L194.940002,356.260010 L194.279999,355.720001 L194.279999,355.779999 L193.440002,355.299988 L193.500000,355.299988 L192.599991,355.059998 L192.660004,355.059998 L191.699997,354.940002 L191.279999,354.940002 L191.279999,354.459991 L191.519989,354.459991 C193.237991 354.407990,194.922989 355.248993,195.839996 356.679993  L195.899994,356.679993 L196.379990,357.519989 L196.379990,357.580017 C197.048004 359.636017,196.822998 361.484009,195.239990 363.040009  L194.580002,363.640015 L194.519989,363.700012 C193.000000 364.648010,191.011002 364.817993,189.360001 364.119995  L189.300003,364.119995 L188.459991,363.700012 L188.459991,363.640015 L187.800003,363.040009 L187.739990,363.040009 L187.139999,362.320007 L187.139999,362.260010 L186.660004,361.480011 L186.599991,361.420013 L186.360001,360.519989 L186.239990,359.559998 L186.239990,359.500000 L186.360001,358.540009 L186.360001,358.480011 C186.589996 356.739990,188.516998 354.811005,190.259995 354.580017  L190.319992,354.580017 L191.279999,354.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M191.279999,354.940002 L191.339996,354.940002 L191.279999,354.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M296.100006,216.339996 L295.260010,216.459991 L294.480011,216.699982 L294.540009,216.699982 L293.880005,217.059998 L293.940002,217.000000 L293.339996,217.480011 L292.800018,218.079987 L292.860016,218.019989 L292.500000,218.739990 L292.500000,218.679993 L292.260010,219.459991 L292.200012,220.299988 L292.200012,220.239990 L292.260010,221.079987 L292.260010,221.019989 L292.500000,221.739990 L292.500000,221.679993 L292.860016,222.399994 L292.800018,222.399994 L293.339996,223.000000 L293.339996,222.940002 L293.940002,223.419983 L293.880005,223.419983 L294.540009,223.839996 L294.480011,223.779999 L295.260010,224.019989 L296.100006,224.079987 L296.040009,224.079987 L297.839996,224.079987 L298.679993,224.019989 L298.619995,224.019989 L299.339996,223.779999 L299.279999,223.839996 L300.000000,223.419983 L300.600006,222.940002 L300.540009,223.000000 L301.080017,222.399994 L301.440002,221.679993 L301.380005,221.739990 L301.619995,221.019989 L301.619995,221.079987 L301.679993,220.239990 L301.679993,220.299988 L301.619995,219.459991 L301.380005,218.679993 L301.440002,218.739990 L301.080017,218.019989 L301.080017,218.079987 L300.540009,217.480011 L300.600006,217.480011 L300.000000,217.000000 L300.000000,217.059998 L299.279999,216.699982 L299.339996,216.699982 L298.619995,216.459991 L298.679993,216.459991 L297.839996,216.339996 L296.040009,216.339996 L296.040009,215.859985 L297.899994,215.859985 L298.740021,215.980011 L298.800018,215.980011 L299.520020,216.220001 L299.520020,216.279999 L300.240021,216.639984 L300.300018,216.639984 L300.899994,217.119995 L300.899994,217.179993 L301.440002,217.779999 L301.500000,217.779999 L301.860016,218.500000 L301.860016,218.559998 C302.464020 220.126007,302.227020 222.161987,300.899994 223.299988  L300.300018,223.779999 L300.240021,223.839996 L299.520020,224.260010 L298.800018,224.500000 L298.740021,224.500000 L297.899994,224.559998 L296.040009,224.559998 L295.200012,224.500000 L295.140015,224.500000 L294.360016,224.260010 L294.300018,224.260010 L293.640015,223.839996 L293.640015,223.779999 L293.040009,223.299988 L292.980011,223.299988 L292.440002,222.699982 L292.440002,222.639984 L292.080017,221.919983 L292.020020,221.919983 L291.779999,221.199982 L291.779999,221.139984 C291.686005 220.295990,291.658020 219.351990,292.020020 218.559998  L292.080017,218.500000 L292.440002,217.779999 C293.113007 216.911987,294.061005 216.212982,295.140015 215.980011  L295.200012,215.980011 L296.040009,215.859985" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M296.040009,216.339996 L296.100006,216.339996 L296.040009,215.859985" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M292.320007,225.279999 L291.540009,225.339996 L291.600006,225.339996 L290.880005,225.579987 L290.160004,225.940002 L290.220001,225.880005 L289.679993,226.359985 L289.140015,226.959991 L289.200012,226.899994 L288.839996,227.559998 L288.839996,227.500000 L288.660004,228.279999 L288.540009,229.059998 L288.540009,229.000000 L288.660004,229.779999 L288.660004,229.720001 L288.839996,230.500000 L288.839996,230.440002 L289.200012,231.100006 L289.140015,231.100006 L289.679993,231.700012 L289.679993,231.639984 L290.220001,232.119995 L290.160004,232.119995 L290.880005,232.480011 L290.880005,232.420013 L291.600006,232.660004 L291.540009,232.660004 L292.320007,232.720001 L292.260010,232.720001 L302.760010,232.720001 L303.600006,232.660004 L303.540009,232.660004 L304.260010,232.420013 L304.200012,232.480011 L304.860016,232.119995 L305.460022,231.639984 L305.399994,231.700012 L305.880005,231.100006 L306.240021,230.440002 L306.179993,230.500000 L306.420013,229.720001 L306.420013,229.779999 L306.480011,229.000000 L306.480011,229.059998 L306.420013,228.279999 L306.179993,227.500000 L306.240021,227.559998 L305.880005,226.899994 L305.880005,226.959991 L305.399994,226.359985 L305.460022,226.359985 L304.860016,225.880005 L304.860016,225.940002 L304.200012,225.579987 L304.260010,225.579987 L303.540009,225.339996 L303.600006,225.339996 L302.760010,225.279999 L292.260010,225.279999 L292.260010,224.799988 L302.820007,224.799988 L303.660004,224.859985 L303.720001,224.859985 L304.440002,225.100006 L304.440002,225.160004 L305.100006,225.519989 L305.160004,225.519989 L305.760010,226.000000 L305.760010,226.059998 L306.240021,226.660004 L306.300018,226.660004 L306.660004,227.320007 L306.660004,227.380005 C307.274994 228.941010,306.973999 230.796997,305.760010 232.000000  L305.160004,232.480011 L305.100006,232.540009 L304.440002,232.899994 L303.720001,233.139984 L303.660004,233.139984 L302.820007,233.200012 L292.260010,233.200012 L291.480011,233.139984 L291.420013,233.139984 L290.700012,232.899994 L290.640015,232.899994 L289.920013,232.540009 L289.920013,232.480011 L289.380005,232.000000 L289.320007,232.000000 L288.779999,231.399994 L288.779999,231.339996 L288.420013,230.679993 L288.360016,230.619995 L288.179993,229.839996 L288.059998,229.059998 L288.059998,229.000000 L288.179993,228.220001 L288.179993,228.160004 C288.390015 226.529999,289.898010 225.260010,291.420013 224.859985  L291.480011,224.859985 L292.260010,224.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M292.260010,225.279999 L292.320007,225.279999 L292.260010,224.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M350.820007,216.339996 L349.980011,216.459991 L349.200012,216.699982 L349.260010,216.699982 L348.600006,217.059998 L348.660004,217.000000 L348.059998,217.480011 L347.520020,218.079987 L347.580017,218.019989 L347.220001,218.739990 L347.220001,218.679993 L346.980011,219.459991 L346.920013,220.299988 L346.920013,220.239990 L346.980011,221.079987 L346.980011,221.019989 L347.220001,221.739990 L347.220001,221.679993 L347.580017,222.399994 L347.520020,222.399994 L348.059998,223.000000 L348.059998,222.940002 L348.660004,223.419983 L348.600006,223.419983 L349.260010,223.839996 L349.200012,223.779999 L349.980011,224.019989 L350.820007,224.079987 L350.760010,224.079987 L352.559998,224.079987 L353.399994,224.019989 L353.339996,224.019989 L354.119995,223.779999 L354.059998,223.839996 L354.720001,223.419983 L355.320007,222.940002 L355.260010,223.000000 L355.800018,222.399994 L356.160004,221.679993 L356.100006,221.739990 L356.339996,221.019989 L356.339996,221.079987 L356.399994,220.239990 L356.399994,220.299988 L356.339996,219.459991 L356.100006,218.679993 L356.160004,218.739990 L355.800018,218.019989 L355.800018,218.079987 L355.260010,217.480011 L355.320007,217.480011 L354.720001,217.000000 L354.720001,217.059998 L354.059998,216.699982 L354.119995,216.699982 L353.339996,216.459991 L353.399994,216.459991 L352.559998,216.339996 L350.760010,216.339996 L350.760010,215.859985 L351.660004,215.859985 C353.476013 215.729004,355.101013 216.304993,356.160004 217.779999  L356.220001,217.779999 L356.580017,218.500000 L356.580017,218.559998 C357.184021 220.126007,356.947021 222.161987,355.619995 223.299988  L355.020020,223.779999 L354.960022,223.839996 L354.300018,224.260010 L354.240021,224.260010 L353.460022,224.500000 L352.619995,224.559998 L350.760010,224.559998 L349.920013,224.500000 L349.860016,224.500000 L349.080017,224.260010 L349.020020,224.260010 L348.360016,223.839996 L348.360016,223.779999 L347.760010,223.299988 L347.700012,223.299988 L347.160004,222.699982 L347.160004,222.639984 L346.800018,221.919983 L346.740021,221.919983 L346.500000,221.199982 L346.500000,221.139984 C346.406006 220.295990,346.378021 219.351990,346.740021 218.559998  L346.800018,218.500000 L347.160004,217.779999 C347.834015 216.911987,348.779999 216.212982,349.860016 215.980011  L349.920013,215.980011 L350.760010,215.859985" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M350.760010,216.339996 L350.820007,216.339996 L350.760010,215.859985" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M347.040009,225.279999 L346.260010,225.339996 L346.320007,225.339996 L345.600006,225.579987 L344.880005,225.940002 L344.940002,225.880005 L344.399994,226.359985 L343.920013,226.959991 L343.980011,226.899994 L343.559998,227.559998 L343.559998,227.500000 L343.380005,228.279999 L343.260010,229.059998 L343.260010,229.000000 L343.380005,229.779999 L343.380005,229.720001 L343.559998,230.500000 L343.559998,230.440002 L343.980011,231.100006 L343.920013,231.100006 L344.399994,231.700012 L344.399994,231.639984 L344.940002,232.119995 L344.880005,232.119995 L345.600006,232.480011 L345.600006,232.420013 L346.320007,232.660004 L346.260010,232.660004 L347.040009,232.720001 L346.980011,232.720001 L357.480011,232.720001 L358.320007,232.660004 L358.260010,232.660004 L358.980011,232.420013 L358.920013,232.480011 L359.580017,232.119995 L360.180023,231.639984 L360.119995,231.700012 L360.600006,231.100006 L360.960022,230.440002 L360.899994,230.500000 L361.140015,229.720001 L361.140015,229.779999 L361.200012,229.000000 L361.200012,229.059998 L361.140015,228.279999 L360.899994,227.500000 L360.960022,227.559998 L360.600006,226.899994 L360.600006,226.959991 L360.119995,226.359985 L360.180023,226.359985 L359.580017,225.880005 L359.580017,225.940002 L358.920013,225.579987 L358.980011,225.579987 L358.260010,225.339996 L358.320007,225.339996 L357.480011,225.279999 L346.980011,225.279999 L346.980011,224.799988 L357.540009,224.799988 L358.380005,224.859985 L358.440002,224.859985 L359.160004,225.100006 L359.160004,225.160004 L359.820007,225.519989 L359.880005,225.519989 L360.480011,226.000000 L360.480011,226.059998 L360.960022,226.660004 L361.020020,226.660004 L361.380005,227.320007 L361.380005,227.380005 C361.994995 228.941010,361.694000 230.796997,360.480011 232.000000  L359.880005,232.480011 L359.820007,232.540009 L359.160004,232.899994 L358.440002,233.139984 L358.380005,233.139984 L357.540009,233.200012 L346.980011,233.200012 L346.200012,233.139984 L346.140015,233.139984 L345.420013,232.899994 L345.360016,232.899994 L344.640015,232.540009 L344.640015,232.480011 L344.100006,232.000000 L344.040009,232.000000 L343.559998,231.399994 L343.559998,231.339996 L343.140015,230.679993 L343.080017,230.619995 L342.899994,229.839996 L342.779999,229.059998 L342.779999,229.000000 L342.899994,228.220001 L342.899994,228.160004 C343.046021 226.684998,344.687012 225.165985,346.140015 224.859985  L346.200012,224.859985 L346.980011,224.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M346.980011,225.279999 L347.040009,225.279999 L346.980011,224.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M314.339996,216.339996 L313.500000,216.459991 L312.720001,216.699982 L312.779999,216.699982 L312.119995,217.059998 L312.179993,217.000000 L311.579987,217.480011 L311.040009,218.079987 L311.100006,218.019989 L310.739990,218.739990 L310.739990,218.679993 L310.500000,219.459991 L310.440002,220.299988 L310.440002,220.239990 L310.500000,221.079987 L310.500000,221.019989 L310.739990,221.739990 L310.739990,221.679993 L311.100006,222.399994 L311.040009,222.399994 L311.579987,223.000000 L311.579987,222.940002 L312.179993,223.419983 L312.119995,223.419983 L312.779999,223.839996 L312.720001,223.779999 L313.500000,224.019989 L314.339996,224.079987 L314.279999,224.079987 L316.079987,224.079987 L316.919983,224.019989 L316.859985,224.019989 L317.639984,223.779999 L317.579987,223.839996 L318.239990,223.419983 L318.839996,222.940002 L318.779999,223.000000 L319.320007,222.399994 L319.679993,221.679993 L319.619995,221.739990 L319.859985,221.019989 L319.859985,221.079987 L319.919983,220.239990 L319.919983,220.299988 L319.859985,219.459991 L319.619995,218.679993 L319.679993,218.739990 L319.320007,218.019989 L319.320007,218.079987 L318.779999,217.480011 L318.839996,217.480011 L318.239990,217.000000 L318.239990,217.059998 L317.579987,216.699982 L317.639984,216.699982 L316.859985,216.459991 L316.919983,216.459991 L316.079987,216.339996 L314.279999,216.339996 L314.279999,215.859985 L315.179993,215.859985 C316.996002 215.729004,318.621002 216.304993,319.679993 217.779999  L319.739990,217.779999 L320.100006,218.500000 L320.100006,218.559998 C320.704010 220.126007,320.467010 222.161987,319.139984 223.299988  L318.540009,223.779999 L318.480011,223.839996 L317.820007,224.260010 L317.760010,224.260010 L316.980011,224.500000 L316.139984,224.559998 L314.279999,224.559998 L313.440002,224.500000 L313.380005,224.500000 L312.600006,224.260010 L312.540009,224.260010 L311.880005,223.839996 L311.880005,223.779999 L311.279999,223.299988 L311.220001,223.299988 L310.679993,222.699982 L310.679993,222.639984 L310.320007,221.919983 L310.260010,221.919983 L310.019989,221.199982 L310.019989,221.139984 C309.925995 220.295990,309.898010 219.351990,310.260010 218.559998  L310.320007,218.500000 L310.679993,217.779999 C311.354004 216.911987,312.299988 216.212982,313.380005 215.980011  L313.440002,215.980011 L314.279999,215.859985" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M314.279999,216.339996 L314.339996,216.339996 L314.279999,215.859985" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M310.559998,225.279999 L309.779999,225.339996 L309.839996,225.339996 L309.119995,225.579987 L308.399994,225.940002 L308.459991,225.880005 L307.919983,226.359985 L307.380005,226.959991 L307.440002,226.899994 L307.079987,227.559998 L307.079987,227.500000 L306.899994,228.279999 L306.779999,229.059998 L306.779999,229.000000 L306.899994,229.779999 L306.899994,229.720001 L307.079987,230.500000 L307.079987,230.440002 L307.440002,231.100006 L307.380005,231.100006 L307.919983,231.700012 L307.919983,231.639984 L308.459991,232.119995 L308.399994,232.119995 L309.119995,232.480011 L309.119995,232.420013 L309.839996,232.660004 L309.779999,232.660004 L310.559998,232.720001 L310.500000,232.720001 L321.000000,232.720001 L321.839996,232.660004 L321.779999,232.660004 L322.500000,232.420013 L322.440002,232.480011 L323.100006,232.119995 L323.700012,231.639984 L323.639984,231.700012 L324.119995,231.100006 L324.480011,230.440002 L324.419983,230.500000 L324.660004,229.720001 L324.660004,229.779999 L324.720001,229.000000 L324.720001,229.059998 L324.660004,228.279999 L324.419983,227.500000 L324.480011,227.559998 L324.119995,226.899994 L324.119995,226.959991 L323.639984,226.359985 L323.700012,226.359985 L323.100006,225.880005 L323.100006,225.940002 L322.440002,225.579987 L322.500000,225.579987 L321.779999,225.339996 L321.839996,225.339996 L321.000000,225.279999 L310.500000,225.279999 L310.500000,224.799988 L321.059998,224.799988 L321.899994,224.859985 L321.959991,224.859985 L322.679993,225.100006 L322.679993,225.160004 L323.339996,225.519989 L323.399994,225.519989 L324.000000,226.000000 L324.000000,226.059998 L324.480011,226.660004 L324.540009,226.660004 L324.899994,227.320007 L324.899994,227.380005 C325.514984 228.941010,325.213989 230.796997,324.000000 232.000000  L323.399994,232.480011 L323.339996,232.540009 L322.679993,232.899994 L321.959991,233.139984 L321.899994,233.139984 L321.059998,233.200012 L310.500000,233.200012 L309.720001,233.139984 L309.660004,233.139984 L308.940002,232.899994 L308.880005,232.899994 L308.160004,232.540009 L308.160004,232.480011 L307.619995,232.000000 L307.559998,232.000000 L307.019989,231.399994 L307.019989,231.339996 L306.660004,230.679993 L306.600006,230.619995 L306.419983,229.839996 L306.299988,229.059998 L306.299988,229.000000 L306.419983,228.220001 L306.419983,228.160004 C306.630005 226.529999,308.138000 225.260010,309.660004 224.859985  L309.720001,224.859985 L310.500000,224.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M310.500000,225.279999 L310.559998,225.279999 L310.500000,224.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M332.579987,216.339996 L331.739990,216.459991 L330.959991,216.699982 L331.019989,216.699982 L330.359985,217.059998 L330.419983,217.000000 L329.819977,217.480011 L329.279999,218.079987 L329.339996,218.019989 L328.979980,218.739990 L328.979980,218.679993 L328.739990,219.459991 L328.679993,220.299988 L328.679993,220.239990 L328.739990,221.079987 L328.739990,221.019989 L328.979980,221.739990 L328.979980,221.679993 L329.339996,222.399994 L329.279999,222.399994 L329.819977,223.000000 L329.819977,222.940002 L330.419983,223.419983 L330.359985,223.419983 L331.019989,223.839996 L330.959991,223.779999 L331.739990,224.019989 L332.579987,224.079987 L332.519989,224.079987 L334.319977,224.079987 L335.159973,224.019989 L335.099976,224.019989 L335.879974,223.779999 L335.819977,223.839996 L336.479980,223.419983 L337.079987,222.940002 L337.019989,223.000000 L337.559998,222.399994 L337.919983,221.679993 L337.859985,221.739990 L338.099976,221.019989 L338.099976,221.079987 L338.159973,220.239990 L338.159973,220.299988 L338.099976,219.459991 L337.859985,218.679993 L337.919983,218.739990 L337.559998,218.019989 L337.559998,218.079987 L337.019989,217.480011 L337.079987,217.480011 L336.479980,217.000000 L336.479980,217.059998 L335.819977,216.699982 L335.879974,216.699982 L335.099976,216.459991 L335.159973,216.459991 L334.319977,216.339996 L332.519989,216.339996 L332.519989,215.859985 L333.419983,215.859985 C335.235992 215.729004,336.860992 216.304993,337.919983 217.779999  L337.979980,217.779999 L338.339996,218.500000 L338.339996,218.559998 C338.944000 220.126007,338.707001 222.161987,337.379974 223.299988  L336.779999,223.779999 L336.720001,223.839996 L336.059998,224.260010 L336.000000,224.260010 L335.220001,224.500000 L334.379974,224.559998 L332.519989,224.559998 L331.679993,224.500000 L331.619995,224.500000 L330.839996,224.260010 L330.779999,224.260010 L330.119995,223.839996 L330.119995,223.779999 L329.519989,223.299988 L329.459991,223.299988 L328.919983,222.699982 L328.919983,222.639984 L328.559998,221.919983 L328.500000,221.919983 L328.259979,221.199982 L328.259979,221.139984 C328.165985 220.295990,328.138000 219.351990,328.500000 218.559998  L328.559998,218.500000 L328.919983,217.779999 C329.593994 216.911987,330.539978 216.212982,331.619995 215.980011  L331.679993,215.980011 L332.519989,215.859985" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M332.519989,216.339996 L332.579987,216.339996 L332.519989,215.859985" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M328.799988,225.279999 L328.019989,225.339996 L328.079987,225.339996 L327.359985,225.579987 L326.639984,225.940002 L326.699982,225.880005 L326.159973,226.359985 L325.619995,226.959991 L325.679993,226.899994 L325.319977,227.559998 L325.319977,227.500000 L325.139984,228.279999 L325.019989,229.059998 L325.019989,229.000000 L325.139984,229.779999 L325.139984,229.720001 L325.319977,230.500000 L325.319977,230.440002 L325.679993,231.100006 L325.619995,231.100006 L326.159973,231.700012 L326.159973,231.639984 L326.699982,232.119995 L326.639984,232.119995 L327.359985,232.480011 L327.359985,232.420013 L328.079987,232.660004 L328.019989,232.660004 L328.799988,232.720001 L328.739990,232.720001 L339.239990,232.720001 L340.079987,232.660004 L340.019989,232.660004 L340.739990,232.420013 L340.679993,232.480011 L341.339996,232.119995 L341.940002,231.639984 L341.879974,231.700012 L342.359985,231.100006 L342.720001,230.440002 L342.659973,230.500000 L342.899994,229.720001 L342.899994,229.779999 L342.959991,229.000000 L342.959991,229.059998 L342.899994,228.279999 L342.659973,227.500000 L342.720001,227.559998 L342.359985,226.899994 L342.359985,226.959991 L341.879974,226.359985 L341.940002,226.359985 L341.339996,225.880005 L341.339996,225.940002 L340.679993,225.579987 L340.739990,225.579987 L340.019989,225.339996 L340.079987,225.339996 L339.239990,225.279999 L328.739990,225.279999 L328.739990,224.799988 L339.299988,224.799988 L340.139984,224.859985 L340.199982,224.859985 L340.919983,225.100006 L340.919983,225.160004 L341.579987,225.519989 L341.639984,225.519989 L342.239990,226.000000 L342.239990,226.059998 L342.720001,226.660004 L342.779999,226.660004 L343.139984,227.320007 L343.139984,227.380005 C343.754974 228.941010,343.453979 230.796997,342.239990 232.000000  L341.639984,232.480011 L341.579987,232.540009 L340.919983,232.899994 L340.199982,233.139984 L340.139984,233.139984 L339.299988,233.200012 L328.739990,233.200012 L327.959991,233.139984 L327.899994,233.139984 L327.179993,232.899994 L327.119995,232.899994 L326.399994,232.540009 L326.399994,232.480011 L325.859985,232.000000 L325.799988,232.000000 L325.259979,231.399994 L325.259979,231.339996 L324.899994,230.679993 L324.839996,230.619995 L324.659973,229.839996 L324.539978,229.059998 L324.539978,229.000000 L324.659973,228.220001 L324.659973,228.160004 C324.869995 226.529999,326.377991 225.260010,327.899994 224.859985  L327.959991,224.859985 L328.739990,224.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M328.739990,225.279999 L328.799988,225.279999 L328.739990,224.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="351.059998" y="204.219971" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M354.540009,204.520020 L354.059998,204.400024 L351.059998,214.780029 L351.059998,214.900024 L351.300018,215.740021 L351.540009,214.900024" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M351.059998,214.900024 L351.540009,214.780029 L348.600006,204.400024 L348.119995,204.520020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="351.059998" y="183.100037" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="351.059998" y="183.340027" width="0.480010" height="21.120001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="298.079987" y="204.700012" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M301.559998,205.000000 L301.079987,204.880005 L298.079987,215.260010 L298.079987,215.380005 L298.320007,216.220001 L298.559998,215.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M298.079987,215.380005 L298.559998,215.260010 L295.559998,204.880005 L295.079987,205.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="298.079987" y="183.580017" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="298.079987" y="183.820007" width="0.480010" height="21.120001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="314.579987" y="205.719971" width="0.479980" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M318.059998,206.020020 L317.579987,205.900024 L314.579987,216.280029 L314.579987,216.400024 L314.820007,217.240021 L315.059998,216.400024" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M314.579987,216.400024 L315.059998,216.280029 L312.059998,205.900024 L311.579987,206.020020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="314.579987" y="184.600037" width="0.479980" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="314.579987" y="184.840027" width="0.479980" height="21.120001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="333.059998" y="204.219971" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M336.540009,204.520020 L336.059998,204.400024 L333.059998,214.780029 L333.059998,214.900024 L333.300018,215.740021 L333.540009,214.900024" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M333.059998,214.900024 L333.540009,214.780029 L330.600006,204.400024 L330.119995,204.520020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="333.059998" y="183.100037" width="0.480010" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="333.059998" y="183.340027" width="0.480010" height="21.120001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M370.619995,360.160004 L369.660004,360.220001 L369.779999,360.220001 L368.880005,360.519989 L368.100006,360.940002 L368.160004,360.880005 L367.440002,361.480011 L366.839996,362.200012 L366.899994,362.140015 L366.479980,362.980011 L366.179993,363.880005 L366.179993,363.760010 L366.119995,364.720001 L366.179993,365.679993 L366.179993,365.619995 L366.479980,366.519989 L366.479980,366.459991 L366.899994,367.239990 L366.839996,367.239990 L367.440002,367.959991 L367.440002,367.899994 L368.160004,368.500000 L368.100006,368.500000 L368.880005,368.920013 L368.880005,368.860016 L369.779999,369.160004 L369.660004,369.160004 L370.619995,369.220001 L371.040009,369.220001 L372.059998,369.160004 L372.000000,369.160004 L372.839996,368.860016 L372.779999,368.920013 L373.619995,368.500000 L374.339996,367.899994 L374.279999,367.959991 L374.880005,367.239990 L375.299988,366.459991 L375.239990,366.519989 L375.540009,365.619995 L375.540009,365.679993 L375.600006,364.720001 L375.540009,363.760010 L375.540009,363.880005 L375.239990,362.980011 L375.299988,362.980011 L374.880005,362.140015 L374.880005,362.200012 L374.279999,361.480011 L374.339996,361.480011 L373.619995,360.880005 L373.619995,360.940002 L372.779999,360.519989 L372.839996,360.519989 L372.000000,360.220001 L372.059998,360.220001 L371.040009,360.160004 L370.619995,360.160004 L370.619995,359.679993 L371.040009,359.679993 L372.059998,359.739990 L372.179993,359.739990 L373.019989,360.040009 L373.019989,360.100006 L373.859985,360.519989 L373.919983,360.519989 L374.639984,361.119995 L374.639984,361.179993 L375.239990,361.899994 L375.299988,361.899994 L375.720001,362.739990 L375.720001,362.800018 C376.501984 364.613007,376.092987 366.899017,374.639984 368.260010  L373.919983,368.860016 L373.859985,368.920013 C372.445984 369.873993,370.260986 369.947998,368.699982 369.339996  L368.639984,369.339996 L367.859985,368.920013 L367.859985,368.860016 L367.139984,368.260010 L367.079987,368.260010 L366.479980,367.540009 L366.479980,367.480011 L366.059998,366.700012 L366.000000,366.700012 L365.699982,365.800018 L365.699982,365.679993 L365.639984,364.720001 L365.699982,363.760010 L365.699982,363.700012 L366.000000,362.800018 L366.059998,362.739990 L366.479980,361.899994 L367.079987,361.179993 C367.721985 360.492004,368.691010 359.970001,369.600006 359.739990  L369.660004,359.739990 L370.619995,359.679993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M370.619995,360.160004 L370.619995,359.679993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M306.720001,255.160004 L306.360016,255.519989 L314.459991,262.420013 L314.820007,262.059998" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M308.820007,253.119995 L308.460022,253.359985 L314.460022,262.359985 L314.520020,262.479980 L315.300018,262.839996 L314.820007,262.119995" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M314.519989,262.480011 L314.759979,262.000000 L304.919983,257.500000 L304.679993,257.980011" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M298.500000,248.140015 L298.320007,248.020020 L298.019989,248.380005 L298.200012,248.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M306.720001,255.160004 L306.899994,255.279999 L306.600006,255.640015 L306.420013,255.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M298.500000,248.140015 L298.200012,248.500000 L306.420013,255.520020 L306.720001,255.160004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M314.940002,249.520020 L314.459991,249.640015 L316.860016,260.020020 L317.339996,259.900024" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M317.880005,249.160004 L317.399994,249.160004 L316.860016,259.959991 L316.860016,260.080017 L317.279999,260.860016 L317.339996,259.959991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M316.859985,260.080017 L317.339996,259.840027 L312.119995,250.420013 L311.639984,250.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M314.040009,245.740021 L313.980011,245.500031 L313.500000,245.620026 L313.559998,245.860016" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M314.940002,249.520020 L315.000000,249.760010 L314.519989,249.880005 L314.459991,249.640015" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M314.040009,245.740021 L313.559998,245.860016 L314.460022,249.640015 L314.940002,249.520020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M326.459991,251.260010 L325.979980,251.020020 L321.000000,260.380005 L321.479980,260.619995" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M328.919983,252.940002 L328.559998,252.580017 L321.059998,260.320007 L320.999969,260.440002 L320.819977,261.279999 L321.419983,260.679993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M321.000000,260.440002 L321.480011,260.559998 L323.700012,250.000000 L323.220001,249.880005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M329.579987,245.440002 L329.699982,245.260010 L329.279999,245.019989 L329.159973,245.200012" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M326.459991,251.260010 L326.339996,251.440002 L325.919983,251.200012 L326.039978,251.020020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M329.579987,245.440002 L329.159973,245.200012 L326.039978,251.019989 L326.459991,251.260010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M335.100006,255.760010 L334.860016,255.400024 L325.980011,261.160004 L326.220001,261.520020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M336.480011,258.460022 L336.360016,257.980011 L326.040009,261.100037 L325.920013,261.160034 L325.320007,261.820007 L326.160004,261.580017" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M325.919983,261.160004 L326.279968,261.519989 L333.359985,253.360016 L332.999969,253.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M349.440002,246.580017 L349.619995,246.460022 L349.380005,246.040009 L349.200012,246.160004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M335.100006,255.820007 L334.920013,255.940002 L334.679993,255.520020 L334.860016,255.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M349.440002,246.580017 L349.200012,246.160004 L334.860016,255.400024 L335.100006,255.820007" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="339.299988" y="300.700012" width="69.360001" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="408.179993" y="300.940033" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="339.059998" y="312.700012" width="69.360001" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="339.059998" y="300.700012" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="356.339996" y="300.700012" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="373.619995" y="300.700012" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="390.899994" y="300.700012" width="0.479980" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="339.299988" y="333.400024" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="408.179993" y="333.640015" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="339.059998" y="345.400024" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="339.059998" y="333.400024" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="356.339996" y="333.400024" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="373.619995" y="333.400024" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="390.899994" y="333.400024" width="0.479980" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="339.779999" y="277.420044" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="408.660004" y="277.660034" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="339.540009" y="289.420044" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="339.540009" y="277.420013" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="356.820007" y="277.420013" width="0.479980" height="12.180000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="374.100006" y="277.420013" width="0.480010" height="12.180000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="391.380005" y="277.420013" width="0.479980" height="12.180000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M346.079987,315.880005 L345.299988,315.940002 L344.519989,316.179993 L344.579987,316.179993 L343.859985,316.540009 L343.919983,316.480011 L343.319977,317.020020 L342.839996,317.619995 L342.899994,317.559998 L342.479980,318.220001 L342.479980,318.160004 L342.239990,318.940002 L342.179993,319.779999 L342.179993,319.720001 L342.239990,320.559998 L342.239990,320.500000 L342.479980,321.279999 L342.479980,321.220001 L342.899994,321.880005 L342.839996,321.880005 L343.319977,322.480011 L343.319977,322.420013 L343.919983,322.959991 L343.859985,322.959991 L344.579987,323.320007 L344.519989,323.260010 L345.299988,323.500000 L346.079987,323.619995 L346.019989,323.619995 L347.819977,323.619995 L348.659973,323.500000 L348.599976,323.500000 L349.379974,323.260010 L349.319977,323.320007 L349.979980,322.959991 L350.639984,322.420013 L350.579987,322.480011 L351.059998,321.880005 L351.419983,321.220001 L351.359985,321.279999 L351.599976,320.500000 L351.599976,320.559998 L351.720001,319.720001 L351.720001,319.779999 L351.599976,318.940002 L351.359985,318.160004 L351.419983,318.220001 L351.059998,317.559998 L351.059998,317.619995 L350.579987,317.020020 L350.639984,317.020020 L349.979980,316.480011 L349.979980,316.540009 L349.319977,316.179993 L349.379974,316.179993 L348.599976,315.940002 L348.659973,315.940002 L347.819977,315.880005 L346.019989,315.880005 L346.019989,315.399994 L346.919983,315.399994 C348.643982 315.223999,350.509979 315.782013,351.419983 317.320007  L351.479980,317.320007 L351.839996,317.980011 L351.839996,318.040009 C352.523987 319.710999,352.176971 321.484009,350.939972 322.779999  L350.279999,323.320007 L350.220001,323.380005 C349.017975 324.313019,345.723999 324.308990,344.399994 323.739990  L344.339996,323.739990 L343.619995,323.380005 L343.619995,323.320007 L343.019989,322.779999 L342.959991,322.779999 L342.479980,322.179993 L342.479980,322.119995 L342.059998,321.459991 L342.000000,321.399994 L341.759979,320.619995 L341.699982,319.779999 L341.699982,319.720001 L341.759979,318.880005 L341.759979,318.820007 C342.112000 317.252014,343.593994 315.769012,345.179993 315.459991  L345.239990,315.459991 L346.019989,315.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M346.019989,315.880005 L346.079987,315.880005 L346.019989,315.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M342.359985,324.820007 L341.519989,324.880005 L341.579987,324.880005 L340.859985,325.119995 L340.199982,325.480011 L340.259979,325.420013 L339.659973,325.899994 L339.179993,326.500000 L339.239990,326.440002 L338.879974,327.100006 L338.639984,327.820007 L338.639984,327.760010 L338.579987,328.600006 L338.579987,328.540009 L338.639984,329.320007 L338.639984,329.260010 L338.879974,329.980011 L338.879974,329.920013 L339.239990,330.580017 L339.179993,330.580017 L339.659973,331.179993 L339.659973,331.119995 L340.259979,331.600006 L340.199982,331.600006 L340.859985,331.960022 L340.859985,331.899994 L341.579987,332.140015 L341.519989,332.140015 L342.359985,332.260010 L342.299988,332.260010 L352.799988,332.260010 L353.579987,332.140015 L353.519989,332.140015 L354.239990,331.899994 L354.179993,331.960022 L354.899994,331.600006 L355.439972,331.119995 L355.379974,331.179993 L355.859985,330.580017 L356.279999,329.920013 L356.219971,329.980011 L356.399994,329.260010 L356.399994,329.320007 L356.519989,328.540009 L356.519989,328.600006 L356.399994,327.760010 L356.219971,327.040009 L356.279999,327.100006 L355.859985,326.440002 L355.859985,326.500000 L355.379974,325.899994 L355.439972,325.899994 L354.899994,325.420013 L354.899994,325.480011 L354.179993,325.119995 L354.239990,325.119995 L353.519989,324.880005 L353.579987,324.880005 L352.799988,324.820007 L342.299988,324.820007 L342.299988,324.339996 L352.859985,324.339996 L353.639984,324.399994 L353.699982,324.399994 L354.419983,324.640015 L354.419983,324.700012 L355.139984,325.059998 L355.199982,325.059998 L355.739990,325.540009 L355.739990,325.600006 L356.219971,326.200012 L356.279999,326.200012 L356.699982,326.860016 L356.699982,326.920013 C357.246979 328.675018,357.052979 330.141022,355.739990 331.480011  L355.199982,331.960022 L355.139984,332.020020 L354.419983,332.380005 L353.699982,332.619995 L353.639984,332.619995 L352.859985,332.740021 L342.299988,332.740021 L341.459991,332.619995 L341.399994,332.619995 L340.679993,332.380005 L340.619995,332.380005 L339.959991,332.020020 L339.959991,331.960022 L339.359985,331.480011 L339.299988,331.480011 L338.819977,330.880005 L338.819977,330.820007 L338.459991,330.160004 L338.399994,330.160004 L338.159973,329.440002 L338.159973,329.380005 C338.069977 328.579010,338.028992 327.662994,338.399994 326.920013  L338.459991,326.860016 L338.819977,326.200012 C339.345978 325.339020,340.440979 324.641998,341.399994 324.399994  L341.459991,324.399994 L342.299988,324.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M342.299988,324.820007 L342.359985,324.820007 L342.299988,324.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M400.799988,315.880005 L400.019989,315.940002 L399.239990,316.179993 L399.299988,316.179993 L398.579987,316.540009 L398.639984,316.480011 L398.039978,317.020020 L397.559998,317.619995 L397.619995,317.559998 L397.199982,318.220001 L397.199982,318.160004 L396.959991,318.940002 L396.899994,319.779999 L396.899994,319.720001 L396.959991,320.559998 L396.959991,320.500000 L397.199982,321.279999 L397.199982,321.220001 L397.619995,321.880005 L397.559998,321.880005 L398.039978,322.480011 L398.039978,322.420013 L398.639984,322.959991 L398.579987,322.959991 L399.299988,323.320007 L399.239990,323.260010 L400.019989,323.500000 L400.799988,323.619995 L400.739990,323.619995 L402.539978,323.619995 L403.379974,323.500000 L403.319977,323.500000 L404.099976,323.260010 L404.039978,323.320007 L404.759979,322.959991 L405.359985,322.420013 L405.299988,322.480011 L405.779999,321.880005 L406.139984,321.220001 L406.079987,321.279999 L406.319977,320.500000 L406.319977,320.559998 L406.440002,319.720001 L406.440002,319.779999 L406.319977,318.940002 L406.079987,318.160004 L406.139984,318.220001 L405.779999,317.559998 L405.779999,317.619995 L405.299988,317.020020 L405.359985,317.020020 L404.759979,316.480011 L404.759979,316.540009 L404.039978,316.179993 L404.099976,316.179993 L403.319977,315.940002 L403.379974,315.940002 L402.539978,315.880005 L400.739990,315.880005 L400.739990,315.399994 L401.639984,315.399994 C403.362000 315.240997,405.252991 315.747009,406.139984 317.320007  L406.199982,317.320007 L406.559998,317.980011 L406.559998,318.040009 C407.243988 319.710999,406.897003 321.484009,405.659973 322.779999  L405.059998,323.320007 L405.000000,323.380005 C403.665985 324.294006,400.549988 324.328003,399.119995 323.739990  L399.059998,323.739990 L398.339996,323.380005 L398.339996,323.320007 L397.739990,322.779999 L397.679993,322.779999 L397.199982,322.179993 L397.199982,322.119995 L396.779999,321.459991 L396.720001,321.399994 L396.479980,320.619995 L396.419983,319.779999 L396.419983,319.720001 L396.479980,318.880005 L396.479980,318.820007 C396.832001 317.252014,398.313995 315.769012,399.899994 315.459991  L399.959991,315.459991 L400.739990,315.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M400.739990,315.880005 L400.799988,315.880005 L400.739990,315.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M397.079987,324.820007 L396.239990,324.880005 L396.299988,324.880005 L395.579987,325.119995 L394.919983,325.480011 L394.979980,325.420013 L394.379974,325.899994 L393.899994,326.500000 L393.959991,326.440002 L393.599976,327.100006 L393.359985,327.820007 L393.359985,327.760010 L393.299988,328.600006 L393.299988,328.540009 L393.359985,329.320007 L393.359985,329.260010 L393.599976,329.980011 L393.599976,329.920013 L393.959991,330.580017 L393.899994,330.580017 L394.379974,331.179993 L394.379974,331.119995 L394.979980,331.600006 L394.919983,331.600006 L395.579987,331.960022 L395.579987,331.899994 L396.299988,332.140015 L396.239990,332.140015 L397.079987,332.260010 L397.019989,332.260010 L407.519989,332.260010 L408.299988,332.140015 L408.239990,332.140015 L408.959991,331.899994 L408.899994,331.960022 L409.619995,331.600006 L410.159973,331.119995 L410.099976,331.179993 L410.639984,330.580017 L411.000000,329.920013 L410.939972,329.980011 L411.119995,329.260010 L411.119995,329.320007 L411.239990,328.540009 L411.239990,328.600006 L411.119995,327.760010 L410.939972,327.040009 L411.000000,327.100006 L410.639984,326.440002 L410.639984,326.500000 L410.099976,325.899994 L410.159973,325.899994 L409.619995,325.420013 L409.619995,325.480011 L408.899994,325.119995 L408.959991,325.119995 L408.239990,324.880005 L408.299988,324.880005 L407.519989,324.820007 L397.019989,324.820007 L397.019989,324.339996 L407.579987,324.339996 L408.359985,324.399994 L408.419983,324.399994 L409.139984,324.640015 L409.139984,324.700012 L409.859985,325.059998 L409.919983,325.059998 L410.459991,325.540009 L410.459991,325.600006 L411.000000,326.200012 L411.059998,326.200012 L411.419983,326.860016 L411.419983,326.920013 C411.953979 328.460999,411.764984 330.377014,410.459991 331.480011  L409.919983,331.960022 L409.859985,332.020020 L409.139984,332.380005 L408.419983,332.619995 L408.359985,332.619995 L407.579987,332.740021 L397.019989,332.740021 L396.179993,332.619995 L396.119995,332.619995 L395.399994,332.380005 L395.339996,332.380005 L394.679993,332.020020 L394.679993,331.960022 L394.079987,331.480011 L394.019989,331.480011 L393.539978,330.880005 L393.539978,330.820007 L393.179993,330.160004 L393.119995,330.160004 L392.879974,329.440002 L392.879974,329.380005 C392.789978 328.579010,392.748993 327.662994,393.119995 326.920013  L393.179993,326.860016 L393.539978,326.200012 C394.065979 325.339020,395.160980 324.643005,396.119995 324.399994  L396.179993,324.399994 L397.019989,324.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M397.019989,324.820007 L397.079987,324.820007 L397.019989,324.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.320007,315.880005 L363.540009,315.940002 L362.760010,316.179993 L362.820007,316.179993 L362.100006,316.540009 L362.160004,316.480011 L361.559998,317.020020 L361.080017,317.619995 L361.140015,317.559998 L360.720001,318.220001 L360.720001,318.160004 L360.480011,318.940002 L360.420013,319.779999 L360.420013,319.720001 L360.480011,320.559998 L360.480011,320.500000 L360.720001,321.279999 L360.720001,321.220001 L361.140015,321.880005 L361.080017,321.880005 L361.559998,322.480011 L361.559998,322.420013 L362.160004,322.959991 L362.100006,322.959991 L362.820007,323.320007 L362.760010,323.260010 L363.540009,323.500000 L364.320007,323.619995 L364.260010,323.619995 L366.059998,323.619995 L366.899994,323.500000 L366.839996,323.500000 L367.619995,323.260010 L367.559998,323.320007 L368.220001,322.959991 L368.880005,322.420013 L368.820007,322.480011 L369.300018,321.880005 L369.660004,321.220001 L369.600006,321.279999 L369.839996,320.500000 L369.839996,320.559998 L369.960022,319.720001 L369.960022,319.779999 L369.839996,318.940002 L369.600006,318.160004 L369.660004,318.220001 L369.300018,317.559998 L369.300018,317.619995 L368.820007,317.020020 L368.880005,317.020020 L368.220001,316.480011 L368.220001,316.540009 L367.559998,316.179993 L367.619995,316.179993 L366.839996,315.940002 L366.899994,315.940002 L366.059998,315.880005 L364.260010,315.880005 L364.260010,315.399994 L365.160004,315.399994 C366.884003 315.223999,368.750000 315.782013,369.660004 317.320007  L369.720001,317.320007 L370.080017,317.980011 L370.080017,318.040009 C370.764008 319.710999,370.417023 321.484009,369.179993 322.779999  L368.520020,323.320007 L368.460022,323.380005 C367.257996 324.313019,363.964020 324.308990,362.640015 323.739990  L362.580017,323.739990 L361.860016,323.380005 L361.860016,323.320007 L361.260010,322.779999 L361.200012,322.779999 L360.720001,322.179993 L360.720001,322.119995 L360.300018,321.459991 L360.240021,321.399994 L360.000000,320.619995 L359.940002,319.779999 L359.940002,319.720001 L360.000000,318.880005 L360.000000,318.820007 C360.352020 317.252014,361.834015 315.769012,363.420013 315.459991  L363.480011,315.459991 L364.260010,315.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.260010,315.880005 L364.320007,315.880005 L364.260010,315.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M360.600006,324.820007 L359.760010,324.880005 L359.820007,324.880005 L359.100006,325.119995 L358.440002,325.480011 L358.500000,325.420013 L357.899994,325.899994 L357.420013,326.500000 L357.480011,326.440002 L357.119995,327.100006 L356.880005,327.820007 L356.880005,327.760010 L356.820007,328.600006 L356.820007,328.540009 L356.880005,329.320007 L356.880005,329.260010 L357.119995,329.980011 L357.119995,329.920013 L357.480011,330.580017 L357.420013,330.580017 L357.899994,331.179993 L357.899994,331.119995 L358.500000,331.600006 L358.440002,331.600006 L359.100006,331.960022 L359.100006,331.899994 L359.820007,332.140015 L359.760010,332.140015 L360.600006,332.260010 L360.540009,332.260010 L371.040009,332.260010 L371.820007,332.140015 L371.760010,332.140015 L372.480011,331.899994 L372.420013,331.960022 L373.140015,331.600006 L373.679993,331.119995 L373.619995,331.179993 L374.160004,330.580017 L374.520020,329.920013 L374.459991,329.980011 L374.640015,329.260010 L374.640015,329.320007 L374.760010,328.540009 L374.760010,328.600006 L374.640015,327.760010 L374.459991,327.040009 L374.520020,327.100006 L374.160004,326.440002 L374.160004,326.500000 L373.619995,325.899994 L373.679993,325.899994 L373.140015,325.420013 L373.140015,325.480011 L372.420013,325.119995 L372.480011,325.119995 L371.760010,324.880005 L371.820007,324.880005 L371.040009,324.820007 L360.540009,324.820007 L360.540009,324.339996 L371.100006,324.339996 L371.880005,324.399994 L371.940002,324.399994 L372.660004,324.640015 L372.660004,324.700012 L373.380005,325.059998 L373.440002,325.059998 L373.980011,325.540009 L373.980011,325.600006 L374.520020,326.200012 L374.580017,326.200012 L374.940002,326.860016 L374.940002,326.920013 C375.473999 328.460999,375.285004 330.377014,373.980011 331.480011  L373.440002,331.960022 L373.380005,332.020020 L372.660004,332.380005 L371.940002,332.619995 L371.880005,332.619995 L371.100006,332.740021 L360.540009,332.740021 L359.700012,332.619995 L359.640015,332.619995 L358.920013,332.380005 L358.860016,332.380005 L358.200012,332.020020 L358.200012,331.960022 L357.600006,331.480011 L357.540009,331.480011 L357.059998,330.880005 L357.059998,330.820007 L356.700012,330.160004 L356.640015,330.160004 L356.399994,329.440002 L356.399994,329.380005 C356.309998 328.579010,356.269012 327.662994,356.640015 326.920013  L356.700012,326.860016 L357.059998,326.200012 C357.585999 325.339020,358.681000 324.641998,359.640015 324.399994  L359.700012,324.399994 L360.540009,324.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M360.540009,324.820007 L360.600006,324.820007 L360.540009,324.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M382.559998,315.880005 L381.779999,315.940002 L381.000000,316.179993 L381.059998,316.179993 L380.339996,316.540009 L380.399994,316.480011 L379.799988,317.020020 L379.320007,317.619995 L379.380005,317.559998 L378.959991,318.220001 L378.959991,318.160004 L378.720001,318.940002 L378.660004,319.779999 L378.660004,319.720001 L378.720001,320.559998 L378.720001,320.500000 L378.959991,321.279999 L378.959991,321.220001 L379.380005,321.880005 L379.320007,321.880005 L379.799988,322.480011 L379.799988,322.420013 L380.399994,322.959991 L380.339996,322.959991 L381.059998,323.320007 L381.000000,323.260010 L381.779999,323.500000 L382.559998,323.619995 L382.500000,323.619995 L384.299988,323.619995 L385.139984,323.500000 L385.079987,323.500000 L385.859985,323.260010 L385.799988,323.320007 L386.459991,322.959991 L387.119995,322.420013 L387.059998,322.480011 L387.540009,321.880005 L387.899994,321.220001 L387.839996,321.279999 L388.079987,320.500000 L388.079987,320.559998 L388.200012,319.720001 L388.200012,319.779999 L388.079987,318.940002 L387.839996,318.160004 L387.899994,318.220001 L387.540009,317.559998 L387.540009,317.619995 L387.059998,317.020020 L387.119995,317.020020 L386.459991,316.480011 L386.459991,316.540009 L385.799988,316.179993 L385.859985,316.179993 L385.079987,315.940002 L385.139984,315.940002 L384.299988,315.880005 L382.500000,315.880005 L382.500000,315.399994 L383.399994,315.399994 C385.123993 315.223999,386.989990 315.782013,387.899994 317.320007  L387.959991,317.320007 L388.320007,317.980011 L388.320007,318.040009 C389.003998 319.710999,388.657013 321.484009,387.419983 322.779999  L386.760010,323.320007 L386.700012,323.380005 C385.497986 324.313019,382.204010 324.308990,380.880005 323.739990  L380.820007,323.739990 L380.100006,323.380005 L380.100006,323.320007 L379.500000,322.779999 L379.440002,322.779999 L378.959991,322.179993 L378.959991,322.119995 L378.540009,321.459991 L378.480011,321.399994 L378.239990,320.619995 L378.179993,319.779999 L378.179993,319.720001 L378.239990,318.880005 L378.239990,318.820007 C378.592010 317.252014,380.074005 315.769012,381.660004 315.459991  L381.720001,315.459991 L382.500000,315.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M382.500000,315.880005 L382.559998,315.880005 L382.500000,315.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M378.839996,324.820007 L378.000000,324.880005 L378.059998,324.880005 L377.339996,325.119995 L376.679993,325.480011 L376.739990,325.420013 L376.139984,325.899994 L375.660004,326.500000 L375.720001,326.440002 L375.359985,327.100006 L375.119995,327.820007 L375.119995,327.760010 L375.059998,328.600006 L375.059998,328.540009 L375.119995,329.320007 L375.119995,329.260010 L375.359985,329.980011 L375.359985,329.920013 L375.720001,330.580017 L375.660004,330.580017 L376.139984,331.179993 L376.139984,331.119995 L376.739990,331.600006 L376.679993,331.600006 L377.339996,331.960022 L377.339996,331.899994 L378.059998,332.140015 L378.000000,332.140015 L378.839996,332.260010 L378.779999,332.260010 L389.279999,332.260010 L390.059998,332.140015 L390.000000,332.140015 L390.720001,331.899994 L390.660004,331.960022 L391.380005,331.600006 L391.919983,331.119995 L391.859985,331.179993 L392.399994,330.580017 L392.760010,329.920013 L392.699982,329.980011 L392.880005,329.260010 L392.880005,329.320007 L393.000000,328.540009 L393.000000,328.600006 L392.880005,327.760010 L392.699982,327.040009 L392.760010,327.100006 L392.399994,326.440002 L392.399994,326.500000 L391.859985,325.899994 L391.919983,325.899994 L391.380005,325.420013 L391.380005,325.480011 L390.660004,325.119995 L390.720001,325.119995 L390.000000,324.880005 L390.059998,324.880005 L389.279999,324.820007 L378.779999,324.820007 L378.779999,324.339996 L389.339996,324.339996 L390.119995,324.399994 L390.179993,324.399994 L390.899994,324.640015 L390.899994,324.700012 L391.619995,325.059998 L391.679993,325.059998 L392.220001,325.540009 L392.220001,325.600006 L392.760010,326.200012 L392.820007,326.200012 L393.179993,326.860016 L393.179993,326.920013 C393.713989 328.460999,393.524994 330.377014,392.220001 331.480011  L391.679993,331.960022 L391.619995,332.020020 L390.899994,332.380005 L390.179993,332.619995 L390.119995,332.619995 L389.339996,332.740021 L378.779999,332.740021 L377.940002,332.619995 L377.880005,332.619995 L377.160004,332.380005 L377.100006,332.380005 L376.440002,332.020020 L376.440002,331.960022 L375.839996,331.480011 L375.779999,331.480011 L375.299988,330.880005 L375.299988,330.820007 L374.940002,330.160004 L374.880005,330.160004 L374.639984,329.440002 L374.639984,329.380005 C374.549988 328.579010,374.509003 327.662994,374.880005 326.920013  L374.940002,326.860016 L375.299988,326.200012 C375.825989 325.339020,376.920990 324.641998,377.880005 324.399994  L377.940002,324.399994 L378.779999,324.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M378.779999,324.820007 L378.839996,324.820007 L378.779999,324.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="401.100006" y="303.700012" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M404.519989,304.000000 L404.039978,303.880005 L401.099976,314.260010 L401.099976,314.380005 L401.339996,315.220001 L401.579987,314.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M401.100006,314.380005 L401.580017,314.260010 L398.580017,303.880005 L398.100006,304.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="401.100006" y="282.580017" width="0.480010" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="348.059998" y="304.180023" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M351.540009,304.480011 L351.059998,304.360016 L348.059998,314.740021 L348.059998,314.860016 L348.300018,315.700012 L348.540009,314.860016" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M348.059998,314.860016 L348.540009,314.740021 L345.600006,304.360016 L345.119995,304.480011" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="348.059998" y="283.059998" width="0.480010" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="364.559998" y="305.200012" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M368.040009,305.500000 L367.559998,305.380005 L364.559998,315.760010 L364.559998,315.880005 L364.800018,316.720001 L365.040009,315.880005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.559998,315.880005 L365.040009,315.760010 L362.100006,305.380005 L361.619995,305.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="364.559998" y="284.080017" width="0.480010" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="383.100006" y="303.700012" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M386.519989,304.000000 L386.039978,303.880005 L383.099976,314.260010 L383.099976,314.380005 L383.339996,315.220001 L383.579987,314.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M383.100006,314.380005 L383.580017,314.260010 L380.580017,303.880005 L380.100006,304.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="383.100006" y="282.580017" width="0.480010" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M356.699982,354.640015 L356.339996,355.000000 L364.439972,361.900024 L364.799988,361.540009" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M358.859985,352.600006 L358.500000,352.839996 L364.439972,361.839996 L364.500000,361.959991 L365.279999,362.320007 L364.799988,361.600006" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.500000,361.960022 L364.739990,361.480011 L354.899994,357.040009 L354.660004,357.520020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M348.480011,347.619995 L348.300018,347.500000 L348.000000,347.859985 L348.180023,347.979980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M356.699982,354.640015 L356.879974,354.760010 L356.579987,355.120026 L356.399994,355.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M348.480011,347.619995 L348.180023,347.979980 L356.400024,355.000000 L356.700012,354.639984" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.919983,349.059998 L364.439972,349.179993 L366.899994,359.500000 L367.379974,359.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M367.919983,348.640015 L367.439972,348.640015 L366.899994,359.440002 L366.899994,359.560028 L367.319977,360.340027 L367.379974,359.440002" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M366.899994,359.559998 L367.380005,359.320007 L362.100006,349.899994 L361.619995,350.139984" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.079987,345.279999 L364.019989,345.040009 L363.539978,345.160004 L363.599976,345.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.919983,349.059998 L364.979980,349.299988 L364.499969,349.419983 L364.439972,349.179993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.079987,345.279999 L363.599976,345.399994 L364.439972,349.179993 L364.919983,349.059998" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M376.500000,350.740021 L376.019989,350.500031 L370.980011,359.920013 L371.459991,360.160034" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M378.899994,352.420013 L378.540009,352.060028 L371.040009,359.860016 L370.979980,359.980011 L370.799988,360.820007 L371.399994,360.220001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M370.980011,359.980011 L371.460022,360.100006 L373.740021,349.540009 L373.260010,349.420013" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M379.559998,344.920013 L379.679993,344.740021 L379.260010,344.500000 L379.139984,344.680023" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M376.500000,350.740021 L376.380005,350.920013 L375.959991,350.680023 L376.079987,350.500031" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M379.559998,344.920013 L379.139984,344.680023 L376.079987,350.500000 L376.500000,350.740021" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M385.139984,355.240021 L384.899994,354.880035 L375.959991,360.640015 L376.199982,361.000031" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M386.459991,357.940002 L386.339996,357.459991 L376.019989,360.580017 L375.899994,360.640015 L375.299988,361.299988 L376.139984,361.059998" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M375.899994,360.640015 L376.259979,361.000000 L383.339996,352.900024 L382.979980,352.540009" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M399.419983,346.059998 L399.599976,345.940002 L399.359985,345.519989 L399.179993,345.639984" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M385.139984,355.300018 L384.959991,355.420013 L384.719971,355.000031 L384.899994,354.880005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M399.419983,346.059998 L399.179993,345.639984 L384.899994,354.880005 L385.139984,355.299988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="159.239990" y="296.080017" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="228.119995" y="296.320007" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="159.000000" y="308.080017" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="159.000000" y="296.080017" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="176.279999" y="296.080017" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="193.559998" y="296.080017" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="210.839996" y="296.080017" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="159.239990" y="328.779999" width="69.360001" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="228.119995" y="329.020020" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="159.000000" y="340.779999" width="69.360001" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="159.000000" y="328.780029" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="176.279999" y="328.780029" width="0.480010" height="12.180000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="193.559998" y="328.780029" width="0.480000" height="12.180000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="210.839996" y="328.780029" width="0.480010" height="12.180000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="159.720001" y="272.740021" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="228.600006" y="272.980011" width="0.479980" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="159.479996" y="284.740021" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="159.479996" y="272.740021" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="176.759995" y="272.740021" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="194.039993" y="272.740021" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="211.320007" y="272.740021" width="0.479980" height="0.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="211.320007" y="272.980011" width="0.479980" height="12.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M166.019989,311.200012 L165.179993,311.320007 L164.399994,311.559998 L164.459991,311.559998 L163.799988,311.920013 L163.859985,311.860016 L163.259995,312.340027 L162.719986,312.940002 L162.779984,312.880005 L162.419983,313.600006 L162.419983,313.540009 L162.179993,314.320007 L162.119995,315.160004 L162.119995,315.100006 L162.179993,315.940002 L162.179993,315.880005 L162.419983,316.600006 L162.419983,316.540009 L162.779984,317.260010 L162.719986,317.260010 L163.259995,317.860016 L163.259995,317.800018 L163.859985,318.279999 L163.799988,318.279999 L164.459991,318.700012 L164.399994,318.640015 L165.179993,318.880005 L166.019989,318.940002 L165.959991,318.940002 L167.759995,318.940002 L168.599991,318.880005 L168.539993,318.880005 L169.319992,318.640015 L169.259995,318.700012 L169.919983,318.279999 L170.519989,317.800018 L170.459991,317.860016 L170.999985,317.260010 L171.359985,316.540009 L171.299988,316.600006 L171.539993,315.880005 L171.539993,315.940002 L171.599991,315.100006 L171.599991,315.160004 L171.539993,314.320007 L171.299988,313.540009 L171.359985,313.600006 L170.999985,312.880005 L170.999985,312.940002 L170.459991,312.340027 L170.519989,312.340027 L169.919983,311.860016 L169.919983,311.920013 L169.259995,311.559998 L169.319992,311.559998 L168.539993,311.320007 L168.599991,311.320007 L167.759995,311.200012 L165.959991,311.200012 L165.959991,310.720001 L166.859985,310.720001 C168.675995 310.589020,170.300995 311.165009,171.359985 312.640015  L171.419983,312.640015 L171.779984,313.360016 L171.779984,313.420013 C172.383987 314.986023,172.146988 317.022003,170.819992 318.160004  L170.219986,318.640015 L170.159988,318.700012 L169.499985,319.120026 L169.439987,319.120026 L168.659988,319.360016 L167.819992,319.420013 L165.959991,319.420013 L165.119995,319.360016 L165.059982,319.360016 L164.279984,319.120026 L164.219986,319.120026 L163.559982,318.700012 L163.559982,318.640015 L162.959991,318.160004 L162.899994,318.160004 L162.359985,317.559998 L162.359985,317.500000 L161.999985,316.779999 L161.939987,316.779999 L161.699982,316.059998 L161.699982,316.000000 C161.605988 315.156006,161.577988 314.212006,161.939987 313.420013  L161.999985,313.360016 L162.359985,312.640015 C163.032990 311.772003,163.979996 311.072998,165.059982 310.840027  L165.119995,310.840027 L165.959991,310.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M165.959991,311.200012 L166.019989,311.200012 L165.959991,310.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M162.239990,320.140015 L161.459991,320.200012 L161.519989,320.200012 L160.799988,320.440002 L160.079987,320.800018 L160.139984,320.740021 L159.599991,321.220001 L159.119995,321.820007 L159.179993,321.760010 L158.759995,322.420013 L158.759995,322.360016 L158.579987,323.140015 L158.459991,323.920013 L158.459991,323.860016 L158.579987,324.640015 L158.579987,324.580017 L158.759995,325.360016 L158.759995,325.300018 L159.179993,325.960022 L159.119995,325.960022 L159.599991,326.560028 L159.599991,326.500000 L160.139984,326.980011 L160.079987,326.980011 L160.799988,327.340027 L160.799988,327.280029 L161.519989,327.520020 L161.459991,327.520020 L162.239990,327.580017 L162.179993,327.580017 L172.679993,327.580017 L173.519989,327.520020 L173.459991,327.520020 L174.179993,327.280029 L174.119995,327.340027 L174.779984,326.980011 L175.379990,326.500000 L175.319992,326.560028 L175.799988,325.960022 L176.159988,325.300018 L176.099991,325.360016 L176.339996,324.580017 L176.339996,324.640015 L176.399994,323.860016 L176.399994,323.920013 L176.339996,323.140015 L176.099991,322.360016 L176.159988,322.420013 L175.799988,321.760010 L175.799988,321.820007 L175.319992,321.220001 L175.379990,321.220001 L174.779984,320.740021 L174.779984,320.800018 L174.119995,320.440002 L174.179993,320.440002 L173.459991,320.200012 L173.519989,320.200012 L172.679993,320.140015 L162.179993,320.140015 L162.179993,319.660004 L172.739990,319.660004 L173.579987,319.720001 L173.639984,319.720001 L174.359985,319.960022 L174.359985,320.020020 L175.019989,320.380005 L175.079987,320.380005 L175.679993,320.860016 L175.679993,320.920013 L176.159988,321.520020 L176.219986,321.520020 L176.579987,322.180023 L176.579987,322.240021 C177.194992 323.801025,176.893997 325.657013,175.679993 326.860016  L175.079987,327.340027 L175.019989,327.400024 L174.359985,327.760010 L173.639984,328.000000 L173.579987,328.000000 L172.739990,328.060028 L162.179993,328.060028 L161.399994,328.000000 L161.339996,328.000000 L160.619995,327.760010 L160.559998,327.760010 L159.839996,327.400024 L159.839996,327.340027 L159.299988,326.860016 L159.239990,326.860016 L158.759995,326.260010 L158.759995,326.200012 L158.339996,325.540009 L158.279984,325.480011 L158.099991,324.700012 L157.979996,323.920013 L157.979996,323.860016 L158.099991,323.080017 L158.099991,323.020020 C158.245987 321.545013,159.886993 320.026001,161.339996 319.720001  L161.399994,319.720001 L162.179993,319.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M162.179993,320.140015 L162.239990,320.140015 L162.179993,319.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M220.739990,311.200012 L219.899994,311.320007 L219.119995,311.559998 L219.179993,311.559998 L218.519989,311.920013 L218.579987,311.860016 L217.979980,312.340027 L217.440002,312.940002 L217.500000,312.880005 L217.139984,313.600006 L217.139984,313.540009 L216.899994,314.320007 L216.839996,315.160004 L216.839996,315.100006 L216.899994,315.940002 L216.899994,315.880005 L217.139984,316.600006 L217.139984,316.540009 L217.500000,317.260010 L217.440002,317.260010 L217.979980,317.860016 L217.979980,317.800018 L218.579987,318.279999 L218.519989,318.279999 L219.179993,318.700012 L219.119995,318.640015 L219.899994,318.880005 L220.739990,318.940002 L220.679993,318.940002 L222.479980,318.940002 L223.319977,318.880005 L223.259979,318.880005 L224.039978,318.640015 L223.979980,318.700012 L224.639984,318.279999 L225.239990,317.800018 L225.179993,317.860016 L225.720001,317.260010 L226.079987,316.540009 L226.019989,316.600006 L226.259979,315.880005 L226.259979,315.940002 L226.319977,315.100006 L226.319977,315.160004 L226.259979,314.320007 L226.019989,313.540009 L226.079987,313.600006 L225.720001,312.880005 L225.720001,312.940002 L225.179993,312.340027 L225.239990,312.340027 L224.639984,311.860016 L224.639984,311.920013 L223.979980,311.559998 L224.039978,311.559998 L223.259979,311.320007 L223.319977,311.320007 L222.479980,311.200012 L220.679993,311.200012 L220.679993,310.720001 L221.579987,310.720001 C223.395996 310.589020,225.022003 311.165009,226.079987 312.640015  L226.139984,312.640015 L226.500000,313.360016 L226.500000,313.420013 C227.104004 314.986023,226.867004 317.022003,225.539978 318.160004  L224.940002,318.640015 L224.880005,318.700012 L224.220001,319.120026 L224.160004,319.120026 L223.380005,319.360016 L222.539978,319.420013 L220.679993,319.420013 L219.839996,319.360016 L219.779999,319.360016 L219.000000,319.120026 L218.940002,319.120026 L218.279999,318.700012 L218.279999,318.640015 L217.679993,318.160004 L217.619995,318.160004 L217.079987,317.559998 L217.079987,317.500000 L216.720001,316.779999 L216.660004,316.779999 L216.419983,316.059998 L216.419983,316.000000 C216.325989 315.156006,216.298004 314.212006,216.660004 313.420013  L216.720001,313.360016 L217.079987,312.640015 C217.752991 311.772003,218.699982 311.072998,219.779999 310.840027  L219.839996,310.840027 L220.679993,310.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M220.679993,311.200012 L220.739990,311.200012 L220.679993,310.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M216.959991,320.140015 L216.179993,320.200012 L216.239990,320.200012 L215.519989,320.440002 L214.799988,320.800018 L214.859985,320.740021 L214.319977,321.220001 L213.839996,321.820007 L213.899994,321.760010 L213.479980,322.420013 L213.479980,322.360016 L213.299988,323.140015 L213.179993,323.920013 L213.179993,323.860016 L213.299988,324.640015 L213.299988,324.580017 L213.479980,325.360016 L213.479980,325.300018 L213.899994,325.960022 L213.839996,325.960022 L214.319977,326.560028 L214.319977,326.500000 L214.859985,326.980011 L214.799988,326.980011 L215.519989,327.340027 L215.519989,327.280029 L216.239990,327.520020 L216.179993,327.520020 L216.959991,327.580017 L216.899994,327.580017 L227.459991,327.580017 L228.239990,327.520020 L228.179993,327.520020 L228.899994,327.280029 L228.839996,327.340027 L229.500000,326.980011 L230.100006,326.500000 L230.039978,326.560028 L230.519989,325.960022 L230.880005,325.300018 L230.819977,325.360016 L231.059998,324.580017 L231.059998,324.640015 L231.179993,323.860016 L231.179993,323.920013 L231.059998,323.140015 L230.819977,322.360016 L230.880005,322.420013 L230.519989,321.760010 L230.519989,321.820007 L230.039978,321.220001 L230.100006,321.220001 L229.500000,320.740021 L229.500000,320.800018 L228.839996,320.440002 L228.899994,320.440002 L228.179993,320.200012 L228.239990,320.200012 L227.459991,320.140015 L216.899994,320.140015 L216.899994,319.660004 L227.519989,319.660004 L228.299988,319.720001 L228.359985,319.720001 L229.079987,319.960022 L229.079987,320.020020 L229.739990,320.380005 L229.799988,320.380005 L230.399994,320.860016 L230.399994,320.920013 L230.880005,321.520020 L230.940002,321.520020 L231.299988,322.180023 L231.299988,322.240021 C231.989990 323.894012,231.608002 325.577026,230.399994 326.860016  L229.799988,327.340027 L229.739990,327.400024 L229.079987,327.760010 L228.359985,328.000000 L228.299988,328.000000 L227.519989,328.060028 L216.899994,328.060028 L216.119995,328.000000 L216.059998,328.000000 L215.339996,327.760010 L215.279999,327.760010 L214.559998,327.400024 L214.559998,327.340027 L214.019989,326.860016 L213.959991,326.860016 L213.479980,326.260010 L213.479980,326.200012 L213.059998,325.540009 L213.000000,325.480011 L212.819977,324.700012 L212.699982,323.920013 L212.699982,323.860016 L212.819977,323.080017 L212.819977,323.020020 C212.966003 321.545013,214.606995 320.026001,216.059998 319.720001  L216.119995,319.720001 L216.899994,319.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M216.899994,320.140015 L216.959991,320.140015 L216.899994,319.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M184.259995,311.200012 L183.419998,311.320007 L182.639999,311.559998 L182.699997,311.559998 L182.039993,311.920013 L182.099991,311.860016 L181.500000,312.340027 L180.959991,312.940002 L181.019989,312.880005 L180.659988,313.600006 L180.659988,313.540009 L180.419998,314.320007 L180.360001,315.160004 L180.360001,315.100006 L180.419998,315.940002 L180.419998,315.880005 L180.659988,316.600006 L180.659988,316.540009 L181.019989,317.260010 L180.959991,317.260010 L181.500000,317.860016 L181.500000,317.800018 L182.099991,318.279999 L182.039993,318.279999 L182.699997,318.700012 L182.639999,318.640015 L183.419998,318.880005 L184.259995,318.940002 L184.199997,318.940002 L186.000000,318.940002 L186.839996,318.880005 L186.779999,318.880005 L187.559998,318.640015 L187.500000,318.700012 L188.159988,318.279999 L188.759995,317.800018 L188.699997,317.860016 L189.239990,317.260010 L189.599991,316.540009 L189.539993,316.600006 L189.779999,315.880005 L189.779999,315.940002 L189.839996,315.100006 L189.839996,315.160004 L189.779999,314.320007 L189.539993,313.540009 L189.599991,313.600006 L189.239990,312.880005 L189.239990,312.940002 L188.699997,312.340027 L188.759995,312.340027 L188.159988,311.860016 L188.159988,311.920013 L187.500000,311.559998 L187.559998,311.559998 L186.779999,311.320007 L186.839996,311.320007 L186.000000,311.200012 L184.199997,311.200012 L184.199997,310.720001 L185.099991,310.720001 C186.916000 310.589020,188.541992 311.165009,189.599991 312.640015  L189.659988,312.640015 L190.019989,313.360016 L190.019989,313.420013 C190.623993 314.986023,190.386993 317.022003,189.059998 318.160004  L188.459991,318.640015 L188.399994,318.700012 L187.739990,319.120026 L187.679993,319.120026 L186.899994,319.360016 L186.059998,319.420013 L184.199997,319.420013 L183.360001,319.360016 L183.299988,319.360016 L182.519989,319.120026 L182.459991,319.120026 L181.799988,318.700012 L181.799988,318.640015 L181.199997,318.160004 L181.139999,318.160004 L180.599991,317.559998 L180.599991,317.500000 L180.239990,316.779999 L180.179993,316.779999 L179.939987,316.059998 L179.939987,316.000000 C179.845993 315.156006,179.817993 314.212006,180.179993 313.420013  L180.239990,313.360016 L180.599991,312.640015 C181.272995 311.772003,182.220001 311.072998,183.299988 310.840027  L183.360001,310.840027 L184.199997,310.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M184.199997,311.200012 L184.259995,311.200012 L184.199997,310.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M180.479996,320.140015 L179.699997,320.200012 L179.759995,320.200012 L179.039993,320.440002 L178.319992,320.800018 L178.379990,320.740021 L177.839996,321.220001 L177.360001,321.820007 L177.419998,321.760010 L177.000000,322.420013 L177.000000,322.360016 L176.819992,323.140015 L176.699997,323.920013 L176.699997,323.860016 L176.819992,324.640015 L176.819992,324.580017 L177.000000,325.360016 L177.000000,325.300018 L177.419998,325.960022 L177.360001,325.960022 L177.839996,326.560028 L177.839996,326.500000 L178.379990,326.980011 L178.319992,326.980011 L179.039993,327.340027 L179.039993,327.280029 L179.759995,327.520020 L179.699997,327.520020 L180.479996,327.580017 L180.419998,327.580017 L190.919998,327.580017 L191.759995,327.520020 L191.699997,327.520020 L192.419998,327.280029 L192.360001,327.340027 L193.019989,326.980011 L193.619995,326.500000 L193.559998,326.560028 L194.039993,325.960022 L194.399994,325.300018 L194.339996,325.360016 L194.580002,324.580017 L194.580002,324.640015 L194.639999,323.860016 L194.639999,323.920013 L194.580002,323.140015 L194.339996,322.360016 L194.399994,322.420013 L194.039993,321.760010 L194.039993,321.820007 L193.559998,321.220001 L193.619995,321.220001 L193.019989,320.740021 L193.019989,320.800018 L192.360001,320.440002 L192.419998,320.440002 L191.699997,320.200012 L191.759995,320.200012 L190.919998,320.140015 L180.419998,320.140015 L180.419998,319.660004 L190.979996,319.660004 L191.819992,319.720001 L191.879990,319.720001 L192.599991,319.960022 L192.599991,320.020020 L193.259995,320.380005 L193.319992,320.380005 L193.919998,320.860016 L193.919998,320.920013 L194.399994,321.520020 L194.459991,321.520020 L194.819992,322.180023 L194.819992,322.240021 C195.434998 323.801025,195.134003 325.657013,193.919998 326.860016  L193.319992,327.340027 L193.259995,327.400024 L192.599991,327.760010 L191.879990,328.000000 L191.819992,328.000000 L190.979996,328.060028 L180.419998,328.060028 L179.639999,328.000000 L179.580002,328.000000 L178.860001,327.760010 L178.800003,327.760010 L178.080002,327.400024 L178.080002,327.340027 L177.539993,326.860016 L177.479996,326.860016 L177.000000,326.260010 L177.000000,326.200012 L176.580002,325.540009 L176.519989,325.480011 L176.339996,324.700012 L176.220001,323.920013 L176.220001,323.860016 L176.339996,323.080017 L176.339996,323.020020 C176.485992 321.545013,178.126999 320.026001,179.580002 319.720001  L179.639999,319.720001 L180.419998,319.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M180.419998,320.140015 L180.479996,320.140015 L180.419998,319.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M202.500000,311.200012 L201.660004,311.320007 L200.880005,311.559998 L200.940002,311.559998 L200.279999,311.920013 L200.339996,311.860016 L199.740005,312.340027 L199.199997,312.940002 L199.259995,312.880005 L198.899994,313.600006 L198.899994,313.540009 L198.660004,314.320007 L198.600006,315.160004 L198.600006,315.100006 L198.660004,315.940002 L198.660004,315.880005 L198.899994,316.600006 L198.899994,316.540009 L199.259995,317.260010 L199.199997,317.260010 L199.740005,317.860016 L199.740005,317.800018 L200.339996,318.279999 L200.279999,318.279999 L200.940002,318.700012 L200.880005,318.640015 L201.660004,318.880005 L202.500000,318.940002 L202.440002,318.940002 L204.239990,318.940002 L205.079987,318.880005 L205.019989,318.880005 L205.799988,318.640015 L205.739990,318.700012 L206.399994,318.279999 L207.000000,317.800018 L206.940002,317.860016 L207.480011,317.260010 L207.839996,316.540009 L207.779999,316.600006 L208.019989,315.880005 L208.019989,315.940002 L208.079987,315.100006 L208.079987,315.160004 L208.019989,314.320007 L207.779999,313.540009 L207.839996,313.600006 L207.480011,312.880005 L207.480011,312.940002 L206.940002,312.340027 L207.000000,312.340027 L206.399994,311.860016 L206.399994,311.920013 L205.739990,311.559998 L205.799988,311.559998 L205.019989,311.320007 L205.079987,311.320007 L204.239990,311.200012 L202.440002,311.200012 L202.440002,310.720001 L203.339996,310.720001 C205.156006 310.589020,206.781006 311.165009,207.839996 312.640015  L207.899994,312.640015 L208.260010,313.360016 L208.260010,313.420013 C208.864014 314.986023,208.627014 317.022003,207.299988 318.160004  L206.700012,318.640015 L206.640015,318.700012 L205.980011,319.120026 L205.920013,319.120026 L205.140015,319.360016 L204.299988,319.420013 L202.440002,319.420013 L201.600006,319.360016 L201.540009,319.360016 L200.759995,319.120026 L200.699997,319.120026 L200.039993,318.700012 L200.039993,318.640015 L199.440002,318.160004 L199.380005,318.160004 L198.839996,317.559998 L198.839996,317.500000 L198.479996,316.779999 L198.419998,316.779999 L198.179993,316.059998 L198.179993,316.000000 C198.085999 315.156006,198.057999 314.212006,198.419998 313.420013  L198.479996,313.360016 L198.839996,312.640015 C199.513000 311.772003,200.460007 311.072998,201.540009 310.840027  L201.600006,310.840027 L202.440002,310.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M202.440002,311.200012 L202.500000,311.200012 L202.440002,310.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M198.720001,320.140015 L197.940002,320.200012 L198.000000,320.200012 L197.279999,320.440002 L196.559998,320.800018 L196.619995,320.740021 L196.080002,321.220001 L195.600006,321.820007 L195.660004,321.760010 L195.240005,322.420013 L195.240005,322.360016 L195.059998,323.140015 L194.940002,323.920013 L194.940002,323.860016 L195.059998,324.640015 L195.059998,324.580017 L195.240005,325.360016 L195.240005,325.300018 L195.660004,325.960022 L195.600006,325.960022 L196.080002,326.560028 L196.080002,326.500000 L196.619995,326.980011 L196.559998,326.980011 L197.279999,327.340027 L197.279999,327.280029 L198.000000,327.520020 L197.940002,327.520020 L198.720001,327.580017 L198.660004,327.580017 L209.220001,327.580017 L210.000000,327.520020 L209.940002,327.520020 L210.660004,327.280029 L210.600006,327.340027 L211.260010,326.980011 L211.860016,326.500000 L211.799988,326.560028 L212.279999,325.960022 L212.640015,325.300018 L212.579987,325.360016 L212.820007,324.580017 L212.820007,324.640015 L212.940002,323.860016 L212.940002,323.920013 L212.820007,323.140015 L212.579987,322.360016 L212.640015,322.420013 L212.279999,321.760010 L212.279999,321.820007 L211.799988,321.220001 L211.860016,321.220001 L211.260010,320.740021 L211.260010,320.800018 L210.600006,320.440002 L210.660004,320.440002 L209.940002,320.200012 L210.000000,320.200012 L209.220001,320.140015 L198.660004,320.140015 L198.660004,319.660004 L209.279999,319.660004 L210.059998,319.720001 L210.119995,319.720001 L210.839996,319.960022 L210.839996,320.020020 L211.500000,320.380005 L211.559998,320.380005 L212.160004,320.860016 L212.160004,320.920013 L212.640015,321.520020 L212.700012,321.520020 L213.059998,322.180023 L213.059998,322.240021 C213.750000 323.894012,213.368011 325.577026,212.160004 326.860016  L211.559998,327.340027 L211.500000,327.400024 L210.839996,327.760010 L210.119995,328.000000 L210.059998,328.000000 L209.279999,328.060028 L198.660004,328.060028 L197.880005,328.000000 L197.820007,328.000000 L197.100006,327.760010 L197.040009,327.760010 L196.320007,327.400024 L196.320007,327.340027 L195.779999,326.860016 L195.720001,326.860016 L195.240005,326.260010 L195.240005,326.200012 L194.820007,325.540009 L194.759995,325.480011 L194.580002,324.700012 L194.460007,323.920013 L194.460007,323.860016 L194.580002,323.080017 L194.580002,323.020020 C194.725998 321.545013,196.367004 320.026001,197.820007 319.720001  L197.880005,319.720001 L198.660004,319.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M198.660004,320.140015 L198.720001,320.140015 L198.660004,319.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="220.980011" y="299.080017" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M224.459991,299.380005 L223.979980,299.260010 L220.979980,309.640015 L220.979980,309.760010 L221.220001,310.600006 L221.459991,309.760010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M220.980011,309.760010 L221.460022,309.640015 L218.520020,299.260010 L218.040009,299.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="220.980011" y="277.960022" width="0.480010" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="168.000000" y="299.560028" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M171.479996,299.860016 L171.000000,299.740021 L168.000000,310.120026 L168.000000,310.240021 L168.239990,311.080017 L168.479996,310.240021" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M168.000000,310.240021 L168.479996,310.120026 L165.479996,299.740021 L165.000000,299.860016" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="168.000000" y="278.440002" width="0.480010" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="184.500000" y="300.580017" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M187.979996,300.880005 L187.500000,300.760010 L184.500000,311.140015 L184.500000,311.260010 L184.739990,312.100006 L184.979996,311.260010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M184.500000,311.260010 L184.979996,311.140015 L181.979996,300.760010 L181.500000,300.880005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="184.500000" y="279.460022" width="0.480010" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="202.980011" y="299.080017" width="0.480010" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M206.459991,299.380005 L205.979980,299.260010 L202.979980,309.640015 L202.979980,309.760010 L203.220001,310.600006 L203.459991,309.760010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M202.980011,309.760010 L203.460022,309.640015 L200.520004,299.260010 L200.040009,299.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="202.980011" y="277.960022" width="0.480010" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M176.639999,350.020020 L176.279999,350.380005 L184.380005,357.280029 L184.740005,356.920013" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M178.739990,347.980011 L178.379990,348.220001 L184.379990,357.220001 L184.439987,357.339996 L185.219986,357.700012 L184.739990,356.980011" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M184.440002,357.339996 L184.680008,356.859985 L174.839996,352.359985 L174.600006,352.839996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M168.419998,343.000000 L168.240005,342.880005 L167.940002,343.239990 L168.119995,343.359985" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M176.639999,350.020020 L176.819992,350.140015 L176.520004,350.500031 L176.339996,350.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M168.419998,343.000000 L168.119995,343.359985 L176.339996,350.380005 L176.639999,350.019989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M184.860001,344.380005 L184.380005,344.500000 L186.779999,354.880005 L187.259995,354.760010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M187.800003,344.020020 L187.320007,344.020020 L186.779999,354.820007 L186.779999,354.940033 L187.199997,355.720032 L187.260010,354.820007" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M186.779999,354.940002 L187.259995,354.700012 L182.039993,345.279999 L181.559998,345.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M183.959991,340.600006 L183.899994,340.360016 L183.419998,340.480011 L183.479996,340.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M184.860001,344.380005 L184.919998,344.619995 L184.440002,344.739990 L184.380005,344.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M183.959991,340.600006 L183.479996,340.720001 L184.379990,344.500000 L184.859985,344.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M196.379990,346.119995 L195.899994,345.880005 L190.919983,355.239990 L191.399994,355.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M198.839996,347.800018 L198.479996,347.440033 L190.979996,355.180023 L190.919998,355.300018 L190.739990,356.140015 L191.339996,355.540009" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M190.919998,355.300018 L191.399994,355.420013 L193.619995,344.860016 L193.139999,344.740021" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M199.500000,340.300018 L199.619995,340.120026 L199.199997,339.880005 L199.080002,340.060028" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M196.379990,346.119995 L196.259995,346.299988 L195.839996,346.059998 L195.959991,345.880005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M199.500000,340.300018 L199.080002,340.060028 L195.960007,345.880005 L196.380005,346.120026" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M205.079987,350.619995 L204.839996,350.260010 L195.899994,356.019989 L196.139984,356.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M206.399994,353.320007 L206.279999,352.839996 L195.959991,355.960022 L195.839996,356.020020 L195.239990,356.679993 L196.079987,356.440002" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M195.839996,356.020020 L196.199997,356.380005 L203.279999,348.220032 L202.919983,347.860016" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M219.359985,341.440002 L219.539978,341.320007 L219.299988,340.899994 L219.119995,341.019989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M205.079987,350.680023 L204.899994,350.800018 L204.659973,350.380035 L204.839996,350.260010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M219.359985,341.440002 L219.119995,341.019989 L204.839996,350.260010 L205.079987,350.679993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="71.940002" y="201.880005" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="140.819992" y="202.119995" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="71.699997" y="213.880005" width="69.360001" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="71.699997" y="201.880005" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="88.979996" y="201.880005" width="0.480000" height="12.180000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="106.259995" y="201.880005" width="0.480000" height="12.180000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="123.539993" y="201.880005" width="0.480000" height="12.180000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="71.940002" y="234.519989" width="69.360001" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="140.819992" y="234.760010" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="71.699997" y="246.519989" width="69.360001" height="0.480010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="71.699997" y="234.520020" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="88.979996" y="234.520020" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="106.259995" y="234.520020" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="123.539993" y="234.520020" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="72.419998" y="178.540039" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="141.300003" y="178.780029" width="0.479980" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="72.179993" y="190.540039" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="72.179993" y="178.540039" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="89.459991" y="178.540039" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="106.739990" y="178.540039" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="124.019989" y="178.540039" width="0.480000" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M78.720001,217.000000 L77.880005,217.059998 L77.940002,217.059998 L77.220001,217.299988 L76.500000,217.720001 L76.559998,217.660004 L75.960007,218.140015 L75.479996,218.739990 L75.540009,218.679993 L75.119995,219.399994 L75.119995,219.339996 L74.880005,220.119995 L74.820007,220.899994 L74.820007,220.839996 L74.880005,221.679993 L74.880005,221.619995 L75.119995,222.399994 L75.119995,222.339996 L75.540009,223.059998 L75.479996,223.059998 L75.960007,223.660004 L75.960007,223.600006 L76.559998,224.079987 L76.500000,224.079987 L77.220001,224.440002 L77.220001,224.380005 L77.940002,224.619995 L77.880005,224.619995 L78.720001,224.739990 L78.660004,224.739990 L80.460007,224.739990 L81.300003,224.619995 L81.240005,224.619995 L82.020004,224.380005 L81.960007,224.440002 L82.619995,224.079987 L83.220001,223.600006 L83.160004,223.660004 L83.699997,223.059998 L84.059998,222.339996 L84.000000,222.399994 L84.240005,221.619995 L84.240005,221.679993 L84.360001,220.839996 L84.360001,220.899994 L84.240005,220.119995 L84.000000,219.339996 L84.059998,219.399994 L83.699997,218.679993 L83.699997,218.739990 L83.160004,218.140015 L83.220001,218.140015 L82.619995,217.660004 L82.619995,217.720001 L81.960007,217.299988 L82.020004,217.299988 L81.240005,217.059998 L81.300003,217.059998 L80.460007,217.000000 L78.660004,217.000000 L78.660004,216.519989 L79.559998,216.519989 C81.479004 216.338013,82.932007 216.924988,84.059998 218.440002  L84.119995,218.440002 L84.479996,219.160004 L84.479996,219.220001 C85.178009 220.766998,84.764999 222.865997,83.520004 223.959991  L82.919998,224.440002 L82.860001,224.500000 L82.199997,224.859985 L82.139999,224.859985 L81.360001,225.100006 L80.520004,225.220001 L78.660004,225.220001 L77.820007,225.100006 L77.759995,225.100006 L77.040009,224.859985 L76.979996,224.859985 L76.259995,224.500000 L76.259995,224.440002 L75.660004,223.959991 L75.600006,223.959991 L75.119995,223.359985 L75.119995,223.299988 L74.699997,222.579987 L74.639999,222.519989 L74.399994,221.739990 L74.339996,220.899994 L74.339996,220.839996 L74.399994,220.059998 L74.399994,220.000000 C74.761002 218.373993,76.158005 216.997986,77.759995 216.579987  L77.820007,216.579987 L78.660004,216.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M78.660004,217.000000 L78.720001,217.000000 L78.660004,216.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M74.940002,225.940002 L74.160004,226.000000 L74.220001,226.000000 L73.500000,226.239990 L72.840012,226.600006 L72.900009,226.540009 L72.300003,227.019989 L71.820007,227.619995 L71.880005,227.559998 L71.520004,228.220001 L71.520004,228.160004 L71.279999,228.940002 L71.160004,229.720001 L71.160004,229.660004 L71.279999,230.440002 L71.279999,230.380005 L71.520004,231.160004 L71.520004,231.100006 L71.880005,231.760010 L71.820007,231.760010 L72.300003,232.360016 L72.300003,232.299988 L72.900009,232.779999 L72.840012,232.779999 L73.500000,233.140015 L73.500000,233.080017 L74.220001,233.320007 L74.160004,233.320007 L74.940002,233.380005 L74.880005,233.380005 L85.440002,233.380005 L86.220001,233.320007 L86.160004,233.320007 L86.880005,233.080017 L86.820007,233.140015 L87.540009,232.779999 L88.080002,232.299988 L88.020004,232.360016 L88.500000,231.760010 L88.860001,231.100006 L88.800003,231.160004 L89.040009,230.380005 L89.040009,230.440002 L89.160004,229.660004 L89.160004,229.720001 L89.040009,228.940002 L88.800003,228.160004 L88.860001,228.220001 L88.500000,227.559998 L88.500000,227.619995 L88.020004,227.019989 L88.080002,227.019989 L87.540009,226.540009 L87.540009,226.600006 L86.820007,226.239990 L86.880005,226.239990 L86.160004,226.000000 L86.220001,226.000000 L85.440002,225.940002 L74.880005,225.940002 L74.880005,225.459991 L85.500000,225.459991 L86.279999,225.519989 L86.339996,225.519989 L87.059998,225.760010 L87.059998,225.820007 L87.779999,226.179993 L87.839996,226.179993 L88.380005,226.660004 L88.380005,226.720001 L88.860001,227.320007 L88.919998,227.320007 L89.279999,227.980011 L89.279999,228.040009 C89.970001 229.694000,89.587997 231.377014,88.380005 232.660004  L87.839996,233.140015 L87.779999,233.200012 L87.059998,233.559998 L86.339996,233.799988 L86.279999,233.799988 L85.500000,233.860016 L74.880005,233.860016 L74.100006,233.799988 L74.040009,233.799988 L73.320007,233.559998 L73.260010,233.559998 L72.600006,233.200012 L72.600006,233.140015 L72.000000,232.660004 L71.940002,232.660004 L71.460007,232.059998 L71.460007,232.000000 L71.100006,231.339996 L71.040009,231.279999 L70.800003,230.500000 L70.680008,229.720001 L70.680008,229.660004 L70.800003,228.880005 L70.800003,228.820007 C71.189011 227.161011,72.404999 225.963013,74.040009 225.519989  L74.100006,225.519989 L74.880005,225.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M74.879990,225.940002 L74.939987,225.940002 L74.879990,225.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M133.440002,217.000000 L132.660004,217.059998 L131.880005,217.299988 L131.940002,217.299988 L131.220001,217.720001 L131.279999,217.660004 L130.680008,218.140015 L130.199997,218.739990 L130.260010,218.679993 L129.839996,219.399994 L129.839996,219.339996 L129.600006,220.119995 L129.540009,220.899994 L129.540009,220.839996 L129.600006,221.679993 L129.600006,221.619995 L129.839996,222.399994 L129.839996,222.339996 L130.260010,223.059998 L130.199997,223.059998 L130.680008,223.660004 L130.680008,223.600006 L131.279999,224.079987 L131.220001,224.079987 L131.940002,224.440002 L131.880005,224.380005 L132.660004,224.619995 L133.440002,224.739990 L133.380005,224.739990 L135.180008,224.739990 L136.020004,224.619995 L135.960007,224.619995 L136.740005,224.380005 L136.680008,224.440002 L137.339996,224.079987 L138.000000,223.600006 L137.940002,223.660004 L138.419998,223.059998 L138.779999,222.339996 L138.720001,222.399994 L138.960007,221.619995 L138.960007,221.679993 L139.080002,220.839996 L139.080002,220.899994 L138.960007,220.119995 L138.720001,219.339996 L138.779999,219.399994 L138.419998,218.679993 L138.419998,218.739990 L137.940002,218.140015 L138.000000,218.140015 L137.339996,217.660004 L137.339996,217.720001 L136.680008,217.299988 L136.740005,217.299988 L135.960007,217.059998 L136.020004,217.059998 L135.180008,217.000000 L133.380005,217.000000 L133.380005,216.519989 L135.240005,216.519989 L136.080002,216.579987 L136.860001,216.820007 L136.919998,216.880005 L137.580002,217.299988 L137.639999,217.299988 L138.300003,217.779999 L138.300003,217.839996 L138.779999,218.440002 L138.839996,218.440002 L139.199997,219.160004 L139.199997,219.220001 C139.899002 220.798004,139.481003 222.734985,138.300003 223.959991  L137.639999,224.440002 L137.580002,224.500000 C136.378006 225.433014,133.084000 225.428986,131.760010 224.859985  L131.699997,224.859985 L130.979996,224.500000 L130.979996,224.440002 L130.380005,223.959991 L130.320007,223.959991 L129.839996,223.359985 L129.839996,223.299988 L129.419998,222.579987 L129.360001,222.519989 L129.119995,221.739990 L129.059998,220.899994 L129.059998,220.839996 L129.119995,220.059998 L129.119995,220.000000 C129.468002 218.386993,130.927002 216.928009,132.540009 216.579987  L132.600006,216.579987 L133.380005,216.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M133.379990,217.000000 L133.439987,217.000000 L133.379990,216.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M129.660004,225.940002 L128.880005,226.000000 L128.940002,226.000000 L128.220001,226.239990 L127.559998,226.600006 L127.620010,226.540009 L127.020004,227.019989 L126.540009,227.619995 L126.600006,227.559998 L126.240005,228.220001 L126.240005,228.160004 L126.000000,228.940002 L125.880005,229.720001 L125.880005,229.660004 L126.000000,230.440002 L126.000000,230.380005 L126.240005,231.160004 L126.240005,231.100006 L126.600006,231.760010 L126.540009,231.760010 L127.020004,232.360016 L127.020004,232.299988 L127.620010,232.779999 L127.559998,232.779999 L128.220001,233.140015 L128.220001,233.080017 L128.940002,233.320007 L128.880005,233.320007 L129.660004,233.380005 L129.600006,233.380005 L140.160004,233.380005 L140.940002,233.320007 L140.880005,233.320007 L141.600006,233.080017 L141.540009,233.140015 L142.260010,232.779999 L142.800003,232.299988 L142.740005,232.360016 L143.220001,231.760010 L143.639999,231.100006 L143.580002,231.160004 L143.760010,230.380005 L143.760010,230.440002 L143.880005,229.660004 L143.880005,229.720001 L143.760010,228.940002 L143.580002,228.160004 L143.639999,228.220001 L143.220001,227.559998 L143.220001,227.619995 L142.740005,227.019989 L142.800003,227.019989 L142.260010,226.540009 L142.260010,226.600006 L141.540009,226.239990 L141.600006,226.239990 L140.880005,226.000000 L140.940002,226.000000 L140.160004,225.940002 L129.600006,225.940002 L129.600006,225.459991 L140.220001,225.459991 L141.000000,225.519989 L141.059998,225.519989 L141.779999,225.760010 L141.779999,225.820007 L142.500000,226.179993 L142.559998,226.179993 L143.100006,226.660004 L143.100006,226.720001 L143.580002,227.320007 L143.639999,227.320007 L144.059998,227.980011 L144.059998,228.040009 L144.240005,228.820007 L144.240005,228.880005 L144.360001,229.660004 L144.360001,229.720001 L144.240005,230.500000 L144.059998,231.279999 L144.059998,231.339996 L143.639999,232.000000 L143.580002,232.059998 L143.100006,232.660004 L142.559998,233.140015 L142.500000,233.200012 L141.779999,233.559998 L141.059998,233.799988 L141.000000,233.799988 L140.220001,233.860016 L129.600006,233.860016 L128.820007,233.799988 L128.760010,233.799988 L128.040009,233.559998 L127.980011,233.559998 L127.320007,233.200012 L127.320007,233.140015 L126.720001,232.660004 L126.660004,232.660004 L126.180008,232.059998 L126.180008,232.000000 L125.820007,231.339996 L125.760010,231.279999 L125.520004,230.500000 L125.400009,229.720001 L125.400009,229.660004 L125.520004,228.880005 L125.520004,228.820007 C125.908997 227.161011,127.125000 225.963013,128.760010 225.519989  L128.820007,225.519989 L129.600006,225.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M129.599991,225.940002 L129.659988,225.940002 L129.599991,225.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M96.959991,217.000000 L96.119995,217.059998 L96.179993,217.059998 L95.459991,217.299988 L94.739990,217.720001 L94.799988,217.660004 L94.199997,218.140015 L93.719986,218.739990 L93.779999,218.679993 L93.359985,219.399994 L93.359985,219.339996 L93.119995,220.119995 L93.059998,220.899994 L93.059998,220.839996 L93.119995,221.679993 L93.119995,221.619995 L93.359985,222.399994 L93.359985,222.339996 L93.779999,223.059998 L93.719986,223.059998 L94.199997,223.660004 L94.199997,223.600006 L94.799988,224.079987 L94.739990,224.079987 L95.459991,224.440002 L95.459991,224.380005 L96.179993,224.619995 L96.119995,224.619995 L96.959991,224.739990 L96.899994,224.739990 L98.699997,224.739990 L99.539993,224.619995 L99.479996,224.619995 L100.259995,224.380005 L100.199997,224.440002 L100.859985,224.079987 L101.519989,223.600006 L101.459991,223.660004 L101.939987,223.059998 L102.299988,222.339996 L102.239990,222.399994 L102.479996,221.619995 L102.479996,221.679993 L102.599991,220.839996 L102.599991,220.899994 L102.479996,220.119995 L102.239990,219.339996 L102.299988,219.399994 L101.939987,218.679993 L101.939987,218.739990 L101.459991,218.140015 L101.519989,218.140015 L100.859985,217.660004 L100.859985,217.720001 L100.199997,217.299988 L100.259995,217.299988 L99.479996,217.059998 L99.539993,217.059998 L98.699997,217.000000 L96.899994,217.000000 L96.899994,216.519989 L98.759995,216.519989 L99.599991,216.579987 L100.379990,216.820007 L100.439987,216.880005 L101.099991,217.299988 L101.159988,217.299988 L101.819992,217.779999 L101.819992,217.839996 L102.299988,218.440002 L102.359985,218.440002 L102.719986,219.160004 L102.719986,219.220001 C103.418991 220.798004,103.000992 222.734985,101.819992 223.959991  L101.159988,224.440002 L101.099991,224.500000 L100.439987,224.859985 L100.379990,224.859985 L99.599991,225.100006 L98.759995,225.220001 L96.899994,225.220001 L96.059998,225.100006 L95.999985,225.100006 L95.279999,224.859985 L95.219986,224.859985 L94.499985,224.500000 L94.499985,224.440002 L93.899994,223.959991 L93.839996,223.959991 L93.359985,223.359985 L93.359985,223.299988 L92.939987,222.579987 L92.879990,222.519989 L92.639984,221.739990 L92.579987,220.899994 L92.579987,220.839996 L92.639984,220.059998 L92.639984,220.000000 C92.999985 218.373993,94.397995 216.997986,95.999985 216.579987  L96.059998,216.579987 L96.899994,216.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M96.899994,217.000000 L96.959991,217.000000 L96.899994,216.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M93.179993,225.940002 L92.399994,226.000000 L92.459991,226.000000 L91.739990,226.239990 L91.079987,226.600006 L91.139999,226.540009 L90.539993,227.019989 L90.059998,227.619995 L90.119995,227.559998 L89.759995,228.220001 L89.759995,228.160004 L89.519989,228.940002 L89.399994,229.720001 L89.399994,229.660004 L89.519989,230.440002 L89.519989,230.380005 L89.759995,231.160004 L89.759995,231.100006 L90.119995,231.760010 L90.059998,231.760010 L90.539993,232.360016 L90.539993,232.299988 L91.139999,232.779999 L91.079987,232.779999 L91.739990,233.140015 L91.739990,233.080017 L92.459991,233.320007 L92.399994,233.320007 L93.179993,233.380005 L93.119995,233.380005 L103.679993,233.380005 L104.459991,233.320007 L104.399994,233.320007 L105.119995,233.080017 L105.059998,233.140015 L105.779999,232.779999 L106.319992,232.299988 L106.259995,232.360016 L106.739990,231.760010 L107.099991,231.100006 L107.039993,231.160004 L107.279999,230.380005 L107.279999,230.440002 L107.399994,229.660004 L107.399994,229.720001 L107.279999,228.940002 L107.039993,228.160004 L107.099991,228.220001 L106.739990,227.559998 L106.739990,227.619995 L106.259995,227.019989 L106.319992,227.019989 L105.779999,226.540009 L105.779999,226.600006 L105.059998,226.239990 L105.119995,226.239990 L104.399994,226.000000 L104.459991,226.000000 L103.679993,225.940002 L93.119995,225.940002 L93.119995,225.459991 L103.739990,225.459991 L104.519989,225.519989 L104.579987,225.519989 L105.299988,225.760010 L105.299988,225.820007 L106.019989,226.179993 L106.079987,226.179993 L106.619995,226.660004 L106.619995,226.720001 L107.099991,227.320007 L107.159988,227.320007 L107.519989,227.980011 L107.519989,228.040009 C108.209991 229.694000,107.827988 231.377014,106.619995 232.660004  L106.079987,233.140015 L106.019989,233.200012 L105.299988,233.559998 L104.579987,233.799988 L104.519989,233.799988 L103.739990,233.860016 L93.119995,233.860016 L92.339996,233.799988 L92.279999,233.799988 L91.559998,233.559998 L91.500000,233.559998 L90.839996,233.200012 L90.839996,233.140015 L90.239990,232.660004 L90.179993,232.660004 L89.699997,232.059998 L89.699997,232.000000 L89.339996,231.339996 L89.279999,231.279999 L89.039993,230.500000 L88.919998,229.720001 L88.919998,229.660004 L89.039993,228.880005 L89.039993,228.820007 C89.428986 227.161011,90.644989 225.963013,92.279999 225.519989  L92.339996,225.519989 L93.119995,225.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M93.119995,225.940002 L93.179993,225.940002 L93.119995,225.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M115.199997,217.000000 L114.419998,217.059998 L113.639999,217.299988 L113.699997,217.299988 L112.979996,217.720001 L113.039993,217.660004 L112.440002,218.140015 L111.959991,218.739990 L112.020004,218.679993 L111.599991,219.399994 L111.599991,219.339996 L111.360001,220.119995 L111.300003,220.899994 L111.300003,220.839996 L111.360001,221.679993 L111.360001,221.619995 L111.599991,222.399994 L111.599991,222.339996 L112.020004,223.059998 L111.959991,223.059998 L112.440002,223.660004 L112.440002,223.600006 L113.039993,224.079987 L112.979996,224.079987 L113.699997,224.440002 L113.639999,224.380005 L114.419998,224.619995 L115.199997,224.739990 L115.139999,224.739990 L116.940002,224.739990 L117.779999,224.619995 L117.720001,224.619995 L118.500000,224.380005 L118.440002,224.440002 L119.099991,224.079987 L119.759995,223.600006 L119.699997,223.660004 L120.179993,223.059998 L120.539993,222.339996 L120.479996,222.399994 L120.720001,221.619995 L120.720001,221.679993 L120.839996,220.839996 L120.839996,220.899994 L120.720001,220.119995 L120.479996,219.339996 L120.539993,219.399994 L120.179993,218.679993 L120.179993,218.739990 L119.699997,218.140015 L119.759995,218.140015 L119.099991,217.660004 L119.099991,217.720001 L118.440002,217.299988 L118.500000,217.299988 L117.720001,217.059998 L117.779999,217.059998 L116.940002,217.000000 L115.139999,217.000000 L115.139999,216.519989 L117.000000,216.519989 L117.839996,216.579987 L118.619995,216.820007 L118.679993,216.880005 L119.339996,217.299988 L119.399994,217.299988 L120.059998,217.779999 L120.059998,217.839996 L120.539993,218.440002 L120.599991,218.440002 L120.959991,219.160004 L120.959991,219.220001 C121.658997 220.798004,121.240997 222.734985,120.059998 223.959991  L119.399994,224.440002 L119.339996,224.500000 C118.138000 225.433014,114.843994 225.428986,113.520004 224.859985  L113.459991,224.859985 L112.739990,224.500000 L112.739990,224.440002 L112.139999,223.959991 L112.080002,223.959991 L111.599991,223.359985 L111.599991,223.299988 L111.179993,222.579987 L111.119995,222.519989 L110.879990,221.739990 L110.819992,220.899994 L110.819992,220.839996 L110.879990,220.059998 L110.879990,220.000000 C111.227997 218.386993,112.686996 216.928009,114.300003 216.579987  L114.360001,216.579987 L115.139999,216.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M115.139999,217.000000 L115.199997,217.000000 L115.139999,216.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M111.419998,225.940002 L110.639999,226.000000 L110.699997,226.000000 L109.979996,226.239990 L109.319992,226.600006 L109.380005,226.540009 L108.779999,227.019989 L108.300003,227.619995 L108.360001,227.559998 L108.000000,228.220001 L108.000000,228.160004 L107.759995,228.940002 L107.639999,229.720001 L107.639999,229.660004 L107.759995,230.440002 L107.759995,230.380005 L108.000000,231.160004 L108.000000,231.100006 L108.360001,231.760010 L108.300003,231.760010 L108.779999,232.360016 L108.779999,232.299988 L109.380005,232.779999 L109.319992,232.779999 L109.979996,233.140015 L109.979996,233.080017 L110.699997,233.320007 L110.639999,233.320007 L111.419998,233.380005 L111.360001,233.380005 L121.919998,233.380005 L122.699997,233.320007 L122.639999,233.320007 L123.360001,233.080017 L123.300003,233.140015 L124.020004,232.779999 L124.559998,232.299988 L124.500000,232.360016 L124.979996,231.760010 L125.399994,231.100006 L125.339996,231.160004 L125.520004,230.380005 L125.520004,230.440002 L125.639999,229.660004 L125.639999,229.720001 L125.520004,228.940002 L125.339996,228.160004 L125.399994,228.220001 L124.979996,227.559998 L124.979996,227.619995 L124.500000,227.019989 L124.559998,227.019989 L124.020004,226.540009 L124.020004,226.600006 L123.300003,226.239990 L123.360001,226.239990 L122.639999,226.000000 L122.699997,226.000000 L121.919998,225.940002 L111.360001,225.940002 L111.360001,225.459991 L121.979996,225.459991 L122.759995,225.519989 L122.819992,225.519989 L123.539993,225.760010 L123.539993,225.820007 L124.259995,226.179993 L124.319992,226.179993 L124.860001,226.660004 L124.860001,226.720001 L125.339996,227.320007 L125.399994,227.320007 L125.819992,227.980011 L125.819992,228.040009 L126.000000,228.820007 L126.000000,228.880005 L126.119995,229.660004 L126.119995,229.720001 L126.000000,230.500000 L125.819992,231.279999 L125.819992,231.339996 L125.399994,232.000000 L125.339996,232.059998 L124.860001,232.660004 L124.319992,233.140015 L124.259995,233.200012 L123.539993,233.559998 L122.819992,233.799988 L122.759995,233.799988 L121.979996,233.860016 L111.360001,233.860016 L110.580002,233.799988 L110.520004,233.799988 L109.800003,233.559998 L109.740005,233.559998 L109.080002,233.200012 L109.080002,233.140015 L108.479996,232.660004 L108.419998,232.660004 L107.940002,232.059998 L107.940002,232.000000 L107.580002,231.339996 L107.520004,231.279999 L107.279999,230.500000 L107.160004,229.720001 L107.160004,229.660004 L107.279999,228.880005 L107.279999,228.820007 C107.667999 227.161011,108.884995 225.963013,110.520004 225.519989  L110.580002,225.519989 L111.360001,225.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M111.360001,225.940002 L111.419998,225.940002 L111.360001,225.459991" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="133.739990" y="204.820007" width="0.480000" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M137.160004,205.119995 L136.680008,205.000000 L133.740005,215.380005 L133.740005,215.500000 L133.980011,216.339996 L134.220001,215.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M133.739990,215.500000 L134.219986,215.380005 L131.219986,205.000000 L130.739990,205.119995" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="133.739990" y="183.700012" width="0.480000" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="80.699997" y="205.359985" width="0.480000" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M84.179993,205.660034 L83.699997,205.540039 L80.699997,215.920044 L80.699997,216.040039 L80.939987,216.880035 L81.179993,216.040039" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M80.699997,216.040009 L81.179993,215.920013 L78.239990,205.540039 L77.759995,205.660034" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="80.699997" y="184.240051" width="0.480000" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="97.199997" y="206.320007" width="0.480000" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M100.679993,206.619995 L100.199997,206.500000 L97.199997,216.880005 L97.199997,217.000000 L97.439987,217.839996 L97.679993,217.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M97.199997,217.000000 L97.679993,216.880005 L94.739990,206.500000 L94.259995,206.619995" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="97.199997" y="185.200012" width="0.480000" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="115.739990" y="204.820007" width="0.480000" height="10.620000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M119.160004,205.119995 L118.680008,205.000000 L115.740005,215.380005 L115.740005,215.500000 L115.980011,216.339996 L116.220001,215.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M115.739990,215.500000 L116.219986,215.380005 L113.219986,205.000000 L112.739990,205.119995" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="115.739990" y="183.700012" width="0.480000" height="21.360001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M89.339996,255.820007 L88.979996,256.179993 L97.080002,263.080017 L97.440002,262.720001" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M91.500000,253.779999 L91.139999,254.019989 L97.080002,263.019989 L97.139999,263.139984 L97.919998,263.500000 L97.440002,262.779999" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M97.139999,263.140015 L97.380005,262.660004 L87.539993,258.160004 L87.300003,258.640015" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M81.119995,248.800018 L80.940002,248.680023 L80.639999,249.040009 L80.819992,249.160004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M89.339996,255.820007 L89.519989,255.940002 L89.220001,256.300018 L89.039993,256.179993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M81.119995,248.800018 L80.819992,249.160004 L89.039993,256.180023 L89.339996,255.820007" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M97.559998,250.180023 L97.080002,250.300018 L99.479996,260.620026 L99.959991,260.500031" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M100.500000,249.820007 L100.020004,249.820007 L99.479996,260.559998 L99.479996,260.679993 L99.899994,261.460022 L99.960007,260.559998" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M99.479996,260.680023 L99.959991,260.440033 L94.739990,251.020020 L94.259995,251.260010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M96.720001,246.400024 L96.660004,246.160034 L96.180008,246.280029 L96.240005,246.520020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M97.559998,250.180023 L97.619995,250.420013 L97.139999,250.540009 L97.080002,250.300018" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M96.720001,246.400024 L96.240005,246.520020 L97.080002,250.300018 L97.559998,250.180023" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M109.080002,251.920013 L108.600006,251.680023 L103.619995,261.040009 L104.100006,261.279999" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M111.539993,253.600006 L111.179993,253.240021 L103.679993,260.980011 L103.619995,261.100006 L103.439987,261.940002 L104.039993,261.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M103.619995,261.100006 L104.099991,261.220001 L106.379990,250.660004 L105.899994,250.540009" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M112.199997,246.100006 L112.319992,245.920013 L111.899994,245.679993 L111.779999,245.860016" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M109.080002,251.920013 L108.960007,252.100006 L108.540009,251.860016 L108.660004,251.680023" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M112.199997,246.100006 L111.779999,245.860016 L108.660004,251.679993 L109.080002,251.920013" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M117.779999,256.420013 L117.539993,256.060028 L108.600006,261.820007 L108.839996,262.180023" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M119.099991,259.059998 L118.979996,258.579987 L108.659988,261.760010 L108.539993,261.820007 L107.939987,262.480011 L108.779999,262.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M108.539993,261.820007 L108.899994,262.179993 L115.979996,254.020020 L115.619995,253.660004" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M132.059998,247.180023 L132.239990,247.060028 L132.000000,246.640015 L131.819992,246.760010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M117.779999,256.480011 L117.600006,256.600006 L117.360001,256.180023 L117.539993,256.059998" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M132.059998,247.180023 L131.819992,246.760010 L117.539993,256.060028 L117.779999,256.480011" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M320.339996,261.160004 L319.380005,261.220001 L319.500000,261.220001 L318.600006,261.519989 L317.820007,261.940002 L317.880005,261.880005 L317.160004,262.480011 L316.559998,263.200012 L316.619995,263.140015 L316.199982,263.980011 L315.899994,264.880005 L315.899994,264.820007 L315.779999,265.779999 L315.779999,265.720001 L315.899994,266.679993 L315.899994,266.619995 L316.199982,267.519989 L316.199982,267.459991 L316.619995,268.239990 L316.559998,268.239990 L317.160004,268.959991 L317.160004,268.899994 L317.880005,269.500000 L317.820007,269.500000 L318.600006,269.920013 L318.600006,269.860016 L319.500000,270.160004 L319.380005,270.160004 L320.339996,270.220001 L320.760010,270.220001 L321.720001,270.160004 L321.660004,270.160004 L322.559998,269.860016 L322.500000,269.920013 L323.339996,269.500000 L324.059998,268.899994 L324.000000,268.959991 L324.540009,268.239990 L325.019989,267.459991 L324.959991,267.519989 L325.199982,266.619995 L325.199982,266.679993 L325.320007,265.720001 L325.320007,265.779999 L325.199982,264.820007 L324.959991,263.920013 L325.019989,263.980011 L324.540009,263.140015 L324.540009,263.200012 L324.000000,262.480011 L324.059998,262.480011 L323.339996,261.880005 L323.339996,261.940002 L322.500000,261.519989 L322.559998,261.519989 L321.660004,261.220001 L321.720001,261.220001 L320.760010,261.160004 L320.339996,261.160004 L320.339996,260.679993 L320.760010,260.679993 L321.720001,260.739990 L321.839996,260.739990 L322.739990,261.040009 L322.739990,261.100006 L323.579987,261.519989 L323.639984,261.519989 L324.359985,262.119995 L324.359985,262.179993 L324.899994,262.899994 L324.959991,262.899994 L325.440002,263.739990 L325.440002,263.800018 C325.968994 265.330994,325.975983 267.243011,324.899994 268.540009  L324.359985,269.260010 L323.639984,269.860016 C322.346008 270.851990,319.904999 270.962006,318.419983 270.339996  L318.359985,270.339996 L317.579987,269.920013 L317.579987,269.860016 L316.859985,269.260010 L316.799988,269.260010 L316.199982,268.540009 L316.199982,268.480011 L315.779999,267.700012 L315.720001,267.700012 L315.419983,266.800018 L315.419983,266.739990 C315.166992 265.777008,315.337006 264.700989,315.720001 263.800018  L315.779999,263.739990 L316.199982,262.899994 C316.980011 261.795013,318.020996 261.083008,319.320007 260.739990  L319.380005,260.739990 L320.339996,260.679993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M320.339996,261.160004 L320.339996,260.679993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M103.199997,261.460022 L102.239990,261.520020 L102.360001,261.520020 L101.459991,261.820007 L100.619995,262.240021 L100.679993,262.180023 L100.020004,262.780029 L99.419998,263.500031 L99.479996,263.440033 L99.059998,264.220032 L98.759995,265.120026 L98.759995,265.060028 L98.639999,266.020020 L98.639999,265.960022 L98.759995,266.920013 L98.759995,266.860016 L99.059998,267.760010 L99.059998,267.700012 L99.479996,268.540009 L99.419998,268.540009 L100.020004,269.260010 L100.020004,269.200012 L100.679993,269.800018 L100.619995,269.800018 L101.459991,270.220032 L101.459991,270.160034 L102.360001,270.460022 L102.239990,270.460022 L103.199997,270.520020 L103.619995,270.520020 L104.580002,270.460022 L104.520004,270.460022 L105.419998,270.160034 L105.360001,270.220032 L106.199997,269.800018 L106.919998,269.200012 L106.860001,269.260010 L107.399994,268.540009 L107.879990,267.700012 L107.819992,267.760010 L108.059998,266.860016 L108.059998,266.920013 L108.179993,265.960022 L108.179993,266.020020 L108.059998,265.060028 L107.819992,264.160034 L107.879990,264.220032 L107.399994,263.440033 L107.399994,263.500031 L106.860001,262.780029 L106.919998,262.780029 L106.199997,262.180023 L106.199997,262.240021 L105.360001,261.820007 L105.419998,261.820007 L104.520004,261.520020 L104.580002,261.520020 L103.619995,261.460022 L103.199997,261.460022 L103.199997,260.980011 L103.619995,260.980011 L104.580002,261.040009 L104.699997,261.040009 L105.599991,261.340027 L105.599991,261.400024 L106.440002,261.820007 L106.500000,261.820007 L107.220001,262.420013 L107.220001,262.480011 L107.759995,263.200012 L107.819992,263.200012 L108.300003,263.980011 L108.300003,264.040009 C108.850998 265.598022,108.798004 267.499023,107.759995 268.840027  L107.220001,269.560028 L106.500000,270.160034 C105.205994 271.153015,102.764999 271.262024,101.279999 270.640015  L101.220001,270.640015 L100.379990,270.220032 L100.379990,270.160034 L99.720001,269.560028 L99.660004,269.560028 L99.059998,268.840027 L99.059998,268.780029 L98.639999,267.940033 L98.580002,267.940033 L98.279999,267.040009 L98.279999,266.980011 C98.026993 266.017029,98.196991 264.941010,98.580002 264.040009  L98.639999,263.980011 L99.059998,263.200012 C100.084000 261.879028,100.589996 261.538025,102.179993 261.040009  L102.239990,261.040009 L103.199997,260.980011" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M103.199997,261.460022 L103.199997,260.980011" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M153.059998,369.279999 L152.580002,369.519989 L157.199997,379.119995 L157.679993,378.880005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M155.879990,368.320007 L155.399994,368.440002 L157.199997,379.059998 L157.259995,379.179993 L157.799988,379.839996 L157.679993,378.940002" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M157.259995,379.180023 L157.619995,378.820038 L150.419998,370.780029 L150.059998,371.140015" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M105.599991,270.220001 L105.539993,270.040009 L105.119995,270.220001 L105.179993,270.399994" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M153.059998,369.339996 L153.119995,369.519989 L152.699997,369.699982 L152.639999,369.519989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M105.599991,270.220001 L105.179993,270.399994 L152.639984,369.520020 L153.059998,369.339996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M304.139984,370.180023 L303.659973,370.060028 L301.799988,380.500031 L302.279999,380.620026" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M307.019989,370.960022 L306.539978,370.720032 L301.799988,380.440033 L301.799988,380.560028 L301.859985,381.460022 L302.279999,380.680023" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M301.799988,380.559998 L302.279999,380.559998 L301.199982,369.820007 L300.720001,369.820007" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M321.059998,273.820007 L321.059998,273.580017 L320.579987,273.520020 L320.579987,273.760010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M304.139984,370.180023 L304.139984,370.420013 L303.659973,370.360016 L303.659973,370.120026" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M321.059998,273.820007 L320.579987,273.760010 L303.660004,370.119995 L304.139984,370.179993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M366.119995,375.339996 L365.760010,374.980011 L358.260010,382.480011 L358.619995,382.839996" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M368.040009,377.680023 L367.800018,377.200012 L358.320007,382.420013 L358.260010,382.540009 L357.779999,383.320038 L358.559998,382.840027" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M358.260010,382.540009 L358.680023,382.779999 L363.900024,373.360016 L363.420013,373.119995" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M370.500000,370.960022 L370.679993,370.780029 L370.320007,370.420013 L370.140015,370.600037" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M366.119995,375.339996 L365.940002,375.519989 L365.579987,375.160004 L365.760010,374.980011" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M370.500000,370.960022 L370.140015,370.600037 L365.760010,374.980011 L366.119995,375.340027" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M212.459991,375.940002 L212.100006,376.299988 L219.959991,383.380005 L220.319977,383.019989" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M214.619995,373.960022 L214.260010,374.200012 L219.959991,383.320007 L220.019989,383.440033 L220.799988,383.800018 L220.320007,383.080017" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M220.019989,383.440002 L220.259979,382.959991 L210.539978,378.220001 L210.299988,378.700012" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M197.519989,362.440002 L197.339996,362.320007 L197.039993,362.679993 L197.219986,362.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M212.459991,375.940002 L212.639984,376.059998 L212.339996,376.420013 L212.160004,376.299988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M197.519989,362.440002 L197.219986,362.799988 L212.160004,376.299988 L212.459991,375.940002" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="121.739990" y="32.380005" width="288.239990" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="409.500000" y="32.619995" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="121.500000" y="45.640015" width="288.239990" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="121.500000" y="32.380005" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="337.500000" y="32.619995" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="265.500000" y="32.619995" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="193.500000" y="32.619995" width="0.480000" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="251.339996" y="67.960022" width="69.360001" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="320.220001" y="68.200012" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="251.100006" y="79.959961" width="69.360001" height="0.480040" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="251.100006" y="67.960022" width="0.479980" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="268.380005" y="67.960022" width="0.479980" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="285.660004" y="67.960022" width="0.480010" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="302.940002" y="67.960022" width="0.479980" height="12.240000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M285.419983,68.559998 L286.019989,65.979980 L286.259979,65.380005 L286.799988,65.679993 L295.199982,70.299988 L296.699982,71.140015 L294.959991,71.200012 L285.419983,71.739990 L284.759979,71.799988 L284.879974,71.140015 L285.359985,70.779968 L294.899994,70.239990 L294.959991,71.200012 L294.659973,71.140015 L286.259979,66.520020 L286.799988,65.679993 L287.039978,66.219971 L286.439972,68.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M284.880005,71.140015 L285.420013,68.559998 L286.440002,68.799988 L285.899994,71.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M285.899994,68.679993 L286.500000,66.099976 L294.899994,70.719971 L285.359985,71.260010" fill-rule="evenodd"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M174.539993,43.720032 L174.299988,43.660034 L174.179993,44.140015 L174.419998,44.200012" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M285.480011,68.320007 L285.720001,68.380005 L285.600006,68.859985 L285.360016,68.799988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M174.539993,43.720032 L174.419998,44.200012 L285.359985,68.800049 L285.480011,68.320007" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M287.220001,65.140015 L288.420013,62.739990 L288.779999,62.200012 L289.200012,62.619995 L296.279999,69.040039 L297.600006,70.239990 L295.860016,69.940002 L286.440002,68.260010 L285.779999,68.080017 L286.079987,67.480042 L286.619995,67.239990 L296.040009,68.920044 L295.860016,69.940002 L295.619995,69.760010 L288.540009,63.340027 L289.200012,62.619995 L289.320007,63.220032 L288.119995,65.619995" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M286.079987,67.479980 L287.220001,65.139954 L288.119995,65.619995 L286.979980,67.959961" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M287.639984,65.380005 L288.839996,62.979980 L295.919983,69.400024 L286.499969,67.720032" fill-rule="evenodd"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M240.119995,41.739990 L239.940002,41.619995 L239.699982,42.039978 L239.880005,42.159973" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M287.339996,64.960022 L287.519989,65.080017 L287.279999,65.500000 L287.100006,65.380005" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M240.119995,41.739990 L239.880005,42.159973 L287.100006,65.380005 L287.339996,64.959961" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M295.139984,60.940002 L297.779999,60.580017 L298.439972,60.520020 L298.319977,61.179993 L296.939972,70.720032 L296.699982,72.460022 L295.979980,70.840027 L292.139984,62.020020 L291.899994,61.419983 L292.559998,61.299988 L293.099976,61.599976 L296.939972,70.419983 L295.979980,70.840027 L295.979980,70.539978 L297.359985,61.000000 L298.319977,61.179993 L297.899994,61.599976 L295.259979,61.960022" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M292.559998,61.299988 L295.139984,60.940002 L295.260010,61.959961 L292.679993,62.320007" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M295.199982,61.419983 L297.839996,61.059998 L296.459991,70.599976 L292.619995,61.779968" fill-rule="evenodd"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M292.739990,40.960022 L292.739990,40.720032 L292.259979,40.780029 L292.259979,41.020020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M295.380005,60.940002 L295.380005,61.179993 L294.899994,61.239990 L294.899994,61.000000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M292.739990,40.960022 L292.259979,41.020020 L294.899994,61.000000 L295.380005,60.940002" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M308.100006,64.720032 L309.360016,67.060059 L309.660004,67.660034 L309.000000,67.780029 L299.640015,69.820007 L297.959991,70.240051 L299.220001,68.980042 L306.059998,62.320007 L306.540009,61.900024 L306.839996,62.440002 L306.779999,63.040039 L299.940002,69.700012 L299.220001,68.980042 L299.459991,68.860046 L308.820007,66.820007 L309.000000,67.780029 L308.459991,67.540039 L307.200012,65.200012" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M306.839996,62.440002 L308.100006,64.720032 L307.199982,65.200012 L305.940002,62.919983" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M307.679993,64.960022 L308.940002,67.300049 L299.579987,69.340027 L306.419983,62.679993" fill-rule="evenodd"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M349.619995,42.700012 L349.799988,42.580017 L349.559998,42.160034 L349.380005,42.280029" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M308.279999,65.020020 L308.100006,65.140015 L307.859985,64.720032 L308.040009,64.600037" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M349.619995,42.700012 L349.380005,42.280029 L308.040009,64.600037 L308.279999,65.020020" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="120.479996" y="116.800049" width="288.299988" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="408.299988" y="117.040039" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="120.239990" y="130.060059" width="288.299988" height="0.479980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="120.239990" y="116.799988" width="0.480000" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="336.299988" y="117.040039" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="264.299988" y="117.040039" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="192.300003" y="117.040039" width="0.480010" height="13.500000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M301.380005,112.239990 L303.959991,111.700012 L304.619995,111.580017 L304.559998,112.239990 L303.959991,121.779968 L303.839996,123.459961 L303.059998,122.020020 L298.500000,113.559998 L298.200012,112.899963 L298.800018,112.779968 L299.339996,113.020020 L303.899994,121.479980 L303.059998,122.020020 L303.000000,121.719971 L303.600006,112.179993 L304.559998,112.239990 L304.200012,112.719971 L301.619995,113.260010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M298.799988,112.780029 L301.379974,112.240051 L301.619995,113.260010 L299.039978,113.800049" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M301.500000,112.720032 L304.079987,112.180054 L303.480011,121.720032 L298.920013,113.260010" fill-rule="evenodd"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M295.199982,82.179993 L295.139984,81.940002 L294.659973,82.059998 L294.719971,82.299988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M301.679993,112.179993 L301.739990,112.419983 L301.259979,112.539978 L301.199982,112.299988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M295.199982,82.179993 L294.719971,82.299988 L301.199982,112.299988 L301.679993,112.179993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M371.820007,118.479980 L373.320007,116.320007 L373.740021,115.839966 L374.160004,116.320007 L380.279999,123.699951 L381.420013,125.019958 L379.740021,124.479980 L370.619995,121.419983 L369.960022,121.239990 L370.320007,120.639954 L370.920013,120.459961 L380.040009,123.519958 L379.740021,124.479980 L379.500000,124.299988 L373.380005,116.919983 L374.160004,116.320007 L374.160004,116.919983 L372.660004,119.079956" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M370.320007,120.640015 L371.820007,118.480042 L372.660004,119.080017 L371.160004,121.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M372.239990,118.780029 L373.739990,116.620056 L379.859985,124.000000 L370.739990,120.940002" fill-rule="evenodd"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M318.299988,81.640015 L318.119995,81.520020 L317.819977,81.940002 L318.000000,82.059998" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M372.000000,118.299988 L372.179993,118.419983 L371.880005,118.839966 L371.700012,118.719971" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M318.299988,81.640015 L318.000000,82.059998 L371.699982,118.720032 L372.000000,118.299988" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M250.440002,116.979980 L252.540009,118.599976 L253.019989,119.019958 L252.480011,119.380005 L244.679993,125.019958 L243.299988,126.039978 L243.959991,124.419983 L247.559998,115.539978 L247.799988,114.940002 L248.339996,115.359985 L248.519989,115.899963 L244.920013,124.779968 L243.959991,124.419983 L244.140015,124.179993 L251.940002,118.539978 L252.480011,119.380005 L251.880005,119.380005 L249.779999,117.760010" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M248.339996,115.359985 L250.440002,116.979980 L249.779999,117.760010 L247.679993,116.140015" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M250.139984,117.340027 L252.239990,118.960022 L244.439972,124.600037 L248.039978,115.720032" fill-rule="evenodd"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M278.880005,81.100037 L279.000000,80.920044 L278.640015,80.620056 L278.520020,80.800049" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M250.619995,117.100037 L250.500000,117.280029 L250.139984,116.980042 L250.260010,116.800049" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M278.880005,81.100037 L278.520020,80.800049 L250.260010,116.800049 L250.619995,117.100037" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M162.839996,119.320007 L163.860001,121.780029 L164.099991,122.380005 L163.440002,122.500000 L153.959991,123.640015 L152.279999,123.820007 L153.599991,122.739990 L161.039993,116.679993 L161.580002,116.260010 L161.819992,116.859985 L161.699997,117.460022 L154.259995,123.520020 L153.599991,122.739990 L153.899994,122.619995 L163.379990,121.479980 L163.440002,122.500000 L162.959991,122.200012 L161.940002,119.739990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M161.819992,116.859985 L162.839996,119.320007 L161.939987,119.739990 L160.919998,117.279968" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M162.419998,119.500000 L163.440002,121.960022 L153.959991,123.099976 L161.399994,117.039978" fill-rule="evenodd"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M252.660004,81.640015 L252.839996,81.580017 L252.660004,81.160034 L252.480011,81.220032" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M163.019989,119.559998 L162.839996,119.619995 L162.659988,119.200012 L162.839996,119.140015" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M252.660004,81.640015 L252.480011,81.220032 L162.839996,119.140015 L163.020004,119.559998" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="265.619995" y="135.940002" width="0.299990" height="6.060000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="265.739990" y="141.699951" width="142.440002" height="0.300050" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<rect x="407.880005" y="136.059998" width="0.299990" height="5.760000" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.799988,172.960022 L364.440002,172.600037 L357.720001,180.880005 L358.079987,181.179993" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M366.899994,175.059998 L366.660004,174.700012 L357.779999,180.880005 L357.660004,180.940002 L357.359985,181.779968 L358.019989,181.239990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M357.660004,180.940002 L358.140015,181.179993 L362.399994,171.220032 L361.920013,170.979980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M390.540009,141.460022 L390.660004,141.280029 L390.300018,140.980042 L390.180023,141.160034" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M364.799988,172.960022 L364.679993,173.140015 L364.319977,172.840027 L364.440002,172.660034" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M390.540009,141.460022 L390.180023,141.160034 L364.440002,172.660034 L364.800018,172.960022" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M371.220001,269.980011 L370.739990,269.860016 L368.760010,280.300018 L369.239990,280.420013" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M374.100006,270.820007 L373.619995,270.580017 L368.760010,280.240021 L368.760010,280.360016 L368.820007,281.260010 L369.240021,280.480011" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M368.760010,280.360016 L369.240021,280.360016 L368.279999,269.620026 L367.800018,269.620026" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M395.100006,143.799988 L395.100006,143.559998 L394.619995,143.500000 L394.619995,143.739990" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M371.220001,269.980011 L371.220001,270.220001 L370.739990,270.160004 L370.739990,269.920013" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M395.100006,143.799988 L394.619995,143.739990 L370.740021,269.919983 L371.220001,269.979980" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M149.039993,178.960022 L148.919998,178.480042 L138.659988,181.300049 L138.779999,181.780029" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M149.519989,181.900024 L149.519989,181.420044 L138.719986,181.300049 L138.599991,181.300049 L137.879990,181.780029 L138.719986,181.780029" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M138.599991,181.299988 L138.839996,181.779968 L148.079987,176.140015 L147.839996,175.659973" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M280.919983,143.020020 L281.159973,142.960022 L281.039978,142.480042 L280.799988,142.540039" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M149.039993,178.960022 L148.799988,179.020020 L148.679993,178.540039 L148.919998,178.480042" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M280.919983,143.020020 L280.799988,142.540039 L148.919983,178.480042 L149.039978,178.960022" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M211.679993,265.600006 L211.320007,265.360016 L205.619995,274.360016 L205.979980,274.600006" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M214.079987,267.520020 L213.720001,267.160034 L205.619995,274.300018 L205.559998,274.420013 L205.319977,275.260010 L205.979980,274.660034" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M205.559998,274.420013 L206.040009,274.540009 L209.100006,264.160004 L208.619995,264.040009" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M289.079987,143.380005 L289.199982,143.200012 L288.779999,142.960022 L288.659973,143.140015" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M211.739990,265.600006 L211.619995,265.779999 L211.199982,265.540009 L211.319977,265.360016" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<path d="M289.079987,143.380005 L288.659973,143.140015 L211.319977,265.360016 L211.739990,265.600006" fill-rule="nonzero"  fill=" rgb(0,0,0) " stroke="black" />
<text x="348.712189" y="138.340027" textLength="1.284000" font-size="8px">l</text>
<text x="340.251007" y="138.340027" textLength="3.144000" font-size="8px">e</text>
<text x="337.183197" y="138.340027" textLength="3.108000" font-size="8px">p</text>
<text x="333.941986" y="138.340027" textLength="3.186000" font-size="8px">u</text>
<text x="331.306183" y="138.340027" textLength="2.676000" font-size="8px">s</text>
<text x="329.806793" y="138.340027" textLength="1.482000" font-size="8px"> </text>
<text x="326.687408" y="138.340027" textLength="3.108000" font-size="8px">d</text>
<text x="324.706207" y="138.340027" textLength="2.178000" font-size="8px">r</text>
<text x="313.865997" y="138.340027" textLength="3.108000" font-size="8px">q</text>
<text x="301.078796" y="138.340027" textLength="4.632000" font-size="8px">m</text>
<text x="223.436432" y="76.599976" textLength="3.150000" font-size="8px">o</text>
<text x="212.873444" y="76.599976" textLength="3.150000" font-size="8px">o</text>
<text x="200.092239" y="76.599976" textLength="2.226000" font-size="8px">f</text>
<text x="196.917633" y="76.599976" textLength="3.186000" font-size="8px">u</text>
<text x="193.743027" y="76.599976" textLength="3.186000" font-size="8px">h</text>
<text x="191.041824" y="76.599976" textLength="2.676000" font-size="8px">s</text>
<text x="186.062424" y="76.599976" textLength="3.510000" font-size="8px">8</text>
<text x="175.500015" y="76.599976" textLength="1.302000" font-size="8px">i</text>
<text x="94.792221" y="125.500000" textLength="3.108000" font-size="8px">p</text>
<text x="90.172226" y="125.500000" textLength="4.632000" font-size="8px">m</text>
<text x="86.933426" y="125.500000" textLength="3.456000" font-size="8px">T</text>
<text x="83.214615" y="125.500000" textLength="2.226000" font-size="8px">f</text>
<text x="75.534012" y="125.500000" textLength="3.144000" font-size="8px">e</text>
<text x="72.352814" y="125.500000" textLength="3.186000" font-size="8px">n</text>
<text x="66.414017" y="125.500000" textLength="2.976000" font-size="8px">L</text>
<text x="62.694614" y="125.500000" textLength="2.250000" font-size="8px">t</text>
<text x="58.242619" y="125.500000" textLength="3.108000" font-size="8px">b</text>
<text x="56.382015" y="125.500000" textLength="1.890000" font-size="8px">-</text>
<text x="52.851017" y="125.500000" textLength="3.510000" font-size="8px">8</text>
<text x="49.371014" y="125.500000" textLength="3.510000" font-size="8px">2</text>
<text x="218.459991" y="114.520020" textLength="3.186000" font-size="8px">n</text>
<text x="215.811005" y="114.520020" textLength="2.682000" font-size="8px">*</text>
<text x="212.270996" y="114.520020" textLength="3.510000" font-size="8px">8</text>
<text x="205.253998" y="114.520020" textLength="3.510000" font-size="8px">1</text>
<text x="201.837006" y="114.520020" textLength="3.450000" font-size="8px">+</text>
<text x="198.297012" y="114.520020" textLength="3.510000" font-size="8px">5</text>
<text x="194.820007" y="114.520020" textLength="3.510000" font-size="8px">9</text>
<text x="291.060059" y="114.520020" textLength="3.186000" font-size="8px">n</text>
<text x="288.353455" y="114.520020" textLength="2.682000" font-size="8px">*</text>
<text x="284.813446" y="114.520020" textLength="3.510000" font-size="8px">8</text>
<text x="281.333435" y="114.520020" textLength="3.510000" font-size="8px">2</text>
<text x="274.374634" y="114.520020" textLength="3.450000" font-size="8px">+</text>
<text x="267.360016" y="114.520020" textLength="3.510000" font-size="8px">6</text>
<text x="362.330994" y="114.520020" textLength="2.682000" font-size="8px">*</text>
<text x="358.850983" y="114.520020" textLength="3.510000" font-size="8px">8</text>
<text x="344.876984" y="114.520020" textLength="3.510000" font-size="8px">1</text>
<text x="406.377594" y="114.520020" textLength="3.510000" font-size="8px">2</text>
<text x="402.839996" y="114.520020" textLength="3.510000" font-size="8px">1</text>
<text x="134.338776" y="114.520020" textLength="2.682000" font-size="8px">*</text>
<text x="130.858780" y="114.520020" textLength="3.510000" font-size="8px">8</text>
<text x="123.838791" y="114.520020" textLength="3.510000" font-size="8px">1</text>
<text x="116.879990" y="114.520020" textLength="3.510000" font-size="8px">7</text>
<text x="113.339996" y="114.520020" textLength="3.510000" font-size="8px">2</text>
<text x="109.860001" y="114.520020" textLength="3.510000" font-size="8px">1</text>
<text x="371.698792" y="40.599915" textLength="3.510000" font-size="8px">0</text>
<text x="305.758789" y="138.340027" textLength="3.108000" font-size="8px">p</text>
<text x="363.240021" y="40.599915" textLength="3.690000" font-size="8px">D</text>
<text x="298.028412" y="41.619934" textLength="4.872000" font-size="8px">W</text>
<text x="232.318817" y="41.739929" textLength="3.510000" font-size="8px">2</text>
<text x="223.800018" y="41.739929" textLength="3.690000" font-size="8px">D</text>
<text x="153.488403" y="41.439941" textLength="4.872000" font-size="8px">W</text>
<text x="355.700409" y="138.340027" textLength="2.856000" font-size="8px">k</text>
<text x="149.820007" y="41.439941" textLength="3.690000" font-size="8px">D</text>
<text x="383.457611" y="83.199951" textLength="3.690000" font-size="8px">D</text>
<text x="381.958221" y="83.199951" textLength="1.482000" font-size="8px"> </text>
<text x="380.817017" y="83.199951" textLength="1.170000" font-size="8px">:</text>
<text x="377.275818" y="83.199951" textLength="3.546000" font-size="8px">B</text>
<text x="370.260010" y="83.199951" textLength="3.510000" font-size="8px">1</text>
<text x="387.116425" y="75.159973" textLength="4.872000" font-size="8px">W</text>
<text x="383.457611" y="75.159973" textLength="3.690000" font-size="8px">D</text>
<text x="381.958221" y="75.159973" textLength="1.482000" font-size="8px"> </text>
<text x="380.817017" y="75.159973" textLength="1.170000" font-size="8px">:</text>
<text x="377.275818" y="75.159973" textLength="3.546000" font-size="8px">B</text>
<text x="373.795807" y="75.159973" textLength="3.510000" font-size="8px">0</text>
<text x="370.260010" y="75.159973" textLength="3.510000" font-size="8px">1</text>
<text x="383.457611" y="67.179993" textLength="3.690000" font-size="8px">D</text>
<text x="381.958221" y="67.179993" textLength="1.482000" font-size="8px"> </text>
<text x="380.817017" y="67.179993" textLength="1.170000" font-size="8px">:</text>
<text x="373.795807" y="67.179993" textLength="3.510000" font-size="8px">1</text>
<text x="391.976410" y="59.200012" textLength="3.510000" font-size="8px">0</text>
<text x="383.457611" y="59.200012" textLength="3.690000" font-size="8px">D</text>
<text x="380.817017" y="59.200012" textLength="1.170000" font-size="8px">:</text>
<text x="377.275818" y="59.200012" textLength="3.546000" font-size="8px">B</text>
<text x="373.795807" y="59.200012" textLength="3.510000" font-size="8px">0</text>
<text x="304.439972" y="88.840027" textLength="3.510000" font-size="8px">1</text>
<text x="286.259979" y="88.840027" textLength="3.510000" font-size="8px">3</text>
<text x="316.739990" y="88.840027" textLength="3.510000" font-size="8px">0</text>
<text x="89.130051" y="39.880066" textLength="2.604000" font-size="8px">c</text>
<text x="87.088852" y="39.880066" textLength="2.178000" font-size="8px">r</text>
<text x="80.193039" y="39.880066" textLength="2.226000" font-size="8px">f</text>
<text x="387.116425" y="67.179993" textLength="4.872000" font-size="8px">W</text>
<text x="77.132446" y="39.880066" textLength="3.150000" font-size="8px">o</text>
<text x="181.441818" y="76.599976" textLength="4.632000" font-size="8px">m</text>
<text x="63.382244" y="39.880066" textLength="2.976000" font-size="8px">L</text>
<text x="59.602848" y="39.880066" textLength="2.250000" font-size="8px">t</text>
<text x="176.821213" y="76.599976" textLength="4.632000" font-size="8px">m</text>
<text x="55.242649" y="39.880066" textLength="3.108000" font-size="8px">b</text>
<text x="53.322048" y="39.880066" textLength="1.890000" font-size="8px">-</text>
<text x="46.320049" y="39.880066" textLength="3.510000" font-size="8px">2</text>
<text x="219.720032" y="30.100037" textLength="3.186000" font-size="8px">n</text>
<text x="217.071045" y="30.100037" textLength="2.682000" font-size="8px">*</text>
<text x="206.514038" y="30.100037" textLength="3.510000" font-size="8px">1</text>
<text x="189.602417" y="76.599976" textLength="1.482000" font-size="8px"> </text>
<text x="203.097046" y="30.100037" textLength="3.450000" font-size="8px">+</text>
<text x="196.080032" y="30.100037" textLength="3.510000" font-size="8px">9</text>
<text x="292.260040" y="30.100037" textLength="3.186000" font-size="8px">n</text>
<text x="289.551025" y="30.100037" textLength="2.682000" font-size="8px">*</text>
<text x="286.071014" y="30.100037" textLength="3.510000" font-size="8px">8</text>
<text x="279.054016" y="30.100037" textLength="3.510000" font-size="8px">1</text>
<text x="275.577026" y="30.100037" textLength="3.450000" font-size="8px">+</text>
<text x="391.976410" y="75.159973" textLength="3.510000" font-size="8px">2</text>
<text x="272.097015" y="30.100037" textLength="3.510000" font-size="8px">3</text>
<text x="268.560028" y="30.100037" textLength="3.510000" font-size="8px">6</text>
<text x="363.477631" y="30.100037" textLength="2.682000" font-size="8px">*</text>
<text x="302.878815" y="41.619934" textLength="3.510000" font-size="8px">1</text>
<text x="250.739990" y="88.840027" textLength="3.510000" font-size="8px">7</text>
<text x="359.998230" y="30.100037" textLength="3.510000" font-size="8px">8</text>
<text x="356.518829" y="30.100037" textLength="3.510000" font-size="8px">2</text>
<text x="346.019409" y="30.100037" textLength="3.510000" font-size="8px">1</text>
<text x="420.066010" y="308.140015" textLength="2.178000" font-size="8px">r</text>
<text x="30.642605" y="385.360016" textLength="2.676000" font-size="8px">s</text>
<text x="339.419983" y="274.960022" textLength="3.510000" font-size="8px">3</text>
<text x="374.939972" y="274.960022" textLength="3.510000" font-size="8px">1</text>
<text x="328.380005" y="231.160004" textLength="3.571045" font-size="8px">a</text>
<text x="127.318787" y="114.520020" textLength="3.510000" font-size="8px">2</text>
<text x="331.440002" y="219.160004" textLength="4.554000" font-size="8px">_</text>
<text x="208.794006" y="114.520020" textLength="3.510000" font-size="8px">2</text>
<text x="216.539978" y="294.400085" textLength="3.510000" font-size="8px">9</text>
<text x="353.759216" y="231.160004" textLength="3.204599" font-size="8px">s</text>
<text x="346.619995" y="231.160004" textLength="3.571045" font-size="8px">a</text>
<text x="227.398804" y="41.739929" textLength="4.872000" font-size="8px">W</text>
<text x="299.039215" y="231.160004" textLength="3.204599" font-size="8px">s</text>
<text x="69.353409" y="125.500000" textLength="2.982000" font-size="8px">a</text>
<text x="291.899994" y="231.160004" textLength="3.571045" font-size="8px">a</text>
<text x="294.959991" y="219.160004" textLength="4.554000" font-size="8px">_</text>
<text x="240.790192" y="304.300018" textLength="2.604000" font-size="8px">c</text>
<text x="92.759995" y="231.820007" textLength="3.571045" font-size="8px">a</text>
<text x="77.580002" y="219.760010" textLength="4.554000" font-size="8px">_</text>
<text x="132.058762" y="30.100037" textLength="3.510000" font-size="8px">8</text>
<text x="408.785980" y="184.960022" textLength="2.178000" font-size="8px">r</text>
<text x="250.990204" y="304.300018" textLength="2.250000" font-size="8px">t</text>
<text x="310.139984" y="231.160004" textLength="3.571045" font-size="8px">a</text>
<text x="393.424194" y="184.960022" textLength="3.108000" font-size="8px">g</text>
<text x="368.880005" y="368.380005" textLength="5.175000" font-size="8px">+</text>
<text x="380.517578" y="184.960022" textLength="2.676000" font-size="8px">s</text>
<text x="159.424179" y="186.040039" textLength="3.510000" font-size="8px">1</text>
<text x="420.009552" y="208.179993" textLength="3.108000" font-size="8px">d</text>
<text x="355.260010" y="198.820068" textLength="3.510000" font-size="8px">0</text>
<text x="235.320007" y="280.660034" textLength="3.456000" font-size="8px">T</text>
<text x="396.600006" y="330.640015" textLength="3.571045" font-size="8px">a</text>
<text x="343.500031" y="175.420044" textLength="3.510000" font-size="8px">1</text>
<text x="374.771973" y="208.179993" textLength="3.510000" font-size="8px">1</text>
<text x="400.391357" y="208.179993" textLength="2.178000" font-size="8px">r</text>
<text x="383.207977" y="184.960022" textLength="1.284000" font-size="8px">l</text>
<text x="307.860016" y="175.420044" textLength="3.510000" font-size="8px">3</text>
<text x="405.670166" y="208.179993" textLength="1.482000" font-size="8px"> </text>
<text x="261.960022" y="374.440002" textLength="3.510000" font-size="8px">1</text>
<text x="393.899994" y="374.440002" textLength="3.510000" font-size="8px">0</text>
<text x="113.160004" y="374.440002" textLength="3.510000" font-size="8px">6</text>
<text x="271.182587" y="304.300018" textLength="3.120000" font-size="8px">y</text>
<text x="78.654617" y="125.500000" textLength="1.482000" font-size="8px"> </text>
<text x="343.431610" y="138.340027" textLength="2.178000" font-size="8px">r</text>
<text x="317.279205" y="231.160004" textLength="3.204599" font-size="8px">s</text>
<text x="397.451965" y="208.179993" textLength="2.982000" font-size="8px">a</text>
<text x="93.507599" y="385.360016" textLength="2.604000" font-size="8px">c</text>
<text x="417.241241" y="30.100037" textLength="3.186000" font-size="8px">n</text>
<text x="243.429596" y="304.300018" textLength="3.510000" font-size="8px">1</text>
<text x="90.899994" y="175.780090" textLength="3.510000" font-size="8px">4</text>
<text x="137.039978" y="114.520020" textLength="3.186000" font-size="8px">n</text>
<text x="277.793427" y="114.520020" textLength="3.510000" font-size="8px">1</text>
<text x="331.874176" y="231.160004" textLength="3.721934" font-size="8px">b</text>
<text x="23.820004" y="385.360016" textLength="3.690000" font-size="8px">D</text>
<text x="142.259995" y="175.780090" textLength="3.510000" font-size="8px">4</text>
<text x="58.341648" y="39.880066" textLength="1.302000" font-size="8px">i</text>
<text x="414.827942" y="208.179993" textLength="3.150000" font-size="8px">o</text>
<text x="295.394165" y="231.160004" textLength="3.721934" font-size="8px">b</text>
<text x="444.153015" y="308.140015" textLength="3.186000" font-size="8px">n</text>
<text x="221.335236" y="76.599976" textLength="2.178000" font-size="8px">r</text>
<text x="286.596558" y="304.300018" textLength="2.178000" font-size="8px">r</text>
<text x="159.299988" y="294.400085" textLength="3.510000" font-size="8px">6</text>
<text x="335.880005" y="374.440002" textLength="3.510000" font-size="8px">5</text>
<text x="129.239990" y="231.820007" textLength="3.571045" font-size="8px">a</text>
<text x="405.419983" y="274.960022" textLength="3.510000" font-size="8px">0</text>
<text x="416.880005" y="308.140015" textLength="3.186000" font-size="8px">S</text>
<text x="256.560577" y="280.660034" textLength="3.108000" font-size="8px">d</text>
<text x="385.784973" y="184.960022" textLength="3.108000" font-size="8px">d</text>
<text x="379.771759" y="208.179993" textLength="2.676000" font-size="8px">s</text>
<text x="377.275818" y="67.179993" textLength="3.546000" font-size="8px">B</text>
<text x="177.244781" y="186.040039" textLength="3.108000" font-size="8px">g</text>
<text x="259.679962" y="280.660034" textLength="1.302000" font-size="8px">i</text>
<text x="389.777954" y="208.179993" textLength="1.302000" font-size="8px">i</text>
<text x="74.317795" y="385.360016" textLength="3.186000" font-size="8px">u</text>
<text x="381.958221" y="59.200012" textLength="1.482000" font-size="8px"> </text>
<text x="387.557953" y="208.179993" textLength="2.250000" font-size="8px">t</text>
<text x="282.534027" y="30.100037" textLength="3.510000" font-size="8px">2</text>
<text x="402.559753" y="208.179993" textLength="3.120000" font-size="8px">y</text>
<text x="381.419983" y="318.640015" textLength="4.554000" font-size="8px">_</text>
<text x="259.674591" y="304.300018" textLength="3.150000" font-size="8px">o</text>
<text x="397.982971" y="184.960022" textLength="3.108000" font-size="8px">d</text>
<text x="96.087006" y="385.360016" textLength="2.856000" font-size="8px">k</text>
<text x="313.199982" y="219.160004" textLength="4.554000" font-size="8px">_</text>
<text x="206.339996" y="211.420013" textLength="3.510000" font-size="8px">1</text>
<text x="424.568329" y="208.179993" textLength="3.510000" font-size="8px">0</text>
<text x="332.399994" y="374.440002" textLength="3.510000" font-size="8px">1</text>
<text x="75.633041" y="39.880066" textLength="1.482000" font-size="8px"> </text>
<text x="213.531036" y="30.100037" textLength="3.510000" font-size="8px">8</text>
<text x="96.223984" y="231.820007" textLength="3.721934" font-size="8px">b</text>
<text x="189.479996" y="363.160004" textLength="5.175000" font-size="8px">+</text>
<text x="316.933807" y="138.340027" textLength="4.632000" font-size="8px">w</text>
<text x="341.339996" y="114.520020" textLength="3.510000" font-size="8px">3</text>
<text x="279.549530" y="280.660034" textLength="2.178000" font-size="8px">r</text>
<text x="192.662384" y="186.040039" textLength="2.178000" font-size="8px">r</text>
<text x="307.320007" y="198.820068" textLength="3.510000" font-size="8px">2</text>
<text x="469.888214" y="308.140015" textLength="3.108000" font-size="8px">d</text>
<text x="210.054047" y="30.100037" textLength="3.510000" font-size="8px">2</text>
<text x="161.819992" y="326.020020" textLength="3.571045" font-size="8px">a</text>
<text x="394.210754" y="208.179993" textLength="3.186000" font-size="8px">n</text>
<text x="61.867199" y="385.360016" textLength="3.150000" font-size="8px">o</text>
<text x="410.827179" y="184.960022" textLength="3.108000" font-size="8px">d</text>
<text x="388.907379" y="184.960022" textLength="1.302000" font-size="8px">i</text>
<text x="423.068939" y="208.179993" textLength="1.482000" font-size="8px"> </text>
<text x="189.494980" y="186.040039" textLength="3.150000" font-size="8px">o</text>
<text x="288.637756" y="304.300018" textLength="3.108000" font-size="8px">d</text>
<text x="363.583984" y="330.640015" textLength="3.721934" font-size="8px">b</text>
<text x="345.592804" y="138.340027" textLength="3.108000" font-size="8px">b</text>
<text x="118.078857" y="231.820007" textLength="3.204599" font-size="8px">s</text>
<text x="391.070343" y="208.179993" textLength="3.150000" font-size="8px">o</text>
<text x="365.040009" y="114.520020" textLength="3.186000" font-size="8px">n</text>
<text x="387.116425" y="83.199951" textLength="4.872000" font-size="8px">W</text>
<text x="72.779999" y="175.780090" textLength="3.510000" font-size="8px">5</text>
<text x="426.364197" y="284.920013" textLength="3.510000" font-size="8px">1</text>
<text x="94.439987" y="175.780090" textLength="3.510000" font-size="8px">7</text>
<text x="396.483582" y="184.960022" textLength="1.482000" font-size="8px"> </text>
<text x="409.857605" y="114.520020" textLength="3.510000" font-size="8px">8</text>
<text x="435.297577" y="284.920013" textLength="1.302000" font-size="8px">i</text>
<text x="169.347000" y="211.420013" textLength="2.250000" font-size="8px">t</text>
<text x="174.063583" y="186.040039" textLength="3.186000" font-size="8px">n</text>
<text x="293.280029" y="175.420044" textLength="3.510000" font-size="8px">9</text>
<text x="351.833984" y="114.520020" textLength="3.510000" font-size="8px">1</text>
<text x="373.795807" y="83.199951" textLength="3.510000" font-size="8px">1</text>
<text x="313.634155" y="231.160004" textLength="3.721934" font-size="8px">b</text>
<text x="370.260010" y="67.179993" textLength="3.510000" font-size="8px">0</text>
<text x="199.557037" y="30.100037" textLength="3.510000" font-size="8px">5</text>
<text x="372.478790" y="184.960022" textLength="3.108000" font-size="8px">p</text>
<text x="161.557205" y="211.420013" textLength="2.676000" font-size="8px">s</text>
<text x="366.899994" y="208.179993" textLength="3.186000" font-size="8px">S</text>
<text x="216.054047" y="76.599976" textLength="3.186000" font-size="8px">n</text>
<text x="366.838806" y="40.599915" textLength="4.872000" font-size="8px">W</text>
<text x="114.599991" y="30.100037" textLength="3.510000" font-size="8px">2</text>
<text x="429.750610" y="308.140015" textLength="2.676000" font-size="8px">s</text>
<text x="91.725052" y="39.880066" textLength="3.510000" font-size="8px">2</text>
<text x="111.000000" y="231.820007" textLength="3.571045" font-size="8px">a</text>
<text x="114.463989" y="231.820007" textLength="3.721934" font-size="8px">b</text>
<text x="405.665375" y="184.960022" textLength="3.150000" font-size="8px">o</text>
<text x="350.114166" y="231.160004" textLength="3.721934" font-size="8px">b</text>
<text x="367.798798" y="184.960022" textLength="4.632000" font-size="8px">m</text>
<text x="342.900024" y="198.820068" textLength="3.510000" font-size="8px">7</text>
<text x="80.154022" y="125.500000" textLength="3.150000" font-size="8px">o</text>
<text x="382.438171" y="208.179993" textLength="2.250000" font-size="8px">t</text>
<text x="294.360016" y="41.619934" textLength="3.690000" font-size="8px">D</text>
<text x="357.360016" y="298.360016" textLength="3.510000" font-size="8px">2</text>
<text x="181.869583" y="186.040039" textLength="3.108000" font-size="8px">d</text>
<text x="116.639999" y="374.440002" textLength="3.510000" font-size="8px">3</text>
<text x="225.599976" y="270.220093" textLength="3.510000" font-size="8px">1</text>
<text x="308.826599" y="138.340027" textLength="3.510000" font-size="8px">1</text>
<text x="80.635788" y="385.360016" textLength="3.144000" font-size="8px">e</text>
<text x="151.858200" y="211.420013" textLength="2.178000" font-size="8px">r</text>
<text x="349.679993" y="219.160004" textLength="4.554000" font-size="8px">_</text>
<text x="180.370178" y="186.040039" textLength="1.482000" font-size="8px"> </text>
<text x="335.519226" y="231.160004" textLength="3.204599" font-size="8px">s</text>
<text x="61.371616" y="125.500000" textLength="1.302000" font-size="8px">i</text>
<text x="189.480011" y="374.440002" textLength="3.510000" font-size="8px">7</text>
<text x="216.540009" y="326.020020" textLength="3.571045" font-size="8px">a</text>
<text x="249.838196" y="280.660034" textLength="1.482000" font-size="8px"> </text>
<text x="118.079987" y="30.100037" textLength="3.510000" font-size="8px">7</text>
<text x="76.259995" y="175.780090" textLength="3.510000" font-size="8px">5</text>
<text x="219.115234" y="76.599976" textLength="2.250000" font-size="8px">t</text>
<text x="54.247196" y="385.360016" textLength="3.108000" font-size="8px">q</text>
<text x="378.272369" y="208.179993" textLength="1.482000" font-size="8px"> </text>
<text x="363.179993" y="318.640015" textLength="4.554000" font-size="8px">_</text>
<text x="275.804962" y="304.300018" textLength="3.108000" font-size="8px">d</text>
<text x="246.358185" y="280.660034" textLength="3.510000" font-size="8px">1</text>
<text x="381.823975" y="330.640015" textLength="3.721934" font-size="8px">b</text>
<text x="194.819992" y="294.400085" textLength="3.510000" font-size="8px">4</text>
<text x="455.619019" y="308.140015" textLength="1.482000" font-size="8px"> </text>
<text x="179.181610" y="211.420013" textLength="2.982000" font-size="8px">a</text>
<text x="226.557037" y="76.599976" textLength="1.284000" font-size="8px">l</text>
<text x="167.096985" y="186.040039" textLength="1.284000" font-size="8px">l</text>
<text x="379.078186" y="184.960022" textLength="1.482000" font-size="8px"> </text>
<text x="372.177582" y="208.179993" textLength="2.604000" font-size="8px">c</text>
<text x="243.238800" y="280.660034" textLength="3.108000" font-size="8px">p</text>
<text x="64.914612" y="125.500000" textLength="1.482000" font-size="8px"> </text>
<text x="378.479980" y="274.960022" textLength="3.510000" font-size="8px">5</text>
<text x="401.105377" y="184.960022" textLength="4.632000" font-size="8px">w</text>
<text x="312.366608" y="138.340027" textLength="1.482000" font-size="8px"> </text>
<text x="42.780048" y="39.880066" textLength="3.510000" font-size="8px">1</text>
<text x="185.940018" y="374.440002" textLength="3.510000" font-size="8px">4</text>
<text x="370.076385" y="208.179993" textLength="2.178000" font-size="8px">r</text>
<text x="375.538177" y="184.960022" textLength="3.510000" font-size="8px">1</text>
<text x="410.267944" y="208.179993" textLength="4.632000" font-size="8px">w</text>
<text x="172.861206" y="211.420013" textLength="3.150000" font-size="8px">o</text>
<text x="183.479431" y="326.020020" textLength="3.721934" font-size="8px">b</text>
<text x="424.711212" y="308.140015" textLength="3.510000" font-size="8px">1</text>
<text x="182.155807" y="211.420013" textLength="2.178000" font-size="8px">r</text>
<text x="441.003571" y="284.920013" textLength="3.186000" font-size="8px">n</text>
<text x="403.678864" y="330.640015" textLength="3.204599" font-size="8px">s</text>
<text x="321.525604" y="138.340027" textLength="3.150000" font-size="8px">o</text>
<text x="27.522007" y="385.360016" textLength="3.144000" font-size="8px">e</text>
<text x="89.066391" y="385.360016" textLength="1.284000" font-size="8px">l</text>
<text x="422.107208" y="308.140015" textLength="2.604000" font-size="8px">c</text>
<text x="160.057800" y="211.420013" textLength="1.482000" font-size="8px"> </text>
<text x="432.331818" y="308.140015" textLength="2.250000" font-size="8px">t</text>
<text x="342.840027" y="298.360016" textLength="3.510000" font-size="8px">1</text>
<text x="437.431213" y="308.140015" textLength="2.250000" font-size="8px">t</text>
<text x="439.711212" y="308.140015" textLength="1.302000" font-size="8px">i</text>
<text x="128.578766" y="30.100037" textLength="3.510000" font-size="8px">2</text>
<text x="404.040009" y="30.100037" textLength="3.510000" font-size="8px">1</text>
<text x="450.321014" y="308.140015" textLength="2.178000" font-size="8px">r</text>
<text x="392.940033" y="298.360016" textLength="3.510000" font-size="8px">7</text>
<text x="52.747799" y="385.360016" textLength="1.482000" font-size="8px"> </text>
<text x="452.499023" y="308.140015" textLength="3.120000" font-size="8px">y</text>
<text x="428.251221" y="308.140015" textLength="1.482000" font-size="8px"> </text>
<text x="456.434967" y="284.920013" textLength="3.150000" font-size="8px">o</text>
<text x="460.166412" y="308.140015" textLength="4.632000" font-size="8px">w</text>
<text x="464.726410" y="308.140015" textLength="3.150000" font-size="8px">o</text>
<text x="83.911850" y="39.880066" textLength="3.186000" font-size="8px">S</text>
<text x="268.749542" y="280.660034" textLength="3.108000" font-size="8px">d</text>
<text x="467.907013" y="308.140015" textLength="2.178000" font-size="8px">r</text>
<text x="472.996185" y="308.140015" textLength="1.482000" font-size="8px"> </text>
<text x="474.495575" y="308.140015" textLength="3.510000" font-size="8px">0</text>
<text x="49.821049" y="39.880066" textLength="3.510000" font-size="8px">8</text>
<text x="418.618805" y="284.920013" textLength="4.632000" font-size="8px">m</text>
<text x="423.238800" y="284.920013" textLength="3.108000" font-size="8px">p</text>
<text x="158.338806" y="41.439941" textLength="3.510000" font-size="8px">3</text>
<text x="370.260010" y="59.200012" textLength="3.510000" font-size="8px">0</text>
<text x="278.915955" y="304.300018" textLength="4.632000" font-size="8px">w</text>
<text x="431.343597" y="284.920013" textLength="2.676000" font-size="8px">s</text>
<text x="448.809570" y="284.920013" textLength="3.108000" font-size="8px">d</text>
<text x="264.190735" y="280.660034" textLength="3.108000" font-size="8px">g</text>
<text x="148.679993" y="211.420013" textLength="3.186000" font-size="8px">S</text>
<text x="451.934967" y="284.920013" textLength="4.632000" font-size="8px">w</text>
<text x="459.602386" y="284.920013" textLength="2.178000" font-size="8px">r</text>
<text x="461.643585" y="284.920013" textLength="3.108000" font-size="8px">d</text>
<text x="411.060028" y="30.100037" textLength="3.510000" font-size="8px">8</text>
<text x="464.702972" y="284.920013" textLength="1.482000" font-size="8px"> </text>
<text x="345.343994" y="330.640015" textLength="3.721934" font-size="8px">b</text>
<text x="348.958862" y="330.640015" textLength="3.204599" font-size="8px">s</text>
<text x="40.015804" y="385.360016" textLength="2.982000" font-size="8px">a</text>
<text x="75.119995" y="199.960083" textLength="3.510000" font-size="8px">3</text>
<text x="399.660004" y="318.640015" textLength="4.554000" font-size="8px">_</text>
<text x="57.367199" y="385.360016" textLength="4.632000" font-size="8px">w</text>
<text x="125.339996" y="199.960083" textLength="3.510000" font-size="8px">3</text>
<text x="367.198853" y="330.640015" textLength="3.204599" font-size="8px">s</text>
<text x="192.037811" y="211.420013" textLength="4.632000" font-size="8px">w</text>
<text x="384.468567" y="184.960022" textLength="1.302000" font-size="8px">i</text>
<text x="318.540009" y="269.380005" textLength="5.175000" font-size="8px">+</text>
<text x="378.359985" y="330.640015" textLength="3.571045" font-size="8px">a</text>
<text x="447.310181" y="284.920013" textLength="1.482000" font-size="8px"> </text>
<text x="385.438843" y="330.640015" textLength="3.204599" font-size="8px">s</text>
<text x="235.559998" y="304.300018" textLength="3.186000" font-size="8px">S</text>
<text x="238.748993" y="304.300018" textLength="2.178000" font-size="8px">r</text>
<text x="387.116425" y="59.200012" textLength="4.872000" font-size="8px">W</text>
<text x="413.949585" y="184.960022" textLength="1.482000" font-size="8px"> </text>
<text x="378.240021" y="298.360016" textLength="3.510000" font-size="8px">5</text>
<text x="45.840015" y="125.500000" textLength="3.510000" font-size="8px">1</text>
<text x="246.909607" y="304.300018" textLength="1.482000" font-size="8px"> </text>
<text x="360.900024" y="298.360016" textLength="3.510000" font-size="8px">3</text>
<text x="248.408997" y="304.300018" textLength="2.676000" font-size="8px">s</text>
<text x="69.321045" y="39.880066" textLength="3.186000" font-size="8px">n</text>
<text x="256.089600" y="304.300018" textLength="2.250000" font-size="8px">t</text>
<text x="85.434021" y="125.500000" textLength="1.482000" font-size="8px"> </text>
<text x="258.369598" y="304.300018" textLength="1.302000" font-size="8px">i</text>
<text x="342.540009" y="30.100037" textLength="3.510000" font-size="8px">3</text>
<text x="262.827606" y="304.300018" textLength="3.186000" font-size="8px">n</text>
<text x="266.016602" y="304.300018" textLength="2.982000" font-size="8px">a</text>
<text x="251.337585" y="280.660034" textLength="2.676000" font-size="8px">s</text>
<text x="269.001587" y="304.300018" textLength="2.178000" font-size="8px">r</text>
<text x="274.305573" y="304.300018" textLength="1.482000" font-size="8px"> </text>
<text x="407.520020" y="30.100037" textLength="3.510000" font-size="8px">2</text>
<text x="283.415955" y="304.300018" textLength="3.150000" font-size="8px">o</text>
<text x="291.697144" y="304.300018" textLength="1.482000" font-size="8px"> </text>
<text x="417.968353" y="208.179993" textLength="2.178000" font-size="8px">r</text>
<text x="293.196533" y="304.300018" textLength="3.510000" font-size="8px">1</text>
<text x="440.972412" y="308.140015" textLength="3.150000" font-size="8px">o</text>
<text x="238.618805" y="280.660034" textLength="4.632000" font-size="8px">m</text>
<text x="407.169556" y="208.179993" textLength="3.108000" font-size="8px">d</text>
<text x="253.978790" y="280.660034" textLength="1.284000" font-size="8px">l</text>
<text x="255.299377" y="280.660034" textLength="1.302000" font-size="8px">i</text>
<text x="341.880005" y="330.640015" textLength="3.571045" font-size="8px">a</text>
<text x="260.993347" y="280.660034" textLength="3.186000" font-size="8px">n</text>
<text x="267.310150" y="280.660034" textLength="1.482000" font-size="8px"> </text>
<text x="188.937607" y="211.420013" textLength="3.108000" font-size="8px">d</text>
<text x="276.428925" y="280.660034" textLength="3.150000" font-size="8px">o</text>
<text x="281.590729" y="280.660034" textLength="3.108000" font-size="8px">d</text>
<text x="164.879990" y="314.020020" textLength="4.554000" font-size="8px">_</text>
<text x="205.842041" y="76.599976" textLength="3.144000" font-size="8px">e</text>
<text x="165.239426" y="326.020020" textLength="3.721934" font-size="8px">b</text>
<text x="344.940002" y="318.640015" textLength="4.554000" font-size="8px">_</text>
<text x="166.467606" y="211.420013" textLength="2.982000" font-size="8px">a</text>
<text x="168.898849" y="326.020020" textLength="3.204599" font-size="8px">s</text>
<text x="219.600006" y="314.020020" textLength="4.554000" font-size="8px">_</text>
<text x="311.340027" y="175.420044" textLength="3.510000" font-size="8px">1</text>
<text x="366.178833" y="30.100037" textLength="3.186000" font-size="8px">n</text>
<text x="219.959442" y="326.020020" textLength="3.721934" font-size="8px">b</text>
<text x="177.659973" y="270.220093" textLength="3.510000" font-size="8px">3</text>
<text x="223.618866" y="326.020020" textLength="3.204599" font-size="8px">s</text>
<text x="444.184784" y="284.920013" textLength="3.108000" font-size="8px">g</text>
<text x="183.119995" y="314.020020" textLength="4.554000" font-size="8px">_</text>
<text x="180.059998" y="326.020020" textLength="3.571045" font-size="8px">a</text>
<text x="204.521454" y="76.599976" textLength="1.284000" font-size="8px">l</text>
<text x="184.326004" y="211.420013" textLength="3.120000" font-size="8px">y</text>
<text x="187.138855" y="326.020020" textLength="3.204599" font-size="8px">s</text>
<text x="289.260010" y="198.820068" textLength="3.510000" font-size="8px">3</text>
<text x="201.359985" y="314.020020" textLength="4.554000" font-size="8px">_</text>
<text x="198.300003" y="326.020020" textLength="3.571045" font-size="8px">a</text>
<text x="197.762985" y="186.040039" textLength="1.482000" font-size="8px"> </text>
<text x="201.719452" y="326.020020" textLength="3.721934" font-size="8px">b</text>
<text x="342.899994" y="274.960022" textLength="3.510000" font-size="8px">1</text>
<text x="169.676987" y="186.040039" textLength="3.108000" font-size="8px">d</text>
<text x="202.306854" y="76.599976" textLength="2.226000" font-size="8px">f</text>
<text x="135.538757" y="30.100037" textLength="2.682000" font-size="8px">*</text>
<text x="205.378876" y="326.020020" textLength="3.204599" font-size="8px">s</text>
<text x="413.395203" y="114.520020" textLength="2.682000" font-size="8px">*</text>
<text x="153.959396" y="211.420013" textLength="2.604000" font-size="8px">c</text>
<text x="101.399994" y="269.619995" textLength="5.175000" font-size="8px">+</text>
<text x="156.555603" y="211.420013" textLength="3.510000" font-size="8px">1</text>
<text x="194.703583" y="186.040039" textLength="3.108000" font-size="8px">d</text>
<text x="164.225403" y="211.420013" textLength="2.250000" font-size="8px">t</text>
<text x="171.567001" y="211.420013" textLength="1.302000" font-size="8px">i</text>
<text x="391.976410" y="83.199951" textLength="3.510000" font-size="8px">3</text>
<text x="176.003403" y="211.420013" textLength="3.186000" font-size="8px">n</text>
<text x="187.438202" y="211.420013" textLength="1.482000" font-size="8px"> </text>
<text x="65.029205" y="385.360016" textLength="2.178000" font-size="8px">r</text>
<text x="199.740005" y="211.420013" textLength="2.178000" font-size="8px">r</text>
<text x="355.800018" y="175.420044" textLength="3.510000" font-size="8px">8</text>
<text x="196.597809" y="211.420013" textLength="3.150000" font-size="8px">o</text>
<text x="210.474030" y="76.599976" textLength="2.604000" font-size="8px">c</text>
<text x="271.868927" y="280.660034" textLength="4.632000" font-size="8px">w</text>
<text x="201.781219" y="211.420013" textLength="3.108000" font-size="8px">d</text>
<text x="258.420013" y="374.440002" textLength="3.510000" font-size="8px">3</text>
<text x="204.840607" y="211.420013" textLength="1.482000" font-size="8px"> </text>
<text x="148.439987" y="186.040039" textLength="3.456000" font-size="8px">T</text>
<text x="292.800018" y="198.820068" textLength="3.510000" font-size="8px">1</text>
<text x="33.283802" y="385.360016" textLength="2.250000" font-size="8px">t</text>
<text x="151.678787" y="186.040039" textLength="4.632000" font-size="8px">m</text>
<text x="156.298782" y="186.040039" textLength="3.108000" font-size="8px">p</text>
<text x="162.904175" y="186.040039" textLength="1.482000" font-size="8px"> </text>
<text x="164.403580" y="186.040039" textLength="2.676000" font-size="8px">s</text>
<text x="168.357590" y="186.040039" textLength="1.302000" font-size="8px">i</text>
<text x="137.639999" y="199.960083" textLength="3.510000" font-size="8px">3</text>
<text x="159.599976" y="270.220093" textLength="3.510000" font-size="8px">4</text>
<text x="172.802383" y="186.040039" textLength="1.302000" font-size="8px">i</text>
<text x="74.519989" y="231.820007" textLength="3.571045" font-size="8px">a</text>
<text x="77.983978" y="231.820007" textLength="3.721934" font-size="8px">b</text>
<text x="434.551819" y="308.140015" textLength="2.982000" font-size="8px">a</text>
<text x="81.598846" y="231.820007" textLength="3.204599" font-size="8px">s</text>
<text x="132.300003" y="219.760010" textLength="4.554000" font-size="8px">_</text>
<text x="132.703979" y="231.820007" textLength="3.721934" font-size="8px">b</text>
<text x="111.779999" y="175.780090" textLength="3.510000" font-size="8px">9</text>
<text x="348.356995" y="114.520020" textLength="3.450000" font-size="8px">+</text>
<text x="136.318848" y="231.820007" textLength="3.204599" font-size="8px">s</text>
<text x="95.819992" y="219.760010" textLength="4.554000" font-size="8px">_</text>
<text x="67.070404" y="385.360016" textLength="3.108000" font-size="8px">d</text>
<text x="99.838852" y="231.820007" textLength="3.204599" font-size="8px">s</text>
<text x="35.503803" y="385.360016" textLength="1.302000" font-size="8px">i</text>
<text x="36.817806" y="385.360016" textLength="3.186000" font-size="8px">n</text>
<text x="42.835201" y="385.360016" textLength="2.250000" font-size="8px">t</text>
<text x="434.036987" y="284.920013" textLength="1.284000" font-size="8px">l</text>
<text x="45.115200" y="385.360016" textLength="1.302000" font-size="8px">i</text>
<text x="436.616974" y="284.920013" textLength="3.108000" font-size="8px">d</text>
<text x="71.629807" y="385.360016" textLength="2.676000" font-size="8px">s</text>
<text x="349.955994" y="138.340027" textLength="3.150000" font-size="8px">o</text>
<text x="49.549801" y="385.360016" textLength="3.186000" font-size="8px">n</text>
<text x="355.313995" y="114.520020" textLength="3.510000" font-size="8px">2</text>
<text x="120.359985" y="114.520020" textLength="3.450000" font-size="8px">+</text>
<text x="198.359985" y="294.400085" textLength="3.510000" font-size="8px">7</text>
<text x="46.429203" y="385.360016" textLength="3.150000" font-size="8px">o</text>
<text x="70.190399" y="385.360016" textLength="1.482000" font-size="8px"> </text>
<text x="77.515793" y="385.360016" textLength="3.108000" font-size="8px">p</text>
<text x="324.720001" y="198.820068" textLength="3.510000" font-size="8px">1</text>
<text x="83.756393" y="385.360016" textLength="2.178000" font-size="8px">r</text>
<text x="72.498047" y="39.880066" textLength="3.144000" font-size="8px">e</text>
<text x="61.882847" y="39.880066" textLength="1.482000" font-size="8px"> </text>
<text x="85.946396" y="385.360016" textLength="3.108000" font-size="8px">b</text>
<text x="90.326996" y="385.360016" textLength="3.150000" font-size="8px">o</text>
<text x="393.119995" y="274.960022" textLength="3.510000" font-size="8px">7</text>
<text x="66.321640" y="39.880066" textLength="2.982000" font-size="8px">a</text>
<text x="357.480011" y="274.960022" textLength="3.510000" font-size="8px">2</text>
<text x="184.994980" y="186.040039" textLength="4.632000" font-size="8px">w</text>
<text x="128.879990" y="199.960083" textLength="3.510000" font-size="8px">9</text>
<text x="384.678558" y="208.179993" textLength="2.982000" font-size="8px">a</text>
<text x="114.059998" y="219.760010" textLength="4.554000" font-size="8px">_</text>
<text x="360.960022" y="274.960022" textLength="3.510000" font-size="8px">3</text>
<text x="405.300018" y="298.360016" textLength="3.510000" font-size="8px">0</text>
<text x="268.859985" y="88.840027" textLength="3.510000" font-size="8px">5</text>
<text x="374.760010" y="298.360016" textLength="3.510000" font-size="8px">1</text>
<text x="82.412445" y="39.880066" textLength="1.482000" font-size="8px"> </text>
<text x="339.300018" y="298.360016" textLength="3.510000" font-size="8px">3</text>
<text x="325.320007" y="175.420044" textLength="3.510000" font-size="8px">2</text>
<text x="297.839996" y="138.340027" textLength="3.456000" font-size="8px">T</text>
<text x="208.974640" y="76.599976" textLength="1.482000" font-size="8px"> </text>
<text x="328.860016" y="175.420044" textLength="3.510000" font-size="8px">3</text>
<text x="289.800018" y="175.420044" textLength="3.510000" font-size="8px">3</text>
<text x="347.040039" y="175.420044" textLength="3.510000" font-size="8px">5</text>
<text x="390.223785" y="184.960022" textLength="3.186000" font-size="8px">n</text>
<text x="228.779999" y="294.400085" textLength="3.510000" font-size="8px">2</text>
<text x="328.200012" y="198.820068" textLength="3.510000" font-size="8px">5</text>
<text x="97.921219" y="125.500000" textLength="3.510000" font-size="8px">1</text>
<text x="310.860016" y="198.820068" textLength="3.510000" font-size="8px">3</text>
<text x="141.119995" y="199.960083" textLength="3.510000" font-size="8px">2</text>
<text x="107.160004" y="199.960083" textLength="3.510000" font-size="8px">4</text>
<text x="352.978821" y="30.100037" textLength="3.510000" font-size="8px">1</text>
<text x="457.058411" y="308.140015" textLength="3.108000" font-size="8px">d</text>
<text x="110.699997" y="199.960083" textLength="3.510000" font-size="8px">7</text>
<text x="439.742371" y="284.920013" textLength="1.302000" font-size="8px">i</text>
<text x="71.639999" y="199.960083" textLength="3.510000" font-size="8px">6</text>
<text x="253.270203" y="304.300018" textLength="2.982000" font-size="8px">a</text>
<text x="89.759995" y="199.960083" textLength="3.510000" font-size="8px">5</text>
<text x="93.239990" y="199.960083" textLength="3.510000" font-size="8px">5</text>
<text x="391.976410" y="67.179993" textLength="3.510000" font-size="8px">1</text>
<text x="415.380005" y="284.920013" textLength="3.456000" font-size="8px">T</text>
<text x="138.779999" y="175.780090" textLength="3.510000" font-size="8px">2</text>
<text x="162.779984" y="294.400085" textLength="3.510000" font-size="8px">3</text>
<text x="108.300003" y="175.780090" textLength="3.510000" font-size="8px">3</text>
<text x="360.119995" y="330.640015" textLength="3.571045" font-size="8px">a</text>
<text x="138.239960" y="30.100037" textLength="3.186000" font-size="8px">n</text>
<text x="126.479996" y="175.780090" textLength="3.510000" font-size="8px">3</text>
<text x="130.019989" y="175.780090" textLength="3.510000" font-size="8px">1</text>
<text x="225.299988" y="294.400085" textLength="3.510000" font-size="8px">3</text>
<text x="212.999969" y="294.400085" textLength="3.510000" font-size="8px">3</text>
<text x="121.619980" y="30.100037" textLength="3.450000" font-size="8px">+</text>
<text x="177.359985" y="294.400085" textLength="3.510000" font-size="8px">5</text>
<text x="429.844208" y="284.920013" textLength="1.482000" font-size="8px"> </text>
<text x="364.559998" y="184.960022" textLength="3.456000" font-size="8px">T</text>
<text x="180.839981" y="294.400085" textLength="3.510000" font-size="8px">5</text>
<text x="229.139984" y="270.220093" textLength="3.510000" font-size="8px">6</text>
<text x="447.339020" y="308.140015" textLength="2.982000" font-size="8px">a</text>
<text x="195.119980" y="270.220093" textLength="3.510000" font-size="8px">3</text>
<text x="349.559418" y="30.100037" textLength="3.450000" font-size="8px">+</text>
<text x="198.599976" y="270.220093" textLength="3.510000" font-size="8px">1</text>
<text x="414.540039" y="30.100037" textLength="2.682000" font-size="8px">*</text>
<text x="353.136597" y="138.340027" textLength="2.604000" font-size="8px">c</text>
<text x="163.139969" y="270.220093" textLength="3.510000" font-size="8px">7</text>
<text x="270.894623" y="114.520020" textLength="3.510000" font-size="8px">3</text>
<text x="213.239960" y="270.220093" textLength="3.510000" font-size="8px">2</text>
<text x="416.104797" y="114.520020" textLength="3.186000" font-size="8px">n</text>
<text x="400.063995" y="330.640015" textLength="3.721934" font-size="8px">b</text>
<text x="216.719971" y="270.220093" textLength="3.510000" font-size="8px">3</text>
<text x="181.139969" y="270.220093" textLength="3.510000" font-size="8px">9</text>
<text x="111.059998" y="30.100037" textLength="3.510000" font-size="8px">1</text>
<text x="125.038773" y="30.100037" textLength="3.510000" font-size="8px">1</text>
</svg>
<figcaption>Figure 5-8.  64-bit Super Block of SAD Operation in VDBPSADBW 
</figcaption></figure>
```

### Operation
#### VDBPSADBW (EVEX encoded versions)
```info-verb
(KL, VL) = (8, 128), (16, 256), (32, 512)
Selection of quadruplets:
FOR I = 0 to VL step 128
    TMP1[I+31:I] <-  select (SRC2[I+127: I], imm8[1:0])
    TMP1[I+63: I+32] <-  select (SRC2[I+127: I], imm8[3:2])
    TMP1[I+95: I+64] <-  select (SRC2[I+127: I], imm8[5:4])
    TMP1[I+127: I+96]<-  select (SRC2[I+127: I], imm8[7:6])
END FOR
SAD of quadruplets:
FOR I =0 to VL step 64
    TMP_DEST[I+15:I] <-  ABS(SRC1[I+7: I] - TMP1[I+7: I]) +
          ABS(SRC1[I+15: I+8]- TMP1[I+15: I+8]) +
          ABS(SRC1[I+23: I+16]- TMP1[I+23: I+16]) +
          ABS(SRC1[I+31: I+24]- TMP1[I+31: I+24]) 
    TMP_DEST[I+31: I+16] <- ABS(SRC1[I+7: I] - TMP1[I+15: I+8]) +
          ABS(SRC1[I+15: I+8]- TMP1[I+23: I+16]) +
          ABS(SRC1[I+23: I+16]- TMP1[I+31: I+24]) +
          ABS(SRC1[I+31: I+24]- TMP1[I+39: I+32])
    TMP_DEST[I+47: I+32] <- ABS(SRC1[I+39: I+32] - TMP1[I+23: I+16]) +
          ABS(SRC1[I+47: I+40]- TMP1[I+31: I+24]) +
          ABS(SRC1[I+55: I+48]- TMP1[I+39: I+32]) +
          ABS(SRC1[I+63: I+56]- TMP1[I+47: I+40]) 
    TMP_DEST[I+63: I+48] <- ABS(SRC1[I+39: I+32] - TMP1[I+31: I+24]) +
          ABS(SRC1[I+47: I+40] - TMP1[I+39: I+32]) +
          ABS(SRC1[I+55: I+48] - TMP1[I+47: I+40]) +
          ABS(SRC1[I+63: I+56] - TMP1[I+55: I+48])
ENDFOR
FOR j <-  0 TO KL-1
    i <-  j * 16
    IF k1[j] OR *no writemask*
          THEN DEST[i+15:i] <-  TMP_DEST[i+15:i]
          ELSE 
                IF *merging-masking* ; merging-masking
                      THEN *DEST[i+15:i] remains unchanged*
                      ELSE  ; zeroing-masking
                            DEST[i+15:i] <-  0
                FI
    FI;
ENDFOR
DEST[MAX_VL-1:VL] <-  0
```

### Intel C/C++ Compiler Intrinsic Equivalent

```cpp
VDBPSADBW __m512i _mm512_dbsad_epu8(__m512i a, __m512i b);
VDBPSADBW __m512i _mm512_mask_dbsad_epu8(__m512i s, __mmask32 m, __m512i a, __m512i b);
VDBPSADBW __m512i _mm512_maskz_dbsad_epu8(__mmask32 m, __m512i a, __m512i b);
VDBPSADBW __m256i _mm256_dbsad_epu8(__m256i a, __m256i b);
VDBPSADBW __m256i _mm256_mask_dbsad_epu8(__m256i s, __mmask16 m, __m256i a, __m256i b);
VDBPSADBW __m256i _mm256_maskz_dbsad_epu8(__mmask16 m, __m256i a, __m256i b);
VDBPSADBW __m128i _mm_dbsad_epu8(__m128i a, __m128i b);
VDBPSADBW __m128i _mm_mask_dbsad_epu8(__m128i s, __mmask8 m, __m128i a, __m128i b);
VDBPSADBW __m128i _mm_maskz_dbsad_epu8(__mmask8 m, __m128i a, __m128i b);
```
### SIMD Floating-Point Exceptions


None

### Other Exceptions


See Exceptions Type E4NF.nb.

