----------------------------
title : ROUNDPS (Intel x86/64 assembly instruction)
cat_title : ROUNDPS
ref_title : ROUNDPS
published : 2020-09-01
path : /X86-64 명령어 레퍼런스/R
publish_date: 2020-09-01
----------------------------


#@ ROUNDPS

** Round Packed Single Precision Floating-Point Values**

```lec-info
아래 표를 해석하는 방법은 [x86-64 명령어 레퍼런스 읽는 법](/316) 글을 참조하시기 바랍니다.
```

|**Opcode\htmlonly{*}/**\newline{}**Instruction**|**Op/ **\newline{}**En**|**64/32 bit **\newline{}**Mode **\newline{}**Support**|**CPUID **\newline{}**Feature **\newline{}**Flag**|**Description**|
|------------------------------------------------|------------------------|------------------------------------------------------|--------------------------------------------------|---------------|
|66 0F 3A 08/r ibROUNDPS xmm1, xmm2/m128, imm8|RMI|V/V|SSE4_1|Round packed single precision floating-point values in xmm2/m128 and place the result in xmm1.  The rounding mode is determined by imm8.|
|VEX.128.66.0F3A.WIG 08 /r ibVROUNDPS xmm1, xmm2/m128, imm8|RMI|V/V|AVX|Round packed single-precision floating-point values in xmm2/m128 and place the result in xmm1. The rounding mode is determined by imm8.|
|VEX.256.66.0F3A.WIG 08 /r ibVROUNDPS ymm1, ymm2/m256, imm8|RMI|V/V|AVX|Round packed single-precision floating-point values in ymm2/m256 and place the result in ymm1. The rounding mode is determined by imm8.|
### Instruction Operand Encoding


|Op/En|Operand 1|Operand 2|Operand 3|Operand 4|
|-----|---------|---------|---------|---------|
|RMI|ModRM:reg (w)|ModRM:r/m (r)|imm8|NA|
### Description


Round the 4 single-precision floating-point values in the source operand (second operand) using the rounding mode specified in the immediate operand (third operand) and place the results in the destination operand (first operand). The rounding process rounds each input floating-point value to an integer value and returns the integer result as a single-precision floating-point value. 

The immediate operand specifies control fields for the rounding operation, three bit fields are defined and shown in Figure 4-24. Bit 3 of the immediate byte controls processor behavior for a precision exception, bit 2 selects the source of rounding mode control. Bits 1:0 specify a non-sticky rounding-mode value (Table 4-18 lists the encoded values for rounding-mode field). 

The Precision Floating-Point Exception is signaled according to the immediate operand. If any source operand is an SNaN then it will be converted to a QNaN. If DAZ is set to '1 then denormals will be converted to zero before rounding.

128-bit Legacy SSE version: The second source can be an XMM register or 128-bit memory location. The destina-tion is not distinct from the first source XMM register and the upper bits (VLMAX-1:128) of the corresponding YMM register destination are unmodified.

VEX.128 encoded version: the source operand second source operand or a 128-bit memory location. The destina-tion operand is an XMM register. The upper bits (VLMAX-1:128) of the corresponding YMM register destination are zeroed.

VEX.256 encoded version: The source operand is a YMM register or a 256-bit memory location. The destination operand is a YMM register. 

Note: In VEX-encoded versions, VEX.vvvv is reserved and must be 1111b otherwise instructions will #UD.


### Operation
#### ROUNDPS(128-bit Legacy SSE version)
```info-verb
DEST[31:0] <-  RoundToInteger(SRC[31:0], ROUND_CONTROL)
DEST[63:32] <-  RoundToInteger(SRC[63:32], ROUND_CONTROL)
DEST[95:64] <-  RoundToInteger(SRC[95:64]], ROUND_CONTROL)
DEST[127:96] <-  RoundToInteger(SRC[127:96]], ROUND_CONTROL)
DEST[VLMAX-1:128] (Unmodified)
```
#### VROUNDPS (VEX.128 encoded version)
```info-verb
DEST[31:0] <-  RoundToInteger(SRC[31:0], ROUND_CONTROL)
DEST[63:32] <-  RoundToInteger(SRC[63:32], ROUND_CONTROL)
DEST[95:64] <-  RoundToInteger(SRC[95:64]], ROUND_CONTROL)
DEST[127:96] <-  RoundToInteger(SRC[127:96]], ROUND_CONTROL)
DEST[VLMAX-1:128] <-  0
```
#### VROUNDPS (VEX.256 encoded version)
```info-verb
DEST[31:0] <-  RoundToInteger(SRC[31:0], ROUND_CONTROL)
DEST[63:32] <-  RoundToInteger(SRC[63:32], ROUND_CONTROL)
DEST[95:64] <-  RoundToInteger(SRC[95:64]], ROUND_CONTROL)
DEST[127:96] <-  RoundToInteger(SRC[127:96]], ROUND_CONTROL)
DEST[159:128] <-  RoundToInteger(SRC[159:128]], ROUND_CONTROL)
DEST[191:160] <-  RoundToInteger(SRC[191:160]], ROUND_CONTROL)
DEST[223:192] <-  RoundToInteger(SRC[223:192] ], ROUND_CONTROL)
DEST[255:224] <-  RoundToInteger(SRC[255:224] ], ROUND_CONTROL)
```

### Intel C/C++ Compiler Intrinsic Equivalent

```cpp
__m128 _mm_round_ps(__m128 s1, int iRoundMode);
__m128 _mm_floor_ps(__m128 s1);
__m128 _mm_ceil_ps(__m128 s1)
__m256 _mm256_round_ps(__m256 s1, int iRoundMode);
__m256 _mm256_floor_ps(__m256 s1);
__m256 _mm256_ceil_ps(__m256 s1)
```
### SIMD Floating-Point Exceptions


Invalid (signaled only if SRC = SNaN) 

Precision (signaled only if imm[3] = '0; if imm[3] = '1, then the Precision Mask in the MXSCSR is ignored and preci-sion exception is not signaled.)

Note that Denormal is not signaled by ROUNDPS.

### Other Exceptions


See Exceptions Type 2; additionally

#UD If VEX.vvvv ->  1111B.

