----------------------------
title : RDRAND (Intel x86/64 assembly instruction)
cat_title : RDRAND
ref_title : RDRAND
published : 2020-09-01
path : /X86-64 명령어 레퍼런스/R
publish_date: 2020-09-01
----------------------------


#@ RDRAND

**Read Random Number**

```lec-info
아래 표를 해석하는 방법은 [x86-64 명령어 레퍼런스 읽는 법](/316) 글을 참조하시기 바랍니다.
```

|**Opcode\htmlonly{*}/**\newline{}**Instruction**|**Op/ **\newline{}**En**|**64/32 bit **\newline{}**Mode **\newline{}**Support**|**CPUID **\newline{}**Feature **\newline{}**Flag**|**Description**|
|------------------------------------------------|------------------------|------------------------------------------------------|--------------------------------------------------|---------------|
|0F C7 /6\newline{}RDRAND r16|M|V/V|RDRAND|Read a 16-bit random number and store in the destination register.|
|0F C7 /6\newline{}RDRAND r32|M|V/V|RDRAND|Read a 32-bit random number and store in the destination register.|
|REX.W + 0F C7 /6\newline{}RDRAND r64|M|V/I|RDRAND|Read a 64-bit random number and store in the destination register.|
### Instruction Operand Encoding


|Op/En|Operand 1|Operand 2|Operand 3|Operand 4|
|-----|---------|---------|---------|---------|
|M|ModRM:r/m (w)|NA|NA|NA|
### Description


Loads a hardware generated random value and store it in the destination register. The size of the random value is determined by the destination register size and operating mode. The Carry Flag indicates whether a random value is available at the time the instruction is executed. CF=1 indicates that the data in the destination is valid. Other-wise CF=0 and the data in the destination operand will be returned as zeros for the specified width. All other flags are forced to 0 in either situation. Software must check the state of CF=1 for determining if a valid random value has been returned, otherwise it is expected to loop and retry execution of `RDRAND` (see Intel(R) 64 and IA-32 Archi-tectures Software Developer's Manual, Volume 1, Section 7.3.17, "Random Number Generator Instructions").

This instruction is available at all privilege levels.

In 64-bit mode, the instruction's default operation size is 32 bits. Using a REX prefix in the form of REX.B permits access to additional registers (R8-R15). Using a REX prefix in the form of REX.W promotes operation to 64 bit oper-ands. See the summary chart at the beginning of this section for encoding data and limits.


### Operation

```info-verb
IF HW_RND_GEN.ready = 1
    THEN 
          CASE of
                osize is 64: DEST[63:0] <- HW_RND_GEN.data;
                osize is 32: DEST[31:0] <- HW_RND_GEN.data;
                osize is 16: DEST[15:0] <- HW_RND_GEN.data;
          ESAC
          CF <- 1;
    ELSE
          CASE of
                osize is 64: DEST[63:0] <- 0;
                osize is 32: DEST[31:0] <- 0;
                osize is 16: DEST[15:0] <- 0;
          ESAC
          CF <- 0;
FI
OF, SF, ZF, AF, PF <- 0;
```
### Flags Affected


The CF flag is set according to the result (see the "Operation" section above). The OF, SF, ZF, AF, and PF flags are set to 0.


### Intel C/C++ Compiler Intrinsic Equivalent

```cpp
RDRAND:  int _rdrand16_step( unsigned short * );
RDRAND:  int _rdrand32_step( unsigned int * );
RDRAND:  int _rdrand64_step( unsigned __int64 *);
```

### Protected Mode Exceptions

#### #UD
* If the LOCK prefix is used.
* If the F2H or F3H prefix is used.
* If CPUID.01H:ECX.RDRAND[bit 30] = 0.

### Real-Address Mode Exceptions



Same exceptions as in protected mode.


### Virtual-8086 Mode Exceptions



Same exceptions as in protected mode.


### Compatibility Mode Exceptions



Same exceptions as in protected mode.


### 64-Bit Mode Exceptions



Same exceptions as in protected mode.

