----------------------------
title : FSTSW, FNSTSWs (Intel x86/64 assembly instruction)
cat_title : FSTSW, FNSTSW
ref_title : FSTSW, FNSTSW
published : 2020-09-01
path : /X86-64 명령어 레퍼런스/F
publish_date: 2020-09-01
----------------------------


#@ FSTSW, FNSTSW

**Store x87 FPU Status Word**

```lec-info
아래 표를 해석하는 방법은 [x86-64 명령어 레퍼런스 읽는 법](/316) 글을 참조하시기 바랍니다.
```

|**Opcode**|**Instruction**|**64-Bit **\newline{}**Mode**|**Compat/**\newline{}**Leg Mode**|**Description**|
|----------|---------------|-----------------------------|---------------------------------|---------------|
|9B DD /7|`FSTSW` m2byte |Valid|Valid|Store FPU status word at m2byte after checking for pending unmasked floating-point exceptions.|
|9B DF E0|`FSTSW` AX |Valid|Valid|Store FPU status word in AX register after checking for pending unmasked floating-point exceptions.|
|DD /7|FNSTSW\footnote{\htmlonly{*}} m2byte |Valid|Valid|Store FPU status word at m2byte without checking for pending unmasked floating-point exceptions.|
|DF E0|FNSTSW\footnote{\htmlonly{*}} AX |Valid|Valid|Store FPU status word in AX register without checking for pending unmasked floating-point exceptions.|

```note
\htmlonly{*} See IA-32 Architecture Compatibility section below
```
### Description


Stores the current value of the x87 FPU status word in the destination location. The destination operand can be either a two-byte memory location or the AX register. The `FSTSW` instruction checks for and handles pending unmasked floating-point exceptions before storing the status word; the `FNSTSW` instruction does not.

The `FNSTSW` AX form of the instruction is used primarily in conditional branching (for instance, after an FPU comparison instruction or an `FPREM`, `FPREM1`, or `FXAM` instruction), where the direction of the branch depends on the state of the FPU condition code flags. (See the section titled "Branching and Conditional Moves on FPU Condi-tion Codes" in Chapter 8 of the Intel(R) 64 and IA-32 Architectures Software Developer's Manual, Volume 1.) This instruction can also be used to invoke exception handlers (by examining the exception flags) in environments that do not use interrupts. When the `FNSTSW` AX instruction is executed, the AX register is updated before the processor executes any further instructions. The status stored in the AX register is thus guaranteed to be from the completion of the prior FPU instruction. 

The assembler issues two instructions for the `FSTSW` instruction (an `FWAIT` instruction followed by an `FNSTSW` instruction), and the processor executes each of these instructions separately. If an exception is generated for either of these instructions, the save EIP points to the instruction that caused the exception.

This instruction's operation is the same in non-64-bit modes and 64-bit mode.

### IA-32 Architecture Compatibility


When operating a Pentium or Intel486 processor in MS-DOS compatibility mode, it is possible (under unusual circumstances) for an FNSTSW instruction to be interrupted prior to being executed to handle a pending FPU exception. See the section titled "No-Wait FPU Instructions Can Get FPU Interrupt in Window" in Appendix D of the Intel(R) 64 and IA-32 Architectures Software Developer's Manual, Volume 1, for a description of these circum-stances. An FNSTSW instruction cannot be interrupted in this way on later Intel processors, except for the Intel Quark\footnote{TM}  X1000 processor.


### Operation

```info-verb
DEST <- FPUStatusWord;
```
### FPU Flags Affected


The C0, C1, C2, and C3 are undefined.

### Floating-Point Exceptions


None


### Protected Mode Exceptions

#### #GP(0)
* If the destination is located in a non-writable segment.
* If a memory operand effective address is outside the CS, DS, ES, FS, or GS segment limit.
* If the DS, ES, FS, or GS register is used to access memory and it contains a NULL segment selector.

#### #SS(0)
* If a memory operand effective address is outside the SS segment limit.

#### #NM
* CR0.EM[bit 2] or CR0.TS[bit 3] = 1.

#### #PF(fault-code)
* If a page fault occurs.

#### #AC(0)
* If alignment checking is enabled and an unaligned memory reference is made while the current privilege level is 3.

#### #UD
* If the LOCK prefix is used.

### Real-Address Mode Exceptions

#### #GP
* If a memory operand effective address is outside the CS, DS, ES, FS, or GS segment limit.

#### #SS
* If a memory operand effective address is outside the SS segment limit.

#### #NM
* CR0.EM[bit 2] or CR0.TS[bit 3] = 1.

### Virtual-8086 Mode Exceptions

#### #GP(0)
* If a memory operand effective address is outside the CS, DS, ES, FS, or GS segment limit.

#### #SS(0)
* If a memory operand effective address is outside the SS segment limit.

#### #NM
* CR0.EM[bit 2] or CR0.TS[bit 3] = 1.

#### #PF(fault-code)
* If a page fault occurs.

#### #AC(0)
* If alignment checking is enabled and an unaligned memory reference is made.

#### #UD
* If the LOCK prefix is used.

### Compatibility Mode Exceptions



Same exceptions as in protected mode.


### 64-Bit Mode Exceptions

#### #SS(0)
* If a memory address referencing the SS segment is in a non-canonical form.

#### #GP(0)
* If the memory address is in a non-canonical form.

#### #NM
* CR0.EM[bit 2] or CR0.TS[bit 3] = 1.

#### #MF
* If there is a pending x87 FPU exception.

#### #PF(fault-code)
* If a page fault occurs.

#### #AC(0)
* If alignment checking is enabled and an unaligned memory reference is made while the current privilege level is 3.

#### #UD
* If the LOCK prefix is used.
