----------------------------
title : EMMS (Intel x86/64 assembly instruction)
cat_title : EMMS
ref_title : EMMS
published : 2020-09-01
path : /X86-64 명령어 레퍼런스/E
publish_date: 2020-09-01
----------------------------


#@ EMMS

**Empty MMX Technology State**

```lec-info
아래 표를 해석하는 방법은 [x86-64 명령어 레퍼런스 읽는 법](/316) 글을 참조하시기 바랍니다.
```

|**Opcode**|**Instruction**|**Op/ **\newline{}**En**|**64-Bit **\newline{}**Mode**|**Compat/**\newline{}**Leg Mode**|**Description**|
|----------|---------------|------------------------|-----------------------------|---------------------------------|---------------|
|0F 77|`EMMS` |NP|Valid|Valid|Set the x87 FPU tag word to empty.|
### Instruction Operand Encoding


|Op/En|Operand 1|Operand 2|Operand 3|Operand 4|
|-----|---------|---------|---------|---------|
|NP|NA|NA|NA|NA|
### Description 


Sets the values of all the tags in the x87 FPU tag word to empty (all 1s). This operation marks the x87 FPU data registers (which are aliased to the MMX technology registers) as available for use by x87 FPU floating-point instruc-tions. (See Figure 8-7 in the Intel(R) 64 and IA-32 Architectures Software Developer's Manual, Volume 1, for the format of the x87 FPU tag word.) All other MMX instructions (other than the EMMS instruction) set all the tags in x87 FPU tag word to valid (all 0s).

The EMMS instruction must be used to clear the MMX technology state at the end of all MMX technology procedures or subroutines and before calling other procedures or subroutines that may execute x87 floating-point instructions. If a floating-point instruction loads one of the registers in the x87 FPU data register stack before the x87 FPU tag word has been reset by the EMMS instruction, an x87 floating-point register stack overflow can occur that will result in an x87 floating-point exception or incorrect result.

EMMS operation is the same in non-64-bit modes and 64-bit mode.


### Operation

```info-verb
x87FPUTagWord <- FFFFH;
```

### Intel C/C++ Compiler Intrinsic Equivalent

```cpp
void _mm_empty()
```
### Flags Affected


None


### Protected Mode Exceptions

#### #UD
* If CR0.EM[bit 2] = 1.

#### #NM
* If CR0.TS[bit 3] = 1.

#### #MF
* If there is a pending FPU exception.

#### #UD
* If the LOCK prefix is used.
### Real-Address Mode Exceptions 


Same exceptions as in protected mode.


### Virtual-8086 Mode Exceptions



Same exceptions as in protected mode.


### Compatibility Mode Exceptions



Same exceptions as in protected mode.


### 64-Bit Mode Exceptions



Same exceptions as in protected mode.

