----------------------------
title : CVTDQ2PS (Intel x86/64 assembly instruction)
cat_title : CVTDQ2PS
ref_title : CVTDQ2PS
published : 2020-09-01
path : /X86-64 명령어 레퍼런스/C
publish_date: 2020-09-01
----------------------------


#@ CVTDQ2PS

**Convert Packed Doubleword Integers to Packed Single-Precision Floating-Point Values**

```lec-info
아래 표를 해석하는 방법은 [x86-64 명령어 레퍼런스 읽는 법](/316) 글을 참조하시기 바랍니다.
```

|**Opcode**\newline{}**Instruction**|**Op / **\newline{}**En**|**64/32 **\newline{}**bit Mode **\newline{}**Support**|**CPUID **\newline{}**Feature **\newline{}**Flag**|**Description**|
|-----------------------------------|-------------------------|------------------------------------------------------|--------------------------------------------------|---------------|
|0F 5B /rCVTDQ2PS xmm1, xmm2/m128|RM|V/V|SSE2|Convert four packed signed doubleword integers from xmm2/mem to four packed single-precision floating-point values in xmm1.|
|VEX.128.0F.WIG 5B /rVCVTDQ2PS xmm1, xmm2/m128|RM|V/V|AVX|Convert four packed signed doubleword integers from xmm2/mem to four packed single-precision floating-point values in xmm1.|
|VEX.256.0F.WIG 5B /rVCVTDQ2PS ymm1, ymm2/m256|RM|V/V|AVX|Convert eight packed signed doubleword integers from ymm2/mem to eight packed single-precision floating-point values in ymm1.|
|EVEX.128.0F.W0 5B /rVCVTDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst|FV|V/V|AVX512VL\newline{}AVX512F|Convert four packed signed doubleword integers from xmm2/m128/m32bcst to four packed single-precision floating-point values in xmm1with writemask k1.|
|EVEX.256.0F.W0 5B /rVCVTDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst|FV|V/V|AVX512VL\newline{}AVX512F|Convert eight packed signed doubleword integers from ymm2/m256/m32bcst to eight packed single-precision floating-point values in ymm1with writemask k1.|
|EVEX.512.0F.W0 5B /rVCVTDQ2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}|FV|V/V|AVX512F|Convert sixteen packed signed doubleword integers from zmm2/m512/m32bcst to sixteen packed single-precision floating-point values in zmm1with writemask k1.|
### Instruction Operand Encoding


|Op/En|Operand 1|Operand 2|Operand 3|Operand 4|
|-----|---------|---------|---------|---------|
|RM|ModRM:reg (w)|ModRM:r/m (r)|NA|NA|
|FV|ModRM:reg (w)|ModRM:r/m (r)|NA|NA|
### Description


Converts four, eight or sixteen packed signed doubleword integers in the source operand to four, eight or sixteen packed single-precision floating-point values in the destination operand.

EVEX encoded versions: The source operand can be a ZMM/YMM/XMM register, a 512/256/128-bit memory loca-tion or a 512/256/128-bit vector broadcasted from a 32-bit memory location. The destination operand is a ZMM/YMM/XMM register conditionally updated with writemask k1.

VEX.256 encoded version: The source operand is a YMM register or 256- bit memory location. The destination operand is a YMM register. Bits (MAX\esc{_}VL-1:256) of the corresponding register destination are zeroed.

VEX.128 encoded version: The source operand is an XMM register or 128- bit memory location. The destination operand is a XMM register. The upper bits (MAX\esc{_}VL-1:128) of the corresponding register destination are zeroed.

128-bit Legacy SSE version: The source operand is an XMM register or 128- bit memory location. The destination operand is an XMM register. The upper Bits (MAX\esc{_}VL-1:128) of the corresponding register destination are unmod-ified.

VEX.vvvv and EVEX.vvvv are reserved and must be 1111b, otherwise instructions will #UD.


### Operation
#### VCVTDQ2PS (EVEX encoded versions) when SRC operand is a register
```info-verb
(KL, VL) = (4, 128), (8, 256), (16, 512)
IF (VL = 512) AND (EVEX.b = 1) 
    THEN
          SET_RM(EVEX.RC);  ; refer to Table 2-4 in the Intel(R) Architecture Instruction Set Extensions Programming Reference
    ELSE 
          SET_RM(MXCSR.RM);  ; refer to Table 2-4 in the Intel(R) Architecture Instruction Set Extensions Programming Reference
FI;
FOR j <-  0 TO KL-1
    i <-  j * 32
    IF k1[j] OR *no writemask*
          THEN DEST[i+31:i] <-
                Convert_Integer_To_Single_Precision_Floating_Point(SRC[i+31:i])
          ELSE 
                IF *merging-masking* ; merging-masking
                      THEN *DEST[i+31:i] remains unchanged*
                      ELSE  ; zeroing-masking
                            DEST[i+31:i] <-  0
                FI
    FI;
ENDFOR
DEST[MAX_VL-1:VL] <-  0
```
#### VCVTDQ2PS (EVEX encoded versions) when SRC operand is a memory source
```info-verb
(KL, VL) = (4, 128), (8, 256), (16, 512)
FOR j <-  0 TO KL-1
    i <- j * 32
    IF k1[j] OR *no writemask*
          THEN 
                IF (EVEX.b = 1) 
                      THEN
                            DEST[i+31:i] <-
                Convert_Integer_To_Single_Precision_Floating_Point(SRC[31:0])
                      ELSE 
                            DEST[i+31:i] <-
                Convert_Integer_To_Single_Precision_Floating_Point(SRC[i+31:i])
                FI;
          ELSE 
                IF *merging-masking* ; merging-masking
                      THEN *DEST[i+31:i] remains unchanged*
                      ELSE  ; zeroing-masking
                            DEST[i+31:i] <-  0
                FI
    FI;
ENDFOR
DEST[MAX_VL-1:VL] <-  0
```
#### VCVTDQ2PS (VEX.256 encoded version)
```info-verb
DEST[31:0] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[31:0])
DEST[63:32] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[63:32])
DEST[95:64] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[95:64])
DEST[127:96] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[127:96)
DEST[159:128] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[159:128])
DEST[191:160] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[191:160])
DEST[223:192] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[223:192])
DEST[255:224] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[255:224)
DEST[MAX_VL-1:256] <-  0
```
#### VCVTDQ2PS (VEX.128 encoded version)
```info-verb
DEST[31:0] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[31:0])
DEST[63:32] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[63:32])
DEST[95:64] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[95:64])
DEST[127:96] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[127z:96)
DEST[MAX_VL-1:128] <-  0
```
#### CVTDQ2PS (128-bit Legacy SSE version)
```info-verb
DEST[31:0] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[31:0])
DEST[63:32] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[63:32])
DEST[95:64] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[95:64])
DEST[127:96] <-  Convert_Integer_To_Single_Precision_Floating_Point(SRC[127z:96)
DEST[MAX_VL-1:128] (unmodified)
```

### Intel C/C++ Compiler Intrinsic Equivalent

```cpp
VCVTDQ2PS __m512 _mm512_cvtepi32_ps( __m512i a);
VCVTDQ2PS __m512 _mm512_mask_cvtepi32_ps( __m512 s, __mmask16 k, __m512i a);
VCVTDQ2PS __m512 _mm512_maskz_cvtepi32_ps( __mmask16 k, __m512i a);
VCVTDQ2PS __m512 _mm512_cvt_roundepi32_ps( __m512i a, int r);
VCVTDQ2PS __m512 _mm512_mask_cvt_roundepi_ps( __m512 s, __mmask16 k, __m512i a, int r);
VCVTDQ2PS __m512 _mm512_maskz_cvt_roundepi32_ps( __mmask16 k, __m512i a, int r);
VCVTDQ2PS __m256 _mm256_mask_cvtepi32_ps( __m256 s, __mmask8 k, __m256i a);
VCVTDQ2PS __m256 _mm256_maskz_cvtepi32_ps( __mmask8 k, __m256i a);
VCVTDQ2PS __m128 _mm_mask_cvtepi32_ps( __m128 s, __mmask8 k, __m128i a);
VCVTDQ2PS __m128 _mm_maskz_cvtepi32_ps( __mmask8 k, __m128i a);
CVTDQ2PS __m256 _mm256_cvtepi32_ps (__m256i src)
CVTDQ2PS __m128 _mm_cvtepi32_ps (__m128i src)
```
### SIMD Floating-Point Exceptions


Precision

### Other Exceptions


VEX-encoded instructions, see Exceptions Type 2; 

EVEX-encoded instructions, see Exceptions Type E2.

#UD If VEX.vvvv != 1111B or EVEX.vvvv != 1111B.

