----------------------------
title : ADCX (Intel x86/64 assembly instruction)
cat_title : ADCX
ref_title : ADCX
published : 2020-09-01
path : /X86-64 명령어 레퍼런스/A
publish_date: 2020-09-01
----------------------------


#@ ADCX

** Unsigned Integer Addition of Two Operands with Carry Flag**

```lec-info
아래 표를 해석하는 방법은 [x86-64 명령어 레퍼런스 읽는 법](/316) 글을 참조하시기 바랍니다.
```

|**Opcode/**\newline{}**Instruction**|**Op/ **\newline{}**En**|**64/32bit **\newline{}**Mode **\newline{}**Support**|**CPUID **\newline{}**Feature **\newline{}**Flag**|**Description**|
|------------------------------------|------------------------|-----------------------------------------------------|--------------------------------------------------|---------------|
|`66 0F 38 F6 /r`\newline{}`ADCX` \tooltip{r32}{4 바이트 짜리 범용 레지스터를 의미 (EAX, ECX, EDX, EBX, ESP, EBP, ESI, EDI). 64 비트 모드의 경우 추가적으로 R8D 부터 R15D 까지 가능.} \tooltip{r/m32}{4 바이트 짜리 피연산자로, 4 바이트 범용 레지스터나 (r32 의 레지스터들), 4 바이트 메모리 데이터를 의미한다.} |RM|V/V|ADX|Unsigned addition of r32 with CF, r/m32 to r32, writes CF.|
|`66 REX.w 0F 38 F6 /r`\newline{}`ADCX` \tooltip{r64}{8 바이트 짜리 범용 레지스터를 의미 (RAX, RBX, RCX, RDX, RDI, RSI, RBP, RSP, R8–R15). 이들은 64비트 모드에서만 사용 가능하다.} \tooltip{r/m64}{8 바이트 짜리 피연산자로, 8 바이트 범용 레지스터나 (r64 의 레지스터들), 8 바이트 메모리 데이터를 의미한다.} |RM|V/NE|ADX|Unsigned addition of r64 with CF, r/m64 to r64, writes CF.|
### Instruction Operand Encoding


|Op/En|Operand 1|Operand 2|Operand 3|Operand 4|
|-----|---------|---------|---------|---------|
|RM|ModRM:reg (r, w)|ModRM:r/m (r)|NA|NA|
### Description


Performs an unsigned addition of the destination operand (first operand), the source operand (second operand) and the carry-flag (CF) and stores the result in the destination operand. The destination operand is a general-purpose register, whereas the source operand can be a general-purpose register or memory location. The state of CF can represent a carry from a previous addition. The instruction sets the CF flag with the carry generated by the unsigned addition of the operands. 

The `ADCX` instruction is executed in the context of multi-precision addition, where we add a series of operands with a carry-chain. At the beginning of a chain of additions, we need to make sure the CF is in a desired initial state. Often, this initial state needs to be 0, which can be achieved with an instruction to zero the CF (e.g. XOR).

This instruction is supported in real mode and virtual-8086 mode. The operand size is always 32 bits if not in 64-bit mode. 

In 64-bit mode, the default operation size is 32 bits. Using a REX Prefix in the form of REX.R permits access to addi-tional registers (R8-15). Using REX Prefix in the form of REX.W promotes operation to 64 bits.

ADCX executes normally either inside or outside a transaction region.

Note: `ADCX` defines the OF flag differently than the ADD/ADC instructions as defined in Intel\footnote{(R)}  64 and IA-32 Archi-tectures Software Developer's Manual, Volume 2A.


### Operation

```info-verb
IF OperandSize is 64-bit
    THEN CF:DEST[63:0] <- DEST[63:0] + SRC[63:0] + CF;
    ELSE CF:DEST[31:0] <- DEST[31:0] + SRC[31:0] + CF;
FI;
```
### Flags Affected


CF is updated based on result. OF, SF, ZF, AF and PF flags are unmodified.


### Intel C/C++ Compiler Intrinsic Equivalent

```cpp
unsigned char _addcarryx_u32 (unsigned char c_in, unsigned int src1, unsigned int src2, unsigned int *sum_out);
unsigned char _addcarryx_u64 (unsigned char c_in, unsigned __int64 src1, unsigned __int64 src2, unsigned __int64 *sum_out);
```
### SIMD Floating-Point Exceptions


None


### Protected Mode Exceptions

#### #UD
* If the LOCK prefix is used.
* If CPUID.(EAX=07H, ECX=0H):EBX.ADX[bit 19] = 0.

#### #SS(0)
* For an illegal address in the SS segment.

#### #GP(0)
* For an illegal memory operand effective address in the CS, DS, ES, FS or GS segments. 
* If the DS, ES, FS, or GS register is used to access memory and it contains a null segment selector.

#### #PF(fault-code)
* For a page fault.

#### #AC(0)
* If alignment checking is enabled and an unaligned memory reference is made while the current privilege level is 3.

### Real-Address Mode Exceptions

#### #UD
* If the LOCK prefix is used.
* If CPUID.(EAX=07H, ECX=0H):EBX.ADX[bit 19] = 0.

#### #SS(0)
* For an illegal address in the SS segment.

#### #GP(0)
* If any part of the operand lies outside the effective address space from 0 to FFFFH.

### Virtual-8086 Mode Exceptions

#### #UD
* If the LOCK prefix is used.
* If CPUID.(EAX=07H, ECX=0H):EBX.ADX[bit 19] = 0.

#### #SS(0)
* For an illegal address in the SS segment.

#### #GP(0)
* If any part of the operand lies outside the effective address space from 0 to FFFFH.

#### #PF(fault-code)
* For a page fault.

#### #AC(0)
* If alignment checking is enabled and an unaligned memory reference is made while the current privilege level is 3.

### Compatibility Mode Exceptions



Same exceptions as in protected mode.


### 64-Bit Mode Exceptions

#### #UD
* If the LOCK prefix is used.
* If CPUID.(EAX=07H, ECX=0H):EBX.ADX[bit 19] = 0.

#### #SS(0)
* If a memory address referencing the SS segment is in a non-canonical form.

#### #GP(0)
* If the memory address is in a non-canonical form.

#### #PF(fault-code)
* For a page fault.

#### #AC(0)
* If alignment checking is enabled and an unaligned memory reference is made while the current privilege level is 3.
