----------------
title : 씹어먹는 C 언어 - <2 - 1. C 언어 본격 맛보기>
cat_title : 2 - 1. C 언어 본격 맛보기
next_page : 19
publish_date : 2009-04-17
path : /C
tex_title : C 언어 본격 맛보기
--------------


이번 강좌에서는 아래와 같은 내용을 배우게 됩니다.

* `Hello, World!` 빠삭하게 분석
* 주석(Comment)의 사용


![씹어먹는 C 언어](/img/ChewingClogo.png)

안녕하세요 여러분. [저번 강의](http://itguru.tistory.com/entry/%EC%94%B9%EC%96%B4%EB%A8%B9%EB%8A%94-C-%EC%96%B8%EC%96%B4-1-C-%EC%96%B8%EC%96%B4%EA%B0%80-%EB%AD%90%EC%95%BC)에서의 희열을 아직도 느끼시나요? 방금 자신의 손으로 최초의 프로그램 - `Hello, World!` 를 만들었다는 사실을 말이죠. 하지만 자신이 프로그램을 만들었다는 사실을 친구들에게 자랑하기 전에, 그 프로그램이 어떻게 동작하는지 살펴보도록 합시다.

### 도대체 뭔일이 있던거지? 

![도대체 뭔일이 있던거지?](/img/whatjusthappened.png)

### Hello, World 프로그램 분석하기

```embed
<div class="video-container">
<iframe width="560" height="315" src="https://www.youtube.com/embed/Xz_XT8v3QCY" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
</div>
```

지난번 강좌에서 **도대체 내가 뭘 쓰고 있는 걸까** 라고 생각하면서 코드를 짜셨을 것입니다. 

그래도 한 가지 눈치 챘을 법한 부분은 바로 큰 따옴표로 닫혀 있는 부분의 "Hello, World!" 가 프로그램에 출력된다는 점입니다. 한 번 다른 문장으로 바꿔서 과연 그 문장이 출력되는지 확인해보는 것도 좋습니다. 

그렇다면 우리가 작성한 코드가 어떠한 의미를 가지는지 살펴보도록 하겠습니다. 

```cpp-formatted
#include <stdio.h>
int main() {
  printf("Hello, World! \n");
  return 0;
}
```

일단 위 프로그램의 첫 줄 부터 봅시다.

```cpp-formatted
#include <stdio.h>
```

`#include` 는 괄호 안에 있는 파일을 우리 프로그램으로 불러온다는 의미 입니다. 말 그대로, 해당 파일의 내용이 컴파일 할 때 우리 파일에 그대로 복사됩니다. 우리의 경우 `stdio.h` 라는 파일을 포함시켰습니다.

우리는 왜, `stdio.h` 라는 파일을 이 프로그램에 포함시켰을 까요? 그 이유는 아래에서 설명하도록 하겠습니다.

그 다음 부분을 살펴 봅시다.

```cpp-formatted
int main()
```

위 문장은 `main` 이라는 **함수**를 정의한 것인데, `main` 은 모든 C 프로그램이 처음으로 시작하는 부분입니다. 이전에 프로그램을 실행한다는 말의 의미가 CPU 의 명령어 레지스터에 프로그램의 시작 명령어 주소값을 전달한다고 하였는데, 실제로 main 에서 첫 번째로 실행할 명령어의 주소값이 전달된다고 생각하시면 됩니다. 

그 다음에 `main` 왼쪽에 `int` 는 영어의 `integer` 의 줄임으로 이 함수가 끝날 때 **정수값** 을 반환한다는 뜻입니다. 사실 함수가 뭔지, 또 반환한다는 것이 무슨 말인지 지금은 잘 모르겠지만 괜찮습니다. 강좌 몇 개만 지나면 다루게됩니다. 


```cpp-formatted
{
```

그 다음 문장은 참으로 간단하네요. 중괄호 입니다. 여기서 중괄호는 `main` 함수의 시작을 알리게 됩니다. 즉, 중괄호로 묶인 부분은 '여기는 `main` 함수 꺼야' 라는 것을 나타냅니다.

C 언어에서는 `main` 함수 뿐만이 아니라 어떠한 문장도 여는 중괄호가 있다면 반드시 이에 대응되는 닫는 중괄호(`}`)가 와야 합니다. 여기서도 마찬가지로, 마지막 문장에서 닫는 중괄호가 와있네요.

```cpp-formatted
printf("Hello, World! \n");
```

이제, 위 프로그램에서 가장 핵심이라 볼 수 있는 부분인 `printf` 를 살펴 봅시다. `printf` 는 화면에 괄호안의 내용을 출력할 수 있게 해주는 함수 입니다. 위의 경우, 괄호 안에 있는 `Hello, World!` 가 화면에 출력되었습니다.

그런데, 도대체 위 함수가 어떻게 해서 화면에 글자를 출력하는 것일까요? 사실, 화면에 글자를 출력하는 것은 쉬운 일 일 것 같지만, 매우 복잡한 과정을 거치는 것입니다. 왜냐하면, 일단 운영체제에 자신이 화면에 글자를 뿌려야 한다는 메시지를 보내야 하고, 또 운영체제는 하드웨어 (모니터) 에 이를 뿌린다는(출력한다는) 것을 이야기 해 주어야 하기 때문이죠.

하지만 이 짧은 문장을 화면에 표현하기 위해 위 모든 내용을 작성해야 한다는 것은 상당히 피곤한 일입니다. 따라서 우리는 화면에 데이터를 출력하는데 필요한 모든 도구들을 가지고 있는 파일을 사용하게 되는데, 그것이 바로 앞서 이야기한 `stdio.h` 입니다. **(studio 가 아닙니다!)**

`stdio` 는 *STanDard Input Output* 의 약자로, **표준 입출력** 이란 뜻입니다. 이 파일에는 입력과 출력, 즉 화면에 출력하고 (혹은 파일에 데이터를 쓰고), 여러분으로 부터 입력을 받아들이는 것 (혹은 파일을 읽는것) 을 수행할 수 있는 기능들을 제공합니다. C 에서는 `.h` 로 끝나는 파일을 **헤더 파일** 이라 부르는데, 헤더 파일의 역할에 대해선 나중에 배우게 됩니다. 우리가 `printf` 를 쓸 수 있는 것도 이 `stdio.h` 를 include 하고 있기 때문이죠.

그런데, 한 가지 이상한 점이 있습니다. 큰 따옴표 안의 내용이 모두 출력되는데, 왜 마지막의 `\n` 은 출력되지 않은 것일까요? 그렇다면 한 번 여러분들 께서 `\n` 을 지워 보고 다시 프로그램을 실행해 보세요. 아마 다음과 같이 나올 것 입니다.

![](http://img1.daumcdn.net/thumb/R1920x0/?fname=http%3A%2F%2Fcfile1.uf.tistory.com%2Fimage%2F207B991A49E9735F64CC19)

지난번 하고 차이점이 보이세요? 분명히 지난 번에는 *Press anykey to continue* 가 한 줄 개행되어 나타났는데 이번에는 연이어 나타났습니다. (윈도우 한글판 사용자의 경우 '아무키나 누르세요' 가 나타날 것입니다)

아하, 알겠습니다. 바로 `\n` 은 키보드 상의 엔터, 즉 개행 문자 였던 것입니다. (참고로 `\` 를 `Escape character` 라고 합니다)

참고적으로 알아야 할 사실은 우리나라 키보드의 경우 `\` 로 나타나지만 외국 대부분의 키보드에는 `\` 대신에 역슬래시(＼) 를 사용합니다. 따라서, 보통 C 언어 서적을 보면 `＼n` 이라 나타난 것이 있는데 이는 `\n` 과 똑같은 것입니다.

마지막으로 중요한 점은, 모든 문장이 끝나는 부분에 세미콜론(;)을 찍어 주어야 된다는 것입니다. 

물론, 함수의 선언 부분 (즉, `int main()` ) 뒤에나 헤더파일 선언 부분 (`#include <stdio.h>`) 뒤에는 `;` 을 붙이면 안되지만, 위와 같이 `printf(.....)` 나, 아래 줄의 `return 0` 와 같은 문장들에게는 꼭 끝에 세미콜론을 붙여아합니다. 만약 붙이지 않는다면 이전 강의에서 보았던 오류들이 나타나게 됩니다.

```cpp-formatted
return 0;
```

영어로 읽어 보면 대충 뜻을 짐작하셨겠지만, 0 을 **반환(return)**한다는 뜻 입니다. 우리 함수가 `int main` 이므로 정수형을 반환한다고 정의하였는데, 실제로 정수값인 0 을 반환합니다. 0 을 왜 반환할까요? 그리고 그것을 반환한다면 '누구' 한테 반환하는 것인가요? 쉽게 말해 이 프로그램을 실행한 프로그램한테 반환하게 됩니다. 그런데 왜 하필이면 0 일까요? 1 이면 안되고 왜 2 이면 안되죠.

그렇다면 한 번 1 이나 다른 원하는 숫자를 반환하도록 해보세요. 결과는 똑같습니다. 그런데 왜 굳이 0 을 반환하는 것일까요?

사실은 0 을 반환한다는 것은 컴퓨터에게 *프로그램이 무사히 종료되었음* 을 알리는 것이죠. 반면에 1 을 반환한다면 컴퓨터에게 *프로그램이 무사히 종료되지 않았어요 - 오류가 발생했어요.* 를 알리는 것입니다.\sidenote{근데 사실 그렇게 크게 신경쓰지 않아도 됩니다. 적어도 윈도우에서는 해당 리턴값은 그냥 무시됩니다.}

```cpp-formatted
}
```

마지막으로 이렇게 꼭 중괄호로 닫아주어야지, 그렇지 않을 경우 파일의 끝이 없다는 오류가 발생하게 됩니다. 와우! 이쯤 되면 위 프로그램을 빠삭하게 분석해 보았다고 할 수 있습니다.

### 주석(Comment) 넣기

마지막으로 모든 프로그래밍 언어에 기본으로 있는 기능이자, 그 만큼 중요한 기능인 주석 넣기에 대해 알아봅시다.

주석이라 하면, 코멘트, 즉 **자신의 코드에 대해 설명을 해주는 것**입니다. 아마 위의 대여섯 줄 짜리 코드에 뭐가 설명할 필요가 있겠어? 라고 생각할 수 있지만 실제로 '쓸만한' 프로그램을 만들게 되면 코드의 길이가 수천줄을 넘어가는 것은 예삿일입니다. 물론 그런 파일들이 여러개 모여서 프로그램을 만들게 되는 것이지요.

그렇게 된다면 코멘트 없이는 이 코드가 도대체 무슨 역할을 하는지도 잘 모르고, 남이 쓴 코드가 어떤일을 하고, 어떻게 돌아가는지 이해가 잘 안되는 경우가 많습니다. 더욱 심각한 사실은 자신이 쓴 코드도 못알아 보는 경우가 있다는 것입니다. 이처럼, 이런 기분나쁜 일을 미연에 방지하기 위해 이 코드가 무슨 역할을 하고 어떻게 동작되는지 간단하게 나마 설명해 주는 것이 필요하겠죠. 그런 것을 바로 주석 이라 합니다.

우리가 코드를 이해하기 위해 필요한 것이지, 컴퓨터에는 아무런 도움이 되지 않는 것이므로 컴파일러는 이 주석을 완전히 무시해 버립니다. 마치 우리만이 볼 수 있는 것 처럼 말이죠. 그렇기 때문에 주석에 무슨 짓을 해도 상관이 없습니다.

기본적으로 C 언어 에서는 두 가지 형태의 주석을 지원합니다.

![](http://img1.daumcdn.net/thumb/R1920x0/?fname=http%3A%2F%2Fcfile25.uf.tistory.com%2Fimage%2F1728BF0C49EE1719061C9D)

마치 컴파일러가 철저히 무시한다는 것을 반영하기라도 한 것인지, 주석은 초록색으로 표시됩니다. 보통 한 줄에 쓸 수 있는 주석은 `//` 로 나타내고, 주석이 조금 길어저 여러 줄에 걸쳐 표시하려면 `/*` 와 `*/` 를 이용합니다. 한 번, 위 `Hello, World!` 프로그램에 자기 나름대로 주석을 넣어 설명을 해보세요.

```lec-summary
`#include <stdio.h>` 란 `stdio.h` 라는 파일을 포함하라는 뜻입니다. 이 파일에는 여러분이 화면에 메세지를 띄울 수 있게 도와주는 여러가지 함수들이 포함되어 있습니다.

`main` 함수는 프로그램이 시작되는 **함수** 입니다.

`{}` 는 함수의 몸체를 알려주는데 사용됩니다.

`printf` 는 화면에 내용을 출력해주는 **함수** 입니다.

`return 0;` 는 0 을 반환한다는 의미 입니다.

`//` 와 `/* */` 는 주석으로 컴파일러가 무시하지만, 프로그래머를 위해 남겨놓는 코멘트 입니다.
```

##@ chewing-c-end