----------------
title : 씹어먹는 C 언어 시작하기
path : /C
cat_title : 씹어먹는 C 언어 시작하기
publish_date : 2009-04-15
next_page : 315
--------------

![씹어먹는 C 언어](/img/ChewingClogo.png)

안녕하세요 여러분. 씹어먹는 C 언어를 연재하고 있는 Psi 입니다.

제 강좌는 제가 참고했던 무수히 많은 책, 인터넷을 돌아다니며 얻은 지식, 그리고 제 경험에서 우러나온 모든 것을 잘 버무려서 만든 것이기 때문에, C 언어를 사용할 줄 아시는 분들이라도, 한 번쯤은 훑어 보시는 것을 추천합니다.

###  C 언어를 공부하면서 반드시 지켜야 할 수칙

* 강좌를 한 번 다 읽었다면 내가 뭘 배웠는지 머리속으로 그려본다. 
* 만약 위 과정이 잘 되지 않는다면 다시 한 번 강좌를 읽는다. 만약 강좌가 이해가 안되면 혼자서 낑낑 거리지 말고 (물론 이러한 자세도 중요하지만) 거침없이 댓글을 올리면 48 시간 대기 중인 Psi 가 댓글을 달아준다. 다만 잘 모르겠는 부분은 정확히 지적해 주면 좋다. 
* 물론 강좌가 이상하다면 거침없이 댓글을 날려야 한다. 필자도 오타(!)를 내거나 오개념(설마....) 을 올릴 수 도 있다.
* 강좌에 나오는 소스 코드들은 **모두 손 으로 직접 쓴다**. `Ctrl + C` 는 절대 금물. 다만, 소스 코드를 아무리 그대로 배꼈는데도 불구하고 이상한 오류가 나는 경우는 그냥 복사해도 좋다. 하지만 그 오류가 무엇인지 알아내는 것이 더욱 중요하다.
* 강좌를 따라 프로그램을 만들면 자기 멋대로 수정하는 버릇(?) 을 가져야 한다.
* 자기가 만든 '아무리 이상한' 프로그램이라도 자부심을 갖고 인터넷에 올려보자.

현재까지 나온 강좌들의 목록 입니다. 

```lec-info
현재 씹어먹는 C 언어를 **동영상 강의**로 제작하고 있습니다. 아직 전체 강의가 동영상으로 만들어지지는 않았지만 일부 강의를 보고 싶으신 분들은 [여기](https://www.youtube.com/watch?v=8kqY1b2nDT8&list=PLEv0cFUBxDmCbYqlvyrabD3Aie-SDyO2N) 에서 확인해보세요! [모두의 코드 공식 채널](https://www.youtube.com/channel/UC2dSXsAKxmISBOziukHtVqA) 에서 보셔도 됩니다.
```

### C 언어 강좌 총 목록

###@ [0. 내가 C 언어를 공부하기 전에 알았으면 좋았을 것들](/315)

C 언어를 본격 접하기 앞서 알아야 할 배경 지식들에 대해서 간단하게 다룹니다. 굳이 안 읽고 바로 다음 강좌로 넘어가게 되지만, 이 글을 읽은다면 C 언어를 공부하면서 나오게될 궁금증을 조금이나하 해소하는데 도움이 될 것입니다.

###@ [1. C 언어가 뭐야?](/5)

C 언어를 배우기 위한 기본적인 프로그램을 설치한다.

###@ [2 - 1. C 언어 본격 맛보기](/6)

`Hello, World!` 를 만들고 이에 대한 설명

###@ [2 - 2. 주석(Comment)에 대한 이해](/19)

주석이 무엇인지 이해한다.

###@ [2 - 3. 컴퓨터가 수를 표현하는 방법 (이진법)](/21)

십진법, 이진법, 16 진법에 친숙해 지고 컴퓨터 메모리의 단위(비트, 바이트, 워드, 더블워드)를 안다.

###@ [3. 변수가 뭐지?](/7)

변수(정수형, 실수형) 가 무엇인지 배우고, 기수법에 대해 알아본다

###@ [4 - 1. 계산하리](/8)

C 언어의 연산자(사칙연산, 쉬프트, 비트 연산자) 들에 대해 알아본다. 

###@ [4 - 2. 컴퓨터가 음수를 표현하는 방법 (2의 보수)](/308)

컴퓨터가 2 의 보수법을 이용해서 어떻게 음수를 표현하는지, 그리고 정수 오버플로우란 무엇인지 배워본다.

###@ [5. 문자 입력 받기](/9)

문자 데이터에 저장, `scanf` 의 이용

###@ [6. 만약에...(if 문)](/10)

`if` 문에 대해 알아본다. (물론 `else` 도..)

###@ [7. 뱅글 뱅글 (for, while) ](/12)

반복문(loop) 에 대해 알아본다.

###@ [8. 우분투 리눅스에서 C 프로그래밍 하기](/14)

우분투 리눅스에서 `GCC` 의 설치, `GCC` 를 이용한 프로그래밍, 초보적 `vi` 사용법을 배운다

###@ [9. 만약에.. 2탄 (switch 문)](/16)

`switch` 문 사용하기, `switch` 문은 `if` 문과 내부적으로 무엇이 다를까?

###@ [10. 연예인 캐스팅(?) (C 언어에서의 형 변환)](/17)

형변환(캐스팅) 하기, 부동 소수점 방식의 원리와 이해, 비트와 바이트에 대해 알아본다. 

###@ [11 - 1. C 언어의 아파트 (배열), 상수](/18)

C 언어의 배열(Array) 의 대한 기본적 내용과, 상수에 대해 알아본다. 

###@ [11 - 2. C 언어의 아파트2 (고차원의 배열)](/20)

2 차원 배열에 대한 이해와 메모리 상의 형태, 그리고 3차 이상의 배열에 대해 알아본다. 

###@ [12 - 1. 포인터는 영희이다! (포인터)](/23)

포인터에 대해 기초를 완벽히 다져준다! `*` 와 `&` 연산자의 이해

###@ [12 - 2. 포인터는 영희이다 2! (포인터)](/24)

상수 포인터, 포인터의 덧셈과 뺄셈, 배열과 포인터와의 관계, `[]` 연산자를 알아본다!

###@ [12 - 3. 포인터는 영희이다 3! (포인터)](/25)

배열 포인터 (1 차원, 2 차원 등등), 포인터 배열, 더블 포인터에 대해 알아본다!

###@ [13 - 1. 마술 상자 함수(function)](/26)

함수의 필요성, 함수의 정의, 함수의 리턴값, 함수의 인자, `main` 함수에 대해 알아본다!

###@ [13 - 2. 마술 상자 함수 2 (function)](/27)

포인터 형태의 인자, 배열을 인자로 받기, 함수의 원형에 대해 알아본다!

###@ [13 - 3. 마술 상자 함수 3 (function)](/28)

더블포인터 인자, 2차원 배열 인자, 상수 인자, 함수 포인터에 대해 알아본다. 

###@ [13 - 4. 마술 상자 함수 (생각해볼 문제에 대한 아이디어)](/30)

13 - 3 강의의 마지막 생각해볼 문제들은 정말로 중요한 것입니다. 이 강의에서는 이들에 대해 다루고 있습니다. 

###@ [14. 컴퓨터의 머리로 따라가보자 - 디버깅(debugging)](/31)

C 프로그래밍에 관련은 없지만 컴퓨터 프로그래밍을 한다면 매우매우 중요한 것이 바로 디버깅이 아닐까 싶습니다.

###@ [15 - 1. 일로 와봐, 문자열(string)](/29)

C 프로그래밍에서 중요한 부분인 문자열에 관해 알아본다.

###@ [15 - 2. 일로와봐, 문자열(string) - 버퍼에 관한 이해](/32)

입력 버퍼(stdin) 에 대한 이해와 고질적인 `scanf` 문제의 발생 원인과 해결책에 대해 알아본다.

###@ [15 - 3. 일로와봐, 문자열(string) - 문자열 지지고 볶기 & 리터럴](/33)

문자열 리터럴(literal) 에 관한 이해 및 문자열을 이용한 여러가지 작업들에 대해 알아본다. 

###@ [15 - 4. 일로와봐, 문자열(string) - 도서 관리 프로젝트](/43)

도서 관리 프로젝트를 만들며 문자열을 다루고, 함수를 이용한 프로그래밍에 친근해진다. 

###@ [16 - 1. 모아모아 구조체(struct)](/55)

구조체에 대한 기본 개념 정의 및 이해, 구조체 포인터 및 `->` 연산자에 대한 설명

###@ [16 - 2. 모아 모아 구조체(struct) - 구조체 인자로 가진 함수](/60)

구조체 포인터에 대한 확실한 이해, 구조체 포인터 인자로 받는 함수, 구조체의 대입에 대해 알아본다

###@ [16 - 3. 구조체와 친구들(공용체(union), 열거형(enum))](/71)

구조체의 나머지 잡다한 기능들에 대한 이해, 공용체, 열거형에 대해 알아본다. 

###@ [17. 변수의 생존 조건 및 데이터 세그먼트의 구조](/83)

여러가지 형식의 변수(지역, 전역, 정적) 에 대해 알고 데이터 세그먼트의 구조를 파악한다. 

###@ [18 - 1. 파일 뽀개기 (헤더파일과 #include, 모듈화 프로그래밍)](/87)

하나의 소스파일에서 탈피해 여러가지 파일들로 나누어 모듈화 프로그래밍을 하고 헤더파일과 `#include` 를 이해한다. 

###@ [18 - 2. 파일 뽀개기 (# 친구들, 라이브러리)](/88)

여러가지 전처리기 명령(`#include, #define, #ifdef, #endif, #else`) 에 대해 알고, 표준 C 라이브러리를 사용한다. 

###@ [19. main 함수의 인자, 텅 빈 void 형](/89)

`void` 형 포인터, 함수에 대해 알고, `main` 함수의 인자 (`argc, argv`) , 그리고 포인터 배열에 대해 이해한다. 

###@ [20 - 1. 동동동 메모리 동적 할당(Dynamic Memory Allocation)](/98)

`malloc` 함수에 대한 이해, 1 차원 및 2 차원 배열 (정확히 말하면 2 차원 배열과는 다르다)  메모리 동적 할당. 

###@ [20 - 2. 메모리 동적 할당 + 메모리 갖고 놀기](/100)

구조체의 동적 할당, 노드(Node) 의 이해, 메모리 처리 관련 함수 (`memmove`, `memcmp`, `memcpy`) 의 이해

###@ [21. 매크로 함수, 인라인 함수](/99)

매크로 함수(macro function) 와 인라인 함수(inline function) 에 대해 이해한다. 

###@ [22. C 언어의 잡다한 키워드들 (typedef, volatile, #pragma)](/103)

`typedef, volatile, #pragma` 키워드에 대해 알아보고, 특히 `#pragma pack` 과 `#pragma once` 에 대해서도 알아본다. 

###@ [23 - 1. 파일 하고 이야기 하기 (파일 입출력에 대한 기본적 이해)](/117)

파일 입출력과 스트림이 무엇인지 알고 `fopen`, `fgets`, `fputs`, `fgetchar`, `fseek`, 파일 위치 지정자에 대해 알아본다. 

###@ [23 - 2. 파일 하고 이야기 하기 (파일 입출력)](/123)

파일 위치 지정자와 `fopen` 의 자세한 사용법(`"r+", "w+", "a", "a+"`) 에 대해 이해하고 `fscanf`, `fprintf` 함수를 다루며 도서 관리 프로그램에 입출력 기능을 추가해본다

###@ [23 - 3. 파일 하고 이야기 하기 (파일 입출력 - 마무리)](/125)

지난 도서 관리 프로그램의 마무리 이다. 

###@ [24. 더 빠르게 실행되는 코드를 위하여 (C 코드 최적화)](/129)

더 훌륭한 코드를 위해서 C 언어에서 코드를 최적화 할 수 있는 여러가지 기법들을 살펴본다.

###@ [25. 강좌를 마치며](/130)