----------------
title : 씹어먹는 C 언어 - <2 - 2. 주석(Comment)에 대한 이해>
cat_title : 2 - 2. 주석(Comment)에 대한 이해
next_page : 21
publish_date : 2009-09-24
path : /C
tex_title : 주석(Comment)
--------------


이번 강의에서는

* 주석에 대한 확실한 이해

![씹어먹는 C 언어](/img/ChewingClogo.png)

사실, [2 - 1](http://itguru.tistory.com/6)강에서도 다룬 내용이지만 댓글을 통해 질문이 들어 왔기에 정확히 주석이란 놈이 무엇인지 알아 보도록 하겠습니다.

우리가 프로그래밍을 하다 보면 소스 코드가 상당히 길어 지게 됩니다. 우리가 앞서 한 `Hello, World!` 출력 예제는 소스 코드가 겨우 몇 줄에 불과하였지만 실제론 소스 코드의 길이가 수천 줄에서 수만 줄 가까히 됩니다. 예를 들어서 우리가 지금 사용하는 `Windows XP` 의 소스 코드가 몇 줄 정도 될 지 추측해 보세요. 한, 십만줄? 50만 줄? 아닙니다. 정확한 자료는 아니지만 대략 4000만 줄 이상 된다고 합니다.

이런 크기로 프로그램을 작성하다 보면 이 소스 코드가 무엇을 뜻하고 또 무슨 일을 하는지 등의 정보를 소스 코드 내에 나타내야 할 필요성이 있게 됩니다. 즉, 컴파일러가 완전히 무시하고 오직 사람의 편의를 위해서만 존재하는 것이 바로 **주석** 입니다.

종종 지금 코드를 쓰고 있는 시점에서 내용을 잘 안다고 주석을 생략하는 경우가 있습니다. 하지만 주석 없는 코드를 1 달 뒤에 다시 본다면 분명히 *아니 이게 지금 뭐하는 코드지?* 라고 생각하실 것입니다. 반면에 주석이 잘 작성되어 있는 코드는 몇 년 뒤에서 다시 읽는다 해도 (주석을 잘 달아놨다는 가정 하에) 쉽게 이해할 수 있습니다.

C 언어에서 주석은 두 가지 방법으로 넣을 수 있습니다.

```cpp-formatted
/* 주석이 들어가는 부분 */

// 주석이 들어가는 부분
```

일단 전자의 경우 `/*` 와 `*/` 로 묶인 내부의 모든 내용들이 주석으로 처리 됩니다. 즉,

```cpp-formatted
/*

이 부분은 내가 아무리 생쇼를 해도 컴파일러가 무시
ㅁㄴㅇ러ㅏㅁ니ㅓㄹ먼리;ㅏㄴㅁ어림나러 무시
ㅁ아ㅓㄹ민럼ㄴㄹ ㅁㄴㅇ럼니러
ㅁㄴ라미너럼나러ㅣㅁ너라ㅣㅓㅇ
printf("Hello, World"); <- 이 것도 당연히 무시
*/
```

와 같이 난리를 쳐도 `/*` 와 `*/` 로 묶인 부분은 무시됩니다. 아래 예제를 보면 이해가 더욱 잘 될 것입니다.

```cpp-formatted
#include <stdio.h>
int main() {
  /*
  printf("Hello, World!\n");
  printf("Hi, Human \n");
  */
  printf("Hi, Computer \n");

  return 0;
}
```

위와 같은 소스코드를 컴파일 하였을 때,

```exec
Hi, Computer 
```

와 같이 `Hi, Computer` 을 출력하는 부분만 남을 것을 볼 수 있습니다. 이는 앞서 말했듯이 `/*` 와 `*/` 로 묶인 부분이 전부다 주석으로 처리되어서 컴파일러가 철저하게 무시하였기 때문 입니다.

반면의 `//` 형태의 주석의 경우 `//` 가 쳐진 줄 만이 주석으로 처리가 됩니다. 즉,

```cpp-formatted
// Hello, World! 를 출력한다.
printf("Hello, World!");
```

로 하면 아래 `printf` 부분 잘 실행됩니다. 하지만 위 주석은 역시 무시됩니다. 아래 예제를 보면 확실히 알 수 있습니다.

```cpp-formatted
#include <stdio.h>
int main() {
  // printf("Hello, World!\n");
  printf("Hi, Human \n");
  printf("Hi, Computer \n");

  return 0;
}
```

성공적으로 컴파일 하였다면

```exec
Hi, Human 
Hi, Computer 
```

와 같이 주석으로 감싸진 부분을 제외하고는 나머지 부분이 잘 출력되었음을 알 수 있습니다.

```lec-summary
항상 주석을 다는 습관을 기릅시다.
주석을 잘 달지 않는다면 나중에 자기가 쓴 코드도 못알아보게 됩니다.
```

##@ chewing-c-end