-----------------
title : 초보자를 위한 C++ 강좌 - 씹어먹는 C++ (완결)
cat_title : 초보자를 위한 C++ 강좌 - 씹어먹는 C++ (완결)
chapter : 강의를 마무리 하면서
path : /C++
publish_date : 2020-05-10
next_page : 311
-----------------

![](/img/ChewingCpplogo.png)

안녕하세요 여러분! 여기까지 오시느라 수고 많으셨습니다.

(C++ 전체 강의를 보시려면 [여기로](/135) 가시면 됩니다)

[2011 년에 시작한 강좌](/135)를 드디어 [2020 년에 와서야 끝](/310)마치게 되었습니다. 긴 기간동안 중간에 공백도 있었고 (~~군대갔다오느라 ㅎㅎ~~) 답글들도 자주 못달아 드렸는데, 그래도 제 글들을 읽어주시는 독자들의 성원 덕분에 어찌어찌해서 완결을 할 수 있었습니다. 강의를 완결하는데 오래걸린 만큼 틀린 내용도 많이 수정하고 내용도 보완해서 좀 더 탄탄한 강좌로 완성할 수 있었던것 같습니다. 소중한 답글 달아주신 분들에 감사의 말을 표하고 싶습니다.

돌이켜보면 9년 이라는 세월이 어떻게 보면 길면서도 또 어떻게 보면 또 금방 지나갔던 것 같습니다. 이 세월 동안 저 역시 학생에서 지금은 C++ 덕분에 밥먹고 사는 소프트웨어 엔지니어가 되었습니다. 

C++ 역시 정말 많이 변했습니다. 2011 년에 C++ 11 이 출시되었지만, 아무래도 당시에는 C++ 98 을 주로 쓰는 추세였죠. 하지만 세월이 흘러 이제는 C++ 20 의 표준안이 완성되어서 일부 컴파일러에서는 사용할 수 있게 되었습니다.

제 강좌도 2011 년 당시에 처음 시작할 때에는 주로 C++ 98/03 의 내용만을 다루다가 강좌 후반에 C++ 11 의 내용을 살짝 다루는 식으로 계획했었는데, 이제 C++ 11 혹은 그 이상인 C++ 14 와 17 이 대세가 된 이상 해당 내용도 모두 포함하는 식으로 계획을 바꾸게 되었습니다. 

물론 C++ 20 이 얼마 전에 공개되었지만 아직 [해당 표준안을 전부 지원하는 컴파일러는 없기 때문에](https://en.cppreference.com/w/cpp/compiler_support) 실무에서 C++ 20 을 사용하기에는 조금 더 시간이 걸릴 것으로 예상 됩니다.\sidenote{참고로 구글에서 C++ 17 이 표준으로 된 지는 채 1년이 지나지 않았습니다. 다시말해 새로운 표준안이 공개되어도 회사에서 이를 적용하는데에는 여러가지 호환성 문제와 검증 문제 때문에 시간이 많이 걸립니다.}

물론 제 C++ 강좌가 여기서 끝나는 것은 아닙니다! 일단 여태까지의 강좌를 통해서 C++ 의 기초적인 개념들을 다루었더라면, 후에는 좀더 C++ 을 실제로 사용하는데 도움이 되는 내용들을 다루고 싶습니다. 제가 생각하고 있는 주제들로는

* [Makefile](/311) 과 CMake 사용법
* C++ 툴들 (clang-format, clang-tidy, ASAN, TSAN 등등) 활용법.
* C++ 유닛 테스트 프레임워크 사용하기 (googletest 와 catch)
* C++ 디자인 패턴 (Singleton, Factory, CRTP, Dependency Injection 등등)
* C++ 20 에 등장할 `concept` 과 `module`
* 할당자 (allocator) 만들기

들이 있는데 추후에 다루어 보겠습니다. 

### 그럼 이제 뭘 해야 되나?

여러분에 손에는 이제 C++ 이라는 강력한 무기가 주어졌습니다. 이제 이 무기를 휘두루기만 하면 되죠! [첫 번째 강의](/135) 에서 이야기 하였지만 수 많은 프로그램과 라이브러리들이 C++ 로 만들어져 있는 만큼 여러분들도 이제 만들러가시면 됩니다 ㅎㅎ

만약에 C++ 을 좀 더 공부하고 싶다면 제가 추천하는 책과 영상들이 있습니다.

#### 읽어볼만한 책들

* 일반적인 프로그래밍 : [The C++ Programming Language, 4th Edition](https://www.amazon.com/C-Programming-Language-4th/dp/0321563840), [Effective Modern C++](https://www.amazon.com/Effective-Modern-Specific-Ways-Improve-ebook/dp/B00PGCMGDQ/ref=sr_1_2?dchild=1&keywords=effective+c%2B%2B&qid=1589541739&sr=8-2)
* C++ 템플릿을 좀 더 알고 싶다면 : [C++ Templates: The Complete Guide](https://www.amazon.com/Templates-Complete-Guide-David-Vandevoorde-ebook/dp/B075MJNCCH/ref=sr_1_1?dchild=1&keywords=C%2B%2B+templates&qid=1589541715&sr=8-1)
* C++ 동시성 프로그래밍 대해 좀 더 알고 싶다면 : [C++ Cuncurrency in Action, Second Edition](https://www.amazon.com/C-Concurrency-Action-Second/dp/B082MS5SZW/ref=sr_1_3?dchild=1&keywords=concurrency+c%2B%2B&qid=1589541768&sr=8-3)
* C++ 디자인 패턴을 좀 더 알고 싶다면 : [Modern C++ Design](https://www.amazon.com/Modern-Design-Programming-Patterns-Depth-ebook/dp/B00AU3JUHG/ref=sr_1_4?dchild=1&keywords=design+pattern+c%2B%2B&qid=1589541844&sr=8-4) 과 [Hands-On Design Patterns with C++](https://www.amazon.com/Hands-Design-Patterns-reusable-maintainable-ebook/dp/B07FNVYSN4/ref=sr_1_5?dchild=1&keywords=design+pattern+c%2B%2B&qid=1589541881&sr=8-5)

참고로 Scott Meyers 의 *Effective Modern C++* 은 C++ 을 실전에서 사용하기 전에 한 번쯤 꼭 읽어봐야할 명서라고 생각합니다.

#### 볼만한 영상들

CppCon 은 1 년에 한 번씩 열리는 C++ 컨퍼런스 인데, 해당 컨퍼런스에서 발표된 영상들이 [모두 유튜브](https://www.youtube.com/channel/UCMlGfpWw-RUdWX_JbLCukXg)에 올라오니 관심 있는 주제로 영상을 보는 것을 추천드립니다. 특히 최신 C++ 트렌드를 따라가는데 도움이 많이 됩니다. 

아래 영상들은 제가 인상적으로 보았던 영상들 입니다.

* [CppCon 2019: Bjarne Stroustrup "C++20: C++ at 40"](https://www.youtube.com/watch?v=u_ij0YNkFUs)
* [CppCon 2019: Andrei Alexandrescu "Speed Is Found In The Minds of People"](https://www.youtube.com/watch?v=FJJTYQYB1JQ)
* [CppCon 2017: Fedor Pikus "C++ atomics, from basic to advanced. What do they really do?"](https://www.youtube.com/watch?v=ZQFzMfHIxng)
* [CppCon 2014: Walter E. Brown "Modern Template Metaprogramming: A Compendium, Part I"](https://www.youtube.com/watch?v=Am2is2QCvxY)
* [CppCon 2017: Jason Turner "Practical C++17"](https://www.youtube.com/watch?v=nnY4e4faNp0)
* [CppCon 2017: Louis Brandy "Curiously Recurring C++ Bugs at Facebook"](https://www.youtube.com/watch?v=lkgszkPnV8g)
* [CppCon 2014: Chandler Carruth "Efficiency with Algorithms, Performance with Data Structures"](https://www.youtube.com/watch?v=fHNmRkzxHWs)
* [CppCon 2019: Stephan T. Lavavej "Floating-Point ＜charconv＞: Making Your Code 10x Faster With C++17's Final Boss"](https://www.youtube.com/watch?v=4P_kbF0EbZM)

사실 C++ 과 직접 관련은 없지만 매우 흥미로운 주제여서 추가하였습니다. 

* [CppCon 2018: Chandler Carruth "Spectre: Secrets, Side-Channels, Sandboxes, and Security"](https://www.youtube.com/watch?v=_f7O3IfIR2k)

그리고 Stephan Lavevej 의 표준 라이브러리에 관한 [강의](https://channel9.msdn.com/Series/C9-Lectures-Stephan-T-Lavavej-Standard-Template-Library-STL-/C9-Lectures-Introduction-to-STL-with-Stephan-T-Lavavej)도 도움이 많이 되었습니다.

### PDF 파일

~~현재 전체 강의 내용을 PDF 로 만들어서 책 처럼 제작하고 있습니다. 사실 LaTeX 를 사용해서 거의 다 완성이 됬는데 몇몇 그림들이 짤리는 경우가 있어서 수정 중에 있습니다. 조만간 완성해서 올릴 예정입니다.~~

**[여기에서 다운 받으시면 됩니다.](/312)**

**그럼 그동안 제 강좌를 봐주셔서 감사합니다!**

##@ chewing-cpp-end