- [ ] analyse the UUID check technique's efficiency
- [X] fix c++11 debug function param error
- [X] completely remove std::system() grep commands
- [ ] add github metrics for license (looks cool af)
- [X] add CTest before alpha release
- [ ] test for processor type and stuff like that for cpuid EAX=1
- [ ] grep everywhere for QEMU shit
- [X] implement VM::EXTREME flag
- [X] update the cli tool image in the readme
- [X] focus on hyperv detection (https://labs.nettitude.com/blog/vm-detection-tricks-part-3-hyper-v-raw-network-protocol/)
- [X] add percentage overload functionality for VM::detect()
- [X] maybe document the project in codeproject.com when a 1.0 is ready
- [X] add a cpuid fuzzer (baremetal and VM)
- [ ] organise the registry existence function better and group them together as a single utility function
- [X] add <source_location> for error handling
- [X] make an MIT version for 1.0
- [X] add function to add custom techniques for end-user
- [X] fix memoization
- [X] add a python script to automatically set the lines of the seperate sections in the header
- [ ] add C++20 concepts for the VM::add_custom() function
- [X] check for valid monitor technique
- [X] fix the is_admin code for windows
- [X] test it on compiler explorer with windows 32-bit settings
- [ ] upload the lib to dnf 
- [ ] upload the lib to apt 
- [X] add ARM support
- [X] look into what `fv-az663-325` is
- [X] implement techniques from [here](https://labs.nettitude.com/blog/vm-detection-tricks-part-3-hyper-v-raw-network-protocol/)
- [X] add multiple choice for VM::brand()
- [ ] add c++20 module support 
- [X] design a way to disable some techniques way easier
- [ ] make a man file in markdown for the cli tool
- [X] implement smbios version technique [here](https://github.com/Print3M/Anti-VM/blob/eb524ed89e783b36c149acc450b2350d4198b06b/detectors.cpp#L88)
- [ ] implement a display size technique for linux with EDID 
- [X] implement a technique that matches the CPU product name and match it with a database of core counts for that specific CPU product
- [X] add usage example in the .hpp file directly below the banner
- [X] use the [[assume()]] attribute in C++23 for certain areas (not sure where exactly) 
- [X] maybe add [[deprecated]]?
- [ ] implement techniques from here https://stackoverflow.com/questions/43026032/detect-running-on-virtual-machine
- [ ] add a .clang_format thingy
- [ ] maybe add internal is_cached functionalities in the cache fetchers
- [ ] make the whole cache table into a mutex so i can claim it's thread-safe
- [ ] make a medium post about it
- [ ] test the VM::modify_score() function
- [ ] check if bios date in /sys/class/dmi/id/ could be useful under QEMU
- [X] make the cli demo in the readme for the 1.9 version
- [X] fix the percentage thing for the disabled techniques
- [X] adopt the firmware technique from the vmprotect source code leak
- [ ] add a .so, .dll, and .dylib shared object files in the release 
- [X] make a struct version as an alternative
- [X] add the license style like in ffmpeg https://github.com/FFmpeg/FFmpeg/tree/master?tab=License-1-ov-file
- [ ] fix the issue of VM::QEMU_USB being ultra slow
- [X] make a MIT transformer python script from GPL to MIT
- [ ] /sys/class/dmi/id/product_name check this in qemu
- [X] fix the VM::vmaware struct
- [X] do the ACPI technique and add it to hyper-x
- [X] "running inside AN unknown VM" instead of "a unknown" for conclusion message
- [X] fix the DMESG error thing
- [ ] do the IDT thing
- [X] filesystem idea from requiem
- [X] update the graph with wmi 
- [ ] add linux support for the hdd_serial_number technique
- [X] update the hyper-x graph to v5 with the acpi thingy
- [ ] add a VM brand information summary if one was detected (i.e. "VMware is a type 2 hypervisor by Broadcom released in 1999, etc etc")
- [ ] fix "dmidecode not found" error
- [ ] fix /dev/mem not found in vbox default
- [ ] dxdiag technique from utoshu
- [ ] redesign the cli so that it has the "NO SUPPORT" category of techniques (and also make a table instead)
- [ ] double check the vmid_template function
- [ ] update sourceforge
- [ ] scan for QEMU strings in QEMU VM
- [ ] add a python script that will automatically add a new technique in the header, CLI, and docs without manually configuring it and potentially forgetting to update one of them
- [ ] rearrange the techniques so that the more likely ones will be executed first
- [ ] add VM::DYNAMIC to the conclusion function docs

# Distant plans
- add the library to conan.io when released
- add a python version of the library (or any other lang for that matter)
- add a GUI version of the lib
- add a rust version of the lib
- submit the project to oss-fuzz 
