<?php 

use Cygnite\Database\Migration;
use Cygnite\Database\Schema;

/**
* This file is generated by Cygnite Migration Command
* You may use up and down method to create migration
*/

class Product extends Migration
{

    protected $database = 'cygnite';
	/**
	 * Run the migrations up.
	 *
	 * @return void
	 */
	public function up()
	{
		//Your schema to migrate
        Schema::instance(
            $this,
            function ($table) {
                $table->tableName = 'product';
                $table->create(
                    array(
                        array('name'=> 'id', 'type' => 'int', 'length' => 11,
                            'increment' => true, 'key' => 'primary'),
                        array('name'=> 'product_name', 'type' => 'string', 'length' =>100),
                        array('name'=> 'category', 'type' => 'string', 'length' =>150),
                        array('name'=> 'description', 'type' => 'string', 'length'  =>255),
                        array('name'=> 'validity', 'type' => 'date', 'length'  =>'0000-00-00'),
                        array('name'=> 'price', 'type' => 'decimal', 'length'  =>'10,2'),
                        array('name'=> 'created_at', 'type' => 'datetime','length'  =>"DEFAULT '0000-00-00 00:00:00'"),
                        array('name'=> 'updated_at','type' => 'datetime','length'  =>"DEFAULT '0000-00-00 00:00:00'"),
                    ),
                    'InnoDB',
                    'latin1'
                )->run();
            }
        );

        $data = array(
            'product_name' => 'Apple Iphone 6',
            'category' => 'Electronic',
            'description' => 'Hugely powerful. Enormously efficient.',
            'validity' => '2018-08-30',
            'price' => '950.00',
            'created_at' => date( 'Y-m-d H:i:s'),
            'updated_at' => date( 'Y-m-d H:i:s'),

        );

        $this->insert('product', $data);

    }

	/**
	 * Revert back your migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        $this->delete('product', '1'); // delete last seeded data
		 //Roll back your changes done by up method.
        Schema::instance(
            $this,
            function ($table) {
                $table->tableName = 'product';
                $table->drop()->run();
            }
        );
	}
}// End of the Migration
