---
title: "How I failed landing a remote position"
path: "/how-i-failed-landing-a-remote-position/"
date: "2017-07-07T17:43:00.000Z"
tags: Interviews, Job
---

I started looking for a remote position, telecommuting in other words, as a software engineer last November. It took me 3 months to apply to ~150 job descriptions and none of them was a successful hire. Nevertheless, I now have a great job and I would like to share that experience with you. I have prepared a spreadsheet listing anonymous applications, whether they rejected me or I rejected them and till which level I got into. I will also share my cover letter and how I approached the remote job hunting.

## Why a remote position?
After quite a few years doing this job, I have become quite selective when it comes to my next job. I need myself to be a good fit on the team and the team to be a good fit for me. I don't like big established corporations cause there is almost never anything interesting for me there. I like small ambitious teams, flexible enough to do one week sprints and put all of their heart in every sprint. I want the team's long-term goals to be my long term goals so I can put myself in it.

I would call them "startups" just because it's cool nowadays, but I won't because that's simply not what I am all about. Startups are all about high risk, I am not (at least not at this point).

While Greece had quite a few success stories of such teams, my hometown Thessaloniki, in northern Greece is not that famous for their startup environment. Leaving Greece wasn't possible at the moment so I thought I would chase a remote position especially after having lots of local friends who work for big companies like, GitHub, Automattic, etc.

Let one not forget, there is also the compensation parameter that says that you can enter a better-paid market than your local market, which is no debatable for my local market.

So I thought I would give it a try.

## The setup
The setup when you do job hunting has everything to do with how you present yourself in the online world. How I present myself you ask? Well, you are looking at it. This web page contains everything you need to know about me, all the projects I am working on, everything I have share with my readers, lots of my views about stuff (ok not everything, but you get the idea). You can find all my social profiles (GitHub, LinkedIn, Twitter, etc) through this web page and lots of other places are linking back to my blog posts.

But to make the recruiter to visit my page, I had to go through her mailbox first. So I tried to write a catchy email worthy enough to make her click my web page. Keep in mind that I am not targeting a big corporation but rather a team where the casual speech is usual. I wanted to write an email that will automatically filter out the "serious" guys and attract the more friendly ones. That's why the friendly tone.

This is the final version of it because I had to do some revises after I sent it a few times.

"Dear Mr/Ms,

I am Kostas Bariotis, a software developer and a passionate doer. I am sending you my regards from sunny Thessaloniki, Greece. Have you ever been? Take a look, I am sure you will fall in love with the amazing beaches of Chalkidiki.

I am currently looking for a product and a team that I would be a great fit in. I stumbled upon your job description and I would really love it to talk more with you guys. I have been working with Node.js for the past three years. (**This is where I explain why I would be a good fit for that particular position**)

I am obsessed with clean and efficient code. I am interested in designing software architectures, APIs and databases to serve the rest of an application. I am a full stack developer yet I love taking a specific field in my hands and getting the juice out of it. I am interested in being a part of a team that builds great software. I have spent the last two years with the [Goodvid.io](https://goodvid.io) team to serve e-commerce sites with curated product videos.

My blog is my personal playground, I am also doing a lot of public speaking talking a lot about tech stuff and also talking with others on my podcast. Stargento and [GitYeller](https://gityeller.com) are two of my side projects. You can find more code samples and my contributions on [Github](https://github.com/kbariotis). Along with some folks, we are organizing the local [Nodejs meetup](https://www.meetup.com/Thessaloniki-Node-js-Meetup/) and [Devit Conf](http://devitconf.org), the biggest web development conference in northern Greece. We are also known as [SKGTech](https://skgtech.io).

Last, but not least, I love reading books, mainly science fiction, traveling and attending conferences and meetups, snowboarding and staying fit. Calisthenics class is my latest activity that takes a lot of my time.

I would love it if we could arrange a talk and talk more about how I could potentially be a fit for your team. Please, consult my resume or see the links below.

Thank you so much and have a nice day. :)"

## Where did I look?
Nowadays there are lots of places to find a remote position, especially in software engineering. Here's my list of preference:

* [weworkremotely.com](https://weworkremotely.com/)
* [Stackoverflow Jobs](https://stackoverflow.com/jobs?sort=i&r=true) (with `Offers remote` filter on)
* [Angel.co](http://angel.co) (mostly known for early stages companies)
* https://github.com/jessicard/remote-jobs
* https://github.com/lukasz-madon/awesome-remote-job

## The results
Like I said I didn't have a successful hire after all. Lots of companies showed interest in me and lots of others didn't even bother contacting me back.

[I have gathered over 70 applications](https://docs.google.com/spreadsheets/d/17w6jiewdPQSgSL3Rripit2RdjWcR_I_m7ObBObmQAh0/edit?usp=sharing) the months that I was looking for a job. Keep in mind that these are only those that I had some sort of communication through email or some other mean. I also did lots of applications on Angel.co and other similar sites that I've never heard back. The sum of the applications must exceed those 70 by far.

## What I have learned
The progress I had with each company varies. It's interesting to see how many contacted me back and how many wanted to do an [interview](https://kostasbariotis.com/interviewer-vs-interviewee/) and how many interviews did I took on average with each company. I believe, though, that the most interesting part is that with over 70 applications I did, I took back like 3 offers which lead me to the conclusion that the market of the remote positions is highly competitive and it's really hard to find the job that you would be happy enough.

As you enter a bigger market of potential employers, the same way they enter a bigger market of potential employees. Most of the times, the best yet the cheapest at their fields are those who get hired.

But that's ok, cause this makes the market grow. There are still these companies that are looking for other parameters and don't care about the cost that much, but these companies have higher expectations and juniors/mid developers are often not being considered that easily.

I am back on track now on a great team and an amazing environment in the heart of Thessaloniki. I am not rejecting the idea of working remotely entirely but I will leave it aside for now.

Hope that you liked this post.
