---
title: "Does your code smells?"
path: "/does-your-code-smells/"
date: "2014-08-25T04:00:57.000Z"
date_updated:   2014-08-25T04:00:57.000Z
---

Programming is like my life. Being in the game since i was a little kid, it's like programming languages are my native languages. Writing good code matters a lot to me.

Being able to write clean code may not seem so important but hazardous situations will occur if you don't. In the long run, smelly code will make your project maintenance slow. At the end, it is possible, that you abandon it and start over. That is a disaster. And you should not allowed it.

I read a <a title="Clean Code Handbook" href="http://www.amazon.com/Clean-Code-Handbook-Software-Craftsmanship/dp/0132350882" target="_blank">book </a>past week. Reading this book, it was something i had to do loooong time before. Written at 2008, by the father of Good Code, <a title="Martin Fowler Personal Page" href="martinfowler.com" target="_blank">Martin Fowler</a>, it opened my eyes for sure. So many principles i haven't even thought about it.

[caption id="attachment_287" align="alignleft" width="225"]<a href="http://www.amazon.com/Clean-Code-Handbook-Software-Craftsmanship/dp/0132350882"><img class="wp-image-287 size-medium" src="https://kbariotis.files.wordpress.com/2014/08/showcover.jpg?w=225" alt="Clean Code by Martin Fowler" width="225" height="300" /></a> Clean Code by Martin Fowler[/caption]

Here's an example. All this time, i have been writing code, almost 50% of it were comments. I thought this is the way other programmers will understand me.  <a title="Martin Fowler Personal Page" href="martinfowler.com" target="_blank">Martin Fowler</a> flipped it over. "The proper use of comments is to compensate our self's for our failure to express our self's." he said.

Now, i am not going to write a book review. It's not something i am good at. I will put some of my favorites notes i kept from the book while reading it.

Take a look.
<h2>About Clean Code.</h2>
<blockquote>Spending time keeping your code clean, is not just cost effective. It's a matter of survival"</blockquote>
&nbsp;
<blockquote>"The only way to make the deadline, the only way to go fast is to keep the code as clean as possible."</blockquote>
<h2> About Functions:</h2>
<blockquote>Functions should be small. Even smaller than that. And do only one thing.</blockquote>
&nbsp;
<blockquote>One level per abstraction in each function.</blockquote>
&nbsp;
<blockquote>Always prefer exceptions than error codes.</blockquote>
&nbsp;
<blockquote>Duplication may be the root all evil in software.</blockquote>
<h2>About Comments</h2>
<blockquote>Comments are bad.</blockquote>
&nbsp;
<blockquote>The proper use of comments is to compensate our self's for our failure to express our self's.</blockquote>
&nbsp;
<blockquote>Comments are not maintainable.</blockquote>
&nbsp;
<blockquote>Think twice before you write them.</blockquote>
<h2>About Code Formatting</h2>
<blockquote>Think of a well written newspaper article. You read it vertically. At the top you expect a headline to tell you what the story is all about and allows you to decide whether is something you want to read. The first paragraph is a synopsis of the whole story. As you continue downwards, the details increase until you have all the dates, the names, etc. We would like source code to be like that.

&nbsp;</blockquote>
Now this is not just it. This book is a treasure for every programmer. If i got your attention give it a try.

What's your favorite notes and rules about writing clean code?

&nbsp;
<h3>If you like this article, take a look on a <a title="How to write clean and efficient code" href="https://medium.com/@kbariotis/how-to-write-clean-efficient-code-f53fd67131f9" target="_blank">similar </a>i have wrote on @medium and follow me on <a title="Kostas Bariotis on Twitter" href="http://twitter.com/kbariotis" target="_blank">twitter</a>.</h3>
