---
title: "Disagree and commit"
path: "/disagree-and-commit/"
date: "2018-07-22"
tags: Culture, Team
---

More than a few times, a recruiter or a company's representative that I am interviewing with will ask me a particular question (among others of course). The question is:

> "Tell me about a situation where you were disagreeing with other people on the team."

First of all, that particular question belongs to the STAR method of Behavioral Analysis. Read [this paper](https://www.vawizard.org/wiz-pdf/STAR_Method_Interviews.pdf) if you want to learn more. To make it short though, the interviewer usually is not looking for a particular answer. She's interested in your fluidity to express your self about that situation.

The reason I am writing this post, is because that question brought me back memories. Once, I was so arrogant that I would put my ego first. I would try to talk everyone in a room out of their opinions and instead to follow mine, as if it was the best in that room.

But that has changed now. With that in mind, I would like to share my lessons and make you a better member of any team you may be part of. Here it goes.

## Stand behind your self
To protect your ideas and to want everyone to hear you is fine only if you can stand behind them. Being strong opinionated doesn't make you an expert in that field. But to express those strong opinions you must first make sure that you know what you are talking about.

Do your homework. Question your own ideas. Do a very long Google search but don't stop at the very first result that will verify your idea. Look for the other results, those that will fail your idea. Question those too. Try to be unbiased and don't allow your inner beliefs to blind you.

## Know how to communicate effectively
Communicating effectively is a key thing to every conversation. Your words must construct valid arguments. Always stick to the topic and have points that others can argue or reason about.

An effective conversation may also be affected by the tone in the room. Ever been in the room where you could clearly say who's talking and who's not so much? People that tend to talk much usually are preventing others from talking. Let everyone speak by trying to keep your part only to your most crucial arguments and points. Let everyone express their self.

<!-- want to go deeper? fallacies http://www.nobeliefs.com/fallacies.htm -->

## Leave your ego at home
If you find your self arguing about a certain matter but you are still not sure if you are right about it, stop it right there. That's a clear sign that you're putting your self in front of your arguments. The conversation may go personal. That may be the right time to agree that you disagree.

Understand that not everything is about you. But rather everything is about the team. Disagreeing will only slow the whole team down. Unless you have a better idea and you're ready to stand behind it, hold back. Say, you know what, we agree to disagree, but let's try that and see what happens.

## To conclude
In a team work, the goals are clear and usually are about moving the team forward. Understand that every word of yours is affecting that movement is important to think twice every time you're about to speak.

Like I said in the beginning of this post, once I was in a position where I was making my team go slower. Now and on every meeting I am participating in, my goal is clear: Help the team move forward.

Now you tell me about a situation where you were disagreeing with other people on the team. ☺️
