//
//  GenreMap.swift
//  Aural
//
//  Copyright © 2024 Kartik Venugopal. All rights reserved.
//
//  This software is licensed under the MIT software license.
//  See the file "LICENSE" in the project root directory for license terms.
//
import Foundation

///
/// A mapping of genre codes to user-friendly human-readable strings.
/// Contains mappings for ID3 and iTunes genres.
///
class GenreMap {
    
    static func forID3Code(_ code: Int) -> String? {
        return id3Map[code]
    }
    
    static func forITunesCode(_ code: Int) -> String? {
        return iTunesMap[code]
    }
    
    static let id3Map: [Int: String] = [
        
        0: "Blues",
        1: "Classic Rock",
        2: "Country",
        3: "Dance",
        4: "Disco",
        5: "Funk",
        6: "Grunge",
        7: "Hip-Hop",
        8: "Jazz",
        9: "Metal",
        10: "New Age",
        11: "Oldies",
        12: "Other",
        13: "Pop",
        14: "R&B",
        15: "Rap",
        16: "Reggae",
        17: "Rock",
        18: "Techno",
        19: "Industrial",
        20: "Alternative",
        21: "Ska",
        22: "Death Metal",
        23: "Pranks",
        24: "Soundtrack",
        25: "Euro",
        26: "Ambient",
        27: "Trip",
        28: "Vocal",
        29: "Jazz & Funk",
        30: "Fusion",
        31: "Trance",
        32: "Classical",
        33: "Instrumental",
        34: "Acid",
        35: "House",
        36: "Game",
        37: "Sound Clip",
        38: "Gospel",
        39: "Noise",
        40: "Alternative Rock",
        41: "Bass",
        42: "Soul",
        43: "Punk",
        44: "Space",
        45: "Meditative",
        46: "Instrumental Pop",
        47: "Instrumental Rock",
        48: "Ethnic",
        49: "Gothic",
        50: "Darkwave",
        51: "Techno",
        52: "Electronic",
        53: "Pop",
        54: "Eurodance",
        55: "Dream",
        56: "Southern Rock",
        57: "Comedy",
        58: "Cult",
        59: "Gangsta",
        60: "Top 40",
        61: "Christian Rap",
        62: "Pop/Funk",
        63: "Jungle",
        64: "Native US",
        65: "Cabaret",
        66: "New Wave",
        67: "Psychadelic",
        68: "Rave",
        69: "Showtunes",
        70: "Trailer",
        71: "Lo",
        72: "Tribal",
        73: "Acid Punk",
        74: "Acid Jazz",
        75: "Polka",
        76: "Retro",
        77: "Musical",
        78: "Rock & Roll",
        79: "Hard Rock",
        80: "Folk",
        81: "Folk",
        82: "National Folk",
        83: "Swing",
        84: "Fast Fusion",
        85: "Bebob",
        86: "Latin",
        87: "Revival",
        88: "Celtic",
        89: "Bluegrass",
        90: "Avantgarde",
        91: "Gothic Rock",
        92: "Progressive Rock",
        93: "Psychedelic Rock",
        94: "Symphonic Rock",
        95: "Slow Rock",
        96: "Big Band",
        97: "Chorus",
        98: "Easy Listening",
        99: "Acoustic",
        100: "Humour",
        101: "Speech",
        102: "Chanson",
        103: "Opera",
        104: "Chamber Music",
        105: "Sonata",
        106: "Symphony",
        107: "Booty Bass",
        108: "Primus",
        109: "Porn Groove",
        110: "Satire",
        111: "Slow Jam",
        112: "Club",
        113: "Tango",
        114: "Samba",
        115: "Folklore",
        116: "Ballad",
        117: "Power Ballad",
        118: "Rhythmic Soul",
        119: "Freestyle",
        120: "Duet",
        121: "Punk Rock",
        122: "Drum Solo",
        123: "Acapella",
        124: "Euro",
        125: "Dance Hall",
        126: "Goa",
        127: "Drum & Bass",
        128: "Club",
        129: "Hardcore",
        130: "Terror",
        131: "Indie",
        132: "BritPop",
        133: "Negerpunk",
        134: "Polsk Punk",
        135: "Beat",
        136: "Christian Gangsta Rap",
        137: "Heavy Metal",
        138: "Black Metal",
        139: "Crossover",
        140: "Contemporary Christian",
        141: "Christian Rock",
        142: "Merengue",
        143: "Salsa",
        144: "Thrash Metal",
        145: "Anime",
        146: "JPop",
        147: "Synthpop",
        148: "Abstract",
        149: "Art Rock",
        150: "Baroque",
        151: "Bhangra",
        152: "Big beat",
        153: "Breakbeat",
        154: "Chillout",
        155: "Downtempo",
        156: "Dub",
        157: "EBM",
        158: "Eclectic",
        159: "Electro",
        160: "Electroclash",
        161: "Emo",
        162: "Experimental",
        163: "Garage",
        164: "Global",
        165: "IDM",
        166: "Illbient",
        167: "Industro-Goth",
        168: "Jam Band",
        169: "Krautrock",
        170: "Leftfield",
        171: "Lounge",
        172: "Math Rock",
        173: "New Romantic",
        174: "Nu-Breakz",
        175: "Post-Punk",
        176: "Post-Rock",
        177: "Psytrance",
        178: "Shoegaze",
        179: "Space Rock",
        180: "Trop Rock",
        181: "World Music",
        182: "Neoclassical",
        183: "Audiobook",
        184: "Audio theatre",
        185: "Neue Deutsche Welle",
        186: "Podcast",
        187: "Indie-Rock",
        188: "G-Funk",
        189: "Dubstep",
        190: "Garage Rock",
        191: "Psybient"
    ]
        
    private static let iTunesMap: [Int: String] = [
        
        2: "Blues",
        1007: "Blues (Chicago Blues)",
        1009: "Blues (Classic Blues)",
        1010: "Blues (Contemporary Blues)",
        1011: "Blues (Country Blues)",
        1012: "Blues (Delta Blues)",
        1013: "Blues (Electric Blues)",
        1210: "Blues (Acoustic Blues)",
        
        3: "Comedy",
        1167: "Comedy (Novelty)",
        1171: "Comedy (Standup Comedy)",
        
        4: "Children’s Music",
        1014: "Children’s Music (Lullabies)",
        1015: "Children’s Music (Sing-Along)",
        1016: "Children’s Music (Stories)",
        
        5: "Classical",
        1017: "Classical (Avant-Garde)",
        1018: "Classical (Baroque)",
        1019: "Classical (Chamber Music)",
        1020: "Classical (Chant)",
        1021: "Classical (Choral)",
        1022: "Classical (Classical Crossover)",
        1023: "Classical (Early Music)",
        1024: "Classical (Impressionist)",
        1025: "Classical (Medieval)",
        1026: "Classical (Minimalism)",
        1027: "Classical (Modern Composition)",
        1028: "Classical (Opera)",
        1029: "Classical (Orchestral)",
        1030: "Classical (Renaissance)",
        1031: "Classical (Romantic)",
        1032: "Classical (Wedding Music)",
        1211: "Classical (High Classical)",
        
        6: "Country",
        1033: "Country (Alternative Country)",
        1034: "Country (Americana)",
        1035: "Country (Bluegrass)",
        1036: "Country (Contemporary Bluegrass)",
        1037: "Country (Contemporary Country)",
        1038: "Country (Country Gospel)",
        1039: "Country (Honky Tonk)",
        1040: "Country (Outlaw Country)",
        1041: "Country (Traditional Bluegrass)",
        1042: "Country (Traditional Country)",
        1043: "Country (Urban Cowboy)",
        
        7: "Electronic",
        1056: "Electronic (Ambient)",
        1057: "Electronic (Downtempo)",
        1058: "Electronic (Electronica)",
        1060: "Electronic (IDM/Experimental)",
        1061: "Electronic (Industrial)",
        
        8: "Holiday",
        1079: "Holiday (Chanukah)",
        1080: "Holiday (Christmas)",
        1081: "Holiday (Christmas: Children’s)",
        1082: "Holiday (Christmas: Classic)",
        1083: "Holiday (Christmas: Classical)",
        1084: "Holiday (Christmas: Jazz)",
        1085: "Holiday (Christmas: Modern)",
        1086: "Holiday (Christmas: Pop)",
        1087: "Holiday (Christmas: R&B)",
        1088: "Holiday (Christmas: Religious)",
        1089: "Holiday (Christmas: Rock)",
        1090: "Holiday (Easter)",
        1091: "Holiday (Halloween)",
        1092: "Holiday (Holiday: Other)",
        1093: "Holiday (Thanksgiving)",
        
        9: "Opera",
        
        10: "Singer/Songwriter",
        1062: "Singer/Songwriter (Alternative Folk)",
        1063: "Singer/Songwriter (Contemporary Folk)",
        1064: "Singer/Songwriter (Contemporary Singer/Songwriter)",
        1065: "Singer/Songwriter (Folk-Rock)",
        1066: "Singer/Songwriter (New Acoustic)",
        1067: "Singer/Songwriter (Traditional Folk)",
        
        11: "Jazz",
        1052: "Jazz (Big Band)",
        1106: "Jazz (Avant-Garde Jazz)",
        1107: "Jazz (Contemporary Jazz)",
        1108: "Jazz (Crossover Jazz)",
        1109: "Jazz (Dixieland)",
        1110: "Jazz (Fusion)",
        1111: "Jazz (Latin Jazz)",
        1112: "Jazz (Mainstream Jazz)",
        1113: "Jazz (Ragtime)",
        1114: "Jazz (Smooth Jazz)",
        1207: "Jazz (Hard Bop)",
        1208: "Jazz (Trad Jazz)",
        1209: "Jazz (Cool)",
        
        12: "Latino",
        1115: "Latino (Latin Jazz)",
        1116: "Latino (Contemporary Latin)",
        1117: "Latino (Pop Latino)",
        1118: "Latino (Raíces)",
        1119: "Latino (Reggaeton y Hip-Hop)",
        1120: "Latino (Baladas y Boleros)",
        1121: "Latino (Alternativo & Rock Latino)",
        1123: "Latino (Regional Mexicano)",
        1124: "Latino (Salsa y Tropical)",
        
        13: "New Age",
        1125: "New Age (Environmental)",
        1126: "New Age (Healing)",
        1127: "New Age (Meditation)",
        1128: "New Age (Nature)",
        1129: "New Age (Relaxation)",
        1130: "New Age (Travel)",
        
        14: "Pop",
        1131: "Pop (Adult Contemporary)",
        1132: "Pop (Britpop)",
        1133: "Pop (Pop/Rock)",
        1134: "Pop (Soft Rock)",
        1135: "Pop (Teen Pop)",
        
        15: "R&B/Soul",
        1136: "R&B/Soul (Contemporary R&B)",
        1137: "R&B/Soul (Disco)",
        1138: "R&B/Soul (Doo Wop)",
        1139: "R&B/Soul (Funk)",
        1140: "R&B/Soul (Motown)",
        1141: "R&B/Soul (Neo-Soul)",
        1142: "R&B/Soul (Quiet Storm)",
        1143: "R&B/Soul (Soul)",
        
        16: "Soundtrack",
        1165: "Soundtrack (Foreign Cinema)",
        1166: "Soundtrack (Musicals)",
        1168: "Soundtrack (Original Score)",
        1169: "Soundtrack (Soundtrack)",
        1172: "Soundtrack (TV Soundtrack)",
        
        17: "Dance",
        1044: "Dance (Breakbeat)",
        1045: "Dance (Exercise)",
        1046: "Dance (Garage)",
        1047: "Dance (Hardcore)",
        1048: "Dance (House)",
        1049: "Dance (Jungle/Drum’n’bass)",
        1050: "Dance (Techno)",
        1051: "Dance (Trance)",
        
        18: "Hip-Hop/Rap",
        1068: "Hip-Hop/Rap (Alternative Rap)",
        1069: "Hip-Hop/Rap (Dirty South)",
        1070: "Hip-Hop/Rap (East Coast Rap)",
        1071: "Hip-Hop/Rap (Gangsta Rap)",
        1072: "Hip-Hop/Rap (Hardcore Rap)",
        1073: "Hip-Hop/Rap (Hip-Hop)",
        1074: "Hip-Hop/Rap (Latin Rap)",
        1075: "Hip-Hop/Rap (Old School Rap)",
        1076: "Hip-Hop/Rap (Rap)",
        1077: "Hip-Hop/Rap (Underground Rap)",
        1078: "Hip-Hop/Rap (West Coast Rap)",
        
        19: "World",
        1177: "World (Afro-Beat)",
        1178: "World (Afro-Pop)",
        1179: "World (Cajun)",
        1180: "World (Celtic)",
        1181: "World (Celtic Folk)",
        1182: "World (Contemporary Celtic)",
        1184: "World (Drinking Songs)",
        1185: "World (Indian Pop)",
        1186: "World (Japanese Pop)",
        1187: "World (Klezmer)",
        1188: "World (Polka)",
        1189: "World (Traditional Celtic)",
        1190: "World (Worldbeat)",
        1191: "World (Zydeco)",
        1195: "World (Caribbean)",
        1196: "World (South America)",
        1197: "World (Middle East)",
        1198: "World (North America)",
        1199: "World (Hawaii)",
        1200: "World (Australia)",
        1201: "World (Japan)",
        1202: "World (France)",
        1203: "World (Africa)",
        1204: "World (Asia)",
        1205: "World (Europe)",
        1206: "World (South Africa)",
        
        20: "Alternative",
        1001: "Alternative (College Rock)",
        1002: "Alternative (Goth Rock)",
        1003: "Alternative (Grunge)",
        1004: "Alternative (Indie Rock)",
        1005: "Alternative (New Wave)",
        1006: "Alternative (Punk)",
        
        21: "Rock",
        1144: "Rock (Adult Alternative)",
        1145: "Rock (American Trad Rock)",
        1146: "Rock (Arena Rock)",
        1147: "Rock (Blues-Rock)",
        1148: "Rock (British Invasion)",
        1149: "Rock (Death Metal/Black Metal)",
        1150: "Rock (Glam Rock)",
        1151: "Rock (Hair Metal)",
        1152: "Rock (Hard Rock)",
        1153: "Rock (Metal)",
        1154: "Rock (Jam Bands)",
        1155: "Rock (Prog-Rock/Art Rock)",
        1156: "Rock (Psychedelic)",
        1157: "Rock (Rock & Roll)",
        1158: "Rock (Rockabilly)",
        1159: "Rock (Roots Rock)",
        1160: "Rock (Singer/Songwriter)",
        1161: "Rock (Southern Rock)",
        1162: "Rock (Surf)",
        1163: "Rock (Tex-Mex)",
        
        22: "Christian & Gospel",
        1094: "Christian & Gospel (CCM)",
        1095: "Christian & Gospel (Christian Metal)",
        1096: "Christian & Gospel (Christian Pop)",
        1097: "Christian & Gospel (Christian Rap)",
        1098: "Christian & Gospel (Christian Rock)",
        1099: "Christian & Gospel (Classic Christian)",
        1100: "Christian & Gospel (Contemporary Gospel)",
        1101: "Christian & Gospel (Gospel)",
        1103: "Christian & Gospel (Praise & Worship)",
        1104: "Christian & Gospel (Southern Gospel)",
        1105: "Christian & Gospel (Traditional Gospel)",
        
        23: "Vocal",
        1173: "Vocal (Standards)",
        1174: "Vocal (Traditional Pop)",
        1175: "Vocal (Vocal Jazz)",
        1176: "Vocal (Vocal Pop)",
        
        24: "Reggae",
        1183: "Reggae (Dancehall)",
        1192: "Reggae (Roots Reggae)",
        1193: "Reggae (Dub)",
        1194: "Reggae (Ska)",
        
        25: "Easy Listening",
        1053: "Easy Listening (Bop)",
        1054: "Easy Listening (Lounge)",
        1055: "Easy Listening (Swing)",
        
        27: "J-Pop",
        
        28: "Enka",
        
        29: "Anime",
        
        30: "Kayokyoku",
        
        50: "Fitness & Workout",
        
        51: "K-Pop",
        
        52: "Karaoke",
        53: "Karaoke (Instrumental)",
        
        1122: "Brazilian",
        1220: "Brazilian (Axé)",
        1221: "Brazilian (Bossa Nova)",
        1222: "Brazilian (Choro)",
        1223: "Brazilian (Forró)",
        1224: "Brazilian (Frevo)",
        1225: "Brazilian (MPB)",
        1226: "Brazilian (Pagode)",
        1227: "Brazilian (Samba)",
        1228: "Brazilian (Sertanejo)",
        1229: "Brazilian (Baile Funk)",
        
        50000061: "Spoken Word",
        50000063: "Disney",
        50000064: "French Pop",
        50000066: "German Pop",
        50000068: "German Folk",
        
        1301: "Arts",
        1302: "Society & Culture (Personal Journals)",
        1303: "Comedy",
        1304: "Education",
        1305: "Kids & Family",
        1306: "Arts (Food)",
        1307: "Health",
        1309: "TV & Film",
        1310: "Music",
        1311: "News & Politics",
        1314: "Religion & Spirituality",
        1315: "Science & Medicine",
        1316: "Sports & Recreation",
        1318: "Technology",
        1320: "Society & Culture (Places & Travel)",
        1321: "Business",
        1323: "Games & Hobbies",
        1324: "Society & Culture",
        1325: "Government & Organizations",
        1401: "Arts (Literature)",
        1402: "Arts (Design)",
        1404: "Games & Hobbies (Video Games)",
        1405: "Arts (Performing Arts)",
        1406: "Arts (Visual Arts)",
        1410: "Business (Careers)",
        1412: "Business (Investing)",
        1413: "Business (Management & Marketing)",
        1415: "Education (K-12)",
        1416: "Education (Higher Education)",
        1417: "Health (Fitness & Nutrition)",
        1420: "Health (Self-Help)",
        1421: "Health (Sexuality)",
        1438: "Religion & Spirituality (Buddhism)",
        1439: "Religion & Spirituality (Christianity)",
        1440: "Religion & Spirituality (Islam)",
        1441: "Religion & Spirituality (Judaism)",
        1443: "Society & Culture (Philosophy)",
        1444: "Religion & Spirituality (Spirituality)",
        1446: "Technology (Gadgets)",
        1448: "Technology (Tech News)",
        1450: "Technology (Podcasting)",
        1454: "Games & Hobbies (Automotive)",
        1455: "Games & Hobbies (Aviation)",
        1456: "Sports & Recreation (Outdoor)",
        1459: "Arts (Fashion & Beauty)",
        1460: "Games & Hobbies (Hobbies)",
        1461: "Games & Hobbies (Other Games)",
        1462: "Society & Culture (History)",
        1463: "Religion & Spirituality (Hinduism)",
        1464: "Religion & Spirituality (Other)",
        1465: "Sports & Recreation (Professional)",
        1466: "Sports & Recreation (College & High School)",
        1467: "Sports & Recreation (Amateur)",
        1468: "Education (Educational Technology)",
        1469: "Education (Language Courses)",
        1470: "Education (Training)",
        1471: "Business (Business News)",
        1472: "Business (Shopping)",
        1473: "Government & Organizations (National)",
        1474: "Government & Organizations (Regional)",
        1475: "Government & Organizations (Local)",
        1476: "Government & Organizations (Non-Profit)",
        1477: "Science & Medicine (Natural Sciences)",
        1478: "Science & Medicine (Medicine)",
        1479: "Science & Medicine (Social Sciences)",
        1480: "Technology (Software How-To)",
        1481: "Health (Alternative Health)"
    ]
}
