//
//  ReverbUnitDelegateProtocol.swift
//  Aural
//
//  Copyright © 2024 Kartik Venugopal. All rights reserved.
//
//  This software is licensed under the MIT software license.
//  See the file "LICENSE" in the project root directory for license terms.
//  

import Foundation

///
/// A functional contract for a delegate representing the Reverb effects unit.
///
/// Acts as a middleman between the Effects UI and the Reverb effects unit,
/// providing a simplified interface / facade for the UI layer to control the Reverb effects unit.
///
/// - SeeAlso: `ReverbUnit`
///
protocol ReverbUnitDelegateProtocol: EffectsUnitDelegateProtocol {
    
    var space: ReverbSpace {get set}
    
    var amount: Float {get set}
    
    var formattedAmount: String {get}
    
    var presets: ReverbPresets {get}
}
