import Document, { Html, Head, Main, NextScript } from "next/document";

class MyDocument extends Document {
  static async getInitialProps(ctx) {
    const initialProps = await Document.getInitialProps(ctx);
    return {
      ...initialProps,
    };
  }

  render() {
    return (
      <Html lang="en">
        <Head>
          <meta httpEquiv="X-UA-Compatible" content="IE=edge" />
          <meta
            name="keywords"
            content="ACE FINANCIAL, WEB-APP, ACE-APP, MOBILE-APP"
          />
          <meta
            name="description"
            content="This repository contains the source code for the Ace Redirect Web Application, which is available only for Android devices and PC's The app is designed to offer a seamless user experience and provide easy access to all of the services offered by Ace Financials Software."
          />
          <meta name="author" content="" />
          <link rel="shortcut icon" href="/img/logo/favicon.png" />
          <link
            href="https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900&display=swap"
            rel="stylesheet"
          />
          <link
            href="https://fonts.googleapis.com/css2?family=Montserrat+Alternates:wght@100;200;300;400;500;600;700;800;900&display=swap"
            rel="stylesheet"
          />
        </Head>

        <body>
          <Main />
          <NextScript />
        </body>
      </Html>
    );
  }
}

export default MyDocument;
