
/**
 * Answers to exercise 13
 * 
 * @author   Kaivalya Rawal
 * @version 15/04/2011
 */
class Complex {
    int real, imag;
    /**
     * Constructer for objects og class Complex
     */
    public Complex (int r , int i){
        real = r;
        imag = i;
    }
    /**
     * 12.1, rewriting normalize as a pure function
     * 
     * @return The value generated by an explicitly stated abstract function/algorithm
     */
    public Complex normalize () {
        return (new Complex(real/abs(), imag/abs()));
    }
    
    /**
     * 12.1, rewriting normalize as a class method
     * 
     * @return The value generated by an explicitly stated abstract function/algorithm
     */
    public statioc void normalize (Complex c) {
        c.real = c.real/c.abs();
        c.imag = c.imag/c.abs();
    }
    
    /**
     * 13.2, Rewriting as an object method, finds the absolute value of a Complex number
     * 
     * @return  The absolute value of a Complex number
     */
    public double abs () {
        return Math.sqrt(real * real  +  imag * imag);
    }
    
    /**
     * 13.3, Rewriting as a class method, checks, whether or not 2 Complex objects are equal
     * 
     * @return  Boolean indicating whether or not the 2 Objects are the same[deep equality]
     */
    public static boolean equals (Complex a, Complex b) {
        return (b.real == a.real && a.imag == b.imag);
    }
}