# Introduction

This directory contains examples for how to use the [Object Pascal](https://en.wikipedia.org/wiki/Object_Pascal)
APIs of [sherpa-onnx](https://github.com/k2-fsa/sherpa-onnx).

**Documentation for this directory**:
https://k2-fsa.github.io/sherpa/onnx/pascal-api/index.html

|Directory| Description|
|---------|------------|
|[read-wav](./read-wav)|It shows how to read a wave file.|
|[speaker-diarization](./speaker-diarization)|It shows how to use Pascal API for speaker diarization.|
|[streaming-asr](./streaming-asr)| It shows how to use streaming models for speech recognition.|
|[non-streaming-asr](./non-streaming-asr)| It shows how to use non-streaming models for speech recognition.|
|[vad](./vad)| It shows how to use the voice activity detection API.|
|[vad-with-non-streaming-asr](./vad-with-non-streaming-asr)| It shows how to use the voice activity detection API with non-streaming models for speech recognition.|
|[portaudio-test](./portaudio-test)| It shows how to use PortAudio for recording and playing.|
|[tts](./tts)| It shows how to use the text-to-speech API.|
