var index = null;
var Pid = scope.pagedata.info.id
/**
 * 建立TCP/IP 连接
 * @constructor
 */
 //建立TCP
//前端先注册以等待接收消息
require(['jinyun_socket'],function(jinyun_socket){
    jinyun_socket.connect(function(){
		jinyun_socket.join(Pid);//加入ID为1的组
	});
    jinyun_socket.onsystem=function(res){
        onBidBack(pid);
    }
});
/**
 * 出价回调数据处理
 * @param data
 */
function onBidBack(pid) {
    //进行出价
    if (pid !== Pid) {
        return false;
    }
	var params = {
					'plugin':'jy_jdpm',
					'action':'detail',
					'op':'detail',
					'query':{
						'pid':pid,
					},
					'callback':function(res){
							if(res.info.nowprice){
								scope.pagedata = res;
								$evalAsync();
							}else{
								console.log('error');
							};
					}
		}
		scope.post_json(params);
}

/**
 * 更新领先用户
 */
function upUser(User) {
    if ($('.user').length) {
        $('#avatar').attr('src', User.avatar);
        $('#nickname').text(User.uid);
        $('#price').text(User.price);
    }
}

/**
 * 更新价格数据
 **/
function upPrice(Price) {
    $("#warranty").text(Price.warranty);//更新保证金额
    $("#clinch").text(Price.clinch);//更新当前成交价
    $("#bidding").text(Price.bidding);//更新当前竞价
    $("#auctionNum").text(Price.auctionNum);//更新出价人数
}

/**
 * 更新剩余时间
 **/
function upTime(Time) {
    switch (Time.type) {
        case 1:
            //更新开始倒计时间
            calibrationStarttime(Time.end,Time.current);
            break;
        case 2:
            //更新结束倒计时间
            calibrationEndtime(Time.end,Time.current);
            break;
        default:
            //无更新
            break;
    }
}



/**
 * 将数值四舍五入(保留2位小数)后格式化成金额形式
 * @param num 数值(Number或者String)
 * @return 金额格式的字符串,如'1,234,567.45'
 * @type String
 */
function formatCurrency(num) {
    num = num.toString().replace(/\$|\,/g, '');
    if (isNaN(num))
        num = "0";
    sign = (num == (num = Math.abs(num)));
    num = Math.floor(num * 100 + 0.50000000001);
    cents = num % 100;
    num = Math.floor(num / 100).toString();
    if (cents < 10)
        cents = "0" + cents;
    for (var i = 0; i < Math.floor((num.length - (1 + i)) / 3); i++)
        num = num.substring(0, num.length - (4 * i + 3)) + ',' +
            num.substring(num.length - (4 * i + 3));
    return (((sign) ? '' : '-') + num + '.' + cents);
}

// 结束倒计时
function endDown(etime, ntime, boxobj, day_elem, hour_elem, minute_elem, second_elem, msec_elem) {
	console.log(etime);console.log(ntime);
    var now_time = new Date(ntime * 1000);
    var end_time = new Date(etime * 1000);
	
    var native_time = new Date().getTime();     //本地时间
    var now_cha = now_time - native_time;       //服务器和本地时间差
    var native_end_time = end_time - now_cha;   //本地结束时间
    var sys_second = 0;

    endDowntimer = setInterval(function () {
        // 检查本地时间是否更改
        sys_second = (native_end_time - new Date().getTime()) / 100; //本地结束剩余时间
        sys_second -= 1;
		if (sys_second <= 0) {
           //scope.pagedata.info.status_ing =2;
		   //$evalAsync();
		   window.location.reload();
		}
        var day = Math.floor((sys_second / 36000) / 24);
        var hour = Math.floor((sys_second / 36000) % 24);
        var minute = Math.floor((sys_second / 600) % 60);
        var second = Math.floor((sys_second / 10) % 60);
        var msec = Math.floor(sys_second % 10); //毫秒

        day = day >= 0 ? day : 0;
        hour = hour >= 0 ? hour : 0;
        minute = minute >= 0 ? minute : 0;
        second = second >= 0 ? second : 0;
        msec = msec >= 0 ? msec : 0;

        day_elem && $(day_elem).text(day);//计算天
        $(hour_elem).text(hour < 10 ? "0" + hour : hour);//计算小时
        $(minute_elem).text(minute < 10 ? "0" + minute : minute);//计算分
        $(second_elem).text(second < 10 ? "0" + second : second);// 计算秒
        $(msec_elem).text(msec);// 计算秒的1/10
        native_time = new Date().getTime();
    }, 100);
}

// 校准结束时间
function calibrationEndtime(etime, ntime) {
    clearInterval(endDowntimer);
    endDown(etime, ntime, ".onBidtime", ".onBidtime .day", ".onBidtime .hour", ".onBidtime .minute", ".onBidtime .second", ".onBidtime .msec");
}

// 开始时间倒计时
function startDown(stime, ntime, boxobj, day_elem, hour_elem, minute_elem, second_elem, msec_elem) {
    var now_time = new Date(ntime * 1000);
    var start_time = new Date(stime * 1000);
    var native_time = new Date().getTime(); //本地时间
    var now_cha = now_time - native_time; //服务器和本地时间差
    var native_start_time = start_time - now_cha; //本地结束时间
    var sys_second = 0;
    startDowntimer = setInterval(function () {
        // if (Math.abs(native_time - new Date().getTime()) > 5000) {
        //     clearInterval(startDowntimer);
        //     $.post(ajaxGetTime, {'pid': Pid}, function (data) {
        //         calibrationStarttime(data.starttime, data.nowtime);
        //     });
        // }
        sys_second = (native_start_time - new Date().getTime()) / 100; //本地结束剩余时间
		sys_second -= 1;
        if (sys_second > 0) {
            var day = Math.floor((sys_second / 36000) / 24);
            var hour = Math.floor((sys_second / 36000) % 24);
            var minute = Math.floor((sys_second / 600) % 60);
            var second = Math.floor((sys_second / 10) % 60);
            var msec = Math.floor(sys_second % 10); //毫秒
            day_elem && $(day_elem).text(day);//计算天
            $(hour_elem).text(hour < 10 ? "0" + hour : hour);//计算小时
            $(minute_elem).text(minute < 10 ? "0" + minute : minute);//计算分
            $(second_elem).text(second < 10 ? "0" + second : second);// 计算秒
            $(msec_elem).text(msec);// 计算秒的1/10
            native_time = new Date().getTime();
        } else {
            window.location.reload();
        }
    }, 100);
}

// 校准开始时间
function calibrationStarttime(stime, ntime) {
    clearInterval(startDowntimer);
    startDown(stime, ntime, ".noStartTime", ".noStartTime .day", ".noStartTime .hour", ".noStartTime .minute", ".noStartTime .second", ".noStartTime .msec");
}


$('.attTixingBox').on('mouseenter', '.Js-follow', function () {
    if ($(this).attr('st') == '1') {
        $(this).children('p').html('取消关注');
    }
});
$('.attTixingBox').on('mouseout', '.Js-follow', function () {
    if ($(this).attr('st') == '1') {
        $(this).children('p').html('已关注');
    }
});
if ($('.Js-follow').attr('st') == 1) {
    $('.Js-follow').addClass('on');
}
$('.Js-follow').click(function () {
    if (checkCodemap()) {
        var thisbj = $(this);
        var st = $(this).attr('st');
        $.post(setAttentionUrl, {'pid': Pid, 'uid': ws_my_uid, 'st': st}, function (data) {
            if (data.status) {
                if (st == 0) {
                    thisbj.children('p').html('已关注');
                    thisbj.attr('st', 1);
                    layer.msg(data.msg);
                    // AMUI.dialog.alert({title: '', content: data.msg});
                    thisbj.addClass('on');
                } else {
                    thisbj.children('p').html('关注');
                    thisbj.attr('st', 0);
                    layer.msg(data.msg);
                    // AMUI.dialog.alert({title: '', content: data.msg});
                    thisbj.removeClass('on');
                }

            } else {
                layer.msg(data.msg);
                // AMUI.dialog.alert({title: '', content: data.msg});
            }
        }, 'json');
    }

});
// 详情页关注拍品操作】
// 详情页拍品提醒操作【
$('.attTixingBox').on('mouseenter', '.Js-remind', function () {
    if ($(this).attr('st') == '1') {
        $(this).children('p').html('取消提醒');
    }
});
$('.attTixingBox').on('mouseout', '.Js-remind', function () {
    if ($(this).attr('st') == '1') {
        $(this).children('p').html('已设提醒');
    }
});
if ($('.Js-remind').attr('st') == 1) {
    $('.Js-remind').addClass('on');
}
$('.attTixingBox').on('click', '.Js-remind', function () {
    if (checkCodemap()) {
        changtx();
    }
});
$('.attTixingBox').on('click', '#setremind', function () {
    if (login == 0) {
        layer.msg();
        AMUI.dialog.alert({title: '', content: '请先登陆后在设置提醒！'});
    } else {
        if (checkCodemap()) {
            asyncbox.open({
                id: "open_0",
                title: '设置提醒',
                args: {pid: Pid},
                modal: true,
                buttons: asyncbox.btn.OKCANCEL,
                url: setTixingUrl,
                callback: handler
            })
        }

    }
});

// 是否提示关注公众号
function checkCodemap() {
    // 是微信端打开
    if (iswei == 1) {
        // 已经开启关注提醒
        if (mapstate != 1 && codemap == 1) {
            $('#codeMapModal').modal();
            return false;
        } else {
            return true;
        }
    } else {
        return true;
    }
}

function changtx() {
    var thisbj = $('.Js-remind');
    var st = $('.Js-remind').attr('st');
    var stype = $('.Js-remind').attr('stype');
    $.post(setScheduledUrl, {'pid': Pid, 'uid': ws_my_uid, 'st': st, 'stype': stype}, function (data) {
        if (data.status) {
            if (st == 0) {
                thisbj.children('p').html('已设提醒');
                thisbj.attr('st', 1);
                layer.msg(data.info);
                // AMUI.dialog.alert({title: '', content: data.info});
                thisbj.addClass('on');
            } else {
                thisbj.children('p').html('设置提醒');
                thisbj.attr('st', 0);
                layer.msg(data.info);
                // AMUI.dialog.alert({title: '', content: data.info});
                thisbj.removeClass('on');
            }

        } else {
            layer.msg(data.info);
            // AMUI.dialog.alert({title: '', content: data.info});
        }
    }, 'json');
}