<?php
/*
	消息通知设置
	// $msgtype=（0常规消息/验证码，1被竞拍覆盖，2竞拍成功，3获得佣金，4身份证审核情况）
*/
namespace jy_jdpm;
defined('BY_JYA') or exit('error');
class notice extends \plugin{
	public function set_sms($mobile,$msg='',$msgtype=0) {
		$tpls = array('0'=>'alicode_tpl','1'=>'aliisout_tpl','2'=>'alisuccess_tpl','3'=>'aligetmoney_tpl','4'=>'alishenfen_tpl','5'=>'alipay_tpl');
		$msgset = plugin_set2('message');
		$smstpl = $msgset[$tpls[$msgtype]];
		// 每个手机号每分钟只能发送一次
		if($_SESSION['uid']){
			$count = pdo_count('jy_jdpm_notice_log',array('mid'=>$_SESSION['uid'],'type'=>0,'createtime >'=> TIMESTAMP - 60),'id');
			if ($count) {
				cache_delete('commodity-' . $pid);
				//exi('请一分钟后再次尝试发送短信！','error');
			}
		}
		// 每个ip地址每天请求10次
		if(getip()){
			$daytime = mktime(0,0,0,date('m'),date('d'),date('Y'));
			$count = pdo_count('jy_jdpm_notice_log',array('ip'=>getip(),'type'=>0,'createtime >'=> $daytime),'id');
			if ($count >10) {
				cache_delete('commodity-' . $pid);
				//exi('发送短信太过频繁！','error');
			}
		}
		$uid = $_SESSION['uid']?$_SESSION['uid']:0;
		if($msgtype==0){
			$msg2 = '发送验证码:['.$msg['code'].']';
		}
		if($msgtype==1){
			$msg2 = '您的拍品被抢拍！';
		}
		if($msgtype==2){
			$msg2 = '竞拍成功！';
		}
		if($msgtype==3){
			$msg2 = '获得佣金！';
		}
		if($msgtype==4){
			$msg2 = '您的身份实名验证,已审核通过！';
		}
		if($msgtype==5){
			$msg2 = '恭喜您已成功获拍，请于竞拍结束24小时内付清拍品货款。若逾期未付款，将承担违约责任。如已付款请忽略';
		}
		$data = array(
				'mid'=>$uid,
				'ip'=>getip(),
				'type'=>0,
				'msg'=>$msg2,
				'createtime'=>TIMESTAMP
		);
		if($msgtype!=0){
			pdo_insert('jy_jdpm_notice_log', $data);
		}
		return cfc('jy_alisms')->sendsms($mobile,$msg,$smstpl);
	}
	//发送网页弹窗短信
	public function set_websms($setmsg,$setuid=0,$getuid=1,$url='') {
		$data = array(
				'mid'=>$getuid,
				'ip'=>getip(),
				'type'=>2,
				'url'=>$url,
				'msg'=>$setmsg,
				'createtime'=>TIMESTAMP,
		);
		pdo_insert('jy_jdpm_notice_log', $data);
		set_workerman2($setmsg,$setuid,$getuid);
		return true;
	}
	public function set_wxsms($msgtype,$uid,$store_id,$order_id) {
			list($msgtype,$uid,$store_id,$order_id)=$arguments;
			$store=pdo_get('jy_dish_store',array('id'=>$store_id,'uniacid'=>$_SESSION['uniacid']));
			$order=pdo_get('jy_dish_order',array('id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
			$order['createtime'] = date('Y/m/d H:i:s',$order['createtime']);
			$self=pdo_get('jy_dish_order_self',array('order_id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
			$out=pdo_get('jy_dish_order_out',array('order_id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
			$userinfo=pdo_get('core_members',array('id'=>$uid,'uniacid'=>$_SESSION['uniacid']));
			$out['out_time'] = $out['out_time']?$out['out_time']:'即时派送';
			$goods=pdo_getall('jy_dish_order_goods',array('order_id'=>$order_id));
			if($goods){
				$str = '';
				foreach($goods as $g){
					$g['goods_package']=$g['goods_package']?json_decode($g['goods_package'],true):array();
					if(empty($g['goods_package'])){
						$money = $g['goods_price'] * $g['goods_num'];
						$str .= ''.str_pad($g['goods_title'], '26', ' ', STR_PAD_RIGHT);
						$str .= ''.str_pad($g['goods_num'], '5', ' ', STR_PAD_RIGHT);
						$str .= ''. number_format($money, 2) . "元\n";
					}else{
						$str .= $g['goods_title']."--规格如下：\n";
						foreach($g['goods_package'] as $p){
								$money = $p['price'] * $p['num'];
								$str .= '['.str_pad($p['title'].']', '23', ' ', STR_PAD_RIGHT);
								$str .= ''.str_pad($p['num'], '5', ' ', STR_PAD_RIGHT);
								$str .= ''. number_format($money, 2) . "元\n";
								
						}
					}
				}
			}
			$goodsinfo = "名称　                数量     单价\n";
			$goodsinfo .= $str;
			$goodsinfo .= "-----------------------------\n";
			$order_type=$this->type__order();
			$order_type=$order_type[$order['order_type']];
			$selfinfo=pdo_get('jy_dish_order_self',array('order_id'=>$order_id));
			$is_pays =array('0'=>'未支付','1'=>'已支付');
			if($msgtype == 'order_new' && $order['order_type'] == 1){
				$url=custom_url('jy_dish/order_show/',true);
				$tpldata=array(
					'first'=>array('value'=>'您好，您的堂点单，已下单成功','color'=>''),
					'keyword1'=>array('value'=>$store['title'],'color'=>'#ff510'),
					'keyword2'=>array('value'=>date('Y-m-d h:i:s',TIMESTAMP),'color'=>'#ff510'),
					'keyword3'=>array('value'=>"\n".$goodsinfo,'color'=>'#ff510'),
					'keyword4'=>array('value'=>$order['price'],'color'=>'#ff510'),
					'remark'=>array('value'=>'查看更多订单信息~!','color'=>'#ff510'),
				);
				$staffdata=array(
					'first'=>array('value'=>'收到一个新的订单，请及时处理！','color'=>''),
					'keyword1'=>array('value'=>$order['ordersn'],'color'=>'#ff510'),
					'keyword2'=>array('value'=>$userinfo['nickname'].$userinfo['mobile'],'color'=>'#ff510'),
					'keyword3'=>array('value'=>$order_type."\n".$goodsinfo,'color'=>'#ff510'),
					'keyword4'=>array('value'=>'堂点，无地址','color'=>'#ff510'),
					'keyword5'=>array('value'=>$order['createtime'],'color'=>'#ff510'),
					'remark'=>array('value'=>'查看更多订单信息~!','color'=>'#ff510'),
				);
				$staffmsg['msgtype']='news';
				$staf[0]['title'] = "收到一个新的订单，请及时处理！\n";
				$staf[0]['description'] ='餐厅:'.$store['title']."\n";
				$staf[0]['description'] .='下单时间:'.$order['createtime']."\n";
				$staf[0]['description'] .='金额:'.$order['price']."\n";
				$staf[0]['description'] .="【菜品详情】\n";
				$staf[0]['description'] .="-----------------------------\n";
				$staf[0]['description'] .=$goodsinfo."\n";
				$staf[0]['description'] .=$userinfo['name'].$userinfo['mobile']."\n";
				$staf[0]['description'] .='查看更多订单信息~!';
				$staf[0]['URL'] =$url;
				$staffmsg['news']['articles'] =$staf;
				
				$newsmsg['msgtype']='news';
				$articles[0]['title'] = "您好，您的堂点单，已下单成功\n";
				$articles[0]['description'] ='餐厅:'.$store['title']."\n";
				$articles[0]['description'] .='下单时间:'.$order['createtime']."\n";
				$articles[0]['description'] .='金额:'.$order['price']."\n";
				$articles[0]['description'] .="【菜品详情】\n";
				$articles[0]['description'] .="-----------------------------\n";
				$articles[0]['description'] .=$goodsinfo."\n";
				$articles[0]['description'] .='查看更多订单信息~!';
				$articles[0]['URL'] =$url;
				$newsmsg['news']['articles'] =$articles;
				$this->sendstaff('kf_order_new',$staffmsg,$staffdata,$uid,$url,$color,$store_id);
				
			}elseif($msgtype == 'order_pay'){
				$url=custom_url('jy_dish/order_show/',true);
				$tpldata=array(
							'first'=>array('value'=>'您好，您有一个订单状态已更新','color'=>''),
							'keyword1'=>array('value'=>$order['ordersn'],'color'=>'#ff510'),
							'keyword2'=>array('value'=>'已付款','color'=>'#ff510'),
							'keyword3'=>array('value'=>$order['createtime'],'color'=>'#ff510'),
							'remark'=>array('value'=>'更多消息请查看订单详情','color'=>'#ff510'),
				);
				$staffdata=array(
					'first'=>array('value'=>'有一个客户订单已支付，请及时处理！','color'=>''),
					'keyword1'=>array('value'=>$order['ordersn'],'color'=>'#ff510'),
					'keyword2'=>array('value'=>'已付款','color'=>'#ff510'),
					'keyword3'=>array('value'=>$order['createtime'],'color'=>'#ff510'),
					'remark'=>array('value'=>'更多消息请查看订单详情','color'=>'#ff510'),
				);
				$staffmsg['msgtype']='news';
				$staf[0]['title'] = "您好，您有一个订单状态已更新\n";
				$staf[0]['description'] ='订单编号:'.$order['ordersn']."\n";
				$staf[0]['description'] .="下单状态:已付款\n";
				$staf[0]['description'] .='订单时间:'.$order['createtime']."\n";
				$staf[0]['description'] .='查看更多订单信息~!';
				$staf[0]['URL'] =$url;
				$staffmsg['news']['articles'] =$staf;
				
				$newsmsg['msgtype']='news';
				$articles[0]['title'] = "您好，您有一个订单状态已更新\n";
				$articles[0]['description'] ='订单编号:'.$order['ordersn']."\n";
				$articles[0]['description'] .="下单状态:已付款\n";
				$articles[0]['description'] .='订单时间:'.$order['createtime']."\n";
				$articles[0]['description'] .='查看更多订单信息~!';
				$articles[0]['URL'] =$url;
				$newsmsg['news']['articles'] =$articles;
				$this->sendstaff('kf_order_pay',$staffmsg,$staffdata,$uid,$url,$color,$store_id);
				
			}elseif($msgtype == 'order_new' && $order['order_type'] == 2){
				$url=custom_url('jy_dish/order_show/',true);
				$tpldata=array(
					'first'=>array('value'=>'您好，您的外卖单，已下单成功','color'=>''),
					'keyword1'=>array('value'=>$store['title'],'color'=>'#ff510'),
					'keyword2'=>array('value'=>date('Y-m-d h:i:s',TIMESTAMP),'color'=>'#ff510'),
					'keyword3'=>array('value'=>"\n".$goodsinfo,'color'=>'#ff510'),
					'keyword4'=>array('value'=>$order['price'],'color'=>'#ff510'),
					'remark'=>array('value'=>'约45分钟后送达~！','color'=>'#ff510'),
				);
				$staffdata=array(
					'first'=>array('value'=>'收到一个新的订单，请及时处理！','color'=>''),
					'keyword1'=>array('value'=>$order['ordersn'],'color'=>'#ff510'),
					'keyword2'=>array('value'=>$out['receiver_name'].$out['receiver_mobile'],'color'=>'#ff510'),
					'keyword3'=>array('value'=>"外卖\n".$goodsinfo,'color'=>'#ff510'),
					'keyword4'=>array('value'=>$out['receiver_address'],'color'=>'#ff510'),
					'keyword5'=>array('value'=>$out['out_time'],'color'=>'#ff510'),
					'remark'=>array('value'=>'查看更多订单信息~!','color'=>'#ff510'),
				);
				$staffmsg['msgtype']='news';
				$staf[0]['title'] = "收到一个新的订单，请及时处理！\n";
				$staf[0]['description'] ='餐厅:'.$store['title']."\n";
				$staf[0]['description'] ="订单类型:外卖\n";
				$staf[0]['description'] .='下单时间:'.$order['createtime']."\n";
				$staf[0]['description'] .='金额:'.$order['price']."\n";
				$staf[0]['description'] .="【菜品详情】\n";
				$staf[0]['description'] .="-----------------------------\n";
				$staf[0]['description'] .=$goodsinfo."\n";
				$staf[0]['description'] .=$out['receiver_name'].$out['receiver_mobile']."\n";
				$staf[0]['description'] .="配送地址：".$out['receiver_address']."\n";
				$staf[0]['description'] .='查看更多订单信息~!';
				$staf[0]['URL'] =$url;
				$staffmsg['news']['articles'] =$staf;
				
				$newsmsg['msgtype']='news';
				$articles[0]['description'] ='餐厅:'.$store['title']."\n";
				$articles[0]['description'] .='下单时间:'.$order['createtime']."\n";
				$articles[0]['description'] .='金额:'.$order['price']."\n";
				$articles[0]['description'] .="【菜品详情】\n";
				$articles[0]['description'] .="-----------------------------\n";
				$articles[0]['description'] .=$goodsinfo."\n";
				$articles[0]['description'] .='约45分钟后送达~！';
				$articles[0]['URL'] =$url;
				$newsmsg['news']['articles'] =$articles;
				$this->sendstaff('kf_order_new',$staffmsg,$staffdata,$uid,$url,$color,$store_id);
			}elseif($msgtype == 'salf_order_new' && $order['order_type'] == 3){
				$url=custom_url('jy_dish/order_show/',true);
				$tpldata=array(
					'first'=>array('value'=>'下单成功,请及时支付！','color'=>''),
					'keyword1'=>array('value'=>$order['ordersn'],'color'=>'#ff510'),
					'keyword2'=>array('value'=>$self['selfnumber'],'color'=>'#ff510'),
					'keyword3'=>array('value'=>$store['title'],'color'=>'#ff510'),
					'keyword4'=>array('value'=>"\n".$goodsinfo,'color'=>'#ff510'),
					'keyword5'=>array('value'=>$order['price'],'color'=>'#ff510'),
					'remark'=>array('value'=>'祝您用餐愉快~！','color'=>'#ff510'),
				);
				$newsmsg['msgtype']='news';
				$articles[0]['title'] = "下单成功,请及时支付！\n";
				$articles[0]['description'] ='订单编号:'.$order['ordersn']."\n";
				$articles[0]['description'] .='取餐号:'.$self['selfnumber']."\n";
				$articles[0]['description'] .='餐厅:'.$store['title']."\n";
				$articles[0]['description'] .='金额:'.$order['price']."\n";
				$articles[0]['description'] .="【菜品详情】\n";
				$articles[0]['description'] .="-----------------------------\n";
				$articles[0]['description'] .=$goodsinfo."\n";
				$articles[0]['description'] .='祝您用餐愉快~！';
				$articles[0]['URL'] =$url;
				$newsmsg['news']['articles'] =$articles;
			}elseif($msgtype == 'yuding_order_new' && $order['order_type'] == 5){
				$url=custom_url('jy_dish/order_show/',true);
				$tpldata=array(
					'first'=>array('value'=>'预定成功！','color'=>''),
					'keyword1'=>array('value'=>$store['title'],'color'=>'#ff510'),
					'keyword2'=>array('value'=>date('Y-m-d h:i:s',TIMESTAMP),'color'=>'#ff510'),
					'keyword3'=>array('value'=>$order['ordersn'],'color'=>'#ff510'),
					'keyword4'=>array('value'=>$order_type,'color'=>'#ff510'),
					'remark'=>array('value'=>'期待您的光临~！','color'=>'#ff510'),
				);
				$newsmsg['msgtype']='news';
				$articles[0]['title'] = "预定成功！\n";
				$articles[0]['description'] ='餐厅:'.$store['title']."\n";
				$articles[0]['description'] .='预定时间:'.$order['createtime']."\n";
				$articles[0]['description'] .='订单编号:'.$order['ordersn']."\n";
				$articles[0]['description'] .='期待您的光临~!';
				$articles[0]['URL'] =$url;
				$newsmsg['news']['articles'] =$articles;
			}elseif($msgtype == 'call'){
				$url=custom_url('jy_dish/queue/',true);
				$callmember = pdo_get('jy_dish_queue_member',array('uniacid'=>$_SESSION['uniacid'],'store_id'=>$store_id,'id'=>$order_id));
				$callmember['createtime'] = date('Y/m/d H:i:s',$callmember['createtime']);
				$tpldata=array(
							'first'=>array('value'=>'排号通知','color'=>''),
							'keyword1'=>array('value'=>$callmember['number'],'color'=>'#ff510'),
							'keyword2'=>array('value'=>$callmember['createtime'],'color'=>'#ff510'),
							'remark'=>array('value'=>'快到您啦，快来就餐吧~！','color'=>'#ff510'),
				);
				$newsmsg['msgtype']='news';
				$articles[0]['title'] = "排号通知\n";
				$articles[0]['description'] ='当前排号:'.$callmember['number']."\n";
				$articles[0]['description'] .='取号时间:'.$callmember['createtime']."\n";
				$articles[0]['description'] .='快到您啦，快来就餐吧~！';
				$articles[0]['URL'] =$url;
				$newsmsg['news']['articles'] =$articles;
			}elseif($msgtype == 'queue_update'){
				$url=custom_url('jy_dish/queue/',true);
				$mymember = pdo_get('jy_dish_queue_member',array('uniacid'=>$_SESSION['uniacid'],'store_id'=>$store_id,'id'=>$order_id));
				$dmember = pdo_count('jy_dish_queue_member',array('uniacid'=>$_SESSION['uniacid'],'store_id'=>$store_id,'status'=>0,'id <'=>$order_id));
				$tpldata=array(
							'first'=>array('value'=>'排号通知','color'=>''),
							'keyword1'=>array('value'=>$store['title'],'color'=>'#ff510'),
							'keyword2'=>array('value'=>$mymember['number'],'color'=>'#ff510'),
							'keyword3'=>array('value'=>$dmember,'color'=>'#ff510'),
							'remark'=>array('value'=>'祝您用餐愉快~！','color'=>'#ff510'),
				);
				$newsmsg['msgtype']='news';
				$articles[0]['title'] = "排号通知\n";
				$articles[0]['description'] ='餐厅:'.$callmember[0]['number']."\n";
				$articles[0]['description'] .='您的排号:'.$mymember['number']."\n";
				$articles[0]['description'] .='还需等待:'.$dmember."\n";
				$articles[0]['description'] .='祝您用餐愉快~！';
				$articles[0]['URL'] =$url;
				$newsmsg['news']['articles'] =$articles;
			}

		$this->send_message($msgtype,$newsmsg,$tpldata,$uid,$url,$color);
	}
	public function setmsg($msgtype,$uid,$store_id,$order_id) {
			list($msgtype,$newsmsg,$tpldata,$uid,$url,$color)=$arguments;
			$tpl=$this->plugin_setting('message_tpl');
			if($msgtype=='order_new'){
				if($tpl['order_new'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['order_new'],$tpldata,$url,$color);
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
			}elseif($msgtype=='order_pay'){
				if($tpl['order_pay'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['order_pay'],$tpldata,$url,$color);
					return true;		
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
				
			}elseif($msgtype=='order_change'){
				if($tpl['order_change'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['order_change'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
				
			}elseif($msgtype=='waiter'){
				if($tpl['waiter'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['waiter'],$tpldata,$url,$color);
					return true;		
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
				
			}elseif($msgtype=='queue_update'){
				if($tpl['queue_update'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['queue_update'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
				
			}elseif($msgtype=='call'){
				if($tpl['call'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['call'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
			}elseif($msgtype=='queue_update'){
				if($tpl['queue_update'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['queue_update'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
			}elseif($msgtype=='salf_order_new'){
				if($tpl['salf_order_new'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['salf_order_new'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
			}elseif($msgtype=='qu_order'){
				if($tpl['qu_order'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['qu_order'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
			}elseif($msgtype=='yuding_order_new'){
				if($tpl['yuding_order_new'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['yuding_order_new'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
			}elseif($msgtype=='kf_order_pay'){
				if($tpl['kf_order_pay'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['kf_order_pay'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
			}elseif($msgtype=='kf_order_new'){
				if($tpl['kf_order_new'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['kf_order_new'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
			}elseif($msgtype=='kf_waiter'){
				if($tpl['kf_waiter'] && $tpl['istpl']){
					cfc('account')->sendTplNotice($uid,$tpl['kf_waiter'],$tpldata,$url,$color);	
					return true;
				}else{
					cfc('account')->sendCustomNotice($newsmsg,$uid);
					return true;
				}
			}
}
}
